/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/JavaOutsideModuleDetector;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nJavaOutsideModuleDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaOutsideModuleDetector.kt\norg/jetbrains/kotlin/idea/inspections/JavaOutsideModuleDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1#2:54\n11158#3:55\n11493#3,3:56\n1755#4,3:59\n*S KotlinDebug\n*F\n+ 1 JavaOutsideModuleDetector.kt\norg/jetbrains/kotlin/idea/inspections/JavaOutsideModuleDetector\n*L\n40#1:55\n40#1:56,3\n41#1:59,3\n*E\n"})
public final class JavaOutsideModuleDetector
implements EditorNotificationProvider {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Object object;
        block15: {
            block14: {
                Module module;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!Intrinsics.areEqual((Object)file.getExtension(), (Object)"java") && !FileTypeRegistry.getInstance().isFileOfType(file, (FileType)JavaFileType.INSTANCE)) {
                    return null;
                }
                object = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
                if (object == null) break block14;
                Module it = module = object;
                boolean bl = false;
                object = ProjectStructureUtils.isGradleModule(it) ? module : null;
                if (object != null) break block15;
            }
            return null;
        }
        Module module = object;
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
        ProjectFileIndex fileIndex = projectFileIndex;
        if (fileIndex.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.RESOURCES) || !fileIndex.isInSourceContent(file)) {
            return null;
        }
        if (fileIndex.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.SOURCES)) {
            boolean bl;
            block13: {
                void $this$mapTo$iv$iv;
                Object object2 = KotlinFacet.Companion.get(module);
                if (object2 == null || (object2 = (KotlinFacetConfiguration)object2.getConfiguration()) == null || (object2 = object2.getSettings()) == null) {
                    return null;
                }
                KotlinFacet facetSettings = object2;
                String string = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                String filePath = string;
                VirtualFile[] $this$map$iv = ProjectRootsUtilKt.getSourceRoots(module);
                boolean $i$f$map = false;
                VirtualFile[] virtualFileArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int j = 0; j < n; ++j) {
                    void it;
                    void item$iv$iv;
                    void var16_18 = item$iv$iv = $this$mapTo$iv$iv[j];
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getPath());
                }
                List nonKotlinPath = CollectionsKt.minus((Iterable)((List)destination$iv$iv), (Iterable)facetSettings.getPureKotlinSourceFolders());
                Iterable $this$any$iv = nonKotlinPath;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!StringsKt.startsWith$default((String)filePath, (String)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return null;
            }
        }
        return JavaOutsideModuleDetector::collectNotificationData$lambda$4;
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$4(FileEditor it) {
        EditorNotificationPanel editorNotificationPanel;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EditorNotificationPanel $this$collectNotificationData_u24lambda_u244_u24lambda_u243 = editorNotificationPanel = new EditorNotificationPanel(it, EditorNotificationPanel.Status.Warning);
        boolean bl = false;
        $this$collectNotificationData_u24lambda_u244_u24lambda_u243.text(KotlinJvmBundle.message("this.java.file.is.outside.of.java.source.roots.and.won.t.be.added.to.the.classpath", new Object[0]));
        $this$collectNotificationData_u24lambda_u244_u24lambda_u243.icon(AllIcons.General.Warning);
        return editorNotificationPanel;
    }
}

