/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.quickfix.RenameToUnderscoreFix;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinCatchMayIgnoreExceptionInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "ignoreCatchBlocksWithComments", "", "getIgnoreCatchBlocksWithComments", "()Z", "setIgnoreCatchBlocksWithComments", "(Z)V", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "Lorg/jetbrains/annotations/NotNull;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "RenameToUnderscoreLocalQuickFix", "kotlin.idea"})
public final class KotlinCatchMayIgnoreExceptionInspection
extends AbstractKotlinInspection {
    private boolean ignoreCatchBlocksWithComments = true;

    public final boolean getIgnoreCatchBlocksWithComments() {
        return this.ignoreCatchBlocksWithComments;
    }

    public final void setIgnoreCatchBlocksWithComments(boolean bl) {
        this.ignoreCatchBlocksWithComments = bl;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.checkbox((String)"ignoreCatchBlocksWithComments", (String)InspectionGadgetsBundle.message((String)"inspection.catch.ignores.exception.option.comments", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (PsiElementVisitor)new KtVisitorVoid(this, holder2){
            final /* synthetic */ KotlinCatchMayIgnoreExceptionInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitCatchSection(KtCatchClause catchClause) {
                Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
                KtParameter ktParameter = catchClause.getCatchParameter();
                if (ktParameter == null) {
                    return;
                }
                KtParameter catchParameter = ktParameter;
                String string = catchParameter.getName();
                if (string == null) {
                    return;
                }
                String name2 = string;
                if (PsiUtil.isIgnoredName((String)name2)) {
                    return;
                }
                if (Intrinsics.areEqual((Object)name2, (Object)"_")) {
                    return;
                }
                KtExpression ktExpression = catchClause.getCatchBody();
                if (ktExpression == null) {
                    return;
                }
                KtExpression catchBody = ktExpression;
                if (catchBody instanceof KtBlockExpression && ((KtBlockExpression)catchBody).getStatements().isEmpty()) {
                    if (this.this$0.getIgnoreCatchBlocksWithComments() && ExpressionExtKt.hasComments((PsiElement)catchBody)) {
                        return;
                    }
                    PsiElement psiElement = ((PsiElement)catchClause).getFirstChild();
                    Intrinsics.checkNotNull((Object)psiElement);
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RenameToUnderscoreLocalQuickFix(name2)};
                    this.$holder.registerProblem(psiElement, KotlinBundle.message((String)"inspection.message.empty.catch.block", (Object[])new Object[0]), localQuickFixArray);
                }
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinCatchMayIgnoreExceptionInspection$RenameToUnderscoreLocalQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "parameterName", "", "<init>", "(Ljava/lang/String;)V", "getParameterName", "()Ljava/lang/String;", "getName", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
    public static final class RenameToUnderscoreLocalQuickFix
    implements LocalQuickFix {
        @NotNull
        private final String parameterName;

        public RenameToUnderscoreLocalQuickFix(@NotNull String parameterName2) {
            Intrinsics.checkNotNullParameter((Object)parameterName2, (String)"parameterName");
            this.parameterName = parameterName2;
        }

        @NotNull
        public final String getParameterName() {
            return this.parameterName;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.parameterName, "_"};
            String string = CommonQuickFixBundle.message((String)"fix.rename.x.to.y", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"rename.to.underscore", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            KtCatchClause ktCatchClause = (KtCatchClause)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getStartElement(), KtCatchClause.class);
            if (ktCatchClause == null) {
                return;
            }
            KtCatchClause catchClause = ktCatchClause;
            KtParameter ktParameter = catchClause.getCatchParameter();
            if (ktParameter == null) {
                return;
            }
            KtParameter parameter = ktParameter;
            RenameToUnderscoreFix renameToUnderscoreFix = new RenameToUnderscoreFix((KtCallableDeclaration)parameter);
            PsiFile psiFile = parameter.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            renameToUnderscoreFix.invoke(project, null, psiFile);
        }
    }
}

