/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a$\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\u0006*\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0014\u0010\u000b\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"isNullChecksToSafeCallFixAvailable", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "collectNullCheckExpressions", "Lkotlin/Triple;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "getNullTestableExpression", "expectedOperation", "Lorg/jetbrains/kotlin/lexer/KtToken;", "isChainStable", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "kotlin.idea"})
public final class NullChecksToSafeCallInspectionKt {
    private static final boolean isNullChecksToSafeCallFixAvailable(KtBinaryExpression expression) {
        Triple<KtExpression, KtQualifiedExpression, Boolean> triple = NullChecksToSafeCallInspectionKt.collectNullCheckExpressions(expression);
        if (triple == null) {
            return false;
        }
        Triple<KtExpression, KtQualifiedExpression, Boolean> triple2 = triple;
        KtExpression lte = (KtExpression)triple2.component1();
        KtQualifiedExpression rte = (KtQualifiedExpression)triple2.component2();
        BindingContext context = ResolutionUtils.analyze$default((KtElement)expression, null, 1, null);
        if (!NullChecksToSafeCallInspectionKt.isChainStable(lte, context)) {
            return false;
        }
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)rte), (BindingContext)context);
        if (resolvedCall == null) {
            return false;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        ReceiverValue extensionReceiver = resolvedCall2.getExtensionReceiver();
        if (extensionReceiver != null && TypeUtils.isNullableType((KotlinType)extensionReceiver.getType())) {
            return false;
        }
        String string = rte.getReceiverExpression().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = NullChecksToSafeCallInspectionKt.isNullChecksToSafeCallFixAvailable$afterIgnoreCalls(string);
        String string3 = lte.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        return Intrinsics.areEqual((Object)string2, (Object)NullChecksToSafeCallInspectionKt.isNullChecksToSafeCallFixAvailable$afterIgnoreCalls(string3));
    }

    private static final Triple<KtExpression, KtQualifiedExpression, Boolean> collectNullCheckExpressions(KtBinaryExpression expression) {
        boolean bl;
        IElementType iElementType = expression.getOperationToken();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.ANDAND)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.OROR)) {
            bl = false;
        } else {
            return null;
        }
        boolean isAnd = bl;
        KtExpression ktExpression = expression.getLeft();
        KtBinaryExpression ktBinaryExpression = ktExpression instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression : null;
        if (ktBinaryExpression == null) {
            return null;
        }
        KtBinaryExpression lhs = ktBinaryExpression;
        KtExpression ktExpression2 = expression.getRight();
        KtBinaryExpression ktBinaryExpression2 = ktExpression2 instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression2 : null;
        if (ktBinaryExpression2 == null) {
            return null;
        }
        KtBinaryExpression rhs = ktBinaryExpression2;
        KtSingleValueToken expectedOperation = isAnd ? KtTokens.EXCLEQ : KtTokens.EQEQ;
        Intrinsics.checkNotNull((Object)expectedOperation);
        KtExpression ktExpression3 = NullChecksToSafeCallInspectionKt.getNullTestableExpression(lhs, (KtToken)expectedOperation);
        if (ktExpression3 == null) {
            return null;
        }
        KtExpression lte = ktExpression3;
        KtExpression ktExpression4 = NullChecksToSafeCallInspectionKt.getNullTestableExpression(rhs, (KtToken)expectedOperation);
        KtQualifiedExpression ktQualifiedExpression = ktExpression4 instanceof KtQualifiedExpression ? (KtQualifiedExpression)ktExpression4 : null;
        if (ktQualifiedExpression == null) {
            return null;
        }
        KtQualifiedExpression rte = ktQualifiedExpression;
        return new Triple((Object)lte, (Object)rte, (Object)isAnd);
    }

    private static final KtExpression getNullTestableExpression(KtBinaryExpression $this$getNullTestableExpression, KtToken expectedOperation) {
        if (!Intrinsics.areEqual((Object)$this$getNullTestableExpression.getOperationToken(), (Object)expectedOperation)) {
            return null;
        }
        KtExpression ktExpression = $this$getNullTestableExpression.getLeft();
        if (ktExpression == null) {
            return null;
        }
        KtExpression lhs = ktExpression;
        KtExpression ktExpression2 = $this$getNullTestableExpression.getRight();
        if (ktExpression2 == null) {
            return null;
        }
        KtExpression rhs = ktExpression2;
        if (KtPsiUtil.isNullConstant((KtExpression)lhs)) {
            return rhs;
        }
        if (KtPsiUtil.isNullConstant((KtExpression)rhs)) {
            return lhs;
        }
        return null;
    }

    private static final boolean isChainStable(KtExpression $this$isChainStable, BindingContext context) {
        boolean bl;
        KtExpression ktExpression = $this$isChainStable;
        if (ktExpression instanceof KtReferenceExpression) {
            bl = IfThenUtilsKt.isStableSimpleExpression($this$isChainStable, context);
        } else if (ktExpression instanceof KtQualifiedExpression) {
            KtExpression ktExpression2 = ((KtQualifiedExpression)$this$isChainStable).getSelectorExpression();
            bl = (ktExpression2 != null ? IfThenUtilsKt.isStableSimpleExpression(ktExpression2, context) : false) && NullChecksToSafeCallInspectionKt.isChainStable(((KtQualifiedExpression)$this$isChainStable).getReceiverExpression(), context);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final String isNullChecksToSafeCallFixAvailable$afterIgnoreCalls(String $this$isNullChecksToSafeCallFixAvailable_u24afterIgnoreCalls) {
        return StringsKt.replace$default((String)$this$isNullChecksToSafeCallFixAvailable_u24afterIgnoreCalls, (String)"?.", (String)".", (boolean)false, (int)4, null);
    }

    public static final /* synthetic */ boolean access$isNullChecksToSafeCallFixAvailable(KtBinaryExpression expression) {
        return NullChecksToSafeCallInspectionKt.isNullChecksToSafeCallFixAvailable(expression);
    }

    public static final /* synthetic */ Triple access$collectNullCheckExpressions(KtBinaryExpression expression) {
        return NullChecksToSafeCallInspectionKt.collectNullCheckExpressions(expression);
    }
}

