/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.codeinsight.utils.EditorUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineAnonymousFunctionProcessor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantLambdaOrAnonymousFunctionInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "RedundantLambdaOrAnonymousFunctionFix", "Util", "kotlin.idea"})
public final class RedundantLambdaOrAnonymousFunctionInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (PsiElementVisitor)new KtVisitorVoid(holder2){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitNamedFunction(KtNamedFunction function) {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.processExpression((KtFunction)function);
            }

            public void visitLambdaExpression(KtLambdaExpression lambdaExpression) {
                Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
                KtFunctionLiteral ktFunctionLiteral = lambdaExpression.getFunctionLiteral();
                Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
                this.processExpression((KtFunction)ktFunctionLiteral);
            }

            private final void processExpression(KtFunction function) {
                if (Util.INSTANCE.findCallIfApplicableTo(function) == null) {
                    return;
                }
                String message2 = function instanceof KtNamedFunction ? KotlinBundle.message((String)"inspection.redundant.anonymous.function.description", (Object[])new Object[0]) : KotlinBundle.message((String)"inspection.redundant.lambda.description", (Object[])new Object[0]);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RedundantLambdaOrAnonymousFunctionFix()};
                this.$holder.registerProblem((PsiElement)function, message2, localQuickFixArray);
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantLambdaOrAnonymousFunctionInspection$RedundantLambdaOrAnonymousFunctionFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "startInWriteAction", "", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
    private static final class RedundantLambdaOrAnonymousFunctionFix
    implements LocalQuickFix {
        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"inspection.redundant.lambda.or.anonymous.function.fix", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getPsiElement();
            KtFunction ktFunction = psiElement instanceof KtFunction ? (KtFunction)psiElement : null;
            if (ktFunction == null) {
                return;
            }
            KtFunction function = ktFunction;
            KtExpression ktExpression = KotlinInlineAnonymousFunctionProcessor.Companion.findCallExpression(function);
            if (ktExpression == null) {
                return;
            }
            KtExpression call2 = ktExpression;
            new KotlinInlineAnonymousFunctionProcessor(function, call2, EditorUtilsKt.findExistingEditor((PsiElement)function), project).run();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantLambdaOrAnonymousFunctionInspection$Util;", "", "<init>", "()V", "findCallIfApplicableTo", "Lorg/jetbrains/kotlin/psi/KtExpression;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "kotlin.idea"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        @Nullable
        public final KtExpression findCallIfApplicableTo(@NotNull KtFunction function) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            return function.hasBody() ? KotlinInlineAnonymousFunctionProcessor.Companion.findCallExpression(function) : null;
        }
    }
}

