/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/WhenWithOnlyElseInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "SimplifyFix", "kotlin.idea"})
public final class WhenWithOnlyElseInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.whenExpressionVisitor(arg_0 -> WhenWithOnlyElseInspection.buildVisitor$lambda$0(holder2, arg_0));
    }

    private static final Unit buildVisitor$lambda$0(ProblemsHolder $holder, KtWhenExpression expression) {
        KtWhenEntry singleEntry;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        List list2 = expression.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEntries(...)");
        KtWhenEntry ktWhenEntry = singleEntry = (KtWhenEntry)CollectionsKt.singleOrNull((List)list2);
        if (!(ktWhenEntry != null ? ktWhenEntry.isElse() : false)) {
            return Unit.INSTANCE;
        }
        boolean usedAsExpression = BindingContextUtilsKt.isUsedAsExpression((KtElement)((KtElement)expression), (BindingContext)ResolutionUtils.analyze$default((KtElement)expression, null, 1, null));
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new SimplifyFix(usedAsExpression)};
        $holder.registerProblem((PsiElement)expression, expression.getWhenKeyword().getTextRange().shiftLeft(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)expression))), KotlinBundle.message((String)"when.has.only.else.branch.and.should.be.simplified", (Object[])new Object[0]), localQuickFixArray);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/WhenWithOnlyElseInspection$SimplifyFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "isUsedAsExpression", "", "<init>", "(Z)V", "getFamilyName", "", "getName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
    private static final class SimplifyFix
    implements LocalQuickFix {
        private final boolean isUsedAsExpression;

        public SimplifyFix(boolean isUsedAsExpression) {
            this.isUsedAsExpression = isUsedAsExpression;
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return KotlinBundle.message((String)"simplify.fix.text", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getPsiElement();
            KtWhenExpression ktWhenExpression = psiElement instanceof KtWhenExpression ? (KtWhenExpression)psiElement : null;
            if (ktWhenExpression == null) {
                return;
            }
            KtWhenExpression whenExpression = ktWhenExpression;
            KtExpression ktExpression = whenExpression.getElseExpression();
            if (ktExpression == null) {
                return;
            }
            ExpressionExtKt.replaceWithBranchAndMoveCaret$default((KtExpression)whenExpression, ktExpression, this.isUsedAsExpression, false, 4, null);
        }
    }
}

