/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.collections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.TextRangeUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.inspections.collections.RedundantAsSequenceInspectionKt;
import org.jetbrains.kotlin.idea.inspections.dfa.KtDfaHelpersKt;
import org.jetbrains.kotlin.idea.intentions.RemoveExplicitTypeArgumentsIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\u00020\t*\u00020\u000bH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\u00020\t*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\t*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/RedundantAsSequenceInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isRedundant", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "registerProblem", "", "qualified", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "callee", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isTermination", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isTransformationOrTermination", "RemoveAsSequenceFix", "kotlin.idea"})
public final class RedundantAsSequenceInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return VisitorWrappersKt.qualifiedExpressionVisitor(arg_0 -> RedundantAsSequenceInspection.buildVisitor$lambda$0(this, holder2, arg_0));
    }

    private final boolean isRedundant(KtTypeArgumentList $this$isRedundant) {
        return RemoveExplicitTypeArgumentsIntention.Companion.isApplicableTo($this$isRedundant, false);
    }

    private final void registerProblem(ProblemsHolder holder2, KtQualifiedExpression qualified, KtExpression callee) {
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RemoveAsSequenceFix()};
        holder2.registerProblem((PsiElement)qualified, TextRangeUtilsKt.textRangeIn((PsiElement)callee, (PsiElement)qualified), KotlinBundle.message((String)"inspection.redundant.assequence.call", (Object[])new Object[0]), localQuickFixArray);
    }

    private final boolean isTermination(KtCallExpression $this$isTermination, BindingContext context) {
        Map map2 = RedundantAsSequenceInspectionKt.access$getTerminations$p();
        KtExpression ktExpression = $this$isTermination.getCalleeExpression();
        FqName fqName2 = (FqName)map2.get(ktExpression != null ? ktExpression.getText() : null);
        if (fqName2 == null) {
            return false;
        }
        FqName fqName3 = fqName2;
        return FunctionUtilsKt.isCalling($this$isTermination, fqName3, context);
    }

    private final boolean isTransformationOrTermination(KtCallExpression $this$isTransformationOrTermination, BindingContext context) {
        Map map2 = RedundantAsSequenceInspectionKt.access$getTransformationsAndTerminations$p();
        KtExpression ktExpression = $this$isTransformationOrTermination.getCalleeExpression();
        FqName fqName2 = (FqName)map2.get(ktExpression != null ? ktExpression.getText() : null);
        if (fqName2 == null) {
            return false;
        }
        FqName fqName3 = fqName2;
        return FunctionUtilsKt.isCalling($this$isTransformationOrTermination, fqName3, context);
    }

    private static final Unit buildVisitor$lambda$0(RedundantAsSequenceInspection this$0, ProblemsHolder $holder, KtQualifiedExpression qualified) {
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(qualified);
        if (ktCallExpression == null) {
            return Unit.INSTANCE;
        }
        KtCallExpression call2 = ktCallExpression;
        KtExpression ktExpression = call2.getCalleeExpression();
        if (ktExpression == null) {
            return Unit.INSTANCE;
        }
        KtExpression callee = ktExpression;
        if (!Intrinsics.areEqual((Object)callee.getText(), (Object)"asSequence")) {
            return Unit.INSTANCE;
        }
        BindingContext context = ResolutionUtils.analyze((KtElement)qualified, BodyResolveMode.PARTIAL);
        if (!FunctionUtilsKt.isCalling(call2, RedundantAsSequenceInspectionKt.access$getAllowedSequenceFunctionFqNames$p(), context)) {
            return Unit.INSTANCE;
        }
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)qualified.getReceiverExpression(), (BindingContext)context);
        if (kotlinType == null) {
            return Unit.INSTANCE;
        }
        KotlinType receiverType = kotlinType;
        if (KtDfaHelpersKt.fqNameEquals(receiverType, "kotlin.sequences.Sequence")) {
            KtTypeArgumentList typeArgumentList = call2.getTypeArgumentList();
            if (typeArgumentList != null && !this$0.isRedundant(typeArgumentList)) {
                return Unit.INSTANCE;
            }
            this$0.registerProblem($holder, qualified, callee);
        } else {
            KtCallExpression grandParentCall;
            if (!FunctionUtilsKt.isIterable$default(receiverType, null, 1, null)) {
                return Unit.INSTANCE;
            }
            KtQualifiedExpression parent2 = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)qualified));
            KtQualifiedExpression ktQualifiedExpression = parent2;
            if (ktQualifiedExpression == null || (ktQualifiedExpression = UtilsKt.getCallExpression(ktQualifiedExpression)) == null) {
                return Unit.INSTANCE;
            }
            KtQualifiedExpression parentCall = ktQualifiedExpression;
            if (!this$0.isTermination((KtCallExpression)parentCall, context)) {
                return Unit.INSTANCE;
            }
            KtQualifiedExpression ktQualifiedExpression2 = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)parent2));
            KtCallExpression ktCallExpression2 = grandParentCall = ktQualifiedExpression2 != null ? UtilsKt.getCallExpression(ktQualifiedExpression2) : null;
            boolean bl = ktCallExpression2 != null ? this$0.isTransformationOrTermination(ktCallExpression2, context) : false;
            if (bl) {
                return Unit.INSTANCE;
            }
            this$0.registerProblem($holder, qualified, callee);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/RedundantAsSequenceInspection$RemoveAsSequenceFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getName", "", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nRedundantAsSequenceInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantAsSequenceInspection.kt\norg/jetbrains/kotlin/idea/inspections/collections/RedundantAsSequenceInspection$RemoveAsSequenceFix\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,99:1\n29#2,7:100\n*S KotlinDebug\n*F\n+ 1 RedundantAsSequenceInspection.kt\norg/jetbrains/kotlin/idea/inspections/collections/RedundantAsSequenceInspection$RemoveAsSequenceFix\n*L\n95#1:100,7\n*E\n"})
    private static final class RemoveAsSequenceFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message((String)"remove.assequence.call.fix.text", (Object[])new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement psiElement;
            void $this$replaced$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtQualifiedExpression ktQualifiedExpression = psiElement2 instanceof KtQualifiedExpression ? (KtQualifiedExpression)psiElement2 : null;
            if (ktQualifiedExpression == null) {
                return;
            }
            KtQualifiedExpression qualified = ktQualifiedExpression;
            CommentSaver commentSaver = new CommentSaver((PsiElement)qualified, false, 2, null);
            PsiElement psiElement3 = (PsiElement)qualified;
            PsiElement newElement$iv = (PsiElement)qualified.getReceiverExpression();
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                psiElement = newElement$iv;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                if (result$iv instanceof KtExpression) {
                    psiElement = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement = (PsiElement)ktExpression;
                }
            }
            KtExpression replaced = (KtExpression)psiElement;
            CommentSaver.restore$default(commentSaver, (PsiElement)replaced, false, 2, null);
        }
    }
}

