/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.psi.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertNullablePropertyToLateinitIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "<init>", "()V", "isApplicableTo", "", "element", "caretOffset", "", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
public final class ConvertNullablePropertyToLateinitIntention
extends SelfTargetingIntention<KtProperty> {
    public ConvertNullablePropertyToLateinitIntention() {
        super(KtProperty.class, KotlinBundle.lazyMessage((String)"convert.to.lateinit.var", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtProperty element, int caretOffset) {
        KtTypeReference typeReference;
        block14: {
            block13: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element.hasModifier(KtTokens.LATEINIT_KEYWORD) || element.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                    return false;
                }
                if (!element.isVar()) {
                    return false;
                }
                LanguageVersionSettings languageVersionSettings = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)element);
                if (!languageVersionSettings.supportsFeature(LanguageFeature.LateinitLocalVariables) && element.isLocal()) {
                    return false;
                }
                if (!languageVersionSettings.supportsFeature(LanguageFeature.LateinitTopLevelProperties) && element.isTopLevel()) {
                    return false;
                }
                KtPropertyAccessor ktPropertyAccessor = element.getGetter();
                if ((ktPropertyAccessor != null ? Boolean.valueOf(ktPropertyAccessor.hasBody()) : null) != null) break block13;
                KtPropertyAccessor ktPropertyAccessor2 = element.getSetter();
                if ((ktPropertyAccessor2 != null ? Boolean.valueOf(ktPropertyAccessor2.hasBody()) : null) == null) break block14;
            }
            return false;
        }
        if (!IfThenUtilsKt.isNullExpression(element.getInitializer())) {
            return false;
        }
        KtTypeReference ktTypeReference = typeReference = element.getTypeReference();
        if (!((ktTypeReference != null ? ktTypeReference.getTypeElement() : null) instanceof KtNullableType)) {
            return false;
        }
        BindingContext context = ResolutionUtils.analyze((KtElement)element, BodyResolveMode.PARTIAL);
        KotlinType kotlinType = (KotlinType)context.get((ReadOnlySlice)BindingContext.TYPE, (Object)typeReference);
        if (kotlinType == null || (kotlinType = TypeUtilsKt.makeNotNullable((KotlinType)kotlinType)) == null) {
            return false;
        }
        KotlinType type2 = kotlinType;
        if (KotlinBuiltIns.isPrimitiveType((KotlinType)type2) || InlineClassesUtilsKt.isInlineClassType((KotlinType)type2) || TypeUtils.isNullableType((KotlinType)type2)) {
            return false;
        }
        Object object = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)element);
        VariableDescriptor variableDescriptor = object instanceof VariableDescriptor ? (VariableDescriptor)object : null;
        if (variableDescriptor == null) {
            return false;
        }
        VariableDescriptor descriptor2 = variableDescriptor;
        if (descriptor2 instanceof PropertyDescriptor && Intrinsics.areEqual((Object)context.get((ReadOnlySlice)BindingContext.BACKING_FIELD_REQUIRED, (Object)descriptor2), (Object)false)) {
            return false;
        }
        return descriptor2.getExtensionReceiverParameter() == null;
    }

    @Override
    public void applyTo(@NotNull KtProperty element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtTypeReference ktTypeReference = element.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference = ktTypeReference;
        KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze((KtElement)element, BodyResolveMode.PARTIAL).get((ReadOnlySlice)BindingContext.TYPE, (Object)typeReference);
        if (kotlinType == null || (kotlinType = TypeUtilsKt.makeNotNullable((KotlinType)kotlinType)) == null) {
            return;
        }
        KotlinType notNullableType = kotlinType;
        element.addModifier(KtTokens.LATEINIT_KEYWORD);
        PsiModificationUtilsKt.setType$default((KtCallableDeclaration)element, notNullableType, false, 2, null);
        element.setInitializer(null);
    }
}

