/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.joinLines;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.ConvertToExpressionBodyUtilsKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.inspections.MergeIfsUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/joinLines/JoinBlockIntoSingleStatementHandler;", "Lcom/intellij/codeInsight/editorActions/JoinLinesHandlerDelegate;", "<init>", "()V", "tryJoinLines", "", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "start", "end", "kotlin.code-insight.impl-base"})
@SourceDebugExtension(value={"SMAP\nJoinBlockIntoSingleStatementHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JoinBlockIntoSingleStatementHandler.kt\norg/jetbrains/kotlin/idea/joinLines/JoinBlockIntoSingleStatementHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class JoinBlockIntoSingleStatementHandler
implements JoinLinesHandlerDelegate {
    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file, int start2, int end) {
        PsiElement psiElement;
        KtDeclarationWithBody oneLineReturnFunction;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof KtFile)) {
            return -1;
        }
        if (start2 == 0) {
            return -1;
        }
        char c = document.getCharsSequence().charAt(start2);
        int index2 = c == '\n' ? start2 - 1 : start2;
        PsiElement psiElement2 = ((KtFile)file).findElementAt(index2);
        if (psiElement2 == null) {
            return -1;
        }
        PsiElement brace = psiElement2;
        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)brace), (Object)KtTokens.LBRACE)) {
            return -1;
        }
        PsiElement psiElement3 = brace.getParent();
        KtBlockExpression ktBlockExpression = psiElement3 instanceof KtBlockExpression ? (KtBlockExpression)psiElement3 : null;
        if (ktBlockExpression == null) {
            return -1;
        }
        KtBlockExpression block = ktBlockExpression;
        List list2 = block.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
        KtExpression ktExpression = (KtExpression)CollectionsKt.singleOrNull((List)list2);
        if (ktExpression == null) {
            return -1;
        }
        KtExpression statement = ktExpression;
        PsiElement parent2 = block.getParent();
        KtDeclarationWithBody ktDeclarationWithBody = parent2 instanceof KtDeclarationWithBody ? (KtDeclarationWithBody)parent2 : null;
        if (ktDeclarationWithBody != null) {
            KtDeclarationWithBody ktDeclarationWithBody2;
            KtDeclarationWithBody it = ktDeclarationWithBody2 = ktDeclarationWithBody;
            boolean bl = false;
            v5 = ConvertToExpressionBodyUtilsKt.isConvertableToExpressionBody(it) ? ktDeclarationWithBody2 : null;
        } else {
            v5 = oneLineReturnFunction = null;
        }
        if (!(parent2 instanceof KtContainerNode) && !(parent2 instanceof KtWhenEntry) && oneLineReturnFunction == null) {
            return -1;
        }
        ASTNode[] aSTNodeArray = block.getNode().getChildren(KtTokens.COMMENTS);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
        if (!(((Object[])aSTNodeArray).length == 0)) {
            return -1;
        }
        PsiElement pparent = ((KtElement)parent2).getParent();
        if (pparent instanceof KtIfExpression) {
            PsiElement ifParent;
            if (Intrinsics.areEqual((Object)block, (Object)((KtIfExpression)pparent).getThen()) && statement instanceof KtIfExpression && ((KtIfExpression)statement).getElse() == null) {
                if (((KtIfExpression)pparent).getElse() != null) {
                    return -1;
                }
                return MergeIfsUtils.INSTANCE.mergeNestedIf((KtIfExpression)pparent);
            }
            if (Intrinsics.areEqual((Object)block, (Object)((KtIfExpression)pparent).getElse()) && !((ifParent = ((KtIfExpression)pparent).getParent()) instanceof KtBlockExpression) && !(ifParent instanceof KtDeclaration) && !KtPsiUtil.isAssignment((PsiElement)ifParent)) {
                return -1;
            }
        }
        if (oneLineReturnFunction != null) {
            ConvertToExpressionBodyUtilsKt.replaceWithExpressionBodyPreservingComments$default(oneLineReturnFunction, false, 1, null);
            KtExpression ktExpression2 = oneLineReturnFunction.getBodyExpression();
            if (ktExpression2 == null) {
                return -1;
            }
            psiElement = (PsiElement)ktExpression2;
        } else {
            psiElement = block.replace((PsiElement)statement);
        }
        PsiElement resultExpression = psiElement;
        Intrinsics.checkNotNull((Object)resultExpression);
        return PsiUtilsKt.getStartOffset((PsiElement)GenericPsiUtils.reformatted(resultExpression, true));
    }
}

