/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.util.SlowOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.permissions.KaAnalysisPermissionRegistry;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaEnumEntrySymbol;
import org.jetbrains.kotlin.idea.base.analysis.RootPrefixUtils;
import org.jetbrains.kotlin.idea.base.psi.imports.ImportInsertionKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.ImportCandidate;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.ImportLikeQuickFix;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.SymbolBasedAutoImportVariant;
import org.jetbrains.kotlin.idea.quickfix.AutoImportVariant;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J:\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u001e\u0010\u0015\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J!\u0010 \u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\"H\u0002R\u00020!\u00a2\u0006\u0002\u0010#J\u0018\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0018H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportQuickFix;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportLikeQuickFix;", "Lcom/intellij/codeInspection/HintAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "text", "", "importVariants", "", "Lorg/jetbrains/kotlin/idea/quickfix/AutoImportVariant;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/lang/String;Ljava/util/List;)V", "getText", "getFamilyName", "createAutoImportAction", "Lcom/intellij/codeInsight/hint/QuestionAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "filterSuggestions", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/name/FqName;", "showHint", "", "fix", "", "importVariant", "project", "Lcom/intellij/openapi/project/Project;", "shouldBeImportedWithShortening", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/SymbolBasedAutoImportVariant;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/SymbolBasedAutoImportVariant;)Z", "isClassDefinitelyPositivelyImportedAlready", "containingFile", "classFqName", "kotlin.code-insight.fixes.k2"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nImportQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportQuickFix.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 permissions.kt\norg/jetbrains/kotlin/analysis/api/permissions/PermissionsKt\n+ 4 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 5 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n*L\n1#1,161:1\n1557#2:162\n1628#2,3:163\n774#2:166\n865#2,2:167\n41#3,2:169\n102#3,2:171\n105#3,5:188\n44#3,3:193\n102#3,8:196\n48#3:204\n30#4,2:173\n35#5,13:175\n*S KotlinDebug\n*F\n+ 1 ImportQuickFix.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportQuickFix\n*L\n54#1:162\n54#1:163,3\n57#1:166\n57#1:167,2\n102#1:169,2\n103#1:171,2\n103#1:188,5\n102#1:193,3\n103#1:196,8\n102#1:204\n104#1:173,2\n104#1:175,13\n*E\n"})
public final class ImportQuickFix
extends ImportLikeQuickFix
implements HintAction,
HighPriorityAction {
    @NotNull
    private final String text;

    public ImportQuickFix(@NotNull KtElement element, @IntentionName @NotNull String text, @NotNull List<? extends AutoImportVariant> importVariants) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(importVariants, (String)"importVariants");
        super(element, importVariants);
        this.text = text;
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"fix.import", (Object[])new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public QuestionAction createAutoImportAction(@NotNull Editor editor, @NotNull KtFile file, @NotNull Function1<? super Collection<FqName>, ? extends Collection<FqName>> filterSuggestions) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(filterSuggestions, (String)"filterSuggestions");
        Iterable iterable = this.getImportVariants();
        Function1<? super Collection<FqName>, ? extends Collection<FqName>> function1 = filterSuggestions;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AutoImportVariant autoImportVariant = (AutoImportVariant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFqName());
        }
        Set filteredFqNames = CollectionsKt.toSet((Iterable)((Iterable)function1.invoke((Object)((List)destination$iv$iv))));
        if (filteredFqNames.size() != 1) {
            return null;
        }
        Iterable $this$filter$iv = this.getImportVariants();
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AutoImportVariant it = (AutoImportVariant)element$iv$iv;
            boolean bl = false;
            if (!filteredFqNames.contains(it.getFqName())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        AutoImportVariant singleSuggestion = (AutoImportVariant)CollectionsKt.first((List)((List)destination$iv$iv2));
        Intrinsics.checkNotNull((Object)singleSuggestion, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.SymbolBasedAutoImportVariant");
        if (((SymbolBasedAutoImportVariant)singleSuggestion).getCanNotBeImportedOnTheFly()) {
            return null;
        }
        ImportLikeQuickFix importLikeQuickFix = this;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new ImportLikeQuickFix.ImportQuestionAction(importLikeQuickFix, project, editor, file, CollectionsKt.listOf((Object)singleSuggestion), true);
    }

    public boolean showHint(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        KtElement ktElement = (KtElement)this.getElement();
        if (ktElement == null) {
            return false;
        }
        KtElement element = ktElement;
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
            return false;
        }
        KtFile ktFile2 = element.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KtFile file = ktFile2;
        TextRange elementRange = element.getTextRange();
        Object[] objectArray = new Object[]{((AutoImportVariant)CollectionsKt.first(this.getImportVariants())).getFqName().asString()};
        String autoImportHintText = KotlinBundle.message((String)"fix.import.question", (Object[])objectArray);
        QuestionAction questionAction = this.createImportAction(editor, file);
        if (questionAction == null) {
            return false;
        }
        QuestionAction importAction = questionAction;
        HintManager.getInstance().showQuestionHint(editor, autoImportHintText, elementRange.getStartOffset(), elementRange.getEndOffset(), importAction);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void fix(@NotNull AutoImportVariant importVariant, @NotNull KtFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)importVariant, (String)"importVariant");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!(importVariant instanceof SymbolBasedAutoImportVariant)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        StatisticsManager.getInstance().incUseCount(((SymbolBasedAutoImportVariant)importVariant).getStatisticsInfo());
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"LLM-15226");
        Throwable throwable = null;
        try {
            boolean bl;
            KtElement element;
            block46: {
                boolean bl2;
                boolean lock$iv$iv22;
                boolean bl3;
                KaSession $this$fix_u24lambda_u246_u24lambda_u244_u24lambda_u243_u24lambda_u242;
                boolean bl4;
                Object object;
                KaSession analysisSession$iv$iv;
                KaSessionProvider this_$iv$iv;
                boolean $i$f$analyze;
                boolean $i$f$analyze2;
                boolean bl5;
                KaAnalysisPermissionRegistry permissionRegistry$iv;
                boolean $i$f$allowAnalysisFromWriteAction;
                boolean bl6;
                KaAnalysisPermissionRegistry permissionRegistry$iv2;
                block47: {
                    KtElement ktElement;
                    AccessToken it = (AccessToken)autoCloseable;
                    boolean bl7 = false;
                    if ((KtElement)this.getElement() == null) {
                        return;
                    }
                    element = ktElement;
                    boolean $i$f$allowAnalysisOnEdt = false;
                    permissionRegistry$iv2 = KaAnalysisPermissionRegistry.Companion.getInstance();
                    if (!permissionRegistry$iv2.isAnalysisAllowedOnEdt()) break block47;
                    bl6 = false;
                    $i$f$allowAnalysisFromWriteAction = false;
                    permissionRegistry$iv = KaAnalysisPermissionRegistry.Companion.getInstance();
                    if (permissionRegistry$iv.isAnalysisAllowedInWriteAction()) {
                        bl5 = false;
                        $i$f$analyze2 = false;
                        Project project2 = element.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project2);
                        $i$f$analyze = false;
                        analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(element);
                        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, element);
                        try {
                            Object lock$iv$iv22;
                            object = lock$iv$iv22 = new Object();
                            synchronized (object) {
                                bl4 = false;
                                $this$fix_u24lambda_u246_u24lambda_u244_u24lambda_u243_u24lambda_u242 = analysisSession$iv$iv;
                                bl3 = false;
                                bl4 = this.shouldBeImportedWithShortening($this$fix_u24lambda_u246_u24lambda_u244_u24lambda_u243_u24lambda_u242, element, (SymbolBasedAutoImportVariant)importVariant);
                            }
                            lock$iv$iv22 = bl4;
                        }
                        finally {
                            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, element);
                        }
                        bl = lock$iv$iv22;
                        break block46;
                    } else {
                        permissionRegistry$iv.setAnalysisAllowedInWriteAction(true);
                        try {
                            bl5 = false;
                            $i$f$analyze2 = false;
                            Project project3 = element.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                            this_$iv$iv = KaSessionProvider.Companion.getInstance(project3);
                            $i$f$analyze = false;
                            analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(element);
                            this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, element);
                            try {
                                Object lock$iv$iv;
                                object = lock$iv$iv = new Object();
                                synchronized (object) {
                                    bl4 = false;
                                    $this$fix_u24lambda_u246_u24lambda_u244_u24lambda_u243_u24lambda_u242 = analysisSession$iv$iv;
                                    bl3 = false;
                                    bl4 = this.shouldBeImportedWithShortening($this$fix_u24lambda_u246_u24lambda_u244_u24lambda_u243_u24lambda_u242, element, (SymbolBasedAutoImportVariant)importVariant);
                                }
                                lock$iv$iv22 = bl4;
                            }
                            finally {
                                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, element);
                            }
                            bl2 = lock$iv$iv22;
                            bl = bl2;
                        }
                        finally {
                            permissionRegistry$iv.setAnalysisAllowedInWriteAction(false);
                        }
                    }
                }
                permissionRegistry$iv2.setAnalysisAllowedOnEdt(true);
                try {
                    boolean bl8;
                    bl6 = false;
                    $i$f$allowAnalysisFromWriteAction = false;
                    permissionRegistry$iv = KaAnalysisPermissionRegistry.Companion.getInstance();
                    if (permissionRegistry$iv.isAnalysisAllowedInWriteAction()) {
                        bl5 = false;
                        $i$f$analyze2 = false;
                        Project project4 = element.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
                        this_$iv$iv = KaSessionProvider.Companion.getInstance(project4);
                        $i$f$analyze = false;
                        analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(element);
                        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, element);
                        try {
                            Object lock$iv$iv;
                            object = lock$iv$iv = new Object();
                            synchronized (object) {
                                bl4 = false;
                                $this$fix_u24lambda_u246_u24lambda_u244_u24lambda_u243_u24lambda_u242 = analysisSession$iv$iv;
                                bl3 = false;
                                bl4 = this.shouldBeImportedWithShortening($this$fix_u24lambda_u246_u24lambda_u244_u24lambda_u243_u24lambda_u242, element, (SymbolBasedAutoImportVariant)importVariant);
                            }
                            lock$iv$iv22 = bl4;
                        }
                        finally {
                            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, element);
                        }
                        bl8 = lock$iv$iv22;
                    } else {
                        permissionRegistry$iv.setAnalysisAllowedInWriteAction(true);
                        try {
                            boolean bl9;
                            bl5 = false;
                            $i$f$analyze2 = false;
                            Project project5 = element.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"getProject(...)");
                            this_$iv$iv = KaSessionProvider.Companion.getInstance(project5);
                            $i$f$analyze = false;
                            analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(element);
                            this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, element);
                            try {
                                boolean bl10;
                                Object lock$iv$iv;
                                object = lock$iv$iv = new Object();
                                synchronized (object) {
                                    bl4 = false;
                                    $this$fix_u24lambda_u246_u24lambda_u244_u24lambda_u243_u24lambda_u242 = analysisSession$iv$iv;
                                    bl3 = false;
                                    bl10 = this.shouldBeImportedWithShortening($this$fix_u24lambda_u246_u24lambda_u244_u24lambda_u243_u24lambda_u242, element, (SymbolBasedAutoImportVariant)importVariant);
                                }
                                bl9 = bl10;
                            }
                            finally {
                                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, element);
                            }
                            bl2 = bl9;
                            bl8 = bl2;
                        }
                        finally {
                            permissionRegistry$iv.setAnalysisAllowedInWriteAction(false);
                        }
                    }
                    boolean bl11 = bl8;
                    bl = bl11;
                }
                finally {
                    permissionRegistry$iv2.setAnalysisAllowedOnEdt(false);
                }
            }
            boolean useShortening = bl;
            String string = QuickFixBundle.message((String)"add.import", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ApplicationUtilsKt.executeWriteCommand(project, string, (Function0<Unit>)((Function0)() -> ImportQuickFix.fix$lambda$6$lambda$5(useShortening, element, importVariant, file)));
            Unit unit = Unit.INSTANCE;
            return;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final boolean shouldBeImportedWithShortening(KaSession $context_receiver_0, KtElement element, SymbolBasedAutoImportVariant importVariant) {
        if (!(element instanceof KtSimpleNameExpression)) {
            return false;
        }
        if (FqNamesUtilKt.isOneSegmentFQN((FqName)importVariant.getFqName())) {
            return false;
        }
        ImportCandidate importCandidate = importVariant.getCandidatePointer().restore($context_receiver_0);
        if (importCandidate == null) {
            return false;
        }
        ImportCandidate restoredCandidate = importCandidate;
        if (!(restoredCandidate.getSymbol() instanceof KaClassLikeSymbol) && !(restoredCandidate.getSymbol() instanceof KaEnumEntrySymbol)) {
            return false;
        }
        return !(((KtSimpleNameExpression)element).getParent() instanceof KtCallableReferenceExpression);
    }

    @Override
    protected boolean isClassDefinitelyPositivelyImportedAlready(@NotNull KtFile containingFile, @NotNull FqName classFqName) {
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        Intrinsics.checkNotNullParameter((Object)classFqName, (String)"classFqName");
        KtImportList importList = containingFile.getImportList();
        if (importList == null) {
            return false;
        }
        for (KtImportDirective statement : importList.getImports()) {
            FqName importRefFqName;
            if (statement.getImportedFqName() == null) continue;
            if (Intrinsics.areEqual((Object)importRefFqName, (Object)classFqName)) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)importRefFqName.shortName(), (Object)Name.identifier((String)"*")) || !Intrinsics.areEqual((Object)importRefFqName.parent(), (Object)classFqName.parent())) continue;
            return true;
        }
        return false;
    }

    private static final Unit fix$lambda$6$lambda$5(boolean $useShortening, KtElement $element, AutoImportVariant $importVariant, KtFile $file) {
        if ($useShortening) {
            KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)$element);
            KtSimpleNameReference ktSimpleNameReference = ktReference instanceof KtSimpleNameReference ? (KtSimpleNameReference)ktReference : null;
            v1 = ktSimpleNameReference != null ? KtSimpleNameReference.bindToFqName$default((KtSimpleNameReference)ktSimpleNameReference, (FqName)RootPrefixUtils.withRootPrefixIfNeeded$default(((SymbolBasedAutoImportVariant)$importVariant).getFqName(), null, 1, null), (KtSimpleNameReference.ShorteningMode)KtSimpleNameReference.ShorteningMode.FORCED_SHORTENING, null, (int)4, null) : null;
        } else {
            v1 = (PsiElement)ImportInsertionKt.addImport$default($file, ((SymbolBasedAutoImportVariant)$importVariant).getFqName(), false, null, null, 14, null);
        }
        return Unit.INSTANCE;
    }
}

