/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.hierarchy.overrides;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.signatures.KaCallableSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolModality;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolOrigin;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaVariableSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaSubstitutor;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.SymbolUtilsKt;
import org.jetbrains.kotlin.idea.base.projectStructure.ApiKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.k2.refactoring.UtilsKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u00020\u000e\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u00020\u000e\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u0002R\u00020\u000e\u00a2\u0006\u0002\u0010\u0013J\u000f\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/hierarchy/overrides/KotlinOverrideHierarchyNodeDescriptor;", "Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;", "parentNode", "klass", "Lcom/intellij/psi/PsiElement;", "baseElement", "<init>", "(Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "Lcom/intellij/psi/SmartPsiElementPointer;", "rawIcon", "Ljavax/swing/Icon;", "stateIcon", "resolveToSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "psiElement", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "getBaseSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "getCurrentClassSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol;", "getCurrentSymbol", "calculateState", "calculateState$kotlin_code_insight_k2", "update", "", "kotlin.code-insight.k2"})
@SourceDebugExtension(value={"SMAP\nKotlinOverrideHierarchyNodeDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinOverrideHierarchyNodeDescriptor.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/hierarchy/overrides/KotlinOverrideHierarchyNodeDescriptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 4 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,177:1\n1#2:178\n45#3,2:179\n54#4,9:181\n65#4,2:192\n1251#5,2:190\n1317#5,2:194\n*S KotlinDebug\n*F\n+ 1 KotlinOverrideHierarchyNodeDescriptor.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/hierarchy/overrides/KotlinOverrideHierarchyNodeDescriptor\n*L\n73#1:179,2\n73#1:181,9\n73#1:192,2\n86#1:190,2\n144#1:194,2\n*E\n"})
public final class KotlinOverrideHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    @NotNull
    private final SmartPsiElementPointer<PsiElement> baseElement;
    @Nullable
    private Icon rawIcon;
    @Nullable
    private Icon stateIcon;

    public KotlinOverrideHierarchyNodeDescriptor(@Nullable HierarchyNodeDescriptor parentNode, @NotNull PsiElement klass, @NotNull PsiElement baseElement) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)baseElement, (String)"baseElement");
        super(klass.getProject(), (NodeDescriptor)parentNode, klass, parentNode == null);
        this.baseElement = SmartPointersKt.createSmartPointer((PsiElement)baseElement);
    }

    private final KaSymbol resolveToSymbol(KaSession $context_receiver_0, PsiElement psiElement) {
        PsiElement psiElement2 = psiElement;
        return psiElement2 instanceof KtNamedDeclaration ? (KaSymbol)$context_receiver_0.getSymbol((KtDeclaration)psiElement) : (psiElement2 instanceof PsiClass ? (KaSymbol)$context_receiver_0.getNamedClassSymbol((PsiClass)psiElement) : (psiElement2 instanceof PsiMember ? (KaSymbol)$context_receiver_0.getCallableSymbol((PsiMember)psiElement) : null));
    }

    private final KaCallableSymbol getBaseSymbol(KaSession $context_receiver_0) {
        KaSymbol kaSymbol;
        PsiElement psiElement = this.baseElement.getElement();
        if (psiElement != null) {
            PsiElement e = psiElement;
            boolean bl = false;
            KaSymbol symbol = this.resolveToSymbol($context_receiver_0, e);
            KaVariableSymbol kaVariableSymbol = symbol instanceof KaValueParameterSymbol ? (KaValueParameterSymbol)symbol : null;
            kaSymbol = kaVariableSymbol != null && (kaVariableSymbol = kaVariableSymbol.getGeneratedPrimaryConstructorProperty()) != null ? (KaSymbol)kaVariableSymbol : symbol;
        } else {
            kaSymbol = null;
        }
        KaSymbol kaSymbol2 = kaSymbol;
        return kaSymbol2 instanceof KaCallableSymbol ? (KaCallableSymbol)kaSymbol2 : null;
    }

    private final KaClassSymbol getCurrentClassSymbol(KaSession $context_receiver_0) {
        KaSymbol kaSymbol;
        PsiElement psiElement = this.getPsiElement();
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            kaSymbol = this.resolveToSymbol($context_receiver_0, it);
        } else {
            kaSymbol = null;
        }
        KaSymbol kaSymbol2 = kaSymbol;
        return kaSymbol2 instanceof KaClassSymbol ? (KaClassSymbol)kaSymbol2 : null;
    }

    private final KaCallableSymbol getCurrentSymbol(KaSession $context_receiver_0) {
        KaClassSymbol kaClassSymbol = this.getCurrentClassSymbol($context_receiver_0);
        if (kaClassSymbol == null) {
            return null;
        }
        KaClassSymbol classSymbol = kaClassSymbol;
        KaCallableSymbol kaCallableSymbol = this.getBaseSymbol($context_receiver_0);
        if (kaCallableSymbol == null) {
            return null;
        }
        KaCallableSymbol baseSymbol = kaCallableSymbol;
        KaDeclarationSymbol kaDeclarationSymbol = $context_receiver_0.getContainingDeclaration(baseSymbol);
        KaClassSymbol kaClassSymbol2 = kaDeclarationSymbol instanceof KaClassSymbol ? (KaClassSymbol)kaDeclarationSymbol : null;
        if (kaClassSymbol2 == null) {
            return null;
        }
        KaClassSymbol baseClassSymbol = kaClassSymbol2;
        KaSubstitutor kaSubstitutor = $context_receiver_0.createInheritanceTypeSubstitutor(classSymbol, baseClassSymbol);
        if (kaSubstitutor == null) {
            return null;
        }
        KaSubstitutor substitution2 = kaSubstitutor;
        KaCallableSignature<KaCallableSymbol> callableSignature = $context_receiver_0.substitute(baseSymbol, substitution2);
        return UtilsKt.findCallableMemberBySignature($context_receiver_0, classSymbol, callableSignature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Icon calculateState$kotlin_code_insight_k2() {
        Icon icon2;
        KaSessionProvider sessionProvider$iv;
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaModule module = ApiKt.getKaModule(element, project, null);
        boolean $i$f$analyze = false;
        KaSessionProvider this_$iv$iv = sessionProvider$iv = KaSessionProvider.Companion.getInstance(module.getProject());
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(module);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, module);
        try {
            Icon icon3;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                Icon icon4;
                boolean bl = false;
                KaSession $this$calculateState_u24lambda_u243 = analysisSession$iv$iv;
                boolean bl2 = false;
                KaClassSymbol kaClassSymbol = this.getCurrentClassSymbol($this$calculateState_u24lambda_u243);
                if (kaClassSymbol == null) {
                    icon4 = null;
                } else {
                    KaClassSymbol classSymbol = kaClassSymbol;
                    KaCallableSymbol kaCallableSymbol = this.getCurrentSymbol($this$calculateState_u24lambda_u243);
                    if (kaCallableSymbol == null) {
                        icon4 = AllIcons.Hierarchy.MethodNotDefined;
                    } else {
                        KaCallableSymbol callableSymbol = kaCallableSymbol;
                        if (SymbolUtilsKt.isJavaSourceOrLibrary(callableSymbol.getOrigin()) || callableSymbol.getOrigin() == KaSymbolOrigin.JAVA_SYNTHETIC_PROPERTY || callableSymbol.getOrigin() == KaSymbolOrigin.LIBRARY || callableSymbol.getOrigin() == KaSymbolOrigin.SOURCE) {
                            icon4 = callableSymbol.getModality() == KaSymbolModality.ABSTRACT ? null : AllIcons.Hierarchy.MethodDefined;
                        } else {
                            boolean bl3;
                            boolean isAbstractClass;
                            block14: {
                                isAbstractClass = classSymbol.getModality() == KaSymbolModality.ABSTRACT;
                                Sequence<KaCallableSymbol> $this$any$iv = $this$calculateState_u24lambda_u243.getAllOverriddenSymbols(callableSymbol);
                                boolean $i$f$any = false;
                                for (Object element$iv : $this$any$iv) {
                                    KaCallableSymbol it = (KaCallableSymbol)element$iv;
                                    boolean bl4 = false;
                                    if (!(it.getModality() != KaSymbolModality.ABSTRACT)) continue;
                                    bl3 = true;
                                    break block14;
                                }
                                bl3 = false;
                            }
                            boolean hasBaseImplementation = bl3;
                            icon4 = isAbstractClass || hasBaseImplementation ? AllIcons.Hierarchy.MethodNotDefined : AllIcons.Hierarchy.ShouldDefineMethod;
                        }
                    }
                }
                icon3 = icon4;
            }
            icon2 = icon3;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, module);
        }
        return icon2;
    }

    public boolean update() {
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        boolean changes = super.update();
        PsiElement classPsi = this.getPsiElement();
        if (classPsi == null) {
            String string = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String invalidPrefix = string;
            String string2 = this.myHighlightedText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            if (!StringsKt.startsWith$default((String)string2, (String)invalidPrefix, (boolean)false, (int)2, null)) {
                this.myHighlightedText.getBeginning().addText(invalidPrefix, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
            }
            return true;
        }
        Icon newRawIcon = classPsi.getIcon(flags);
        Icon newStateIcon = this.calculateState$kotlin_code_insight_k2();
        if (changes || newRawIcon != this.rawIcon || newStateIcon != this.stateIcon) {
            Icon[] icon2;
            changes = true;
            this.rawIcon = newRawIcon;
            this.stateIcon = newStateIcon;
            Icon newIcon = this.rawIcon;
            if (this.myIsBase) {
                icon2 = new LayeredIcon(2);
                icon2.setIcon(newIcon, 0);
                icon2.setIcon(AllIcons.Actions.Forward, 1, -AllIcons.Actions.Forward.getIconWidth() / 2, 0);
                newIcon = (Icon)icon2;
            }
            if (this.stateIcon != null) {
                icon2 = new Icon[]{this.stateIcon, newIcon};
                newIcon = (Icon)new RowIcon(icon2);
            }
            this.setIcon(newIcon);
        }
        CompositeAppearance compositeAppearance = this.myHighlightedText;
        Intrinsics.checkNotNullExpressionValue((Object)compositeAppearance, (String)"myHighlightedText");
        CompositeAppearance oldText = compositeAppearance;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        CompositeAppearance.DequeEnd $this$update_u24lambda_u246 = this.myHighlightedText.getEnding();
        boolean bl = false;
        String classDescriptorAsString = ((PsiNamedElement)classPsi).getName();
        $this$update_u24lambda_u246.addText(classDescriptorAsString, classNameAttributes);
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)PsiUtilsKt.getParents((PsiElement)classPsi), KotlinOverrideHierarchyNodeDescriptor::update$lambda$6$lambda$4);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String parentDescriptorAsString;
            PsiElement parent2 = (PsiElement)element$iv;
            boolean bl2 = false;
            PsiElement psiElement = parent2;
            if (psiElement instanceof KtClass || psiElement instanceof KtCallableDeclaration || psiElement instanceof PsiMember) {
                PsiElement psiElement2 = parent2;
                Object object = psiElement2 instanceof PsiNamedElement ? (PsiNamedElement)psiElement2 : null;
                if (object == null || (object = object.getName()) == null) continue;
                Object name2 = object;
                Object[] objectArray = new Object[]{name2};
                $this$update_u24lambda_u246.addText(KotlinBundle.message((String)"hierarchy.text.in", (Object[])objectArray), classNameAttributes);
                if (!(parent2 instanceof KtFunction) && !(parent2 instanceof PsiMethod)) continue;
                $this$update_u24lambda_u246.addText("()", classNameAttributes);
                continue;
            }
            if (psiElement instanceof KtFile) {
                Object object = ((KtFile)parent2).getPackageDirective();
                if (object == null || (object = object.getQualifiedName()) == null) {
                    object = "";
                }
                parentDescriptorAsString = object;
                $this$update_u24lambda_u246.addText("  (" + parentDescriptorAsString + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
                continue;
            }
            if (!(psiElement instanceof PsiClassOwner)) continue;
            parentDescriptorAsString = ((PsiClassOwner)parent2).getPackageName();
            $this$update_u24lambda_u246.addText("  (" + parentDescriptorAsString + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }

    private static final boolean update$lambda$6$lambda$4(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof PsiNamedElement;
    }
}

