/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.hints;

import com.intellij.codeInsight.codeVision.CodeVisionRelativeOrdering;
import com.intellij.codeInsight.daemon.impl.InheritorsLineMarkerNavigator;
import com.intellij.codeInsight.hints.codeVision.CodeVisionProviderBase;
import com.intellij.codeInsight.hints.codeVision.InheritorsCodeVisionProvider;
import com.intellij.java.analysis.OuterModelsModificationTrackerManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.awt.event.MouseEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.searching.inheritors.KotlinSearchUtilKt;
import org.jetbrains.kotlin.idea.statistics.KotlinCodeVisionUsagesCollector;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\"\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/hints/KotlinInheritorsCodeVisionProvider;", "Lcom/intellij/codeInsight/hints/codeVision/InheritorsCodeVisionProvider;", "<init>", "()V", "acceptsFile", "", "file", "Lcom/intellij/psi/PsiFile;", "acceptsElement", "element", "Lcom/intellij/psi/PsiElement;", "getVisionInfo", "Lcom/intellij/codeInsight/hints/codeVision/CodeVisionProviderBase$CodeVisionInfo;", "getClassInheritors", "", "Lorg/jetbrains/kotlin/psi/KtClass;", "getCallableInheritors", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "getHint", "", "logClickToFUS", "", "hint", "handleClick", "editor", "Lcom/intellij/openapi/editor/Editor;", "event", "Ljava/awt/event/MouseEvent;", "relativeOrderings", "", "Lcom/intellij/codeInsight/codeVision/CodeVisionRelativeOrdering;", "getRelativeOrderings", "()Ljava/util/List;", "id", "getId", "()Ljava/lang/String;", "Companion", "kotlin.code-insight.k2"})
public final class KotlinInheritorsCodeVisionProvider
extends InheritorsCodeVisionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "kotlin.inheritors";

    public boolean acceptsFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getLanguage(), (Object)KotlinLanguage.INSTANCE);
    }

    public boolean acceptsElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof KtCallableDeclaration || element instanceof KtClass;
    }

    @Nullable
    public CodeVisionProviderBase.CodeVisionInfo getVisionInfo(@NotNull PsiElement element, @NotNull PsiFile file) {
        int n;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (element instanceof KtCallableDeclaration) {
            n = this.getCallableInheritors((KtCallableDeclaration)element);
        } else if (element instanceof KtClass) {
            n = this.getClassInheritors((KtClass)element);
        } else {
            return null;
        }
        int count = n;
        if (count > 0) {
            boolean bl;
            KtTypeParameterListOwner ktTypeParameterListOwner = (KtTypeParameterListOwner)element;
            if (ktTypeParameterListOwner instanceof KtCallableDeclaration) {
                bl = !KtPsiUtilKt.hasBody((KtDeclaration)((KtDeclaration)element));
            } else if (ktTypeParameterListOwner instanceof KtClass) {
                bl = ((KtClass)element).isInterface() || ((KtClass)element).hasModifier(KtTokens.ABSTRACT_KEYWORD);
            } else {
                return null;
            }
            boolean isAbstractMethod = bl;
            String key = isAbstractMethod ? "hints.codevision.implementations.format" : (element instanceof KtClass ? "hints.codevision.inheritors.format" : "hints.codevision.overrides.format");
            Object[] objectArray = new Object[]{count};
            return new CodeVisionProviderBase.CodeVisionInfo(KotlinBundle.message((String)key, (Object[])objectArray), Integer.valueOf(count), false, 4, null);
        }
        return null;
    }

    private final int getClassInheritors(KtClass element) {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)element), () -> KotlinInheritorsCodeVisionProvider.getClassInheritors$lambda$0(element));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return ((Number)object).intValue();
    }

    private final int getCallableInheritors(KtCallableDeclaration element) {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)element), () -> KotlinInheritorsCodeVisionProvider.getCallableInheritors$lambda$1(element));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return ((Number)object).intValue();
    }

    @Nullable
    public String getHint(@NotNull PsiElement element, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CodeVisionProviderBase.CodeVisionInfo codeVisionInfo = this.getVisionInfo(element, file);
        return codeVisionInfo != null ? codeVisionInfo.getText() : null;
    }

    public void logClickToFUS(@NotNull PsiElement element, @NotNull String hint2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)hint2, (String)"hint");
        PsiElement psiElement = element;
        if (psiElement instanceof KtClassOrObject) {
            string = element instanceof KtClass && ((KtClass)element).isInterface() ? "interface" : "class";
        } else if (psiElement instanceof KtFunction) {
            string = "function";
        } else if (psiElement instanceof KtProperty) {
            string = "property";
        } else {
            return;
        }
        String location = string;
        KotlinCodeVisionUsagesCollector.INSTANCE.logInheritorsClicked(((KtTypeParameterListOwner)element).getProject(), location);
    }

    public void handleClick(@NotNull Editor editor, @NotNull PsiElement element, @Nullable MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        InheritorsLineMarkerNavigator lineMarkerNavigator2 = new InheritorsLineMarkerNavigator(){

            protected String getMessageForDumbMode() {
                return KotlinBundle.message((String)"notification.navigation.to.overriding.classes", (Object[])new Object[0]);
            }
        };
        KtNamedDeclaration ktNamedDeclaration = element instanceof KtNamedDeclaration ? (KtNamedDeclaration)element : null;
        if (ktNamedDeclaration == null || (ktNamedDeclaration = ktNamedDeclaration.getNameIdentifier()) == null) {
            ktNamedDeclaration = element;
        }
        lineMarkerNavigator2.navigate(event, (PsiElement)ktNamedDeclaration);
    }

    @NotNull
    public List<CodeVisionRelativeOrdering> getRelativeOrderings() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public String getId() {
        return ID;
    }

    private static final CachedValueProvider.Result getClassInheritors$lambda$0(KtClass $element) {
        int overrides2 = SequencesKt.count((Sequence)KotlinSearchUtilKt.findAllInheritors$default($element, null, 1, null));
        Object[] objectArray = new Object[]{OuterModelsModificationTrackerManager.getTracker((Project)$element.getProject())};
        return new CachedValueProvider.Result((Object)overrides2, objectArray);
    }

    private static final CachedValueProvider.Result getCallableInheritors$lambda$1(KtCallableDeclaration $element) {
        int overrides2 = SequencesKt.count((Sequence)KotlinSearchUtilKt.findAllOverridings$default($element, null, 1, null));
        Object[] objectArray = new Object[]{OuterModelsModificationTrackerManager.getTracker((Project)$element.getProject())};
        return new CachedValueProvider.Result((Object)overrides2, objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/hints/KotlinInheritorsCodeVisionProvider$Companion;", "", "<init>", "()V", "ID", "", "kotlin.code-insight.k2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

