/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.base.KaConstantValue;
import org.jetbrains.kotlin.analysis.api.components.KaDiagnosticCheckerFilter;
import org.jetbrains.kotlin.analysis.api.diagnostics.KaDiagnosticWithPsi;
import org.jetbrains.kotlin.analysis.api.fir.diagnostics.KaFirDiagnostic;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.CleanupFix;
import org.jetbrains.kotlin.idea.codeinsight.utils.PropertyModifierUtilsKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.inspections.MayBeConstantInspectionBase;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.inspections.MayBeConstantInspectionBaseKt;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFix;
import org.jetbrains.kotlin.idea.util.AnnotationModificationUtilsKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\f\u0010\b\u001a\u00020\t*\u00020\u0007H\u0014J\u0015\u0010\n\u001a\u00020\u000b*\u00020\u0007H\u0002R\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0010H\u0002R\u00020\f\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u000b*\u00020\u0010H\u0002R\u00020\f\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/MayBeConstantInspection;", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/inspections/MayBeConstantInspectionBase;", "<init>", "()V", "createAddConstModifierFix", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getConstantStatus", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/inspections/MayBeConstantInspectionBase$Status;", "hasNonNullablePrimitiveOrStringType", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtProperty;)Z", "getConstantValue", "Lorg/jetbrains/kotlin/analysis/api/base/KaConstantValue;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/analysis/api/base/KaConstantValue;", "usesNonConstValAsConstant", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtExpression;)Z", "AddConstModifierFix", "kotlin.code-insight.inspections.k2"})
@SourceDebugExtension(value={"SMAP\nMayBeConstantInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MayBeConstantInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/MayBeConstantInspection\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n30#2,2:97\n30#2,2:112\n35#3,13:99\n35#3,13:114\n1#4:127\n*S KotlinDebug\n*F\n+ 1 MayBeConstantInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/MayBeConstantInspection\n*L\n38#1:97,2\n47#1:112,2\n38#1:99,13\n47#1:114,13\n*E\n"})
public final class MayBeConstantInspection
extends MayBeConstantInspectionBase {
    @Override
    @NotNull
    protected AddModifierFix createAddConstModifierFix(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return new AddConstModifierFix(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected MayBeConstantInspectionBase.Status getConstantStatus(@NotNull KtProperty $this$getConstantStatus) {
        Object object;
        Object object2;
        Object object3;
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getConstantStatus, (String)"<this>");
        if (!PropertyModifierUtilsKt.checkMayBeConstantByFields($this$getConstantStatus)) {
            return MayBeConstantInspectionBase.Status.NONE;
        }
        KtExpression initializer2 = $this$getConstantStatus.getInitializer();
        boolean $i$f$analyze = false;
        Project project = ((KtElement)$this$getConstantStatus).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)$this$getConstantStatus);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)$this$getConstantStatus);
        try {
            Object lock$iv$iv;
            object3 = lock$iv$iv = new Object();
            synchronized (object3) {
                block22: {
                    boolean bl = false;
                    KaSession $this$getConstantStatus_u24lambda_u240 = analysisSession$iv$iv;
                    boolean bl2 = false;
                    if (this.hasNonNullablePrimitiveOrStringType($this$getConstantStatus_u24lambda_u240, $this$getConstantStatus)) break block22;
                    MayBeConstantInspectionBase.Status status = MayBeConstantInspectionBase.Status.NONE;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 10] lbl24 : MonitorExitStatement: MONITOREXIT : var8_11 /* !! */ 
                    MayBeConstantInspectionBase.Status status2 = status;
                    return status2;
                }
                object2 = Unit.INSTANCE;
            }
            lock$iv$iv = object2;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)$this$getConstantStatus);
        }
        boolean withJvmField = AnnotationModificationUtilsKt.findAnnotation$default((KtAnnotated)$this$getConstantStatus, ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"kotlin/jvm/JvmField", (boolean)false, (int)2, null), null, false, 6, null) != null;
        List list2 = $this$getConstantStatus.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
        if (!((Collection)list2).isEmpty() && !withJvmField) {
            return MayBeConstantInspectionBase.Status.NONE;
        }
        if (initializer2 != null) {
            void this_$iv$iv2;
            boolean $i$f$analyze3 = false;
            Project project2 = ((KtElement)initializer2).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            KaSessionProvider $i$f$analyze4 = KaSessionProvider.Companion.getInstance(project2);
            boolean $i$f$analyze5 = false;
            KaSession analysisSession$iv$iv2 = this_$iv$iv2.getAnalysisSession((KtElement)initializer2);
            this_$iv$iv2.beforeEnteringAnalysis(analysisSession$iv$iv2, (KtElement)initializer2);
            try {
                MayBeConstantInspectionBase.Status status;
                Object lock$iv$iv = new Object();
                object2 = lock$iv$iv;
                synchronized (object2) {
                    boolean erroneousConstant;
                    block25: {
                        KaConstantValue kaConstantValue;
                        KaSession $this$getConstantStatus_u24lambda_u241;
                        block24: {
                            boolean bl = false;
                            $this$getConstantStatus_u24lambda_u241 = analysisSession$iv$iv2;
                            boolean bl3 = false;
                            if (this.getConstantValue($this$getConstantStatus_u24lambda_u241, initializer2) != null) break block24;
                            MayBeConstantInspectionBase.Status status3 = MayBeConstantInspectionBase.Status.NONE;
                            // MONITOREXIT @DISABLED, blocks:[4, 21, 5, 11] lbl66 : MonitorExitStatement: MONITOREXIT : var9_14 /* !! */ 
                            MayBeConstantInspectionBase.Status status4 = status3;
                            return status4;
                        }
                        KaConstantValue constant = kaConstantValue;
                        erroneousConstant = this.usesNonConstValAsConstant($this$getConstantStatus_u24lambda_u241, initializer2);
                        if (!(constant instanceof KaConstantValue.NullValue) && !(constant instanceof KaConstantValue.ErrorValue)) break block25;
                        MayBeConstantInspectionBase.Status status5 = MayBeConstantInspectionBase.Status.NONE;
                        // MONITOREXIT @DISABLED, blocks:[4, 21, 7, 11] lbl74 : MonitorExitStatement: MONITOREXIT : var9_14 /* !! */ 
                        MayBeConstantInspectionBase.Status status6 = status5;
                        return status6;
                    }
                    status = MayBeConstantInspectionBaseKt.matchStatus(withJvmField, erroneousConstant);
                }
                object3 = status;
            }
            finally {
                this_$iv$iv2.afterLeavingAnalysis(analysisSession$iv$iv2, (KtElement)initializer2);
            }
            object = object3;
        } else {
            object = withJvmField ? MayBeConstantInspectionBase.Status.JVM_FIELD_MIGHT_BE_CONST_NO_INITIALIZER : MayBeConstantInspectionBase.Status.NONE;
        }
        return object;
    }

    private final boolean hasNonNullablePrimitiveOrStringType(KaSession $context_receiver_0, KtProperty $this$hasNonNullablePrimitiveOrStringType) {
        KaType type2 = $context_receiver_0.getReturnType((KtDeclaration)$this$hasNonNullablePrimitiveOrStringType);
        if ($context_receiver_0.isMarkedNullable(type2)) {
            return false;
        }
        return $context_receiver_0.isPrimitive(type2) || $context_receiver_0.isStringType(type2);
    }

    private final KaConstantValue getConstantValue(KaSession $context_receiver_0, KtExpression $this$getConstantValue) {
        return $context_receiver_0.evaluate($this$getConstantValue);
    }

    private final boolean usesNonConstValAsConstant(KaSession $context_receiver_0, KtExpression $this$usesNonConstValAsConstant) {
        Object v0;
        block1: {
            Collection<KaDiagnosticWithPsi<?>> diagnostics = $context_receiver_0.diagnostics((KtElement)$this$usesNonConstValAsConstant, KaDiagnosticCheckerFilter.ONLY_COMMON_CHECKERS);
            Iterable iterable = diagnostics;
            for (Object t : iterable) {
                KaDiagnosticWithPsi it = (KaDiagnosticWithPsi)t;
                boolean bl = false;
                if (!(it instanceof KaFirDiagnostic.NonConstValUsedInConstantExpression)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/MayBeConstantInspection$AddConstModifierFix;", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/CleanupFix;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtProperty;)V", "startInWriteAction", "", "invokeImpl", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "addConstModifier", "kotlin.code-insight.inspections.k2"})
    @SourceDebugExtension(value={"SMAP\nMayBeConstantInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MayBeConstantInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/MayBeConstantInspection$AddConstModifierFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1863#2,2:97\n*S KotlinDebug\n*F\n+ 1 MayBeConstantInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/MayBeConstantInspection$AddConstModifierFix\n*L\n92#1:97,2\n*E\n"})
    private static final class AddConstModifierFix
    extends AddModifierFix
    implements CleanupFix {
        public AddConstModifierFix(@NotNull KtProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)property;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.CONST_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"CONST_KEYWORD");
            super(ktModifierListOwner, ktModifierKeywordToken);
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        @Override
        protected void invokeImpl(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Object t = this.getElement();
            KtProperty ktProperty = t instanceof KtProperty ? (KtProperty)t : null;
            if (ktProperty == null) {
                return;
            }
            KtProperty property = ktProperty;
            this.addConstModifier(property);
        }

        private final void addConstModifier(KtProperty property) {
            List<KtAnnotationEntry> annotationsToRemove = PropertyModifierUtilsKt.getJvmAnnotations(property);
            JavaFileType javaFileType = JavaFileType.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)javaFileType, (String)"INSTANCE");
            PropertyModifierUtilsKt.replaceReferencesToGetterByReferenceToField(property, (LanguageFileType)javaFileType);
            ApplicationUtilsKt.runWriteActionIfPhysical((PsiElement)property, () -> AddConstModifierFix.addConstModifier$lambda$0(property, annotationsToRemove));
        }

        private static final Unit addConstModifier$lambda$0(KtProperty $property, List $annotationsToRemove) {
            $property.addModifier(KtTokens.CONST_KEYWORD);
            Iterable $this$forEach$iv = $annotationsToRemove;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtAnnotationEntry p0 = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                p0.delete();
            }
            return Unit.INSTANCE;
        }
    }
}

