/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaFunctionType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.TypeUtilsKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0016\u0010\r\u001a\u0004\u0018\u00010\f*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"COROUTINE_CONTEXT_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "COROUTINE_SCOPE_FQ_NAME", "RUN_BLOCKING_FQ_NAME", "WITH_CONTEXT_FQ_NAME", "RUN_BLOCKING_FUNCTION_NAME", "", "RUN_FUNCTION_NAME", "isRunBlocking", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "function", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol;", "resolveToFunctionSymbol", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "analysisSession", "kotlin.code-insight.inspections.k2"})
public final class RunBlockingInSuspendFunctionInspectionKt {
    @NotNull
    private static final FqName COROUTINE_CONTEXT_FQ_NAME = new FqName("kotlin.coroutines.CoroutineContext");
    @NotNull
    private static final FqName COROUTINE_SCOPE_FQ_NAME = new FqName("kotlinx.coroutines.CoroutineScope");
    @NotNull
    private static final FqName RUN_BLOCKING_FQ_NAME = new FqName("kotlinx.coroutines.runBlocking");
    @NotNull
    private static final FqName WITH_CONTEXT_FQ_NAME = new FqName("kotlinx.coroutines.withContext");
    @NotNull
    private static final String RUN_BLOCKING_FUNCTION_NAME = "runBlocking";
    @NotNull
    private static final String RUN_FUNCTION_NAME = "run";

    private static final boolean isRunBlocking(KaSession $this$isRunBlocking, KaNamedFunctionSymbol function) {
        if (!Intrinsics.areEqual((Object)$this$isRunBlocking.getImportableFqName(function), (Object)RUN_BLOCKING_FQ_NAME)) {
            return false;
        }
        if (function.getValueParameters().size() != 2) {
            return false;
        }
        return RunBlockingInSuspendFunctionInspectionKt.isRunBlocking$checkFirstParameter(function, $this$isRunBlocking) && RunBlockingInSuspendFunctionInspectionKt.isRunBlocking$checkSecondParameter(function, $this$isRunBlocking);
    }

    private static final KaNamedFunctionSymbol resolveToFunctionSymbol(KtCallExpression $this$resolveToFunctionSymbol, KaSession analysisSession) {
        KaSymbol kaSymbol;
        KaSession $this$resolveToFunctionSymbol_u24lambda_u240 = analysisSession;
        boolean bl = false;
        KtExpression ktExpression = $this$resolveToFunctionSymbol.getCalleeExpression();
        KaSymbol kaSymbol2 = ktExpression != null && (ktExpression = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)ktExpression))) != null ? $this$resolveToFunctionSymbol_u24lambda_u240.resolveToSymbol((KtReference)ktExpression) : (kaSymbol = null);
        return kaSymbol instanceof KaNamedFunctionSymbol ? (KaNamedFunctionSymbol)kaSymbol : null;
    }

    private static final boolean isRunBlocking$checkFirstParameter(KaNamedFunctionSymbol $function, KaSession $this_isRunBlocking) {
        KaValueParameterSymbol parameter = (KaValueParameterSymbol)CollectionsKt.first($function.getValueParameters());
        KaClassLikeSymbol kaClassLikeSymbol = TypeUtilsKt.getSymbol(parameter.getReturnType());
        if (kaClassLikeSymbol == null) {
            return false;
        }
        KaClassLikeSymbol symbol = kaClassLikeSymbol;
        return Intrinsics.areEqual((Object)$this_isRunBlocking.getImportableFqName(symbol), (Object)COROUTINE_CONTEXT_FQ_NAME);
    }

    private static final boolean isRunBlocking$checkSecondParameter(KaNamedFunctionSymbol $function, KaSession $this_isRunBlocking) {
        KaValueParameterSymbol parameter = (KaValueParameterSymbol)CollectionsKt.last($function.getValueParameters());
        KaType parameterType = parameter.getReturnType();
        if (!$this_isRunBlocking.isSuspendFunctionType(parameterType)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)parameterType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.analysis.api.types.KaFunctionType");
        KaLifetimeOwner kaLifetimeOwner = ((KaFunctionType)parameterType).getReceiverType();
        if (kaLifetimeOwner == null || (kaLifetimeOwner = TypeUtilsKt.getSymbol(kaLifetimeOwner)) == null) {
            return false;
        }
        KaLifetimeOwner receiverSymbol = kaLifetimeOwner;
        return Intrinsics.areEqual((Object)$this_isRunBlocking.getImportableFqName((KaSymbol)receiverSymbol), (Object)COROUTINE_SCOPE_FQ_NAME);
    }

    public static final /* synthetic */ KaNamedFunctionSymbol access$resolveToFunctionSymbol(KtCallExpression $receiver, KaSession analysisSession) {
        return RunBlockingInSuspendFunctionInspectionKt.resolveToFunctionSymbol($receiver, analysisSession);
    }

    public static final /* synthetic */ boolean access$isRunBlocking(KaSession $receiver, KaNamedFunctionSymbol function) {
        return RunBlockingInSuspendFunctionInspectionKt.isRunBlocking($receiver, function);
    }

    public static final /* synthetic */ FqName access$getWITH_CONTEXT_FQ_NAME$p() {
        return WITH_CONTEXT_FQ_NAME;
    }
}

