/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.ConstantExpressionEvaluator;
import com.intellij.psi.impl.LanguageConstantExpressionEvaluator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0014J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\r\u0010\u0011\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0012H\u0016J\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0003*\u00020\u00142\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u000e\u0010\u0017\u001a\u00020\u0016*\u0004\u0018\u00010\u0018H\u0002R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/EvaluateCompileTimeExpressionIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "", "<init>", "()V", "invoke", "", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "element", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "isApplicableByPsi", "", "isConstantExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "constantNodeTypes", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.code-insight.intentions.k2"})
@SourceDebugExtension(value={"SMAP\nEvaluateCompileTimeExpressionIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EvaluateCompileTimeExpressionIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/EvaluateCompileTimeExpressionIntention\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,78:1\n213#2:79\n*S KotlinDebug\n*F\n+ 1 EvaluateCompileTimeExpressionIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/EvaluateCompileTimeExpressionIntention\n*L\n60#1:79\n*E\n"})
public final class EvaluateCompileTimeExpressionIntention
extends KotlinApplicableModCommandAction<KtBinaryExpression, String> {
    @NotNull
    private final List<IElementType> constantNodeTypes;

    public EvaluateCompileTimeExpressionIntention() {
        super(Reflection.getOrCreateKotlinClass(KtBinaryExpression.class));
        Object[] objectArray = new IElementType[]{KtNodeTypes.FLOAT_CONSTANT, KtNodeTypes.CHARACTER_CONSTANT, KtNodeTypes.INTEGER_CONSTANT};
        this.constantNodeTypes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    protected void invoke(@NotNull ActionContext actionContext, @NotNull KtBinaryExpression element, @NotNull String elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        element.replace((PsiElement)new KtPsiFactory(project, false, 2, null).createExpression(elementContext));
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = (String)this.getElementContext(context, (KtElement)element);
        if (string == null) {
            return null;
        }
        String constantValue = string;
        Object[] objectArray = new Object[]{constantValue};
        return Presentation.of((String)KotlinBundle.message((String)"replace.with.0", (Object[])objectArray));
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"evaluate.compile.time.expression", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public String prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ConstantExpressionEvaluator expressionEvaluator = (ConstantExpressionEvaluator)LanguageConstantExpressionEvaluator.INSTANCE.forLanguage(element.getLanguage());
        Object object = expressionEvaluator.computeConstantExpression((PsiElement)element, false);
        if (object == null) {
            return null;
        }
        Object value = object;
        Object object2 = value;
        return object2 instanceof Character ? "'" + StringUtil.escapeStringCharacters((String)String.valueOf(((Character)value).charValue())) + "'" : (object2 instanceof Long ? value + "L" : (object2 instanceof Float ? (Float.isNaN(((Number)value).floatValue()) ? "Float.NaN" : (Float.isInfinite(((Number)value).floatValue()) ? (((Number)value).floatValue() > 0.0f ? "Float.POSITIVE_INFINITY" : "Float.NEGATIVE_INFINITY") : value + "f")) : (object2 instanceof Double ? (Double.isNaN(((Number)value).doubleValue()) ? "Double.NaN" : (Double.isInfinite(((Number)value).doubleValue()) ? (((Number)value).doubleValue() > 0.0 ? "Double.POSITIVE_INFINITY" : "Double.NEGATIVE_INFINITY") : String.valueOf(((Number)value).doubleValue()))) : value.toString())));
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
        boolean $i$f$getStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtBinaryExpression.class, (boolean)true) == null && this.isConstantExpression((KtExpression)element);
    }

    private final boolean isConstantExpression(KtExpression $this$isConstantExpression) {
        KtExpression expression = KtPsiUtil.deparenthesize((KtExpression)$this$isConstantExpression);
        return expression instanceof KtConstantExpression ? this.constantNodeTypes.contains(((KtConstantExpression)expression).getElementType()) : (expression instanceof KtPrefixExpression ? this.isConstantExpression(((KtPrefixExpression)expression).getBaseExpression()) : (expression instanceof KtBinaryExpression ? this.isConstantExpression(((KtBinaryExpression)expression).getLeft()) && this.isConstantExpression(((KtBinaryExpression)expression).getRight()) : false));
    }
}

