/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectView;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.FileNodeWithNestedFileNodes;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.projectView.KtFileTreeNodeKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B3\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0016J\u0012\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/projectView/KtFileTreeNode;", "Lcom/intellij/ide/projectView/impl/nodes/PsiFileNode;", "Lcom/intellij/ide/projectView/impl/nodes/FileNodeWithNestedFileNodes;", "project", "Lcom/intellij/openapi/project/Project;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "viewSettings", "Lcom/intellij/ide/projectView/ViewSettings;", "nestedFileNodes", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/ide/projectView/ViewSettings;Ljava/util/Collection;)V", "getKtFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getNestedFileNodes", "getChildrenImpl", "kotlin.base.project-structure"})
public final class KtFileTreeNode
extends PsiFileNode
implements FileNodeWithNestedFileNodes {
    @NotNull
    private final KtFile ktFile;
    @NotNull
    private final Collection<AbstractTreeNode<?>> nestedFileNodes;

    public KtFileTreeNode(@Nullable Project project, @NotNull KtFile ktFile2, @NotNull ViewSettings viewSettings, @NotNull Collection<? extends AbstractTreeNode<?>> nestedFileNodes) {
        Intrinsics.checkNotNullParameter((Object)ktFile2, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)viewSettings, (String)"viewSettings");
        Intrinsics.checkNotNullParameter(nestedFileNodes, (String)"nestedFileNodes");
        super(project, (PsiFile)ktFile2, viewSettings);
        this.ktFile = ktFile2;
        this.nestedFileNodes = nestedFileNodes;
    }

    @NotNull
    public final KtFile getKtFile() {
        return this.ktFile;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getNestedFileNodes() {
        return this.nestedFileNodes;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildrenImpl() {
        Collection collection;
        if (this.getSettings().isShowMembers()) {
            ViewSettings viewSettings = this.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)viewSettings, (String)"getSettings(...)");
            collection = CollectionsKt.plus(this.nestedFileNodes, (Iterable)KtFileTreeNodeKt.toDeclarationsNodes(this.ktFile, viewSettings));
        } else {
            collection = this.nestedFileNodes;
        }
        return collection;
    }
}

