/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.quickfix.ChangeVisibilityFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.RemoveModifierFixBase;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u001a\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n*\u00020\rH\u0002J \u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000f*\u00020\rH\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u000bH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CallFromPublicInlineFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "<init>", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "containingDeclaration", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "referenceDeclaration", "Lkotlin/Triple;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "hasReifiedTypeParameter", "", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nCallFromPublicInlineFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallFromPublicInlineFactory.kt\norg/jetbrains/kotlin/idea/quickfix/CallFromPublicInlineFactory\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n123#2:61\n123#2:62\n123#2:64\n1#3:63\n1755#4,3:65\n*S KotlinDebug\n*F\n+ 1 CallFromPublicInlineFactory.kt\norg/jetbrains/kotlin/idea/quickfix/CallFromPublicInlineFactory\n*L\n18#1:61\n44#1:62\n52#1:64\n58#1:65,3\n*E\n"})
public final class CallFromPublicInlineFactory
extends KotlinIntentionActionsFactory {
    @NotNull
    public static final CallFromPublicInlineFactory INSTANCE = new CallFromPublicInlineFactory();

    private CallFromPublicInlineFactory() {
    }

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        List fixes = new ArrayList();
        PsiElement $this$safeAs$iv = diagnostic.getPsiElement();
        boolean $i$f$safeAs = false;
        PsiElement psiElement = $this$safeAs$iv;
        if (!(psiElement instanceof KtExpression)) {
            psiElement = null;
        }
        KtExpression ktExpression = (KtExpression)psiElement;
        if (ktExpression == null) {
            return fixes;
        }
        KtExpression element = ktExpression;
        Pair<KtCallableDeclaration, String> pair = this.containingDeclaration(element);
        if (pair == null) {
            return fixes;
        }
        Pair<KtCallableDeclaration, String> pair2 = pair;
        KtCallableDeclaration containingDeclaration = (KtCallableDeclaration)pair2.component1();
        String containingDeclarationName = (String)pair2.component2();
        DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
        if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.NON_PUBLIC_CALL_FROM_PUBLIC_INLINE) || Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.PROTECTED_CALL_FROM_PUBLIC_INLINE.getWarningFactory()) || Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.PROTECTED_CALL_FROM_PUBLIC_INLINE.getErrorFactory())) {
            Triple<KtDeclaration, String, KtModifierKeywordToken> triple = this.referenceDeclaration(element);
            if (triple == null) {
                return fixes;
            }
            Triple<KtDeclaration, String, KtModifierKeywordToken> triple2 = triple;
            KtDeclaration declaration = (KtDeclaration)triple2.component1();
            String declarationName = (String)triple2.component2();
            KtModifierKeywordToken declarationVisibility = (KtModifierKeywordToken)triple2.component3();
            fixes.add(new ChangeVisibilityFix((KtModifierListOwner)containingDeclaration, containingDeclarationName, declarationVisibility, false, 8, null));
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)declaration;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PUBLIC_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"PUBLIC_KEYWORD");
            fixes.add(new ChangeVisibilityFix(ktModifierListOwner, declarationName, ktModifierKeywordToken, false, 8, null));
            if (!this.hasReifiedTypeParameter(containingDeclaration)) {
                KtModifierListOwner ktModifierListOwner2 = (KtModifierListOwner)containingDeclaration;
                KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.INLINE_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken2, (String)"INLINE_KEYWORD");
                IntentionAction intentionAction = new RemoveModifierFixBase(ktModifierListOwner2, ktModifierKeywordToken2, false).asIntention();
                Intrinsics.checkNotNullExpressionValue((Object)intentionAction, (String)"asIntention(...)");
                fixes.add(intentionAction);
            }
        } else if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.SUPER_CALL_FROM_PUBLIC_INLINE.getWarningFactory()) || Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.SUPER_CALL_FROM_PUBLIC_INLINE.getErrorFactory())) {
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)containingDeclaration;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.INTERNAL_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"INTERNAL_KEYWORD");
            fixes.add(new ChangeVisibilityFix(ktModifierListOwner, containingDeclarationName, ktModifierKeywordToken, false, 8, null));
            KtModifierListOwner ktModifierListOwner3 = (KtModifierListOwner)containingDeclaration;
            KtModifierKeywordToken ktModifierKeywordToken3 = KtTokens.PRIVATE_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken3, (String)"PRIVATE_KEYWORD");
            fixes.add(new ChangeVisibilityFix(ktModifierListOwner3, containingDeclarationName, ktModifierKeywordToken3, false, 8, null));
            if (!this.hasReifiedTypeParameter(containingDeclaration)) {
                KtModifierListOwner ktModifierListOwner4 = (KtModifierListOwner)containingDeclaration;
                KtModifierKeywordToken ktModifierKeywordToken4 = KtTokens.INLINE_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken4, (String)"INLINE_KEYWORD");
                IntentionAction intentionAction = new RemoveModifierFixBase(ktModifierListOwner4, ktModifierKeywordToken4, false).asIntention();
                Intrinsics.checkNotNullExpressionValue((Object)intentionAction, (String)"asIntention(...)");
                fixes.add(intentionAction);
            }
        }
        return fixes;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<KtCallableDeclaration, String> containingDeclaration(KtExpression $this$containingDeclaration) {
        KtDeclaration ktDeclaration;
        block6: {
            block5: {
                KtCallableDeclaration ktCallableDeclaration;
                void $this$safeAs$iv;
                KtCallableDeclaration ktCallableDeclaration2 = new KtCallableDeclaration[]{Reflection.getOrCreateKotlinClass(KtNamedFunction.class), Reflection.getOrCreateKotlinClass(KtProperty.class)};
                KtDeclaration ktDeclaration2 = (KtDeclaration)PsiTreeUtilKt.parentOfTypes$default((PsiElement)((PsiElement)$this$containingDeclaration), (KClass[])ktCallableDeclaration2, (boolean)false, (int)2, null);
                if (ktDeclaration2 == null) break block5;
                ktDeclaration = ktDeclaration2;
                boolean $i$f$safeAs = false;
                Object v0 = $this$safeAs$iv;
                if (!(v0 instanceof KtCallableDeclaration)) {
                    v0 = null;
                }
                if ((ktCallableDeclaration2 = (KtCallableDeclaration)v0) == null) break block5;
                KtCallableDeclaration it = ktCallableDeclaration = ktCallableDeclaration2;
                boolean bl = false;
                Object object = ktDeclaration = it.hasModifier(KtTokens.INLINE_KEYWORD) ? ktCallableDeclaration : null;
                if (ktDeclaration != null) break block6;
            }
            return null;
        }
        KtDeclaration declaration = ktDeclaration;
        String string = declaration.getName();
        if (string == null) {
            return null;
        }
        String name2 = string;
        return TuplesKt.to((Object)declaration, (Object)name2);
    }

    private final Triple<KtDeclaration, String, KtModifierKeywordToken> referenceDeclaration(KtExpression $this$referenceDeclaration) {
        KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)$this$referenceDeclaration));
        PsiElement $this$safeAs$iv = ktReference != null ? ktReference.resolve() : null;
        boolean $i$f$safeAs = false;
        PsiElement psiElement = $this$safeAs$iv;
        if (!(psiElement instanceof KtDeclaration)) {
            psiElement = null;
        }
        KtDeclaration ktDeclaration = (KtDeclaration)psiElement;
        if (ktDeclaration == null) {
            return null;
        }
        KtDeclaration declaration = ktDeclaration;
        String string = declaration.getName();
        if (string == null) {
            return null;
        }
        String name2 = string;
        KtModifierKeywordToken ktModifierKeywordToken = KtPsiUtilKt.visibilityModifierType((KtModifierListOwner)((KtModifierListOwner)declaration));
        if (ktModifierKeywordToken == null) {
            return null;
        }
        KtModifierKeywordToken visibility = ktModifierKeywordToken;
        return new Triple((Object)declaration, (Object)name2, (Object)visibility);
    }

    private final boolean hasReifiedTypeParameter(KtCallableDeclaration $this$hasReifiedTypeParameter) {
        boolean bl;
        block3: {
            List list2 = $this$hasReifiedTypeParameter.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeParameters(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtTypeParameter it = (KtTypeParameter)element$iv;
                    boolean bl2 = false;
                    if (!it.hasModifier(KtTokens.REIFIED_KEYWORD)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

