/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.quickfix.AutoImportVariant;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002 !B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u0005\"\u000e\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001b0\u001aJ8\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0014\u0010\u001e\u001a\u00020\u001f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ImportFixHelper;", "", "<init>", "()V", "calculateTextForFix", "", "T", "", "importInfos", "", "Lorg/jetbrains/kotlin/idea/quickfix/ImportFixHelper$ImportInfo;", "suggestions", "Lorg/jetbrains/kotlin/name/FqName;", "calculateWeightBasedOnFqName", "", "fqName", "sourceDeclaration", "Lcom/intellij/psi/PsiElement;", "createListPopupWithImportVariants", "Lcom/intellij/openapi/ui/popup/ListPopup;", "project", "Lcom/intellij/openapi/project/Project;", "variants", "", "Lorg/jetbrains/kotlin/idea/quickfix/AutoImportVariant;", "addImport", "Lkotlin/Function1;", "", "getVariantSelectionPopup", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "suggestionsAreFromSameParent", "", "ImportKind", "ImportInfo", "kotlin.fir.frontend-independent"})
@SourceDebugExtension(value={"SMAP\nImportFixHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportFixHelper.kt\norg/jetbrains/kotlin/idea/quickfix/ImportFixHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,186:1\n1498#2:187\n1528#2,3:188\n1531#2,3:198\n1557#2:201\n1628#2,3:202\n1485#2:205\n1510#2,3:206\n1513#2,3:216\n1663#2,8:219\n381#3,7:191\n381#3,7:209\n*S KotlinDebug\n*F\n+ 1 ImportFixHelper.kt\norg/jetbrains/kotlin/idea/quickfix/ImportFixHelper\n*L\n42#1:187\n42#1:188,3\n42#1:198,3\n67#1:201\n67#1:202,3\n67#1:205\n67#1:206,3\n67#1:216,3\n182#1:219,8\n42#1:191,7\n67#1:209,7\n*E\n"})
public final class ImportFixHelper {
    @NotNull
    public static final ImportFixHelper INSTANCE = new ImportFixHelper();

    private ImportFixHelper() {
    }

    /*
     * WARNING - void declaration
     */
    @IntentionName
    @NotNull
    public final <T extends Comparable<? super T>> String calculateTextForFix(@NotNull Iterable<ImportInfo<T>> importInfos, @NotNull Iterable<FqName> suggestions) {
        String string;
        Object[] it;
        Collection<String> collection;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(importInfos, (String)"importInfos");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        Iterable<ImportInfo<T>> $this$groupBy$iv = importInfos;
        boolean $i$f$groupBy = false;
        Iterable<ImportInfo<T>> iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ImportInfo it2 = (ImportInfo)element$iv$iv;
            boolean $i$a$-groupBy-ImportFixHelper$calculateTextForFix$importNamesGroupedByKind$32 = false;
            key$iv$iv = it2.getKind();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            ImportInfo $i$a$-groupBy-ImportFixHelper$calculateTextForFix$importNamesGroupedByKind$32 = (ImportInfo)element$iv$iv;
            collection = list$iv$iv;
            boolean bl = false;
            collection.add((String)it);
        }
        Map importNamesGroupedByKind = destination$iv$iv;
        if (importNamesGroupedByKind.size() == 1) {
            Map.Entry entry = (Map.Entry)CollectionsKt.first((Iterable)importNamesGroupedByKind.entrySet());
            ImportKind kind2 = (ImportKind)((Object)entry.getKey());
            List names = (List)entry.getValue();
            Function1[] $i$f$groupByTo2 = new Function1[]{ImportFixHelper::calculateTextForFix$lambda$2, ImportFixHelper::calculateTextForFix$lambda$3};
            TreeSet sortedImportInfos = new TreeSet(ComparisonsKt.compareBy((Function1[])$i$f$groupByTo2));
            sortedImportInfos.addAll(names);
            String firstName = ((ImportInfo)sortedImportInfos.first()).getName();
            boolean singlePackage = this.suggestionsAreFromSameParent(suggestions);
            if (singlePackage) {
                sortedByName = CollectionsKt.toSortedSet((Iterable)sortedImportInfos, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        ImportInfo it = (ImportInfo)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (ImportInfo)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                    }
                });
                int size = sortedByName.size();
                if (size == 2) {
                    it = new Object[]{kind2.toText(size), ((ImportInfo)sortedByName.first()).getName(), ((ImportInfo)sortedByName.last()).getName()};
                    string = KotlinBundle.message((String)"fix.import.kind.0.name.1.and.name.2", (Object[])it);
                } else {
                    it = new Object[]{kind2.toText(size), firstName, size - 1};
                    string = KotlinBundle.message((String)"fix.import.kind.0.name.1.2", (Object[])it);
                }
            } else if (kind2.getGroupedByPackage()) {
                sortedByName = new Object[]{kind2.toText(1), firstName, 0};
                string = KotlinBundle.message((String)"fix.import.kind.0.name.1.2", (Object[])sortedByName);
            } else {
                void $this$groupByTo$iv$iv2;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv = sortedImportInfos;
                boolean $i$f$map = false;
                key$iv$iv = $this$map$iv;
                Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    ImportInfo bl = (ImportInfo)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(it3.getName());
                }
                Iterable $this$groupBy$iv2 = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv2));
                boolean $i$f$groupBy2 = false;
                $this$mapTo$iv$iv = $this$groupBy$iv2;
                destination$iv$iv2 = new LinkedHashMap();
                boolean $i$f$groupByTo3 = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                    Object object;
                    String it4 = (String)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it4);
                    String key$iv$iv2 = StringsKt.substringBefore$default((String)it4, (char)'.', null, (int)2, null);
                    Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv2);
                    if (value$iv$iv$iv == null) {
                        boolean bl3 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv2, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                Object groupBy = destination$iv$iv2;
                List value = (List)((Map.Entry)CollectionsKt.first((Iterable)groupBy.entrySet())).getValue();
                String first2 = (String)CollectionsKt.first((List)value);
                int multiple = value.size() == 1 ? 0 : 1;
                if (groupBy.size() != 1) {
                    var14_21 = new Object[3];
                    var14_21[0] = kind2.toText(1);
                    Intrinsics.checkNotNull((Object)first2);
                    var14_21[1] = StringsKt.substringAfter$default((String)first2, (char)'.', null, (int)2, null);
                    var14_21[2] = multiple;
                    string = KotlinBundle.message((String)"fix.import.kind.0.name.1.2", (Object[])var14_21);
                } else if (value.size() == 2) {
                    var14_21 = new Object[]{kind2.toText(value.size()), first2, CollectionsKt.last((List)value)};
                    string = KotlinBundle.message((String)"fix.import.kind.0.name.1.and.name.2", (Object[])var14_21);
                } else {
                    var14_21 = new Object[]{kind2.toText(1), first2, multiple};
                    string = KotlinBundle.message((String)"fix.import.kind.0.name.1.2", (Object[])var14_21);
                }
            }
        } else {
            string = KotlinBundle.message((String)"fix.import", (Object[])new Object[0]);
        }
        return string;
    }

    public final int calculateWeightBasedOnFqName(@NotNull FqName fqName2, @Nullable PsiElement sourceDeclaration) {
        int n;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        String fqNameString = fqName2.asString();
        if (StringsKt.startsWith$default((String)fqNameString, (String)"kotlin.", (boolean)false, (int)2, null)) {
            n = 6;
        } else if (StringsKt.startsWith$default((String)fqNameString, (String)"kotlinx.", (boolean)false, (int)2, null)) {
            n = 5;
        } else if (StringsKt.startsWith$default((String)fqNameString, (String)"java.", (boolean)false, (int)2, null)) {
            n = 2;
        } else if (sourceDeclaration != null) {
            PsiFile psiFile = sourceDeclaration.getContainingFile();
            VirtualFile virtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)sourceDeclaration.getProject()).getFileIndex();
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
            ProjectFileIndex fileIndex = projectFileIndex;
            n = virtualFile != null && fileIndex.isInSourceContent(virtualFile) ? 7 : 0;
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public final ListPopup createListPopupWithImportVariants(@NotNull Project project, @NotNull List<? extends AutoImportVariant> variants, @NotNull Function1<? super AutoImportVariant, Unit> addImport2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(variants, (String)"variants");
        Intrinsics.checkNotNullParameter(addImport2, (String)"addImport");
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup(project, (ListPopupStep)this.getVariantSelectionPopup(project, variants, addImport2), arg_0 -> ImportFixHelper.createListPopupWithImportVariants$lambda$10(ImportFixHelper::createListPopupWithImportVariants$lambda$9, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createListPopup(...)");
        return listPopup;
    }

    private final BaseListPopupStep<AutoImportVariant> getVariantSelectionPopup(Project project, List<? extends AutoImportVariant> variants, Function1<? super AutoImportVariant, Unit> addImport2) {
        String string = KotlinBundle.message((String)"action.add.import.chooser.title", (Object[])new Object[0]);
        return (BaseListPopupStep)new BaseListPopupStep<AutoImportVariant>(variants, project, addImport2, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ Function1<AutoImportVariant, Unit> $addImport;
            {
                this.$project = $project;
                this.$addImport = $addImport;
                super($super_call_param$1, $variants);
            }

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep<String> onChosen(AutoImportVariant selectedValue, boolean finalChoice) {
                if (selectedValue == null || this.$project.isDisposed()) {
                    return null;
                }
                if (finalChoice) {
                    this.$addImport.invoke((Object)selectedValue);
                    return null;
                }
                List list2 = AddImportAction.getAllExcludableStrings((String)selectedValue.getFqName().asString());
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllExcludableStrings(...)");
                List toExclude = list2;
                return (PopupStep)new BaseListPopupStep<String>((List<String>)toExclude, this.$project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(null, $toExclude);
                    }

                    public String getTextFor(String value) {
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        Object[] objectArray = new Object[]{value};
                        return KotlinBundle.message((String)"fix.import.exclude", (Object[])objectArray);
                    }

                    public PopupStep<Object> onChosen(String selectedValue, boolean finalChoice) {
                        Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                        if (finalChoice && !this.$project.isDisposed()) {
                            AddImportAction.excludeFromImport((Project)this.$project, (String)selectedValue);
                        }
                        return null;
                    }
                };
            }

            public boolean hasSubstep(AutoImportVariant selectedValue) {
                return true;
            }

            public String getTextFor(AutoImportVariant value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getHint();
            }

            public Icon getIconFor(AutoImportVariant value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getIcon();
            }
        };
    }

    public final boolean suggestionsAreFromSameParent(@NotNull Iterable<FqName> suggestions) {
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        Iterable<FqName> $this$distinctBy$iv = suggestions;
        boolean $i$f$distinctBy = false;
        HashSet<FqName> set$iv = new HashSet<FqName>();
        ArrayList<FqName> list$iv = new ArrayList<FqName>();
        Iterator<FqName> iterator = $this$distinctBy$iv.iterator();
        while (iterator.hasNext()) {
            FqName key$iv;
            FqName e$iv;
            FqName it = e$iv = iterator.next();
            boolean bl = false;
            FqName fqName2 = FqNamesUtilKt.parentOrNull((FqName)it);
            if (fqName2 == null) {
                fqName2 = FqName.ROOT;
            }
            if (!set$iv.add(key$iv = fqName2)) continue;
            list$iv.add(e$iv);
        }
        return ((List)list$iv).size() == 1;
    }

    private static final Comparable calculateTextForFix$lambda$2(ImportInfo it) {
        return it.getPriority();
    }

    private static final Comparable calculateTextForFix$lambda$3(ImportInfo it) {
        return (Comparable)((Object)it.getName());
    }

    private static final Component createListPopupWithImportVariants$lambda$9$lambda$8(DefaultPsiElementCellRenderer $psiRenderer, JList list2, AutoImportVariant value, int index2, boolean isSelected, boolean cellHasFocus) {
        JPanel jPanel;
        JPanel $this$createListPopupWithImportVariants_u24lambda_u249_u24lambda_u248_u24lambda_u247 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$createListPopupWithImportVariants_u24lambda_u249_u24lambda_u248_u24lambda_u247.add($psiRenderer.getListCellRendererComponent(list2, (Object)value.getDeclarationToImport(), index2, isSelected, cellHasFocus));
        return jPanel;
    }

    private static final ListCellRenderer createListPopupWithImportVariants$lambda$9(ListCellRenderer it) {
        DefaultPsiElementCellRenderer psiRenderer = new DefaultPsiElementCellRenderer();
        return (arg_0, arg_1, arg_2, arg_3, arg_4) -> ImportFixHelper.createListPopupWithImportVariants$lambda$9$lambda$8(psiRenderer, arg_0, arg_1, arg_2, arg_3, arg_4);
    }

    private static final ListCellRenderer createListPopupWithImportVariants$lambda$10(Function1 $tmp0, Object p0) {
        return (ListCellRenderer)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ImportFixHelper$ImportInfo;", "T", "", "", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/ImportFixHelper$ImportKind;", "name", "", "priority", "<init>", "(Lorg/jetbrains/kotlin/idea/quickfix/ImportFixHelper$ImportKind;Ljava/lang/String;Ljava/lang/Comparable;)V", "getKind", "()Lorg/jetbrains/kotlin/idea/quickfix/ImportFixHelper$ImportKind;", "getName", "()Ljava/lang/String;", "getPriority", "()Ljava/lang/Comparable;", "Ljava/lang/Comparable;", "kotlin.fir.frontend-independent"})
    public static final class ImportInfo<T extends Comparable<? super T>> {
        @NotNull
        private final ImportKind kind;
        @NotNull
        private final String name;
        @NotNull
        private final T priority;

        public ImportInfo(@NotNull ImportKind kind2, @NotNull String name2, @NotNull T priority) {
            Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(priority, (String)"priority");
            this.kind = kind2;
            this.name = name2;
            this.priority = priority;
        }

        @NotNull
        public final ImportKind getKind() {
            return this.kind;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final T getPriority() {
            return this.priority;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ImportFixHelper$ImportKind;", "", "key", "", "groupedByPackage", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;Z)V", "getGroupedByPackage", "()Z", "CLASS", "TYPE_ALIAS", "PROPERTY", "OBJECT", "FUNCTION", "EXTENSION_PROPERTY", "EXTENSION_FUNCTION", "INFIX_FUNCTION", "INFIX_EXTENSION_FUNCTION", "OPERATOR", "toText", "number", "", "kotlin.fir.frontend-independent"})
    public static final class ImportKind
    extends Enum<ImportKind> {
        @NotNull
        private final String key;
        private final boolean groupedByPackage;
        public static final /* enum */ ImportKind CLASS = new ImportKind("text.class.0", true);
        public static final /* enum */ ImportKind TYPE_ALIAS = new ImportKind("text.type.alias.0", true);
        public static final /* enum */ ImportKind PROPERTY = new ImportKind("PROPERTY", 2, "text.property.0", false, 2, null);
        public static final /* enum */ ImportKind OBJECT = new ImportKind("text.object.0", true);
        public static final /* enum */ ImportKind FUNCTION = new ImportKind("FUNCTION", 4, "text.function.0", false, 2, null);
        public static final /* enum */ ImportKind EXTENSION_PROPERTY = new ImportKind("EXTENSION_PROPERTY", 5, "text.extension.property.0", false, 2, null);
        public static final /* enum */ ImportKind EXTENSION_FUNCTION = new ImportKind("EXTENSION_FUNCTION", 6, "text.extension.function.0", false, 2, null);
        public static final /* enum */ ImportKind INFIX_FUNCTION = new ImportKind("INFIX_FUNCTION", 7, "text.infix.function.0", false, 2, null);
        public static final /* enum */ ImportKind INFIX_EXTENSION_FUNCTION = new ImportKind("INFIX_EXTENSION_FUNCTION", 8, "text.infix.extension.function.0", false, 2, null);
        public static final /* enum */ ImportKind OPERATOR = new ImportKind("OPERATOR", 9, "text.operator.0", false, 2, null);
        private static final /* synthetic */ ImportKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ImportKind(String key, boolean groupedByPackage) {
            this.key = key;
            this.groupedByPackage = groupedByPackage;
        }

        /* synthetic */ ImportKind(String string, int n, String string2, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                bl = false;
            }
            this(string2, bl);
        }

        public final boolean getGroupedByPackage() {
            return this.groupedByPackage;
        }

        @NotNull
        public final String toText(int number) {
            Object[] objectArray = new Object[]{number == 1 ? 1 : 2};
            return KotlinBundle.message((String)this.key, (Object[])objectArray);
        }

        public static ImportKind[] values() {
            return (ImportKind[])$VALUES.clone();
        }

        public static ImportKind valueOf(String value) {
            return Enum.valueOf(ImportKind.class, value);
        }

        @NotNull
        public static EnumEntries<ImportKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = importKindArray = new ImportKind[]{ImportKind.CLASS, ImportKind.TYPE_ALIAS, ImportKind.PROPERTY, ImportKind.OBJECT, ImportKind.FUNCTION, ImportKind.EXTENSION_PROPERTY, ImportKind.EXTENSION_FUNCTION, ImportKind.INFIX_FUNCTION, ImportKind.INFIX_EXTENSION_FUNCTION, ImportKind.OPERATOR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

