/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.ReplacePrimitiveCastWithNumberConversionFix;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBindingKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplacePrimitiveCastWithNumberConversionFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
public final class ReplacePrimitiveCastWithNumberConversionFixFactory
extends KotlinSingleIntentionActionFactory {
    @NotNull
    public static final ReplacePrimitiveCastWithNumberConversionFixFactory INSTANCE = new ReplacePrimitiveCastWithNumberConversionFixFactory();

    private ReplacePrimitiveCastWithNumberConversionFixFactory() {
    }

    @Override
    @Nullable
    protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement = ((SimpleDiagnostic)Errors.CAST_NEVER_SUCCEEDS.cast((UnboundDiagnostic)diagnostic)).getPsiElement();
        KtOperationReferenceExpression ktOperationReferenceExpression = psiElement instanceof KtOperationReferenceExpression ? (KtOperationReferenceExpression)psiElement : null;
        if (ktOperationReferenceExpression == null) {
            return null;
        }
        KtOperationReferenceExpression element = ktOperationReferenceExpression;
        PsiElement psiElement2 = element.getParent();
        KtBinaryExpressionWithTypeRHS ktBinaryExpressionWithTypeRHS = psiElement2 instanceof KtBinaryExpressionWithTypeRHS ? (KtBinaryExpressionWithTypeRHS)psiElement2 : null;
        if (ktBinaryExpressionWithTypeRHS == null) {
            return null;
        }
        KtBinaryExpressionWithTypeRHS binaryExpression = ktBinaryExpressionWithTypeRHS;
        BindingContext context = ResolutionUtils.analyze$default((KtElement)binaryExpression, null, 1, null);
        KtExpression ktExpression = binaryExpression.getLeft();
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"getLeft(...)");
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)ktExpression, (BindingContext)context);
        if (kotlinType == null) {
            return null;
        }
        KotlinType expressionType = kotlinType;
        if (!TypeUtilsKt.isPrimitiveNumberType((KotlinType)expressionType)) {
            return null;
        }
        KtTypeReference ktTypeReference = binaryExpression.getRight();
        if (ktTypeReference == null || (ktTypeReference = TypeBindingKt.createTypeBinding((KtTypeReference)ktTypeReference, (BindingContext)context)) == null || (ktTypeReference = ktTypeReference.getType()) == null) {
            return null;
        }
        KtTypeReference castType = ktTypeReference;
        if (!TypeUtilsKt.isPrimitiveNumberType((KotlinType)castType)) {
            return null;
        }
        return new ReplacePrimitiveCastWithNumberConversionFix(binaryExpression, IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS.renderType((KotlinType)castType)).asIntention();
    }
}

