/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.sealedSubClassToObject;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.core.util.ProgressUtilsKt;
import org.jetbrains.kotlin.idea.intentions.ConvertSecondaryConstructorToPrimaryIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0014\u0010\u0012\u001a\u00020\t*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u00020\t*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0016\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J(\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00182\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J&\u0010\u001c\u001a\u00020\t*\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00182\u0006\u0010\u001d\u001a\u00020\u0011H\u0002J&\u0010\u001e\u001a\u00020\t*\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00182\u0006\u0010\u001d\u001a\u00020\u0011H\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/sealedSubClassToObject/ConvertSealedSubClassToObjectFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "startInWriteAction", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "changeDeclaration", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtClass;", "changeToObject", "factory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "transformToObject", "changeInstances", "mapReferencesByLanguage", "", "Lcom/intellij/lang/Language;", "", "Lcom/intellij/psi/PsiElement;", "replaceKotlin", "klass", "replaceJava", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nConvertSealedSubClassToObjectFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertSealedSubClassToObjectFix.kt\norg/jetbrains/kotlin/idea/quickfix/sealedSubClassToObject/ConvertSealedSubClassToObjectFix\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,129:1\n196#2:130\n1863#3,2:131\n774#3:133\n865#3,2:134\n1863#3,2:136\n774#3:138\n865#3,2:139\n1863#3,2:141\n1498#3:143\n1528#3,3:144\n1531#3,3:154\n381#4,7:147\n*S KotlinDebug\n*F\n+ 1 ConvertSealedSubClassToObjectFix.kt\norg/jetbrains/kotlin/idea/quickfix/sealedSubClassToObject/ConvertSealedSubClassToObjectFix\n*L\n41#1:130\n62#1:131,2\n107#1:133\n107#1:134,2\n108#1:136,2\n121#1:138\n121#1:139,2\n122#1:141,2\n96#1:143\n96#1:144,3\n96#1:154,3\n96#1:147,7\n*E\n"})
public final class ConvertSealedSubClassToObjectFix
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static final Language JAVA_LANG = Language.findLanguageByID((String)"JAVA");
    @Nullable
    private static final Language KOTLIN_LANG = Language.findLanguageByID((String)"kotlin");

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"convert.sealed.subclass.to.object.fix.family.name", (Object[])new Object[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        void $this$getParentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
        PsiElement psiElement2 = psiElement;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType = false;
        KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClass.class, (boolean)strict$iv);
        if (ktClass == null) {
            return;
        }
        KtClass klass = ktClass;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)klass));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        SmartPsiElementPointer ktClassSmartPointer = smartPsiElementPointer;
        this.changeInstances((SmartPsiElementPointer<KtClass>)ktClassSmartPointer);
        this.changeDeclaration((SmartPsiElementPointer<KtClass>)ktClassSmartPointer);
    }

    private final void changeDeclaration(SmartPsiElementPointer<KtClass> pointer) {
        ActionsKt.runWriteAction(() -> ConvertSealedSubClassToObjectFix.changeDeclaration$lambda$0(pointer, this));
    }

    private final void changeToObject(KtClass $this$changeToObject, KtPsiFactory factory2) {
        block4: {
            KtExpression ktExpression;
            Iterable $this$forEach$iv = $this$changeToObject.getSecondaryConstructors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtSecondaryConstructor it = (KtSecondaryConstructor)element$iv;
                boolean bl = false;
                new ConvertSecondaryConstructorToPrimaryIntention().applyTo(it, (Editor)null);
            }
            KtPrimaryConstructor ktPrimaryConstructor = $this$changeToObject.getPrimaryConstructor();
            if (ktPrimaryConstructor != null) {
                ktPrimaryConstructor.delete();
            }
            PsiElement psiElement = $this$changeToObject.getClassOrInterfaceKeyword();
            if (psiElement == null) break block4;
            if (!$this$changeToObject.isData() && LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)$this$changeToObject).supportsFeature(LanguageFeature.DataObjects)) {
                ktExpression = (KtExpression)CreateByPatternKt.createDeclarationByPattern$default((KtPsiFactory)factory2, (String)(KtTokens.DATA_KEYWORD.getValue() + " " + KtTokens.OBJECT_KEYWORD.getValue()), (Object[])new Object[0], (boolean)false, (int)4, null);
            } else {
                String string = KtTokens.OBJECT_KEYWORD.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                ktExpression = factory2.createExpression(string);
            }
            psiElement.replace((PsiElement)ktExpression);
        }
    }

    private final void transformToObject(KtClass $this$transformToObject, KtPsiFactory factory2) {
        String string = $this$transformToObject.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        $this$transformToObject.replace((PsiElement)factory2.createObject(string));
    }

    private final void changeInstances(SmartPsiElementPointer<KtClass> pointer) {
        Map<Language, List<PsiElement>> map2;
        Map<Language, List<PsiElement>> $this$changeInstances_u24lambda_u243 = map2 = this.mapReferencesByLanguage(pointer);
        boolean bl = false;
        ActionsKt.runWriteAction(() -> ConvertSealedSubClassToObjectFix.changeInstances$lambda$3$lambda$2(pointer, this, $this$changeInstances_u24lambda_u243));
    }

    private final Map<Language, List<PsiElement>> mapReferencesByLanguage(SmartPsiElementPointer<KtClass> pointer) {
        Project project = pointer.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Map map2 = (Map)ProgressUtilsKt.runSynchronouslyWithProgressIfEdt(project, KotlinBundle.message((String)"progress.looking.up.sealed.subclass.usage", (Object[])new Object[0]), true, () -> ConvertSealedSubClassToObjectFix.mapReferencesByLanguage$lambda$7(pointer));
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceKotlin(Map<Language, ? extends List<? extends PsiElement>> $this$replaceKotlin, KtClass klass) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        List<? extends PsiElement> list2 = $this$replaceKotlin.get(KOTLIN_LANG);
        if (list2 == null) {
            return;
        }
        List<? extends PsiElement> list3 = list2;
        Project project = klass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtExpression singletonCall = CreateByPatternKt.buildExpression$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (boolean)false, arg_0 -> ConvertSealedSubClassToObjectFix.replaceKotlin$lambda$8(klass, arg_0), (int)1, null);
        Iterable $this$filter$iv = list3;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)KtNodeTypes.CALL_EXPRESSION)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            it.replace((PsiElement)singletonCall);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceJava(Map<Language, ? extends List<? extends PsiElement>> $this$replaceJava, KtClass klass) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        List<? extends PsiElement> list2 = $this$replaceJava.get(JAVA_LANG);
        if (list2 == null) {
            return;
        }
        List<? extends PsiElement> list3 = list2;
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(list3);
        if (psiElement == null) {
            return;
        }
        PsiElement first2 = psiElement;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)klass.getProject());
        PsiExpression psiExpression = elementFactory.createExpressionFromText(klass.getName() + ".INSTANCE", first2);
        Intrinsics.checkNotNullExpressionValue((Object)psiExpression, (String)"createExpressionFromText(...)");
        PsiExpression javaSingletonCall = psiExpression;
        Iterable $this$filter$iv = list3;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)JavaElementType.NEW_EXPRESSION)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getParent().getNode().getElementType(), (Object)JavaElementType.EXPRESSION_STATEMENT)) {
                it.delete();
                continue;
            }
            it.replace((PsiElement)javaSingletonCall);
        }
    }

    private static final Unit changeDeclaration$lambda$0(SmartPsiElementPointer $pointer, ConvertSealedSubClassToObjectFix this$0) {
        KtClass ktClass = (KtClass)$pointer.getElement();
        if (ktClass == null) {
            return Unit.INSTANCE;
        }
        KtClass element = ktClass;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        this$0.changeToObject(element, psiFactory);
        this$0.transformToObject(element, psiFactory);
        return Unit.INSTANCE;
    }

    private static final Unit changeInstances$lambda$3$lambda$2(SmartPsiElementPointer $pointer, ConvertSealedSubClassToObjectFix this$0, Map $this_apply) {
        KtClass ktClass = (KtClass)$pointer.getElement();
        if (ktClass == null) {
            return Unit.INSTANCE;
        }
        KtClass ktClass2 = ktClass;
        this$0.replaceKotlin($this_apply, ktClass2);
        this$0.replaceJava($this_apply, ktClass2);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map mapReferencesByLanguage$lambda$7(SmartPsiElementPointer $pointer) {
        Map map2;
        KtClass ktClass = (KtClass)$pointer.getElement();
        if (ktClass != null) {
            void $this$groupByTo$iv$iv;
            KtClass ktClass2 = ktClass;
            boolean bl = false;
            Iterable iterable = ReferencesSearch.search((PsiElement)((PsiElement)ktClass2)).asIterable();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"asIterable(...)");
            Iterable $this$groupBy$iv = iterable;
            boolean $i$f$groupBy = false;
            Iterable iterable2 = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                void it;
                Object object;
                Language key$iv$iv;
                PsiReference it2 = (PsiReference)element$iv$iv;
                boolean $i$a$-groupBy-ConvertSealedSubClassToObjectFix$mapReferencesByLanguage$1$1$32 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it2.getElement().getLanguage(), (String)"getLanguage(...)");
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                PsiReference $i$a$-groupBy-ConvertSealedSubClassToObjectFix$mapReferencesByLanguage$1$1$32 = (PsiReference)element$iv$iv;
                List list2 = list$iv$iv;
                boolean bl3 = false;
                list2.add(it.getElement().getParent());
            }
            map2 = destination$iv$iv;
        } else {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    private static final Unit replaceKotlin$lambda$8(KtClass $klass, BuilderByPattern $this$buildExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$buildExpression, (String)"$this$buildExpression");
        Name name2 = $klass.getNameAsSafeName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getNameAsSafeName(...)");
        $this$buildExpression.appendName(name2);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/sealedSubClassToObject/ConvertSealedSubClassToObjectFix$Companion;", "", "<init>", "()V", "JAVA_LANG", "Lcom/intellij/lang/Language;", "Lorg/jetbrains/annotations/Nullable;", "getJAVA_LANG", "()Lcom/intellij/lang/Language;", "KOTLIN_LANG", "getKOTLIN_LANG", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Language getJAVA_LANG() {
            return JAVA_LANG;
        }

        @Nullable
        public final Language getKOTLIN_LANG() {
            return KOTLIN_LANG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

