/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.copy;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.FqNameUtils;
import org.jetbrains.kotlin.idea.codeInsight.shorten.DelayedRequestsWaitingSetKt;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.copy.AbstractCopyKotlinDeclarationsHandler;
import org.jetbrains.kotlin.idea.refactoring.copy.AbstractCopyKotlinDeclarationsHandlerKt;
import org.jetbrains.kotlin.idea.refactoring.copy.CopyKotlinDeclarationDialog;
import org.jetbrains.kotlin.idea.refactoring.move.AutoCreatingPsiDirectoryWrapper;
import org.jetbrains.kotlin.idea.refactoring.move.AutoCreatingPsiDirectoryWrapperKt;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveConflictCheckerInfo;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.MoveConflictUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.MoveContainerChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.move.MoveContainerInfo;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003456B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J-\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u001aJ'\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u001eJ'\u0010\u001f\u001a\u00020\u001c2\u000e\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020!0\u00172\b\u0010\"\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010#J\u0018\u0010$\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0018\u0010%\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J0\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020'2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010,\u001a\u00020\u0005H\u0002J<\u0010-\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00070.2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000b2\u0016\u0010/\u001a\u0012\u0012\u0004\u0012\u00020\u001100j\b\u0012\u0004\u0012\u00020\u0011`1H\u0002J\u0010\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u00020!H\u0016\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler;", "Lorg/jetbrains/kotlin/idea/refactoring/copy/AbstractCopyKotlinDeclarationsHandler;", "<init>", "()V", "createFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "targetFileName", "", "targetDirectory", "Lcom/intellij/psi/PsiDirectory;", "getTargetDataForUnitTest", "Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$TargetData;", "sourceData", "Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$SourceData;", "getTargetDataForUX", "collectInternalUsages", "Ljava/util/LinkedHashSet;", "Lcom/intellij/usageView/UsageInfo;", "targetData", "trackedCopyFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceFiles", "", "Lcom/intellij/psi/PsiFileSystemItem;", "initialTargetDirectory", "([Lcom/intellij/psi/PsiFileSystemItem;Lcom/intellij/psi/PsiDirectory;)Ljava/util/Set;", "doCopyFiles", "", "filesToCopy", "([Lcom/intellij/psi/PsiFileSystemItem;Lcom/intellij/psi/PsiDirectory;)V", "doCopy", "elements", "Lcom/intellij/psi/PsiElement;", "defaultTargetDirectory", "([Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiDirectory;)V", "getTargetFileName", "doRefactor", "doRefactoringOnFile", "Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$RefactoringResult;", "fileToCopy", "isSingleDeclarationInFile", "", "doRefactoringOnElement", "targetFile", "collectConflicts", "Lcom/intellij/util/containers/MultiMap;", "internalUsages", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "doClone", "element", "TargetData", "SourceData", "RefactoringResult", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nCopyKotlinDeclarationsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopyKotlinDeclarationsHandler.kt\norg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,374:1\n11476#2,9:375\n13402#2:384\n13403#2:386\n11485#2:387\n1#3:385\n1#3:389\n73#4:388\n73#4:401\n808#5,11:390\n1454#5,2:402\n774#5:404\n865#5,2:405\n1456#5,3:407\n1863#5,2:410\n1863#5,2:412\n1557#5:414\n1628#5,3:415\n*S KotlinDebug\n*F\n+ 1 CopyKotlinDeclarationsHandler.kt\norg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler\n*L\n197#1:375,9\n197#1:384\n197#1:386\n197#1:387\n197#1:385\n215#1:388\n349#1:401\n338#1:390,11\n126#1:402,2\n127#1:404\n127#1:405,2\n126#1:407,3\n171#1:410,2\n276#1:412,2\n326#1:414\n326#1:415,3\n*E\n"})
public final class CopyKotlinDeclarationsHandler
extends AbstractCopyKotlinDeclarationsHandler {
    @Override
    @NotNull
    public KtFile createFile(@NotNull String targetFileName, @NotNull PsiDirectory targetDirectory) {
        Intrinsics.checkNotNullParameter((Object)targetFileName, (String)"targetFileName");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        return PackageUtilsKt.createKotlinFile$default(targetFileName, targetDirectory, null, 4, null);
    }

    private final TargetData getTargetDataForUnitTest(SourceData sourceData) {
        SourceData $this$getTargetDataForUnitTest_u24lambda_u240 = sourceData;
        boolean bl = false;
        VirtualFile virtualFile = ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)$this$getTargetDataForUnitTest_u24lambda_u240.getInitialTargetDirectory());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile targetSourceRoot = virtualFile;
        String string = AbstractCopyKotlinDeclarationsHandlerKt.getCopyNewName($this$getTargetDataForUnitTest_u24lambda_u240.getProject());
        if (string == null) {
            KtElement ktElement = $this$getTargetDataForUnitTest_u24lambda_u240.getSingleElementToCopy();
            string = ktElement != null ? ktElement.getName() : null;
            if (string == null) {
                String string2 = $this$getTargetDataForUnitTest_u24lambda_u240.getOriginalFile().getName();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            }
        }
        String newName = string;
        if ($this$getTargetDataForUnitTest_u24lambda_u240.getSingleElementToCopy() != null && ((CharSequence)newName).length() == 0) {
            return null;
        }
        return new TargetData(false, newName, AutoCreatingPsiDirectoryWrapperKt.toDirectoryWrapper($this$getTargetDataForUnitTest_u24lambda_u240.getInitialTargetDirectory()), targetSourceRoot);
    }

    private final TargetData getTargetDataForUX(SourceData sourceData) {
        KtNamedDeclaration singleNamedSourceElement;
        boolean openInEditor = false;
        String newName = null;
        AutoCreatingPsiDirectoryWrapper targetDirWrapper = null;
        VirtualFile targetSourceRoot = null;
        KtElement ktElement = sourceData.getSingleElementToCopy();
        KtNamedDeclaration ktNamedDeclaration = singleNamedSourceElement = ktElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)ktElement : null;
        if (singleNamedSourceElement != null) {
            dialog = new CopyKotlinDeclarationDialog(singleNamedSourceElement, sourceData.getInitialTargetDirectory(), sourceData.getProject());
            dialog.setTitle(AbstractCopyKotlinDeclarationsHandlerKt.getCopyCommandName());
            if (!dialog.showAndGet()) {
                return null;
            }
            openInEditor = dialog.getOpenInEditor();
            newName = dialog.getNewName();
            MoveDestination moveDestination = dialog.getTargetDirectory();
            targetDirWrapper = moveDestination != null ? AutoCreatingPsiDirectoryWrapperKt.toDirectoryWrapper(moveDestination) : null;
            targetSourceRoot = dialog.getTargetSourceRoot();
        } else {
            KtFile[] ktFileArray = new KtFile[]{sourceData.getOriginalFile()};
            dialog = new CopyFilesOrDirectoriesDialog((PsiElement[])ktFileArray, sourceData.getInitialTargetDirectory(), sourceData.getProject(), false);
            if (!dialog.showAndGet()) {
                return null;
            }
            openInEditor = dialog.openInEditor();
            newName = dialog.getNewName();
            PsiDirectory psiDirectory = dialog.getTargetDirectory();
            targetDirWrapper = psiDirectory != null ? AutoCreatingPsiDirectoryWrapperKt.toDirectoryWrapper(psiDirectory) : null;
            PsiDirectory psiDirectory2 = dialog.getTargetDirectory();
            Object object = targetSourceRoot = psiDirectory2 != null ? ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)psiDirectory2) : null;
        }
        if (targetDirWrapper == null) {
            return null;
        }
        if (newName == null) {
            return null;
        }
        if (sourceData.getSingleElementToCopy() != null && ((CharSequence)newName).length() == 0) {
            return null;
        }
        return new TargetData(openInEditor, newName, targetDirWrapper, targetSourceRoot);
    }

    private final LinkedHashSet<UsageInfo> collectInternalUsages(SourceData sourceData, TargetData targetData) {
        return (LinkedHashSet)ActionsKt.runReadAction(() -> CopyKotlinDeclarationsHandler.collectInternalUsages$lambda$3(targetData, sourceData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<VirtualFile> trackedCopyFiles(PsiFileSystemItem[] sourceFiles, PsiDirectory initialTargetDirectory) {
        if (!this.getCopyFilesHandler().canCopy((PsiElement[])sourceFiles)) {
            return SetsKt.emptySet();
        }
        var mapper2 = new VirtualFileListener(){
            private final Set<VirtualFile> filesCopied;
            {
                this.filesCopied = new LinkedHashSet<E>();
            }

            public final Set<VirtualFile> getFilesCopied() {
                return this.filesCopied;
            }

            public void fileCopied(VirtualFileCopyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                this.filesCopied.add(virtualFile);
            }

            public void fileCreated(VirtualFileEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                this.filesCopied.add(virtualFile);
            }
        };
        VirtualFileManager $this$trackedCopyFiles_u24lambda_u244 = VirtualFileManager.getInstance();
        boolean bl = false;
        try {
            $this$trackedCopyFiles_u24lambda_u244.addVirtualFileListener(mapper2);
            this.getCopyFilesHandler().doCopy((PsiElement[])sourceFiles, initialTargetDirectory);
        }
        finally {
            $this$trackedCopyFiles_u24lambda_u244.removeVirtualFileListener(mapper2);
        }
        return mapper2.getFilesCopied();
    }

    private final void doCopyFiles(PsiFileSystemItem[] filesToCopy, PsiDirectory initialTargetDirectory) {
        if (filesToCopy.length == 0) {
            return;
        }
        Project project = ((PsiElement)filesToCopy[0]).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        ApplicationUtilsKt.executeCommand$default(project2, AbstractCopyKotlinDeclarationsHandlerKt.getCopyCommandName(), null, () -> CopyKotlinDeclarationsHandler.doCopyFiles$lambda$8(this, filesToCopy, initialTargetDirectory, psiManager2, project2), 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public void doCopy(@NotNull PsiElement[] elements, @Nullable PsiDirectory defaultTargetDirectory) {
        void $this$mapNotNullTo$iv$iv;
        PsiFileSystemItem[] psiFileSystemItemArray;
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        if (elements.length == 0) {
            return;
        }
        if (!this.canCopyDeclarations(elements) && (psiFileSystemItemArray = this.getSourceFiles(elements)) != null) {
            PsiFileSystemItem[] it = psiFileSystemItemArray;
            boolean bl = false;
            this.doCopyFiles(it, defaultTargetDirectory);
            return;
        }
        PsiElement[] $this$mapNotNull$iv = elements;
        boolean $i$f$mapNotNull = false;
        PsiElement[] bl = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            KtElement it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl2 = false;
            void it = element$iv$iv;
            boolean bl3 = false;
            if (AbstractCopyKotlinDeclarationsHandlerKt.getCopyableElement((PsiElement)it) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List elementsToCopy = (List)destination$iv$iv;
        if (elementsToCopy.isEmpty()) {
            return;
        }
        KtElement singleElementToCopy = (KtElement)CollectionsKt.singleOrNull((List)elementsToCopy);
        PsiFile psiFile = ((KtElement)CollectionsKt.first((List)elementsToCopy)).getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        KtFile originalFile = (KtFile)psiFile;
        PsiDirectory psiDirectory = defaultTargetDirectory;
        if (psiDirectory == null && (psiDirectory = originalFile.getContainingDirectory()) == null) {
            return;
        }
        PsiDirectory initialTargetDirectory = psiDirectory;
        Project project = initialTargetDirectory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        SourceData sourceData = new SourceData(project2, singleElementToCopy, elementsToCopy, originalFile, initialTargetDirectory);
        boolean $i$f$isUnitTestMode = false;
        TargetData targetData = ApplicationManager.getApplication().isUnitTestMode() ? this.getTargetDataForUnitTest(sourceData) : this.getTargetDataForUX(sourceData);
        if (targetData == null) {
            return;
        }
        LinkedHashSet<UsageInfo> internalUsages = this.collectInternalUsages(sourceData, targetData);
        MoveUtilKt.markInternalUsages((Collection<? extends UsageInfo>)internalUsages);
        MultiMap<PsiElement, String> conflicts = this.collectConflicts(sourceData, targetData, (HashSet<UsageInfo>)internalUsages);
        KotlinCommonRefactoringUtilKt.checkConflictsInteractively$default(project2, conflicts, null, () -> CopyKotlinDeclarationsHandler.doCopy$lambda$12(project2, internalUsages, this, sourceData, targetData), 2, null);
    }

    private final String getTargetFileName(SourceData sourceData, TargetData targetData) {
        return StringsKt.contains$default((CharSequence)targetData.getNewName(), (CharSequence)".", (boolean)false, (int)2, null) ? targetData.getNewName() : targetData.getNewName() + "." + sourceData.getOriginalFile().getVirtualFile().getExtension();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void doRefactor(SourceData sourceData, TargetData targetData) {
        Object object;
        RefactoringResult refactoringResult = null;
        try {
            RefactoringResult refactoringResult2;
            KtFile fileToCopy;
            PsiDirectory targetDirectory = (PsiDirectory)ActionsKt.runWriteAction(() -> CopyKotlinDeclarationsHandler.doRefactor$lambda$13(targetData, sourceData));
            String targetFileName = this.getTargetFileName(sourceData, targetData);
            boolean isSingleDeclarationInFile = sourceData.getSingleElementToCopy() instanceof KtNamedDeclaration && Intrinsics.areEqual((Object)CollectionsKt.singleOrNull((List)sourceData.getOriginalFile().getDeclarations()), (Object)sourceData.getSingleElementToCopy());
            Object object2 = sourceData.getSingleElementToCopy() instanceof KtFile ? (KtFile)sourceData.getSingleElementToCopy() : (fileToCopy = isSingleDeclarationInFile ? sourceData.getOriginalFile() : null);
            if (fileToCopy != null) {
                refactoringResult2 = this.doRefactoringOnFile(fileToCopy, sourceData, targetDirectory, targetFileName, isSingleDeclarationInFile);
            } else {
                KtFile ktFile2 = this.getOrCreateTargetFile(sourceData.getOriginalFile(), targetDirectory, targetFileName);
                if (ktFile2 == null) {
                    throw new IncorrectOperationException("Could not create target file.");
                }
                KtFile targetFile = ktFile2;
                refactoringResult2 = this.doRefactoringOnElement(sourceData, targetFile);
            }
            refactoringResult = refactoringResult2;
            KtNamedDeclaration ktNamedDeclaration = refactoringResult.getCopiedDeclaration();
            if (ktNamedDeclaration != null) {
                KtNamedDeclaration newDeclaration = ktNamedDeclaration;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)targetData.getNewName(), (Object)newDeclaration.getName())) {
                    Collection collection = ReferencesSearch.search((PsiElement)((PsiElement)newDeclaration), (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)newDeclaration))).findAll();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findAll(...)");
                    Collection selfReferences = collection;
                    ActionsKt.runWriteAction(() -> CopyKotlinDeclarationsHandler.doRefactor$lambda$16$lambda$15(selfReferences, newDeclaration, targetData));
                }
            }
            if (targetData.getOpenInEditor()) {
                EditorHelper.openInEditor((PsiElement)((PsiElement)refactoringResult.getTargetFile()));
            }
            if ((object = refactoringResult) == null || (object = ((RefactoringResult)object).getRestoredInternalUsages()) == null) return;
        }
        catch (IncorrectOperationException e) {
            Object object3;
            try {
                Messages.showMessageDialog((Project)sourceData.getProject(), (String)e.getMessage(), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
                object3 = refactoringResult;
                if (object3 == null || (object3 = ((RefactoringResult)object3).getRestoredInternalUsages()) == null) return;
            }
            catch (Throwable throwable) {
                Object object4 = refactoringResult;
                if (object4 == null || (object4 = ((RefactoringResult)object4).getRestoredInternalUsages()) == null) throw throwable;
                Object it = object4;
                boolean bl = false;
                MoveUtilKt.cleanUpInternalUsages((Collection)it);
                throw throwable;
            }
            Object it = object3;
            boolean bl = false;
            MoveUtilKt.cleanUpInternalUsages((Collection)it);
            return;
        }
        Object it = object;
        boolean bl = false;
        MoveUtilKt.cleanUpInternalUsages((Collection)it);
        return;
    }

    private final RefactoringResult doRefactoringOnFile(KtFile fileToCopy, SourceData sourceData, PsiDirectory targetDirectory, String targetFileName, boolean isSingleDeclarationInFile) {
        Object object;
        PsiFile targetFile = (PsiFile)ActionsKt.runWriteAction(() -> CopyKotlinDeclarationsHandler.doRefactoringOnFile$lambda$19(targetDirectory, targetFileName, fileToCopy, sourceData));
        KtNamedDeclaration copiedDeclaration = isSingleDeclarationInFile && targetFile instanceof KtFile ? ((object = CollectionsKt.singleOrNull((List)((KtFile)targetFile).getDeclarations())) instanceof KtNamedDeclaration ? (KtNamedDeclaration)object : null) : null;
        return new RefactoringResult(targetFile, copiedDeclaration, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final RefactoringResult doRefactoringOnElement(SourceData sourceData, KtFile targetFile) {
        void $this$filterIsInstanceTo$iv$iv;
        ArrayList restoredInternalUsages = new ArrayList();
        HashMap oldToNewElementsMapping = new HashMap();
        ActionsKt.runWriteAction(() -> CopyKotlinDeclarationsHandler.doRefactoringOnElement$lambda$21(sourceData, oldToNewElementsMapping, targetFile, restoredInternalUsages));
        Collection collection = oldToNewElementsMapping.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filterIsInstance$iv = collection;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtNamedDeclaration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        KtNamedDeclaration copiedDeclaration = (KtNamedDeclaration)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        return new RefactoringResult((PsiFile)targetFile, copiedDeclaration, restoredInternalUsages);
    }

    private final MultiMap<PsiElement, String> collectConflicts(SourceData sourceData, TargetData targetData, HashSet<UsageInfo> internalUsages) {
        MultiMap multiMap;
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode() && BaseRefactoringProcessor.ConflictsInTestsException.isTestIgnore()) {
            MultiMap multiMap2 = MultiMap.empty();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"empty(...)");
            return multiMap2;
        }
        VirtualFile virtualFile = targetData.getTargetSourceRoot();
        if (virtualFile == null || (virtualFile = PhysicalFileSystemUtilsKt.toPsiDirectory(virtualFile, sourceData.getProject())) == null) {
            MultiMap multiMap3 = MultiMap.empty();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap3, (String)"empty(...)");
            return multiMap3;
        }
        VirtualFile targetSourceRootPsi = virtualFile;
        if (!Intrinsics.areEqual((Object)sourceData.getProject(), (Object)sourceData.getOriginalFile().getProject())) {
            MultiMap multiMap4 = MultiMap.empty();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap4, (String)"empty(...)");
            return multiMap4;
        }
        Project project = sourceData.getProject();
        Collection collection = sourceData.getElementsToCopy();
        VirtualFile virtualFile2 = targetSourceRootPsi.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        KotlinMoveConflictCheckerInfo moveCheckerInfo = new KotlinMoveConflictCheckerInfo(project, collection, new KotlinMoveTarget.Directory(FqName.ROOT, virtualFile2), (KtElement)sourceData.getOriginalFile(), null, 16, null);
        MultiMap $this$collectConflicts_u24lambda_u2422 = multiMap = new MultiMap();
        boolean bl = false;
        $this$collectConflicts_u24lambda_u2422.putAllValues(MoveConflictUtilKt.checkModuleConflictsInDeclarations(moveCheckerInfo, (Set<UsageInfo>)internalUsages));
        $this$collectConflicts_u24lambda_u2422.putAllValues(MoveConflictUtilKt.checkVisibilityInDeclarations(moveCheckerInfo));
        return multiMap;
    }

    public void doClone(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    /*
     * WARNING - void declaration
     */
    private static final LinkedHashSet collectInternalUsages$lambda$3(TargetData $targetData, SourceData $sourceData) {
        void $this$flatMapTo$iv;
        String targetPackageName = $targetData.getTargetDirWrapper().getPackageName();
        MoveContainerChangeInfo changeInfo = new MoveContainerChangeInfo(new MoveContainerInfo.Package($sourceData.getOriginalFile().getPackageFqName()), new MoveContainerInfo.Package(new FqName(targetPackageName)));
        Iterable iterable = $sourceData.getElementsToCopy();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            void $this$filterTo$iv$iv;
            KtElement elementToCopy = (KtElement)element$iv;
            boolean bl = false;
            Iterable $this$filter$iv = MoveUtilKt.getInternalReferencesToUpdateOnPackageNameChange(elementToCopy, changeInfo);
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                UsageInfo it = (UsageInfo)element$iv$iv;
                boolean bl2 = false;
                MoveRenameUsageInfo moveRenameUsageInfo = it instanceof MoveRenameUsageInfo ? (MoveRenameUsageInfo)it : null;
                Object referencedElement = moveRenameUsageInfo != null ? moveRenameUsageInfo.getReferencedElement() : null;
                if (!(referencedElement == null || !PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)elementToCopy), (PsiElement)referencedElement, (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable list$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (LinkedHashSet)destination$iv;
    }

    private static final Unit doCopyFiles$lambda$8$lambda$7$lambda$6(KtFile $targetKtFile, Project $project) {
        if (!PackageUtilsKt.packageMatchesDirectoryOrImplicit($targetKtFile)) {
            PsiDirectory psiDirectory = $targetKtFile.getContainingDirectory();
            if (psiDirectory != null && (psiDirectory = PackageUtilsKt.getFqNameWithImplicitPrefix(psiDirectory)) != null && (psiDirectory = FqNameUtils.quoteIfNeeded((FqName)psiDirectory)) != null) {
                PsiDirectory targetDirectoryFqName = psiDirectory;
                boolean bl = false;
                $targetKtFile.setPackageFqName((FqName)targetDirectoryFqName);
            }
        }
        DelayedRequestsWaitingSetKt.performDelayedRefactoringRequests$default($project, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit doCopyFiles$lambda$8(CopyKotlinDeclarationsHandler this$0, PsiFileSystemItem[] $filesToCopy, PsiDirectory $initialTargetDirectory, PsiManager $psiManager, Project $project) {
        Set<VirtualFile> copiedFiles = this$0.trackedCopyFiles($filesToCopy, $initialTargetDirectory);
        Iterable $this$forEach$iv = copiedFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile copiedFile = (VirtualFile)element$iv;
            boolean bl = false;
            PsiFile psiFile = $psiManager.findFile(copiedFile);
            KtFile targetKtFile = psiFile instanceof KtFile ? (KtFile)psiFile : null;
            if (targetKtFile == null) continue;
            ActionsKt.runWriteAction(() -> CopyKotlinDeclarationsHandler.doCopyFiles$lambda$8$lambda$7$lambda$6(targetKtFile, $project));
        }
        return Unit.INSTANCE;
    }

    private static final Unit doCopy$lambda$12$lambda$11(CopyKotlinDeclarationsHandler this$0, SourceData $sourceData, TargetData $targetData) {
        this$0.doRefactor($sourceData, $targetData);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit doCopy$lambda$12(Project $project, LinkedHashSet $internalUsages, CopyKotlinDeclarationsHandler this$0, SourceData $sourceData, TargetData $targetData) {
        try {
            ApplicationUtilsKt.executeCommand$default($project, AbstractCopyKotlinDeclarationsHandlerKt.getCopyCommandName(), null, () -> CopyKotlinDeclarationsHandler.doCopy$lambda$12$lambda$11(this$0, $sourceData, $targetData), 2, null);
        }
        finally {
            MoveUtilKt.cleanUpInternalUsages($internalUsages);
        }
        return Unit.INSTANCE;
    }

    private static final PsiDirectory doRefactor$lambda$13(TargetData $targetData, SourceData $sourceData) {
        return $targetData.getTargetDirWrapper().getOrCreateDirectory($sourceData.getInitialTargetDirectory());
    }

    private static final Unit doRefactor$lambda$16$lambda$15(Collection $selfReferences, KtNamedDeclaration $newDeclaration, TargetData $targetData) {
        Iterable $this$forEach$iv = $selfReferences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiReference it = (PsiReference)element$iv;
            boolean bl = false;
            it.handleElementRename($targetData.getNewName());
        }
        $newDeclaration.setName($targetData.getNewName());
        return Unit.INSTANCE;
    }

    private static final PsiFile doRefactoringOnFile$lambda$19(PsiDirectory $targetDirectory, String $targetFileName, KtFile $fileToCopy, SourceData $sourceData) {
        FqName targetDirectoryFqName = PackageUtilsKt.getFqNameWithImplicitPrefix($targetDirectory);
        PsiFile psiFile = $targetDirectory.copyFileFrom($targetFileName, (PsiFile)$fileToCopy);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"copyFileFrom(...)");
        PsiFile copiedFile = psiFile;
        if (copiedFile instanceof KtFile && PackageUtilsKt.packageMatchesDirectoryOrImplicit($fileToCopy)) {
            FqName fqName2 = targetDirectoryFqName;
            if (fqName2 != null && (fqName2 = FqNameUtils.quoteIfNeeded(fqName2)) != null) {
                FqName it = fqName2;
                boolean bl = false;
                ((KtFile)copiedFile).setPackageFqName(it);
            }
        }
        DelayedRequestsWaitingSetKt.performDelayedRefactoringRequests$default($sourceData.getProject(), null, 2, null);
        return copiedFile;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit doRefactoringOnElement$lambda$21(SourceData $sourceData, HashMap $oldToNewElementsMapping, KtFile $targetFile, ArrayList $restoredInternalUsages) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $sourceData.getElementsToCopy();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtElement ktElement = (KtElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiElement psiElement = $targetFile.add(it.copy());
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
            collection.add((KtNamedDeclaration)psiElement);
        }
        List newElements = (List)destination$iv$iv;
        MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)$sourceData.getElementsToCopy(), (Iterable)newElements), (Map)$oldToNewElementsMapping);
        ((Map)$oldToNewElementsMapping).put($sourceData.getOriginalFile(), $targetFile);
        for (PsiElement newElement2 : $oldToNewElementsMapping.values()) {
            Collection collection = $restoredInternalUsages;
            Intrinsics.checkNotNull((Object)newElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            CollectionsKt.addAll((Collection)collection, (Iterable)MoveUtilKt.restoreInternalUsages((KtElement)newElement2, $oldToNewElementsMapping, true));
            MoveUtilKt.postProcessMoveUsages$default($restoredInternalUsages, $oldToNewElementsMapping, null, 4, null);
        }
        DelayedRequestsWaitingSetKt.performDelayedRefactoringRequests$default($sourceData.getProject(), null, 2, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$RefactoringResult;", "", "targetFile", "Lcom/intellij/psi/PsiFile;", "copiedDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "restoredInternalUsages", "", "Lcom/intellij/usageView/UsageInfo;", "<init>", "(Lcom/intellij/psi/PsiFile;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Ljava/util/List;)V", "getTargetFile", "()Lcom/intellij/psi/PsiFile;", "getCopiedDeclaration", "()Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "getRestoredInternalUsages", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.idea"})
    private static final class RefactoringResult {
        @NotNull
        private final PsiFile targetFile;
        @Nullable
        private final KtNamedDeclaration copiedDeclaration;
        @Nullable
        private final List<UsageInfo> restoredInternalUsages;

        public RefactoringResult(@NotNull PsiFile targetFile, @Nullable KtNamedDeclaration copiedDeclaration, @Nullable List<? extends UsageInfo> restoredInternalUsages) {
            Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
            this.targetFile = targetFile;
            this.copiedDeclaration = copiedDeclaration;
            this.restoredInternalUsages = restoredInternalUsages;
        }

        public /* synthetic */ RefactoringResult(PsiFile psiFile, KtNamedDeclaration ktNamedDeclaration, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = null;
            }
            this(psiFile, ktNamedDeclaration, list2);
        }

        @NotNull
        public final PsiFile getTargetFile() {
            return this.targetFile;
        }

        @Nullable
        public final KtNamedDeclaration getCopiedDeclaration() {
            return this.copiedDeclaration;
        }

        @Nullable
        public final List<UsageInfo> getRestoredInternalUsages() {
            return this.restoredInternalUsages;
        }

        @NotNull
        public final PsiFile component1() {
            return this.targetFile;
        }

        @Nullable
        public final KtNamedDeclaration component2() {
            return this.copiedDeclaration;
        }

        @Nullable
        public final List<UsageInfo> component3() {
            return this.restoredInternalUsages;
        }

        @NotNull
        public final RefactoringResult copy(@NotNull PsiFile targetFile, @Nullable KtNamedDeclaration copiedDeclaration, @Nullable List<? extends UsageInfo> restoredInternalUsages) {
            Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
            return new RefactoringResult(targetFile, copiedDeclaration, restoredInternalUsages);
        }

        public static /* synthetic */ RefactoringResult copy$default(RefactoringResult refactoringResult, PsiFile psiFile, KtNamedDeclaration ktNamedDeclaration, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                psiFile = refactoringResult.targetFile;
            }
            if ((n & 2) != 0) {
                ktNamedDeclaration = refactoringResult.copiedDeclaration;
            }
            if ((n & 4) != 0) {
                list2 = refactoringResult.restoredInternalUsages;
            }
            return refactoringResult.copy(psiFile, ktNamedDeclaration, list2);
        }

        @NotNull
        public String toString() {
            return "RefactoringResult(targetFile=" + this.targetFile + ", copiedDeclaration=" + this.copiedDeclaration + ", restoredInternalUsages=" + this.restoredInternalUsages + ")";
        }

        public int hashCode() {
            int result2 = this.targetFile.hashCode();
            result2 = result2 * 31 + (this.copiedDeclaration == null ? 0 : this.copiedDeclaration.hashCode());
            result2 = result2 * 31 + (this.restoredInternalUsages == null ? 0 : ((Object)this.restoredInternalUsages).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RefactoringResult)) {
                return false;
            }
            RefactoringResult refactoringResult = (RefactoringResult)other;
            if (!Intrinsics.areEqual((Object)this.targetFile, (Object)refactoringResult.targetFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.copiedDeclaration, (Object)refactoringResult.copiedDeclaration)) {
                return false;
            }
            return Intrinsics.areEqual(this.restoredInternalUsages, refactoringResult.restoredInternalUsages);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u000bH\u00c6\u0003JC\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$SourceData;", "", "project", "Lcom/intellij/openapi/project/Project;", "singleElementToCopy", "Lorg/jetbrains/kotlin/psi/KtElement;", "elementsToCopy", "", "originalFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "initialTargetDirectory", "Lcom/intellij/psi/PsiDirectory;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtElement;Ljava/util/List;Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/psi/PsiDirectory;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSingleElementToCopy", "()Lorg/jetbrains/kotlin/psi/KtElement;", "getElementsToCopy", "()Ljava/util/List;", "getOriginalFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getInitialTargetDirectory", "()Lcom/intellij/psi/PsiDirectory;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.idea"})
    private static final class SourceData {
        @NotNull
        private final Project project;
        @Nullable
        private final KtElement singleElementToCopy;
        @NotNull
        private final List<KtElement> elementsToCopy;
        @NotNull
        private final KtFile originalFile;
        @NotNull
        private final PsiDirectory initialTargetDirectory;

        public SourceData(@NotNull Project project, @Nullable KtElement singleElementToCopy, @NotNull List<? extends KtElement> elementsToCopy, @NotNull KtFile originalFile, @NotNull PsiDirectory initialTargetDirectory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(elementsToCopy, (String)"elementsToCopy");
            Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
            Intrinsics.checkNotNullParameter((Object)initialTargetDirectory, (String)"initialTargetDirectory");
            this.project = project;
            this.singleElementToCopy = singleElementToCopy;
            this.elementsToCopy = elementsToCopy;
            this.originalFile = originalFile;
            this.initialTargetDirectory = initialTargetDirectory;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Nullable
        public final KtElement getSingleElementToCopy() {
            return this.singleElementToCopy;
        }

        @NotNull
        public final List<KtElement> getElementsToCopy() {
            return this.elementsToCopy;
        }

        @NotNull
        public final KtFile getOriginalFile() {
            return this.originalFile;
        }

        @NotNull
        public final PsiDirectory getInitialTargetDirectory() {
            return this.initialTargetDirectory;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @Nullable
        public final KtElement component2() {
            return this.singleElementToCopy;
        }

        @NotNull
        public final List<KtElement> component3() {
            return this.elementsToCopy;
        }

        @NotNull
        public final KtFile component4() {
            return this.originalFile;
        }

        @NotNull
        public final PsiDirectory component5() {
            return this.initialTargetDirectory;
        }

        @NotNull
        public final SourceData copy(@NotNull Project project, @Nullable KtElement singleElementToCopy, @NotNull List<? extends KtElement> elementsToCopy, @NotNull KtFile originalFile, @NotNull PsiDirectory initialTargetDirectory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(elementsToCopy, (String)"elementsToCopy");
            Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
            Intrinsics.checkNotNullParameter((Object)initialTargetDirectory, (String)"initialTargetDirectory");
            return new SourceData(project, singleElementToCopy, elementsToCopy, originalFile, initialTargetDirectory);
        }

        public static /* synthetic */ SourceData copy$default(SourceData sourceData, Project project, KtElement ktElement, List list2, KtFile ktFile2, PsiDirectory psiDirectory, int n, Object object) {
            if ((n & 1) != 0) {
                project = sourceData.project;
            }
            if ((n & 2) != 0) {
                ktElement = sourceData.singleElementToCopy;
            }
            if ((n & 4) != 0) {
                list2 = sourceData.elementsToCopy;
            }
            if ((n & 8) != 0) {
                ktFile2 = sourceData.originalFile;
            }
            if ((n & 0x10) != 0) {
                psiDirectory = sourceData.initialTargetDirectory;
            }
            return sourceData.copy(project, ktElement, list2, ktFile2, psiDirectory);
        }

        @NotNull
        public String toString() {
            return "SourceData(project=" + this.project + ", singleElementToCopy=" + this.singleElementToCopy + ", elementsToCopy=" + this.elementsToCopy + ", originalFile=" + this.originalFile + ", initialTargetDirectory=" + this.initialTargetDirectory + ")";
        }

        public int hashCode() {
            int result2 = this.project.hashCode();
            result2 = result2 * 31 + (this.singleElementToCopy == null ? 0 : this.singleElementToCopy.hashCode());
            result2 = result2 * 31 + ((Object)this.elementsToCopy).hashCode();
            result2 = result2 * 31 + this.originalFile.hashCode();
            result2 = result2 * 31 + this.initialTargetDirectory.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SourceData)) {
                return false;
            }
            SourceData sourceData = (SourceData)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)sourceData.project)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.singleElementToCopy, (Object)sourceData.singleElementToCopy)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.elementsToCopy, sourceData.elementsToCopy)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.originalFile, (Object)sourceData.originalFile)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.initialTargetDirectory, (Object)sourceData.initialTargetDirectory);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00c6\u0003J3\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationsHandler$TargetData;", "", "openInEditor", "", "newName", "", "targetDirWrapper", "Lorg/jetbrains/kotlin/idea/refactoring/move/AutoCreatingPsiDirectoryWrapper;", "targetSourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(ZLjava/lang/String;Lorg/jetbrains/kotlin/idea/refactoring/move/AutoCreatingPsiDirectoryWrapper;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getOpenInEditor", "()Z", "getNewName", "()Ljava/lang/String;", "getTargetDirWrapper", "()Lorg/jetbrains/kotlin/idea/refactoring/move/AutoCreatingPsiDirectoryWrapper;", "getTargetSourceRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "kotlin.idea"})
    private static final class TargetData {
        private final boolean openInEditor;
        @NotNull
        private final String newName;
        @NotNull
        private final AutoCreatingPsiDirectoryWrapper targetDirWrapper;
        @Nullable
        private final VirtualFile targetSourceRoot;

        public TargetData(boolean openInEditor, @NotNull String newName, @NotNull AutoCreatingPsiDirectoryWrapper targetDirWrapper, @Nullable VirtualFile targetSourceRoot) {
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            Intrinsics.checkNotNullParameter((Object)targetDirWrapper, (String)"targetDirWrapper");
            this.openInEditor = openInEditor;
            this.newName = newName;
            this.targetDirWrapper = targetDirWrapper;
            this.targetSourceRoot = targetSourceRoot;
        }

        public final boolean getOpenInEditor() {
            return this.openInEditor;
        }

        @NotNull
        public final String getNewName() {
            return this.newName;
        }

        @NotNull
        public final AutoCreatingPsiDirectoryWrapper getTargetDirWrapper() {
            return this.targetDirWrapper;
        }

        @Nullable
        public final VirtualFile getTargetSourceRoot() {
            return this.targetSourceRoot;
        }

        public final boolean component1() {
            return this.openInEditor;
        }

        @NotNull
        public final String component2() {
            return this.newName;
        }

        @NotNull
        public final AutoCreatingPsiDirectoryWrapper component3() {
            return this.targetDirWrapper;
        }

        @Nullable
        public final VirtualFile component4() {
            return this.targetSourceRoot;
        }

        @NotNull
        public final TargetData copy(boolean openInEditor, @NotNull String newName, @NotNull AutoCreatingPsiDirectoryWrapper targetDirWrapper, @Nullable VirtualFile targetSourceRoot) {
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            Intrinsics.checkNotNullParameter((Object)targetDirWrapper, (String)"targetDirWrapper");
            return new TargetData(openInEditor, newName, targetDirWrapper, targetSourceRoot);
        }

        public static /* synthetic */ TargetData copy$default(TargetData targetData, boolean bl, String string, AutoCreatingPsiDirectoryWrapper autoCreatingPsiDirectoryWrapper, VirtualFile virtualFile, int n, Object object) {
            if ((n & 1) != 0) {
                bl = targetData.openInEditor;
            }
            if ((n & 2) != 0) {
                string = targetData.newName;
            }
            if ((n & 4) != 0) {
                autoCreatingPsiDirectoryWrapper = targetData.targetDirWrapper;
            }
            if ((n & 8) != 0) {
                virtualFile = targetData.targetSourceRoot;
            }
            return targetData.copy(bl, string, autoCreatingPsiDirectoryWrapper, virtualFile);
        }

        @NotNull
        public String toString() {
            return "TargetData(openInEditor=" + this.openInEditor + ", newName=" + this.newName + ", targetDirWrapper=" + this.targetDirWrapper + ", targetSourceRoot=" + this.targetSourceRoot + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.openInEditor);
            result2 = result2 * 31 + this.newName.hashCode();
            result2 = result2 * 31 + this.targetDirWrapper.hashCode();
            result2 = result2 * 31 + (this.targetSourceRoot == null ? 0 : this.targetSourceRoot.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TargetData)) {
                return false;
            }
            TargetData targetData = (TargetData)other;
            if (this.openInEditor != targetData.openInEditor) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.newName, (Object)targetData.newName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.targetDirWrapper, (Object)targetData.targetDirWrapper)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.targetSourceRoot, (Object)targetData.targetSourceRoot);
        }
    }
}

