/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.ProjectTaskManagerImpl;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.scratch.K2ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchCompilationSupport;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/actions/RunScratchActionK2;", "Lorg/jetbrains/kotlin/idea/scratch/actions/ScratchAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "ExplainInfo", "kotlin.jvm"})
public final class RunScratchActionK2
extends ScratchAction {
    public RunScratchActionK2() {
        Supplier supplier = KotlinJvmBundle.INSTANCE.getLazyMessage("scratch.run.button", new Object[0]);
        Icon icon2 = AllIcons.Actions.Execute;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Execute");
        super(supplier, icon2);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        ScratchFile scratchFile2 = this.getCurrentScratchFile(e);
        if (scratchFile2 == null) {
            return;
        }
        ScratchFile scratchFile3 = scratchFile2;
        K2ScratchExecutor k2ScratchExecutor = scratchFile3.getK2ScratchExecutor();
        if (k2ScratchExecutor == null) {
            return;
        }
        K2ScratchExecutor executor = k2ScratchExecutor;
        Module module = scratchFile3.getModule();
        ProjectTaskManagerImpl.putBuildOriginator((Project)project2, ((Object)((Object)this)).getClass());
        if (module != null && scratchFile3.getOptions().isMakeBeforeRun()) {
            Module[] moduleArray = new Module[]{module};
            Promise promise = ProjectTaskManager.getInstance((Project)project2).build(moduleArray).onSuccess(arg_0 -> RunScratchActionK2.actionPerformed$lambda$1(arg_0 -> RunScratchActionK2.actionPerformed$lambda$0(executor, module, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)promise);
        } else {
            executor.execute();
        }
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        ScratchFile scratchFile2 = this.getCurrentScratchFile(e);
        if (scratchFile2 == null) {
            return;
        }
        ScratchFile scratchFile3 = scratchFile2;
        e.getPresentation().setVisible(!scratchFile3.getOptions().isInteractiveMode());
        e.getPresentation().setEnabled(!ScratchCompilationSupport.INSTANCE.isAnyInProgress() && !scratchFile3.getOptions().isInteractiveMode());
        if (e.getPresentation().isEnabled()) {
            e.getPresentation().setText(this.getTemplatePresentation().getText());
        } else {
            e.getPresentation().setText(KotlinJvmBundle.message("other.scratch.file.execution.is.in.progress", new Object[0]));
        }
    }

    private static final Unit actionPerformed$lambda$0(K2ScratchExecutor $executor, Module $module, ProjectTaskManager.Result executionResult) {
        if (executionResult.isAborted() || executionResult.hasErrors()) {
            Object[] objectArray = new Object[]{$module.getName()};
            ScratchExecutor.errorOccurs$default($executor, KotlinJvmBundle.message("there.were.compilation.errors.in.module.0", objectArray), null, false, 6, null);
        } else {
            $executor.execute();
        }
        return Unit.INSTANCE;
    }

    private static final void actionPerformed$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u000f\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/actions/RunScratchActionK2$ExplainInfo;", "", "variableName", "", "offsets", "Lkotlin/Pair;", "", "variableValue", "line", "<init>", "(Ljava/lang/String;Lkotlin/Pair;Ljava/lang/Object;Ljava/lang/Integer;)V", "getVariableName", "()Ljava/lang/String;", "getOffsets", "()Lkotlin/Pair;", "getVariableValue", "()Ljava/lang/Object;", "getLine", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "toString", "kotlin.jvm"})
    public static final class ExplainInfo {
        @NotNull
        private final String variableName;
        @NotNull
        private final Pair<Integer, Integer> offsets;
        @Nullable
        private final Object variableValue;
        @Nullable
        private final Integer line;

        public ExplainInfo(@NotNull String variableName, @NotNull Pair<Integer, Integer> offsets, @Nullable Object variableValue, @Nullable Integer line) {
            Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
            Intrinsics.checkNotNullParameter(offsets, (String)"offsets");
            this.variableName = variableName;
            this.offsets = offsets;
            this.variableValue = variableValue;
            this.line = line;
        }

        @NotNull
        public final String getVariableName() {
            return this.variableName;
        }

        @NotNull
        public final Pair<Integer, Integer> getOffsets() {
            return this.offsets;
        }

        @Nullable
        public final Object getVariableValue() {
            return this.variableValue;
        }

        @Nullable
        public final Integer getLine() {
            return this.line;
        }

        @NotNull
        public String toString() {
            return "ExplainInfo(variableName='" + this.variableName + "', offsets=" + this.offsets + ", variableValue=" + this.variableValue + ", line=" + this.line + ")";
        }
    }
}

