/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.psi.PsiFile;
import com.intellij.util.ApplicationKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.scratch.K2ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchFileAutoRunner;
import org.jetbrains.kotlin.idea.scratch.ScratchFileAutoRunnerK2;
import org.jetbrains.kotlin.idea.scratch.ScratchFileOptions;
import org.jetbrains.kotlin.idea.scratch.actions.ClearScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchActionK2;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandlerAdapter;
import org.jetbrains.kotlin.idea.scratch.ui.IsMakeBeforeRunAction;
import org.jetbrains.kotlin.idea.scratch.ui.ModulesComboBoxAction;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchTopPanelKt;
import org.jetbrains.kotlin.idea.scratch.ui.SmallBorderCheckboxAction;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanelK2;", "", "scratchFile", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "<init>", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;)V", "getScratchFile", "()Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "moduleChooserAction", "Lorg/jetbrains/kotlin/idea/scratch/ui/ModulesComboBoxAction;", "actionsToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "getActionsToolbar", "()Lcom/intellij/openapi/actionSystem/ActionToolbar;", "setupTopPanelUpdateHandlers", "", "createUpdateToolbarHandler", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandlerAdapter;", "IsInteractiveCheckboxAction", "kotlin.jvm"})
public final class ScratchTopPanelK2 {
    @NotNull
    private final ScratchFile scratchFile;
    @NotNull
    private final ModulesComboBoxAction moduleChooserAction;
    @NotNull
    private final ActionToolbar actionsToolbar;

    public ScratchTopPanelK2(@NotNull ScratchFile scratchFile2) {
        DefaultActionGroup defaultActionGroup;
        Intrinsics.checkNotNullParameter((Object)scratchFile2, (String)"scratchFile");
        this.scratchFile = scratchFile2;
        this.moduleChooserAction = new ModulesComboBoxAction(this.scratchFile);
        this.setupTopPanelUpdateHandlers();
        DefaultActionGroup $this$_init__u24lambda_u240 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        $this$_init__u24lambda_u240.add((AnAction)new RunScratchActionK2());
        $this$_init__u24lambda_u240.addSeparator();
        $this$_init__u24lambda_u240.add((AnAction)new ClearScratchAction());
        $this$_init__u24lambda_u240.addSeparator();
        $this$_init__u24lambda_u240.add((AnAction)this.moduleChooserAction);
        $this$_init__u24lambda_u240.add((AnAction)new IsMakeBeforeRunAction(this.scratchFile));
        $this$_init__u24lambda_u240.addSeparator();
        $this$_init__u24lambda_u240.add((AnAction)new IsInteractiveCheckboxAction());
        DefaultActionGroup toolbarGroup = defaultActionGroup;
        this.actionsToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)toolbarGroup, true);
    }

    @NotNull
    public final ScratchFile getScratchFile() {
        return this.scratchFile;
    }

    @NotNull
    public final ActionToolbar getActionsToolbar() {
        return this.actionsToolbar;
    }

    private final void setupTopPanelUpdateHandlers() {
        block0: {
            this.scratchFile.addModuleListener((Function2<? super PsiFile, ? super Module, Unit>)((Function2)(arg_0, arg_1) -> ScratchTopPanelK2.setupTopPanelUpdateHandlers$lambda$1(this, arg_0, arg_1)));
            ScratchOutputHandlerAdapter toolbarHandler = this.createUpdateToolbarHandler();
            K2ScratchExecutor k2ScratchExecutor = this.scratchFile.getK2ScratchExecutor();
            if (k2ScratchExecutor == null) break block0;
            k2ScratchExecutor.addOutputHandler(toolbarHandler);
        }
    }

    private final ScratchOutputHandlerAdapter createUpdateToolbarHandler() {
        return new ScratchOutputHandlerAdapter(this){
            final /* synthetic */ ScratchTopPanelK2 this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStart(ScratchFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ScratchTopPanelKt.access$updateToolbar(this.this$0.getActionsToolbar());
            }

            public void onFinish(ScratchFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ScratchTopPanelKt.access$updateToolbar(this.this$0.getActionsToolbar());
            }
        };
    }

    private static final Unit setupTopPanelUpdateHandlers$lambda$1(ScratchTopPanelK2 this$0, PsiFile psiFile, Module module) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"<unused var>");
        ScratchTopPanelKt.access$updateToolbar(this$0.actionsToolbar);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanelK2$IsInteractiveCheckboxAction;", "Lorg/jetbrains/kotlin/idea/scratch/ui/SmallBorderCheckboxAction;", "<init>", "(Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanelK2;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "isInteractiveMode", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "kotlin.jvm"})
    private final class IsInteractiveCheckboxAction
    extends SmallBorderCheckboxAction {
        public IsInteractiveCheckboxAction() {
            Object[] objectArray = new Object[]{2L};
            super(KotlinJvmBundle.message("scratch.is.interactive.checkbox", new Object[0]), KotlinJvmBundle.message("scratch.is.interactive.checkbox.description", objectArray));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return ScratchTopPanelK2.this.getScratchFile().getOptions().isInteractiveMode();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean isInteractiveMode) {
            Project project;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (isInteractiveMode && (project = e.getProject()) != null) {
                ApplicationKt.getApplication().invokeLater(() -> IsInteractiveCheckboxAction.setSelected$lambda$0(project, ScratchTopPanelK2.this));
            }
            ScratchTopPanelK2.this.getScratchFile().saveOptions((Function1<? super ScratchFileOptions, ScratchFileOptions>)((Function1)arg_0 -> IsInteractiveCheckboxAction.setSelected$lambda$1(isInteractiveMode, arg_0)));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        private static final void setSelected$lambda$0(Project $project, ScratchTopPanelK2 this$0) {
            TasksKt.runWithModalProgressBlocking((Project)$project, (String)KotlinJvmBundle.message("progress.title.run.scratch", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($project, this$0, null){
                int label;
                final /* synthetic */ Project $project;
                final /* synthetic */ ScratchTopPanelK2 this$0;
                {
                    this.$project = $project;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ScratchFileAutoRunner scratchFileAutoRunner = ScratchFileAutoRunner.Companion.getInstance(this.$project);
                            ScratchFileAutoRunnerK2 scratchFileAutoRunnerK2 = scratchFileAutoRunner instanceof ScratchFileAutoRunnerK2 ? (ScratchFileAutoRunnerK2)scratchFileAutoRunner : null;
                            if (scratchFileAutoRunnerK2 == null) break;
                            this.label = 1;
                            Object object3 = scratchFileAutoRunnerK2.submitRun(this.this$0.getScratchFile(), (Continuation<? super Unit>)((Continuation)this));
                            if (object3 == object2) {
                                return object2;
                            }
                            break;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            break;
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private static final ScratchFileOptions setSelected$lambda$1(boolean $isInteractiveMode, ScratchFileOptions $this$saveOptions) {
            Intrinsics.checkNotNullParameter((Object)$this$saveOptions, (String)"$this$saveOptions");
            return ScratchFileOptions.copy$default($this$saveOptions, false, false, $isInteractiveMode, 3, null);
        }
    }
}

