/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.vfilefinder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinBuiltInsMetadataIndex;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinClassFileIndex;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinMetadataFileIndex;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinMetadataFilePackageIndex;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinStdlibIndexKt;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u000e2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00180\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/vfilefinder/IdeVirtualFileFinder;", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "<init>", "(Lcom/intellij/psi/search/GlobalSearchScope;)V", "findMetadata", "Ljava/io/InputStream;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findMetadataTopLevelClassesInPackage", "", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "hasMetadataPackage", "", "fqName", "findBuiltInsData", "findSourceOrBinaryVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findVirtualFileWithHeader", "key", "Lcom/intellij/util/indexing/ID;", "Ljava/lang/Void;", "Companion", "kotlin.base.project-structure"})
@SourceDebugExtension(value={"SMAP\nIdeVirtualFileFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeVirtualFileFinder.kt\norg/jetbrains/kotlin/idea/vfilefinder/IdeVirtualFileFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class IdeVirtualFileFinder
extends VirtualFileFinder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GlobalSearchScope scope;
    @NotNull
    private static final Logger LOG;

    public IdeVirtualFileFinder(@NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super(null, 1, null);
        this.scope = scope;
        if (!Intrinsics.areEqual((Object)this.scope, (Object)GlobalSearchScope.EMPTY_SCOPE) && this.scope.getProject() == null) {
            LOG.warn("Scope with null project " + this.scope);
        }
    }

    @Nullable
    public InputStream findMetadata(@NotNull ClassId classId) {
        InputStream inputStream;
        Object object;
        block5: {
            block4: {
                VirtualFile virtualFile;
                Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                object = this.findVirtualFileWithHeader(classId.asSingleFqName(), KotlinMetadataFileIndex.Companion.getNAME());
                if (object == null) break block4;
                VirtualFile it = virtualFile = object;
                boolean bl = false;
                object = it.exists() ? virtualFile : null;
                if (object != null) break block5;
            }
            return null;
        }
        VirtualFile file = object;
        try {
            inputStream = file.getInputStream();
        }
        catch (FileNotFoundException e) {
            inputStream = null;
        }
        return inputStream;
    }

    @Nullable
    public Set<String> findMetadataTopLevelClassesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return null;
    }

    public boolean hasMetadataPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return KotlinStdlibIndexKt.hasSomethingInPackage(KotlinMetadataFilePackageIndex.Companion.getNAME(), fqName2, this.scope);
    }

    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        VirtualFile virtualFile = this.findVirtualFileWithHeader(packageFqName, KotlinBuiltInsMetadataIndex.Companion.getNAME());
        return virtualFile != null ? virtualFile.getInputStream() : null;
    }

    @Nullable
    public VirtualFile findSourceOrBinaryVirtualFile(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return this.findVirtualFileWithHeader(classId);
    }

    @Nullable
    public VirtualFile findVirtualFileWithHeader(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return this.findVirtualFileWithHeader(classId.asSingleFqName(), KotlinClassFileIndex.Companion.getNAME());
    }

    private final VirtualFile findVirtualFileWithHeader(FqName fqName2, ID<FqName, Void> key) {
        Iterator iterator = FileBasedIndex.getInstance().getContainingFilesIterator(key, (Object)fqName2, this.scope);
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"getContainingFilesIterator(...)");
        Iterator iterator2 = iterator;
        return iterator2.hasNext() ? (VirtualFile)iterator2.next() : null;
    }

    static {
        Logger logger = Logger.getInstance(IdeVirtualFileFinder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/vfilefinder/IdeVirtualFileFinder$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.base.project-structure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

