/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.Converter;
import org.jetbrains.kotlin.j2k.PropertyDetector;
import org.jetbrains.kotlin.j2k.PropertyInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u000e\u001a\u00020\bH\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0006\u001a6\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\u0007j\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/j2k/PropertyDetectionCache;", "", "converter", "Lorg/jetbrains/kotlin/j2k/Converter;", "<init>", "(Lorg/jetbrains/kotlin/j2k/Converter;)V", "cache", "Ljava/util/HashMap;", "Lcom/intellij/psi/PsiClass;", "", "Lcom/intellij/psi/PsiMember;", "Lorg/jetbrains/kotlin/j2k/PropertyInfo;", "Lkotlin/collections/HashMap;", "get", "psiClass", "kotlin.j2k.k1.old"})
@SourceDebugExtension(value={"SMAP\npropertyDetection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 propertyDetection.kt\norg/jetbrains/kotlin/j2k/PropertyDetectionCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,528:1\n1#2:529\n*E\n"})
public final class PropertyDetectionCache {
    @NotNull
    private final Converter converter;
    @NotNull
    private final HashMap<PsiClass, Map<PsiMember, PropertyInfo>> cache;

    public PropertyDetectionCache(@NotNull Converter converter) {
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        this.converter = converter;
        this.cache = new HashMap();
    }

    @NotNull
    public final Map<PsiMember, PropertyInfo> get(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Map<PsiMember, PropertyInfo> map2 = this.cache.get(psiClass);
        if (map2 != null) {
            Map<PsiMember, PropertyInfo> it = map2;
            boolean bl = false;
            return it;
        }
        boolean bl = (Boolean)this.converter.getInConversionScope().invoke((Object)psiClass);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Map<PsiMember, PropertyInfo> detected2 = new PropertyDetector(psiClass, this.converter).detectProperties();
        ((Map)this.cache).put(psiClass, detected2);
        return detected2;
    }
}

