/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.codehaus.plexus.components.io.functions.FileSupplier;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.util.IOUtil;

public class ResourceUtils {
    private ResourceUtils() {
    }

    public static boolean isUptodate(PlexusIoResource source, File destination) {
        return ResourceUtils.isUptodate(source, destination.lastModified());
    }

    public static boolean isUptodate(PlexusIoResource source, long destinationDate) {
        long s = source.getLastModified();
        if (s == 0L) {
            return false;
        }
        if (destinationDate == 0L) {
            return false;
        }
        return destinationDate > s;
    }

    public static boolean isUptodate(long sourceDate, long destinationDate) {
        if (sourceDate == 0L) {
            return false;
        }
        if (destinationDate == 0L) {
            return false;
        }
        return destinationDate > sourceDate;
    }

    public static void copyFile(PlexusIoResource in, File outFile) throws IOException {
        try (InputStream input = in.getContents();
             OutputStream output = Files.newOutputStream(outFile.toPath(), new OpenOption[0]);){
            IOUtil.copy((InputStream)input, (OutputStream)output);
        }
    }

    public static void copyFile(InputStream input, File outFile) throws IOException {
        OutputStream output = null;
        try {
            output = Files.newOutputStream(outFile.toPath(), new OpenOption[0]);
            IOUtil.copy((InputStream)input, (OutputStream)output);
            output.close();
            output = null;
            input.close();
            input = null;
        }
        finally {
            IOUtil.close((InputStream)input);
            IOUtil.close((OutputStream)output);
        }
    }

    public static boolean isSame(PlexusIoResource resource, File file2) {
        if (resource instanceof FileSupplier) {
            File resourceFile = ((FileSupplier)resource).getFile();
            return file2.equals(resourceFile);
        }
        return false;
    }

    public static boolean isCanonicalizedSame(PlexusIoResource resource, File file2) throws IOException {
        if (resource instanceof FileSupplier) {
            File resourceFile = ((FileSupplier)resource).getFile();
            return file2.getCanonicalFile().equals(resourceFile.getCanonicalFile());
        }
        return false;
    }
}

