/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomElement;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProfiles;
import org.jetbrains.idea.maven.dom.model.MavenDomProfilesModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.model.MavenCoordinate;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.plugins.groovy.MavenGroovyPomCompletionContributor;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0012\u0010\u0014\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\u0019\u0010\u0015\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\u0012\u0010\u0017\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\u0019\u0010\u0018\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\u0012\u0010\u0019\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0013J\u0012\u0010\u001f\u001a\u00020\u00112\b\u0010 \u001a\u0004\u0018\u00010\u001bH\u0007J\u0018\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\tH\u0007J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0007J\u0012\u0010*\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020+H\u0007J\u0012\u0010*\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0014\u0010,\u001a\u0004\u0018\u00010\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010)2\u0006\u0010.\u001a\u00020'H\u0007J\u0012\u0010/\u001a\u0004\u0018\u00010)2\u0006\u0010\u001a\u001a\u00020+H\u0007J\u0012\u0010/\u001a\u0004\u0018\u00010)2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u001a\u00100\u001a\u0004\u0018\u00010'2\u0006\u00101\u001a\u0002022\u0006\u0010\u0012\u001a\u00020\tH\u0007J\u001a\u00103\u001a\u0004\u0018\u0001042\u0006\u00101\u001a\u0002022\u0006\u0010\u0012\u001a\u00020\tH\u0007J9\u00105\u001a\u0004\u0018\u0001H6\"\n\b\u0000\u00106*\u0004\u0018\u0001072\u0006\u00101\u001a\u0002022\u0006\u0010\u0012\u001a\u00020\t2\f\u00108\u001a\b\u0012\u0004\u0012\u0002H609H\u0007\u00a2\u0006\u0002\u0010:J1\u00105\u001a\u0004\u0018\u0001H6\"\n\b\u0000\u00106*\u0004\u0018\u0001072\u0006\u0010\u0012\u001a\u00020\u00132\f\u00108\u001a\b\u0012\u0004\u0012\u0002H609H\u0007\u00a2\u0006\u0002\u0010;J4\u0010<\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H6\u0018\u00010=\"\n\b\u0000\u00106*\u0004\u0018\u0001072\u0006\u0010\u0012\u001a\u00020\u00132\f\u00108\u001a\b\u0012\u0004\u0012\u0002H609H\u0002J\u001a\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010@\u001a\u00020+2\u0006\u0010A\u001a\u00020\rH\u0007J \u0010B\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010C\u0018\u00010\u00062\u0006\u0010D\u001a\u00020\rH\u0002J!\u0010E\u001a\u0004\u0018\u00010?2\u0006\u0010\"\u001a\u00020?2\b\u0010F\u001a\u0004\u0018\u00010CH\u0002\u00a2\u0006\u0002\u0010GJ\u001a\u0010H\u001a\u0004\u0018\u00010I2\u0006\u00101\u001a\u0002022\u0006\u0010\u0012\u001a\u00020\tH\u0007J\"\u0010J\u001a\u0004\u0018\u00010K2\u0006\u00101\u001a\u0002022\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010L\u001a\u00020\rH\u0007J \u0010M\u001a\u0004\u0018\u00010\u001b2\u0006\u00101\u001a\u0002022\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010L\u001a\u00020\rJ\u001a\u0010N\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\b2\u0006\u0010O\u001a\u00020)H\u0002J\u0010\u0010P\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J \u0010Q\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010'\u0018\u00010=0R2\u0006\u0010S\u001a\u000202H\u0007J\u0010\u0010T\u001a\u00020U2\u0006\u0010\u001e\u001a\u00020\u0013H\u0007J\"\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020'2\b\u0010Y\u001a\u0004\u0018\u00010Z2\u0006\u0010[\u001a\u00020UH\u0007J\"\u0010V\u001a\u00020W2\u0006\u0010\\\u001a\u00020]2\b\u0010Y\u001a\u0004\u0018\u00010Z2\u0006\u0010[\u001a\u00020^H\u0007J\u001a\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020'2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0007J\u001a\u0010V\u001a\u00020W2\u0006\u0010\\\u001a\u00020]2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0007J\u0018\u0010_\u001a\u00020C2\u0006\u0010\\\u001a\u00020]2\b\u0010Y\u001a\u0004\u0018\u00010ZJ\u0010\u0010`\u001a\u00020\r2\u0006\u0010X\u001a\u00020'H\u0007J\u001c\u0010a\u001a\u0004\u0018\u00010\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u00101\u001a\u000202H\u0007J\u001a\u0010b\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u00101\u001a\u000202H\u0007RQ\u0010\u0004\u001aE\u0012<\u0012:\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\b \n*\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\b\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lorg/jetbrains/idea/maven/dom/MavenDomUtil;", "", "<init>", "()V", "FILTERED_RESOURCES_ROOTS_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/util/Pair;", "", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "SUBTAGS_IN_SETTINGS_FILE", "", "XML_TAG_NAME_PATTERN", "Ljava/util/regex/Pattern;", "isMavenFile", "", "file", "Lcom/intellij/psi/PsiFile;", "isProjectFile", "getXmlProjectModelVersion", "Lcom/intellij/openapi/util/NlsSafe;", "isProfilesFile", "getXmlSettingsNameSpace", "isSettingsFile", "element", "Lcom/intellij/psi/PsiElement;", "findContainingMavenizedModule", "Lcom/intellij/openapi/module/Module;", "psiFile", "isMavenProperty", "target", "calcRelativePath", "parent", "child", "updateMavenParent", "Lorg/jetbrains/idea/maven/dom/model/MavenDomParent;", "mavenModel", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "parentProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "getVirtualFile", "Lcom/intellij/util/xml/DomElement;", "doGetVirtualFile", "findProject", "projectDom", "findContainingProject", "getMavenDomProjectModel", "project", "Lcom/intellij/openapi/project/Project;", "getMavenDomProfilesModel", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProfiles;", "getMavenDomModel", "T", "Lorg/jetbrains/idea/maven/dom/MavenDomElement;", "clazz", "Ljava/lang/Class;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Class;)Lorg/jetbrains/idea/maven/dom/MavenDomElement;", "(Lcom/intellij/psi/PsiFile;Ljava/lang/Class;)Lorg/jetbrains/idea/maven/dom/MavenDomElement;", "getMavenDomFile", "Lcom/intellij/util/xml/DomFileElement;", "findTag", "Lcom/intellij/psi/xml/XmlTag;", "domElement", "path", "translateTagName", "", "text", "getIndexedTag", "index", "(Lcom/intellij/psi/xml/XmlTag;Ljava/lang/Integer;)Lcom/intellij/psi/xml/XmlTag;", "getPropertiesFile", "Lcom/intellij/lang/properties/psi/PropertiesFile;", "findProperty", "Lcom/intellij/lang/properties/IProperty;", "propName", "findPropertyValue", "getFilteredResourcesRoots", "mavenProject", "isFilteredResourceFile", "collectProjectModels", "", "p", "describe", "Lorg/jetbrains/idea/maven/model/MavenId;", "createDomDependency", "Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;", "model", "editor", "Lcom/intellij/openapi/editor/Editor;", "id", "dependencies", "Lorg/jetbrains/idea/maven/dom/model/MavenDomDependencies;", "Lorg/jetbrains/idea/maven/model/MavenCoordinate;", "getCollectionIndex", "getProjectName", "getMavenVersion", "isAtLeastMaven4", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenDomUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenDomUtil.kt\norg/jetbrains/idea/maven/dom/MavenDomUtil\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,525:1\n108#2:526\n80#2,22:527\n*S KotlinDebug\n*F\n+ 1 MavenDomUtil.kt\norg/jetbrains/idea/maven/dom/MavenDomUtil\n*L\n298#1:526\n298#1:527,22\n*E\n"})
public final class MavenDomUtil {
    @NotNull
    public static final MavenDomUtil INSTANCE = new MavenDomUtil();
    @NotNull
    private static final Key<Pair<Long, Set<VirtualFile>>> FILTERED_RESOURCES_ROOTS_KEY;
    @NotNull
    private static final Set<String> SUBTAGS_IN_SETTINGS_FILE;
    @NotNull
    private static final Pattern XML_TAG_NAME_PATTERN;

    private MavenDomUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isMavenFile(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (MavenDomUtil.isProjectFile(file2)) return true;
        if (MavenDomUtil.isProfilesFile(file2)) return true;
        if (!MavenDomUtil.isSettingsFile(file2)) return false;
        return true;
    }

    @JvmStatic
    public static final boolean isProjectFile(@Nullable PsiFile file2) {
        if (!(file2 instanceof XmlFile)) {
            return false;
        }
        XmlTag rootTag = ((XmlFile)file2).getRootTag();
        if (rootTag == null || !Intrinsics.areEqual((Object)"project", (Object)rootTag.getName())) {
            return false;
        }
        String xmlns = rootTag.getAttributeValue("xmlns");
        if (xmlns != null && StringsKt.startsWith$default((String)xmlns, (String)"http://maven.apache.org/POM/", (boolean)false, (int)2, null)) {
            return true;
        }
        String string = ((XmlFile)file2).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return MavenUtil.isPomFileName(string);
    }

    @JvmStatic
    @Nullable
    public static final String getXmlProjectModelVersion(@Nullable PsiFile file2) {
        if (!(file2 instanceof XmlFile)) {
            return null;
        }
        XmlTag rootTag = ((XmlFile)file2).getRootTag();
        if (rootTag == null || !Intrinsics.areEqual((Object)"project", (Object)rootTag.getName())) {
            return null;
        }
        return rootTag.getSubTagText("modelVersion");
    }

    @JvmStatic
    public static final boolean isProfilesFile(@Nullable PsiFile file2) {
        if (!(file2 instanceof XmlFile)) {
            return false;
        }
        return Intrinsics.areEqual((Object)"profiles.xml", (Object)((XmlFile)file2).getName());
    }

    @JvmStatic
    @Nullable
    public static final String getXmlSettingsNameSpace(@Nullable PsiFile file2) {
        if (!(file2 instanceof XmlFile)) {
            return null;
        }
        XmlTag rootTag = ((XmlFile)file2).getRootTag();
        if (rootTag == null || !Intrinsics.areEqual((Object)"settings", (Object)rootTag.getName())) {
            return null;
        }
        return rootTag.getAttributeValue("xmlns");
    }

    @JvmStatic
    public static final boolean isSettingsFile(@Nullable PsiFile file2) {
        if (!(file2 instanceof XmlFile)) {
            return false;
        }
        XmlTag rootTag = ((XmlFile)file2).getRootTag();
        if (rootTag == null || !Intrinsics.areEqual((Object)"settings", (Object)rootTag.getName())) {
            return false;
        }
        String xmlns = rootTag.getAttributeValue("xmlns");
        if (xmlns != null) {
            return StringsKt.contains$default((CharSequence)xmlns, (CharSequence)"maven", (boolean)false, (int)2, null);
        }
        boolean hasTag = false;
        for (PsiElement e = rootTag.getFirstChild(); e != null; e = e.getNextSibling()) {
            if (!(e instanceof XmlTag)) continue;
            if (SUBTAGS_IN_SETTINGS_FILE.contains(((XmlTag)e).getName())) {
                return true;
            }
            hasTag = true;
        }
        return !hasTag;
    }

    @JvmStatic
    public static final boolean isMavenFile(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile file2 = psiFile;
        return MavenDomUtil.isMavenFile(file2);
    }

    @Nullable
    public final Module findContainingMavenizedModule(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 == null) {
            return null;
        }
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project2);
        if (!manager.isMavenizedProject()) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
        ProjectFileIndex index = projectFileIndex;
        Module module = index.getModuleForFile(file2);
        if (module == null || !manager.isMavenizedModule(module)) {
            return null;
        }
        return module;
    }

    @JvmStatic
    public static final boolean isMavenProperty(@Nullable PsiElement target) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)target, XmlTag.class, (boolean)false);
        if (tag == null) {
            return false;
        }
        return DomUtil.findDomElement((PsiElement)((PsiElement)tag), MavenDomProperties.class) != null;
    }

    @JvmStatic
    @NotNull
    public static final String calcRelativePath(@NotNull VirtualFile parent, @NotNull VirtualFile child) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        String result2 = FileUtil.getRelativePath((String)parent.getPath(), (String)child.getPath(), (char)'/');
        if (result2 == null) {
            MavenLog.LOG.warn("cannot calculate relative path for\nparent: " + parent + "\nchild: " + child);
            result2 = child.getPath();
        }
        String string = FileUtil.toSystemIndependentName((String)result2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final MavenDomParent updateMavenParent(@NotNull MavenDomProjectModel mavenModel, @NotNull MavenProject parentProject) {
        Intrinsics.checkNotNullParameter((Object)mavenModel, (String)"mavenModel");
        Intrinsics.checkNotNullParameter((Object)parentProject, (String)"parentProject");
        MavenDomParent mavenDomParent = mavenModel.getMavenParent();
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomParent, (String)"getMavenParent(...)");
        MavenDomParent result2 = mavenDomParent;
        VirtualFile pomFile = DomUtil.getFile((DomElement)mavenModel).getVirtualFile();
        Project project = mavenModel.getManager().getProject();
        MavenId parentId = parentProject.getMavenId();
        result2.getGroupId().setStringValue(parentId.getGroupId());
        result2.getArtifactId().setStringValue(parentId.getArtifactId());
        result2.getVersion().setStringValue(parentId.getVersion());
        if (!Comparing.equal((Object)pomFile.getParent().getParent(), (Object)parentProject.getDirectoryFile()) || !FileUtil.namesEqual((String)"pom.xml", (String)parentProject.getFile().getName())) {
            result2.getRelativePath().setValue((Object)PsiManager.getInstance((Project)project).findFile(parentProject.getFile()));
        }
        return result2;
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile getVirtualFile(@NotNull DomElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        XmlFile xmlFile = DomUtil.getFile((DomElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"getFile(...)");
        PsiFile psiFile = (PsiFile)xmlFile;
        return INSTANCE.doGetVirtualFile(psiFile);
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile getVirtualFile(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        return INSTANCE.doGetVirtualFile(psiFile);
    }

    private final VirtualFile doGetVirtualFile(PsiFile psiFile) {
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null) {
            return null;
        }
        VirtualFile virtualFile = (psiFile2 = psiFile2.getOriginalFile()).getVirtualFile();
        if (virtualFile instanceof LightVirtualFile) {
            virtualFile = (VirtualFile)ObjectUtils.chooseNotNull((Object)psiFile2.getUserData(MavenGroovyPomCompletionContributor.ORIGINAL_POM_FILE), (Object)virtualFile);
        }
        return virtualFile;
    }

    @JvmStatic
    @Nullable
    public static final MavenProject findProject(@NotNull MavenDomProjectModel projectDom) {
        Intrinsics.checkNotNullParameter((Object)projectDom, (String)"projectDom");
        XmlElement element = projectDom.getXmlElement();
        if (element == null) {
            return null;
        }
        VirtualFile file2 = MavenDomUtil.getVirtualFile((PsiElement)element);
        if (file2 == null) {
            return null;
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(element.getProject());
        return manager.findProject(file2);
    }

    @JvmStatic
    @Nullable
    public static final MavenProject findContainingProject(@NotNull DomElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psi = (PsiElement)element.getXmlElement();
        return psi == null ? null : MavenDomUtil.findContainingProject(psi);
    }

    @JvmStatic
    @Nullable
    public static final MavenProject findContainingProject(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        VirtualFile file2 = MavenDomUtil.getVirtualFile(element);
        if (file2 == null) {
            return null;
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(element.getProject());
        return manager.findContainingProject(file2);
    }

    @JvmStatic
    @Nullable
    public static final MavenDomProjectModel getMavenDomProjectModel(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return MavenDomUtil.getMavenDomModel(project, file2, MavenDomProjectModel.class);
    }

    @JvmStatic
    @Nullable
    public static final MavenDomProfiles getMavenDomProfilesModel(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        MavenDomProfilesModel model = MavenDomUtil.getMavenDomModel(project, file2, MavenDomProfilesModel.class);
        if (model != null) {
            return model.getProfiles();
        }
        return MavenDomUtil.getMavenDomModel(project, file2, MavenDomProfiles.class);
    }

    @JvmStatic
    @Nullable
    public static final <T extends MavenDomElement> T getMavenDomModel(@NotNull Project project, @NotNull VirtualFile file2, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (!file2.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        if (psiFile == null) {
            return null;
        }
        return MavenDomUtil.getMavenDomModel(psiFile, clazz);
    }

    @JvmStatic
    @Nullable
    public static final <T extends MavenDomElement> T getMavenDomModel(@NotNull PsiFile file2, @NotNull Class<T> clazz) {
        DomFileElement<T> fileElement;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        DomFileElement<T> domFileElement = fileElement = INSTANCE.getMavenDomFile(file2, clazz);
        return (T)(domFileElement != null ? (MavenDomElement)domFileElement.getRootElement() : null);
    }

    private final <T extends MavenDomElement> DomFileElement<T> getMavenDomFile(PsiFile file2, Class<T> clazz) {
        if (!(file2 instanceof XmlFile)) {
            return null;
        }
        return DomManager.getDomManager((Project)file2.getProject()).getFileElement((XmlFile)file2, clazz);
    }

    @JvmStatic
    @Nullable
    public static final XmlTag findTag(@NotNull DomElement domElement, @NotNull String path2) {
        Pair<String, Integer> nameAndIndex;
        Intrinsics.checkNotNullParameter((Object)domElement, (String)"domElement");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        List list = StringUtil.split((String)path2, (String)".");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"split(...)");
        List elements = list;
        if (elements.isEmpty()) {
            return null;
        }
        Object e = elements.get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        Pair<String, Integer> pair = nameAndIndex = INSTANCE.translateTagName((String)e);
        Intrinsics.checkNotNull(pair);
        String name = (String)pair.first;
        Integer index = (Integer)nameAndIndex.second;
        XmlTag result2 = domElement.getXmlTag();
        if (result2 == null || !Intrinsics.areEqual((Object)name, (Object)result2.getName())) {
            return null;
        }
        result2 = INSTANCE.getIndexedTag(result2, index);
        for (String each : elements.subList(1, elements.size())) {
            Intrinsics.checkNotNull((Object)each);
            Pair<String, Integer> pair2 = nameAndIndex = INSTANCE.translateTagName(each);
            Intrinsics.checkNotNull(pair2);
            name = (String)pair2.first;
            index = (Integer)nameAndIndex.second;
            XmlTag xmlTag = result2;
            Intrinsics.checkNotNull((Object)xmlTag);
            result2 = xmlTag.findFirstSubTag(name);
            if (result2 == null) {
                return null;
            }
            result2 = INSTANCE.getIndexedTag(result2, index);
        }
        return result2;
    }

    private final Pair<String, Integer> translateTagName(String text) {
        String $this$trim$iv = text;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String tagName = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        Integer index = null;
        Matcher matcher = XML_TAG_NAME_PATTERN.matcher(tagName);
        if (matcher.find()) {
            tagName = matcher.group(1);
            try {
                String string = matcher.group(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                index = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return Pair.create((Object)tagName, index);
    }

    private final XmlTag getIndexedTag(XmlTag parent, Integer index) {
        if (index == null) {
            return parent;
        }
        XmlTag[] xmlTagArray = parent.getSubTags();
        Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"getSubTags(...)");
        XmlTag[] children = xmlTagArray;
        if (index < 0 || index >= children.length) {
            return null;
        }
        return children[index];
    }

    @JvmStatic
    @Nullable
    public static final PropertiesFile getPropertiesFile(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        if (!(psiFile instanceof PropertiesFile)) {
            return null;
        }
        return (PropertiesFile)psiFile;
    }

    @JvmStatic
    @Nullable
    public static final IProperty findProperty(@NotNull Project project, @NotNull VirtualFile file2, @NotNull String propName) {
        PropertiesFile propertiesFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)propName, (String)"propName");
        PropertiesFile propertiesFile2 = propertiesFile = MavenDomUtil.getPropertiesFile(project, file2);
        return propertiesFile2 != null ? propertiesFile2.findPropertyByKey(propName) : null;
    }

    @Nullable
    public final PsiElement findPropertyValue(@NotNull Project project, @NotNull VirtualFile file2, @NotNull String propName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)propName, (String)"propName");
        IProperty prop = MavenDomUtil.findProperty(project, file2, propName);
        IProperty iProperty = prop;
        return iProperty != null && (iProperty = iProperty.getPsiElement()) != null && (iProperty = iProperty.getFirstChild()) != null && (iProperty = iProperty.getNextSibling()) != null ? iProperty.getNextSibling() : null;
    }

    private final Set<VirtualFile> getFilteredResourcesRoots(MavenProject mavenProject) {
        Pair cachedValue;
        block7: {
            block6: {
                cachedValue = mavenProject.getCachedValue(FILTERED_RESOURCES_ROOTS_KEY);
                if (cachedValue == null) break block6;
                Long l = (Long)cachedValue.first;
                long l2 = VirtualFileManager.getInstance().getModificationCount();
                if (l != null && l == l2) break block7;
            }
            Set set = null;
            for (MavenResource resource : ContainerUtil.concat(mavenProject.getResources(), mavenProject.getTestResources())) {
                String resourceDirectory;
                if (!resource.isFiltered()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)resource.getDirectory(), (String)"getDirectory(...)");
                VirtualFile resourceDir = LocalFileSystem.getInstance().findFileByPath(resourceDirectory);
                if (resourceDir == null) continue;
                if (set == null) {
                    set = new HashSet();
                }
                set.add(resourceDir);
            }
            if (set == null) {
                set = new LinkedHashSet();
            }
            cachedValue = Pair.create((Object)VirtualFileManager.getInstance().getModificationCount(), (Object)set);
            mavenProject.putCachedValue(FILTERED_RESOURCES_ROOTS_KEY, cachedValue);
        }
        return (Set)cachedValue.second;
    }

    @JvmStatic
    public static final boolean isFilteredResourceFile(@NotNull PsiElement element) {
        Set<VirtualFile> filteredRoots;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        VirtualFile file2 = INSTANCE.doGetVirtualFile(psiFile);
        if (file2 == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        Intrinsics.checkNotNull((Object)psiFile2);
        MavenProjectsManager manager = MavenProjectsManager.getInstance(psiFile2.getProject());
        MavenProject mavenProject = manager.findContainingProject(file2);
        if (mavenProject == null) {
            return false;
        }
        Set<VirtualFile> set = filteredRoots = INSTANCE.getFilteredResourcesRoots(mavenProject);
        Intrinsics.checkNotNull(set);
        if (!set.isEmpty()) {
            for (VirtualFile f = file2.getParent(); f != null; f = f.getParent()) {
                if (!filteredRoots.contains(f)) continue;
                return true;
            }
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final List<DomFileElement<MavenDomProjectModel>> collectProjectModels(@NotNull Project p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        List list = DomService.getInstance().getFileElements(MavenDomProjectModel.class, p, GlobalSearchScope.projectScope((Project)p));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFileElements(...)");
        return list;
    }

    @JvmStatic
    @NotNull
    public static final MavenId describe(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        MavenDomProjectModel model = MavenDomUtil.getMavenDomModel(psiFile, MavenDomProjectModel.class);
        if (model == null) {
            return new MavenId(null, null, null);
        }
        String groupId = model.getGroupId().getStringValue();
        String artifactId = model.getArtifactId().getStringValue();
        String version = model.getVersion().getStringValue();
        if (groupId == null) {
            groupId = model.getMavenParent().getGroupId().getStringValue();
        }
        if (version == null) {
            version = model.getMavenParent().getVersion().getStringValue();
        }
        return new MavenId(groupId, artifactId, version);
    }

    @JvmStatic
    @NotNull
    public static final MavenDomDependency createDomDependency(@NotNull MavenDomProjectModel model, @Nullable Editor editor, @NotNull MavenId id) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        MavenDomDependencies mavenDomDependencies = model.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencies, (String)"getDependencies(...)");
        return MavenDomUtil.createDomDependency(mavenDomDependencies, editor, (MavenCoordinate)id);
    }

    @JvmStatic
    @NotNull
    public static final MavenDomDependency createDomDependency(@NotNull MavenDomDependencies dependencies, @Nullable Editor editor, @NotNull MavenCoordinate id) {
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        MavenDomDependency dep = MavenDomUtil.createDomDependency(dependencies, editor);
        dep.getGroupId().setStringValue(id.getGroupId());
        dep.getArtifactId().setStringValue(id.getArtifactId());
        dep.getVersion().setStringValue(id.getVersion());
        return dep;
    }

    @JvmStatic
    @NotNull
    public static final MavenDomDependency createDomDependency(@NotNull MavenDomProjectModel model, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        MavenDomDependencies mavenDomDependencies = model.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencies, (String)"getDependencies(...)");
        return MavenDomUtil.createDomDependency(mavenDomDependencies, editor);
    }

    @JvmStatic
    @NotNull
    public static final MavenDomDependency createDomDependency(@NotNull MavenDomDependencies dependencies, @Nullable Editor editor) {
        DomElement element;
        DomCollectionChildDescription childDescription;
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        int index = INSTANCE.getCollectionIndex(dependencies, editor);
        if (index >= 0 && (childDescription = dependencies.getGenericInfo().getCollectionChildDescription("dependency")) != null && (element = childDescription.addValue((DomElement)dependencies, index)) instanceof MavenDomDependency) {
            return (MavenDomDependency)element;
        }
        MavenDomDependency mavenDomDependency = dependencies.addDependency();
        Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependency, (String)"addDependency(...)");
        return mavenDomDependency;
    }

    public final int getCollectionIndex(@NotNull MavenDomDependencies dependencies, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        if (editor != null) {
            int offset = editor.getCaretModel().getOffset();
            List<MavenDomDependency> list = dependencies.getDependencies();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDependencies(...)");
            List<MavenDomDependency> dependencyList = list;
            int n = ((Collection)dependencyList).size();
            for (int i2 = 0; i2 < n; ++i2) {
                MavenDomDependency dependency = dependencyList.get(i2);
                XmlElement xmlElement = dependency.getXmlElement();
                if (xmlElement == null || xmlElement.getTextRange().getStartOffset() < offset) continue;
                return i2;
            }
        }
        return -1;
    }

    @JvmStatic
    @NotNull
    public static final String getProjectName(@NotNull MavenDomProjectModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        MavenProject mavenProject = MavenDomUtil.findProject(model);
        if (mavenProject != null) {
            return mavenProject.getDisplayName();
        }
        String name = model.getName().getStringValue();
        CharSequence charSequence = name;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            return name;
        }
        return "pom.xml";
    }

    @JvmStatic
    @Nullable
    public static final String getMavenVersion(@Nullable VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = file2;
        VirtualFile directory = virtualFile != null ? virtualFile.getParent() : null;
        MavenDistribution distribution = null;
        distribution = directory == null ? MavenDistributionsCache.getInstance(project).getSettingsDistribution() : MavenDistributionsCache.getInstance(project).getMavenDistribution(directory.getPath());
        return distribution.getVersion();
    }

    @JvmStatic
    public static final boolean isAtLeastMaven4(@Nullable VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return StringUtil.compareVersionNumbers((String)MavenDomUtil.getMavenVersion(file2, project), (String)"4") >= 0;
    }

    static {
        Key key = Key.create((String)"MavenDomUtil.FILTERED_RESOURCES_ROOTS");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        FILTERED_RESOURCES_ROOTS_KEY = key;
        Object[] objectArray = new String[]{"localRepository", "interactiveMode", "usePluginRegistry", "offline", "pluginGroups", "servers", "mirrors", "proxies", "profiles", "activeProfiles"};
        HashSet hashSet = ContainerUtil.newHashSet((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSet(...)");
        SUBTAGS_IN_SETTINGS_FILE = hashSet;
        Pattern pattern = Pattern.compile("(\\S*)\\[(\\d*)\\]\\z");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        XML_TAG_NAME_PATTERN = pattern;
    }
}

