/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProfile;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenPropertyResolver {
    public static final Pattern PATTERN = Pattern.compile("\\$\\{(.+?)}|@(.+?)@");

    public static String resolve(String text, MavenDomProjectModel projectDom) {
        XmlElement element = projectDom.getXmlElement();
        if (element == null) {
            return text;
        }
        VirtualFile file2 = MavenDomUtil.getVirtualFile((PsiElement)element);
        if (file2 == null) {
            return text;
        }
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(projectDom.getManager().getProject());
        MavenProject mavenProject = mavenProjectsManager.findProject(file2);
        AdditionalPropertySourceImpl additionalPropertySource = new AdditionalPropertySourceImpl(mavenProject, projectDom);
        return new MavenPropertyResolverHelper(projectDom, mavenProjectsManager, mavenProject, additionalPropertySource).filterText(text);
    }

    @Deprecated
    public static Properties collectPropertiesFromDOM(@Nullable MavenProject project, MavenDomProjectModel projectDom) {
        Properties result2 = new Properties();
        result2.putAll(MavenPropertyResolver.collectPropertyMapFromDOM(project, projectDom));
        return result2;
    }

    public static Map<String, String> collectPropertyMapFromDOM(@Nullable MavenProject project, MavenDomProjectModel projectDom) {
        HashMap<String, String> result2 = new HashMap<String, String>();
        MavenPropertyResolver.collectPropertyMapFromDOM((MavenDomProperties)ReadAction.compute(() -> projectDom.getProperties()), result2);
        if (project != null) {
            MavenPropertyResolver.collectPropertiesForActivatedProfiles(project, projectDom, result2);
        }
        return result2;
    }

    private static void collectPropertiesForActivatedProfiles(@NotNull MavenProject project, MavenDomProjectModel projectDom, Map<String, String> result2) {
        if (project == null) {
            MavenPropertyResolver.$$$reportNull$$$0(0);
        }
        Collection activeProfiles = project.getActivatedProfilesIds().getEnabledProfiles();
        List profiles2 = (List)ReadAction.compute(() -> projectDom.getProfiles().getProfiles());
        for (MavenDomProfile each : profiles2) {
            XmlTag idTag = each.getId().getXmlTag();
            if (idTag == null || !activeProfiles.contains(idTag.getValue().getTrimmedText())) continue;
            MavenPropertyResolver.collectPropertyMapFromDOM(each.getProperties(), result2);
        }
    }

    private static void collectPropertyMapFromDOM(MavenDomProperties props, Map<String, String> result2) {
        XmlTag propsTag = props.getXmlTag();
        if (propsTag != null) {
            for (XmlTag each : propsTag.getSubTags()) {
                result2.put(each.getName(), each.getValue().getTrimmedText());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/MavenPropertyResolver", "collectPropertiesForActivatedProfiles"));
    }

    private static class AdditionalPropertySourceImpl
    implements AdditionalPropertySource {
        @Nullable
        private final MavenProject mavenProject;
        private final MavenDomProjectModel projectDom;
        private Map<String, String> additionalProperties;

        private AdditionalPropertySourceImpl(@Nullable MavenProject mavenProject, MavenDomProjectModel projectDom) {
            this.mavenProject = mavenProject;
            this.projectDom = projectDom;
        }

        @Override
        public String get(String key) {
            if (null == this.additionalProperties) {
                this.additionalProperties = MavenPropertyResolver.collectPropertyMapFromDOM(this.mavenProject, this.projectDom);
            }
            return this.additionalProperties.get(key);
        }
    }

    private static class MavenPropertyResolverHelper {
        private static final Pattern pattern = PATTERN;
        private final MavenDomProjectModel projectDom;
        private final MavenProjectsManager mavenProjectsManager;
        @Nullable
        private final MavenProject mavenProject;
        private final AdditionalPropertySource additionalPropertySource;

        private MavenPropertyResolverHelper(MavenDomProjectModel projectDom, MavenProjectsManager mavenProjectsManager, @Nullable MavenProject mavenProject, AdditionalPropertySource additionalPropertySource) {
            this.projectDom = projectDom;
            this.mavenProjectsManager = mavenProjectsManager;
            this.mavenProject = mavenProject;
            this.additionalPropertySource = additionalPropertySource;
        }

        public String filterText(String text) {
            StringBuilder res = new StringBuilder();
            try {
                this.doFilterText(pattern, text, null, res);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return res.toString();
        }

        private void doFilterText(Pattern pattern, String text, @Nullable Map<String, String> resolvedPropertiesParam, Appendable out) throws IOException {
            Map<String, String> resolvedProperties = resolvedPropertiesParam;
            Matcher matcher = pattern.matcher(text);
            int groupCount = matcher.groupCount();
            int last = 0;
            while (matcher.find()) {
                String propertyValue;
                out.append(text, last, matcher.start());
                last = matcher.end();
                String propertyName = null;
                for (int i2 = 0; i2 < groupCount && (propertyName = matcher.group(i2 + 1)) == null; ++i2) {
                }
                assert (propertyName != null);
                if (resolvedProperties == null) {
                    resolvedProperties = new HashMap<String, String>();
                }
                if ((propertyValue = resolvedProperties.get(propertyName)) == null) {
                    if (resolvedProperties.containsKey(propertyName)) {
                        out.append(matcher.group());
                        continue;
                    }
                    String resolved = this.mavenProject != null ? this.doResolvePropertyForMavenProject(propertyName) : this.doResolvePropertyForMavenDomModel(propertyName);
                    if (resolved == null) {
                        out.append(matcher.group());
                        continue;
                    }
                    resolvedProperties.put(propertyName, null);
                    StringBuilder sb = new StringBuilder();
                    this.doFilterText(pattern, resolved, resolvedProperties, sb);
                    propertyValue = sb.toString();
                    resolvedProperties.put(propertyName, propertyValue);
                }
                out.append(propertyValue);
            }
            out.append(text, last, text.length());
        }

        @Nullable
        private String doResolvePropertyForMavenProject(String propName) {
            String javaVersion;
            String jreDir;
            boolean hasPrefix = false;
            String unprefixed = propName;
            if (propName.startsWith("pom.")) {
                unprefixed = propName.substring("pom.".length());
                hasPrefix = true;
            } else if (propName.startsWith("project.")) {
                unprefixed = propName.substring("project.".length());
                hasPrefix = true;
            }
            MavenProject selectedProject = this.mavenProject;
            while (unprefixed.startsWith("parent.")) {
                if (selectedProject == null) {
                    return null;
                }
                MavenId parentId = selectedProject.getParentId();
                if (parentId == null) {
                    return null;
                }
                if ((unprefixed = unprefixed.substring("parent.".length())).equals("groupId")) {
                    return parentId.getGroupId();
                }
                if (unprefixed.equals("artifactId")) {
                    return parentId.getArtifactId();
                }
                if (unprefixed.equals("version")) {
                    return parentId.getVersion();
                }
                selectedProject = this.mavenProjectsManager.findProject(parentId);
                if (selectedProject != null) continue;
                return null;
            }
            if (unprefixed.equals("basedir") || hasPrefix && this.mavenProject == selectedProject && unprefixed.equals("baseUri")) {
                return null == selectedProject ? null : selectedProject.getDirectory();
            }
            if ("java.home".equals(propName) && null != this.mavenProject && (jreDir = MavenUtil.getModuleJreHome(this.mavenProjectsManager, this.mavenProject)) != null) {
                return jreDir;
            }
            if ("java.version".equals(propName) && null != this.mavenProject && (javaVersion = MavenUtil.getModuleJavaVersion(this.mavenProjectsManager, this.mavenProject)) != null) {
                return javaVersion;
            }
            String result2 = MavenUtil.getPropertiesFromMavenOpts().get(propName);
            if (result2 != null) {
                return result2;
            }
            if (null == this.mavenProject) {
                return null;
            }
            result2 = this.mavenProject.getMavenConfig().get(propName);
            if (result2 != null) {
                return result2;
            }
            result2 = this.mavenProject.getJvmConfig().get(propName);
            if (result2 != null) {
                return result2;
            }
            result2 = MavenServerUtil.collectSystemProperties().getProperty(propName);
            if (result2 != null) {
                return result2;
            }
            result2 = selectedProject.getModelMap().get(unprefixed);
            if (result2 != null) {
                return result2;
            }
            result2 = this.additionalPropertySource.get(propName);
            if (result2 != null) {
                return result2;
            }
            result2 = this.mavenProject.getProperties().getProperty(propName);
            if (result2 != null) {
                return result2;
            }
            if ("settings.localRepository".equals(propName)) {
                return this.mavenProject.getLocalRepositoryPath().toAbsolutePath().toString();
            }
            return null;
        }

        @Nullable
        private String doResolvePropertyForMavenDomModel(String propName) {
            if (propName.startsWith("parent.")) {
                MavenDomParent parentDomElement = this.projectDom.getMavenParent();
                if (!parentDomElement.exists()) {
                    return null;
                }
                MavenId parentId = new MavenId(parentDomElement.getGroupId().getStringValue(), parentDomElement.getArtifactId().getStringValue(), parentDomElement.getVersion().getStringValue());
                if ((propName = propName.substring("parent.".length())).equals("groupId")) {
                    return parentId.getGroupId();
                }
                if (propName.equals("artifactId")) {
                    return parentId.getArtifactId();
                }
                if (propName.equals("version")) {
                    return parentId.getVersion();
                }
                return null;
            }
            String result2 = MavenUtil.getPropertiesFromMavenOpts().get(propName);
            if (result2 != null) {
                return result2;
            }
            result2 = MavenServerUtil.collectSystemProperties().getProperty(propName);
            if (result2 != null) {
                return result2;
            }
            result2 = this.additionalPropertySource.get(propName);
            if (result2 != null) {
                return result2;
            }
            if ("settings.localRepository".equals(propName)) {
                return MavenProjectsManager.getInstance(this.projectDom.getManager().getProject()).getRepositoryPath().toAbsolutePath().toString();
            }
            return null;
        }
    }

    static interface AdditionalPropertySource {
        public String get(String var1);
    }
}

