/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.util.PropertiesUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenTestRunningSettings;
import org.jetbrains.idea.maven.utils.MavenFilteredJarUtils;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.jps.maven.model.impl.MavenFilteredJarConfiguration;

public final class MavenJUnitPatcher
extends JUnitPatcher {
    public static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{(.+?)}");
    public static final Pattern ARG_LINE_PATTERN = Pattern.compile("@\\{(.+?)}");
    private static final Logger LOG = Logger.getInstance(MavenJUnitPatcher.class);
    private static final Set<String> EXCLUDE_SUBTAG_NAMES = Set.of("classpathDependencyExclude", "classpathDependencyExcludes", "dependencyExclude");
    private static final Map<String, List<String>> SCOPE_FILTER = Map.of("compile", Arrays.asList("system", "provided", "compile"), "runtime", Arrays.asList("compile", "runtime"), "compile+runtime", Arrays.asList("system", "provided", "compile", "runtime"), "runtime+system", Arrays.asList("system", "compile", "runtime"), "test", Arrays.asList("system", "provided", "compile", "runtime", "test"));

    public void patchJavaParameters(@Nullable Module module, JavaParameters javaParameters) {
        if (module == null) {
            return;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(module.getProject());
        MavenProject mavenProject = projectsManager.findProject(module);
        if (mavenProject == null) {
            return;
        }
        UnaryOperator<String> runtimeProperties = MavenJUnitPatcher.getDynamicConfigurationProperties(module, mavenProject, javaParameters);
        MavenJUnitPatcher.configureFromPlugin(module, javaParameters, mavenProject, runtimeProperties, "maven-surefire-plugin", "surefire");
        MavenJUnitPatcher.configureFromPlugin(module, javaParameters, mavenProject, runtimeProperties, "maven-failsafe-plugin", "failsafe");
        MavenJUnitPatcher.replaceFilteredJarDirectories(projectsManager, module, javaParameters, mavenProject);
    }

    private static List<DependenciesWithClassifiers> groupByClassifiers(@NotNull List<MavenArtifact> dependencies) {
        if (dependencies == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(0);
        }
        LinkedHashMap map = new LinkedHashMap();
        dependencies.forEach(d -> map.compute(d.getMavenId(), (i2, l) -> {
            if (l == null) {
                return new SmartList((Object)d.getClassifier());
            }
            l.add(d.getClassifier());
            return l;
        }));
        return ContainerUtil.map(map.entrySet(), e -> new DependenciesWithClassifiers((MavenId)e.getKey(), (List)e.getValue()));
    }

    private static void replaceFilteredJarDirectories(MavenProjectsManager projectsManager, @NotNull Module module, JavaParameters parameters, MavenProject project) {
        if (module == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(1);
        }
        if (!Registry.is((String)"maven.build.additional.jars")) {
            return;
        }
        List<ReplaceInfo> fixClassPath = MavenJUnitPatcher.getClassPathReplaceInfos(projectsManager, project);
        MavenJUnitPatcher.replaceClassPath(module, parameters, fixClassPath);
    }

    private static void replaceClassPath(@NotNull Module module, JavaParameters parameters, List<ReplaceInfo> fixClassPath) {
        if (module == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(2);
        }
        if (fixClassPath.isEmpty()) {
            return;
        }
        String[] paths = ArrayUtil.toStringArray((Collection)parameters.getClassPath().getPathList());
        ArrayList<String> resultingPath = new ArrayList<String>(paths.length);
        boolean pathFixed = false;
        HashMap configurationMap = new HashMap();
        fixClassPath.forEach(ri -> configurationMap.put(FileUtil.toCanonicalPath((String)ri.configurations.get((int)0).originalOutput), ri));
        for (String path2 : paths) {
            ReplaceInfo replaceInfo = (ReplaceInfo)configurationMap.get(FileUtil.toCanonicalPath((String)path2));
            if (replaceInfo != null) {
                pathFixed = true;
                if (replaceInfo.append) {
                    resultingPath.add(path2);
                }
                resultingPath.addAll(ContainerUtil.map(replaceInfo.configurations, c -> c.jarOutput));
                continue;
            }
            resultingPath.add(path2);
        }
        if (!pathFixed) {
            LOG.warn("expected to replace " + fixClassPath.size() + " dependencies in running module " + module.getName() + ", but replaced 0");
        } else {
            parameters.getClassPath().clear();
            parameters.getClassPath().addAll(resultingPath);
        }
    }

    @NotNull
    private static List<ReplaceInfo> getClassPathReplaceInfos(MavenProjectsManager projectsManager, MavenProject project) {
        HashSet<MavenId> visited = new HashSet<MavenId>();
        ArrayDeque<DependenciesWithClassifiers> queue = new ArrayDeque<DependenciesWithClassifiers>(MavenJUnitPatcher.groupByClassifiers(project.getDependencies()));
        ArrayList<ReplaceInfo> fixClassPath = new ArrayList<ReplaceInfo>();
        while (!queue.isEmpty()) {
            DependenciesWithClassifiers dependencies = queue.poll();
            MavenProject depProject = projectsManager.findProject(dependencies.id);
            if (depProject == null || !visited.add(dependencies.id)) continue;
            List configurations = ContainerUtil.mapNotNull(dependencies.classifiers, classifier -> MavenJUnitPatcher.findFilteredJarConfig(projectsManager, depProject, classifier));
            if (!configurations.isEmpty()) {
                fixClassPath.add(new ReplaceInfo(configurations, MavenJUnitPatcher.needAppendClasspath(dependencies.classifiers)));
            }
            queue.addAll(MavenJUnitPatcher.groupByClassifiers(project.getDependencies()));
        }
        ArrayList<ReplaceInfo> arrayList = fixClassPath;
        if (arrayList == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static boolean needAppendClasspath(List<String> classifiers) {
        for (String c : classifiers) {
            if (c != null && !c.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static MavenFilteredJarConfiguration findFilteredJarConfig(MavenProjectsManager projectsManager, MavenProject mavenProject, String classifier) {
        List<@NotNull MavenFilteredJarConfiguration> configurations = MavenFilteredJarUtils.getAllFilteredConfigurations(projectsManager, mavenProject);
        return (MavenFilteredJarConfiguration)ContainerUtil.find(configurations, c -> StringUtil.equals((CharSequence)c.classifier, (CharSequence)classifier));
    }

    private static void configureFromPlugin(@NotNull Module module, JavaParameters javaParameters, MavenProject mavenProject, UnaryOperator<String> runtimeProperties, String pluginArtifact, String pluginName) {
        MavenPlugin plugin;
        if (module == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(4);
        }
        if ((plugin = mavenProject.findPlugin("org.apache.maven.plugins", pluginArtifact)) != null) {
            Element config = mavenProject.getPluginGoalConfiguration(plugin, null);
            if (config == null) {
                config = new Element("configuration");
            }
            MavenJUnitPatcher.patchJavaParameters(module, javaParameters, mavenProject, pluginName, config, runtimeProperties);
        }
    }

    private static UnaryOperator<String> getDynamicConfigurationProperties(Module module, MavenProject mavenProject, JavaParameters javaParameters) {
        MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel(module.getProject(), mavenProject.getFile());
        if (domModel == null) {
            return s -> s;
        }
        Map<String, String> staticProperties = MavenPropertyResolver.collectPropertyMapFromDOM(mavenProject, domModel);
        Properties modelProperties = mavenProject.getProperties();
        String jaCoCoConfigProperty = MavenJUnitPatcher.getJaCoCoArgLineProperty(mavenProject);
        ParametersList vmParameters = javaParameters.getVMParametersList();
        return name -> {
            String vmPropertyValue = vmParameters.getPropertyValue(name);
            if (vmPropertyValue != null) {
                return vmPropertyValue;
            }
            String staticPropertyValue = (String)staticProperties.get(name);
            if (staticPropertyValue != null) {
                return MavenPropertyResolver.resolve(staticPropertyValue, domModel);
            }
            String modelPropertyValue = modelProperties.getProperty((String)name);
            if (modelPropertyValue != null) {
                return modelPropertyValue;
            }
            if (name.equals(jaCoCoConfigProperty)) {
                return "";
            }
            return null;
        };
    }

    private static String getJaCoCoArgLineProperty(MavenProject mavenProject) {
        Element propertyName;
        Element jaCoCoGoalConfig;
        Element propertyName2;
        String jaCoCoConfigProperty = "argLine";
        Element jaCoCoConfig = mavenProject.getPluginConfiguration("org.jacoco", "jacoco-maven-plugin");
        if (jaCoCoConfig != null && (propertyName2 = jaCoCoConfig.getChild("propertyName")) != null) {
            jaCoCoConfigProperty = propertyName2.getTextTrim();
        }
        if ((jaCoCoGoalConfig = mavenProject.getPluginGoalConfiguration("org.jacoco", "jacoco-maven-plugin", "prepare-agent")) != null && (propertyName = jaCoCoGoalConfig.getChild("propertyName")) != null) {
            jaCoCoConfigProperty = propertyName.getTextTrim();
        }
        return jaCoCoConfigProperty;
    }

    private static void patchJavaParameters(@NotNull Module module, @NotNull JavaParameters javaParameters, @NotNull MavenProject mavenProject, @NotNull String plugin, @NotNull Element config, @NotNull UnaryOperator<String> runtimeProperties) {
        Element environmentVariables;
        String value;
        if (module == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(5);
        }
        if (javaParameters == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(6);
        }
        if (mavenProject == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(7);
        }
        if (plugin == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(8);
        }
        if (config == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(9);
        }
        if (runtimeProperties == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(10);
        }
        MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel(module.getProject(), mavenProject.getFile());
        MavenTestRunningSettings testRunningSettings = MavenProjectSettings.getInstance(module.getProject()).getTestRunningSettings();
        List<String> paths = MavenJDOMUtil.findChildrenValuesByPath(config, "additionalClasspathElements", "additionalClasspathElement");
        if (!paths.isEmpty()) {
            for (String pathLine : paths) {
                for (String path2 : pathLine.split(",")) {
                    javaParameters.getClassPath().add(MavenJUnitPatcher.resolvePluginProperties(plugin, path2.trim(), domModel));
                }
            }
        }
        List<String> excludes = MavenJUnitPatcher.getExcludedCoordinates(config);
        String scopeExclude = MavenJDOMUtil.findChildValueByPath(config, "classpathDependencyScopeExclude");
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(module.getProject());
        if (scopeExclude != null || !excludes.isEmpty()) {
            for (MavenArtifact dependency : mavenProject.getDependencies()) {
                if ((scopeExclude == null || !SCOPE_FILTER.getOrDefault(scopeExclude, Collections.emptyList()).contains(dependency.getScope())) && !excludes.contains(dependency.getGroupId() + ":" + dependency.getArtifactId())) continue;
                File file2 = dependency.getFile();
                javaParameters.getClassPath().remove(file2.getAbsolutePath());
                Optional.ofNullable(mavenProjectsManager.findProject(dependency.getMavenId())).map(mavenProjectsManager::findModule).map(CompilerModuleExtension::getInstance).map(CompilerModuleExtension::getCompilerOutputPath).ifPresent(compilerOutputPath -> javaParameters.getClassPath().remove(compilerOutputPath));
            }
        }
        if (testRunningSettings.isPassSystemProperties()) {
            Element systemPropertiesFile;
            Element systemPropertyVariables;
            if (MavenJUnitPatcher.isEnabled(plugin, "systemPropertyVariables") && (systemPropertyVariables = config.getChild("systemPropertyVariables")) != null) {
                for (Element element : systemPropertyVariables.getChildren()) {
                    String propertyName = element.getName();
                    if (javaParameters.getVMParametersList().hasProperty(propertyName)) continue;
                    value = MavenJUnitPatcher.resolvePluginProperties(plugin, element.getValue(), domModel);
                    value = MavenJUnitPatcher.resolveVmProperties(javaParameters.getVMParametersList(), value);
                    if (!MavenJUnitPatcher.isResolved(plugin, value)) continue;
                    javaParameters.getVMParametersList().addProperty(propertyName, value);
                }
            }
            if (MavenJUnitPatcher.isEnabled(plugin, "systemPropertiesFile") && (systemPropertiesFile = config.getChild("systemPropertiesFile")) != null) {
                Object systemPropertiesFilePath = systemPropertiesFile.getTextTrim();
                if (StringUtil.isNotEmpty((String)systemPropertiesFilePath) && !FileUtil.isAbsolute((String)systemPropertiesFilePath)) {
                    systemPropertiesFilePath = mavenProject.getDirectory() + "/" + (String)systemPropertiesFilePath;
                }
                if (StringUtil.isNotEmpty((String)systemPropertiesFilePath) && new File((String)systemPropertiesFilePath).exists()) {
                    try (BufferedReader fis = Files.newBufferedReader(Paths.get((String)systemPropertiesFilePath, new String[0]), StandardCharsets.ISO_8859_1);){
                        Map properties = PropertiesUtil.loadProperties((Reader)fis);
                        properties.forEach((pName, pValue) -> javaParameters.getVMParametersList().addProperty(pName, pValue));
                    }
                    catch (IOException e) {
                        LOG.warn("Can't read property file '" + (String)systemPropertiesFilePath + "': " + e.getMessage());
                    }
                }
            }
        }
        if (testRunningSettings.isPassEnvironmentVariables() && MavenJUnitPatcher.isEnabled(plugin, "environmentVariables") && (environmentVariables = config.getChild("environmentVariables")) != null) {
            for (Element element : environmentVariables.getChildren()) {
                String variableName = element.getName();
                if (javaParameters.getEnv().containsKey(variableName)) continue;
                value = MavenJUnitPatcher.resolvePluginProperties(plugin, element.getValue(), domModel);
                value = MavenJUnitPatcher.resolveVmProperties(javaParameters.getVMParametersList(), value);
                if (!MavenJUnitPatcher.isResolved(plugin, value)) continue;
                javaParameters.addEnv(variableName, value);
            }
        }
        if (testRunningSettings.isPassArgLine() && MavenJUnitPatcher.isEnabled(plugin, "argLine")) {
            Element argLine = config.getChild("argLine");
            String propertyText = argLine != null ? argLine.getTextTrim() : "${argLine}";
            String value2 = MavenJUnitPatcher.resolvePluginProperties(plugin, propertyText, domModel);
            value2 = MavenJUnitPatcher.resolveVmProperties(javaParameters.getVMParametersList(), value2);
            if (StringUtil.isNotEmpty((String)value2) && MavenJUnitPatcher.isResolved(plugin, value2)) {
                value2 = MavenJUnitPatcher.resolveRuntimeProperties(value2, runtimeProperties);
                javaParameters.getVMParametersList().addParametersString(value2);
            }
        }
    }

    private static String resolveRuntimeProperties(String value, UnaryOperator<String> runtimeProperties) {
        Matcher matcher = ARG_LINE_PATTERN.matcher(value);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String replacement = (String)runtimeProperties.apply(matcher.group(1));
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement == null ? matcher.group() : replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    @NotNull
    private static List<String> getExcludedCoordinates(@NotNull Element config) {
        Element excludesElement;
        if (config == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(11);
        }
        if ((excludesElement = config.getChild("classpathDependencyExcludes")) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MavenJUnitPatcher.$$$reportNull$$$0(12);
            }
            return list;
        }
        String rawText = excludesElement.getTextTrim();
        ArrayList<String> excludes = new ArrayList<String>();
        if (!rawText.isEmpty()) {
            StreamEx.split((CharSequence)rawText, (char)',').map(String::trim).into(excludes);
        }
        for (Element child : excludesElement.getChildren()) {
            String excludeItem;
            String name = child.getName();
            if (name == null || !EXCLUDE_SUBTAG_NAMES.contains(name) || (excludeItem = child.getTextTrim()).isEmpty()) continue;
            StreamEx.split((CharSequence)excludeItem, (char)',').map(String::trim).into(excludes);
        }
        ArrayList<String> arrayList = excludes;
        if (arrayList == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private static String resolvePluginProperties(@NotNull String plugin, @NotNull String value, @Nullable MavenDomProjectModel domModel) {
        if (plugin == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(14);
        }
        if (value == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(15);
        }
        if (domModel != null) {
            value = MavenPropertyResolver.resolve(value, domModel);
        }
        return value.replaceAll("\\$\\{" + plugin + "\\.(forkNumber|threadNumber)}", "1");
    }

    private static String resolveVmProperties(@NotNull ParametersList vmParameters, @NotNull String value) {
        if (vmParameters == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(16);
        }
        if (value == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(17);
        }
        Matcher matcher = PROPERTY_PATTERN.matcher(value);
        HashMap<String, String> toReplace = new HashMap<String, String>();
        while (matcher.find()) {
            String finding = matcher.group();
            String propertyValue = vmParameters.getPropertyValue(finding.substring(2, finding.length() - 1));
            if (propertyValue == null) continue;
            toReplace.put(finding, propertyValue);
        }
        for (Map.Entry entry : toReplace.entrySet()) {
            value = value.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return value;
    }

    private static boolean isEnabled(String plugin, String s) {
        return !Boolean.parseBoolean(System.getProperty("idea.maven." + plugin + ".disable." + s));
    }

    private static boolean isResolved(String plugin, String s) {
        return !s.contains("${") || Boolean.parseBoolean(System.getProperty("idea.maven." + plugin + ".allPropertiesAreResolved"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenJUnitPatcher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtimeProperties";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenJUnitPatcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPathReplaceInfos";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedCoordinates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "groupByClassifiers";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "replaceFilteredJarDirectories";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "replaceClassPath";
                break;
            }
            case 3: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "configureFromPlugin";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "patchJavaParameters";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedCoordinates";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolvePluginProperties";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveVmProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 12, 13 -> new IllegalStateException(string);
        };
    }

    record ReplaceInfo(List<MavenFilteredJarConfiguration> configurations, boolean append) {
    }

    record DependenciesWithClassifiers(MavenId id, List<String> classifiers) {
    }
}

