/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution.run;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTreeFilters;
import com.intellij.build.BuildView;
import com.intellij.build.BuildViewManager;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.Filterable;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.CantRunException;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.PtyOptions;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.eel.EelTargetEnvironmentRequest;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.testDiscovery.JvmToggleAutoTestAction;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfigurationViewManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.terminal.TerminalExecutionConsole;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.BuildToolConsoleProcessAdapter;
import org.jetbrains.idea.maven.buildtool.MavenBuildEventProcessor;
import org.jetbrains.idea.maven.execution.MavenRebuildAction;
import org.jetbrains.idea.maven.execution.MavenResumeAction;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.execution.run.MavenBuildHandlerFilterSpyWrapper;
import org.jetbrains.idea.maven.execution.run.MavenHandlerFilterSpyWrapper;
import org.jetbrains.idea.maven.execution.run.MavenKillableProcessHandler;
import org.jetbrains.idea.maven.execution.run.MavenRuntimeTargetResolver;
import org.jetbrains.idea.maven.execution.target.MavenCommandLineSetup;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeTargetConfiguration;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeTypeConstants;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenParsingContext;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.server.MavenWrapperDownloader;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenCommandLineState
extends JavaCommandLineState
implements RemoteConnectionCreator {
    private final MavenRunConfiguration myConfiguration;
    private RemoteConnectionCreator myRemoteConnectionCreator;

    public MavenCommandLineState(@NotNull ExecutionEnvironment environment, @NotNull MavenRunConfiguration configuration) {
        if (environment == null) {
            MavenCommandLineState.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            MavenCommandLineState.$$$reportNull$$$0(1);
        }
        super(environment);
        this.myConfiguration = configuration;
    }

    public TargetEnvironmentRequest createCustomTargetEnvironmentRequest() {
        Project project = this.myConfiguration.getProject();
        EelDescriptor eelDescriptor = EelProviderUtil.getEelDescriptor((Project)project);
        if (eelDescriptor instanceof LocalEelDescriptor) {
            return null;
        }
        EelApi eel = EelProviderUtil.upgradeBlocking((EelDescriptor)eelDescriptor);
        EelTargetEnvironmentRequest.Configuration configuration = new EelTargetEnvironmentRequest.Configuration(eel);
        MavenRuntimeTargetResolver targetResolver = new MavenRuntimeTargetResolver(project, eel);
        MavenRuntimeTargetConfiguration runtimeTarget = targetResolver.resolve(this.myConfiguration);
        configuration.addLanguageRuntime((LanguageRuntimeConfiguration)runtimeTarget);
        return new EelTargetEnvironmentRequest(configuration);
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        if (this.getEnvironment().getTargetEnvironmentRequest() instanceof LocalTargetEnvironmentRequest) {
            JavaParameters parameters = this.myConfiguration.createJavaParameters(this.getEnvironment().getProject());
            JavaRunConfigurationExtensionManager.getInstance().updateJavaParameters((RunConfigurationBase)this.myConfiguration, parameters, this.getEnvironment().getRunnerSettings(), this.getEnvironment().getExecutor());
            return parameters;
        }
        return new JavaParameters();
    }

    @Nullable
    protected ConsoleView createConsole(@NotNull Executor executor) throws ExecutionException {
        ConsoleView console;
        if (executor == null) {
            MavenCommandLineState.$$$reportNull$$$0(2);
        }
        if ((console = super.createConsole(executor)) != null && this.getEnvironment().getTargetEnvironmentRequest() instanceof LocalTargetEnvironmentRequest) {
            return JavaRunConfigurationExtensionManager.getInstance().decorateExecutionConsole((RunConfigurationBase)this.myConfiguration, this.getRunnerSettings(), console, executor);
        }
        return console;
    }

    @Nullable
    protected ConsoleView createConsole(@NotNull Executor executor, @NotNull ProcessHandler processHandler, @NotNull Project project) throws ExecutionException {
        ConsoleView console;
        if (executor == null) {
            MavenCommandLineState.$$$reportNull$$$0(3);
        }
        if (processHandler == null) {
            MavenCommandLineState.$$$reportNull$$$0(4);
        }
        if (project == null) {
            MavenCommandLineState.$$$reportNull$$$0(5);
        }
        if ((console = this.createConsoleView(executor, processHandler, project)) != null && this.getEnvironment().getTargetEnvironmentRequest() instanceof LocalTargetEnvironmentRequest) {
            return JavaRunConfigurationExtensionManager.getInstance().decorateExecutionConsole((RunConfigurationBase)this.myConfiguration, this.getRunnerSettings(), console, executor);
        }
        return console;
    }

    @Nullable
    protected ConsoleView createConsoleView(@NotNull Executor executor, @NotNull ProcessHandler processHandler, @NotNull Project project) throws ExecutionException {
        if (executor == null) {
            MavenCommandLineState.$$$reportNull$$$0(6);
        }
        if (processHandler == null) {
            MavenCommandLineState.$$$reportNull$$$0(7);
        }
        if (project == null) {
            MavenCommandLineState.$$$reportNull$$$0(8);
        }
        return this.emulateTerminal() ? new TerminalExecutionConsole(project, null) : super.createConsole(executor);
    }

    protected boolean emulateTerminal() {
        return !SystemInfo.isWindows && this.myConfiguration.getGeneralSettings() != null && this.myConfiguration.getGeneralSettings().isEmulateTerminal() && this.getTargetEnvironmentRequest() instanceof LocalTargetEnvironmentRequest;
    }

    public ExecutionResult doDelegateBuildExecute(@NotNull Executor executor, @NotNull ProgramRunner runner, ExternalSystemTaskId taskId, DefaultBuildDescriptor descriptor2, ProcessHandler processHandler, Function<String, String> targetFileMapper) throws ExecutionException {
        if (executor == null) {
            MavenCommandLineState.$$$reportNull$$$0(9);
        }
        if (runner == null) {
            MavenCommandLineState.$$$reportNull$$$0(10);
        }
        ConsoleView consoleView = this.createConsole(executor, processHandler, this.myConfiguration.getProject());
        BuildViewManager viewManager = (BuildViewManager)this.getEnvironment().getProject().getService(BuildViewManager.class);
        descriptor2.withProcessHandler((BuildProcessHandler)new MavenBuildHandlerFilterSpyWrapper(processHandler), null);
        descriptor2.withExecutionEnvironment(this.getEnvironment());
        StartBuildEventImpl startBuildEvent = new StartBuildEventImpl((BuildDescriptor)descriptor2, "");
        boolean withResumeAction = MavenResumeAction.isApplicable(this.getEnvironment().getProject(), this.getJavaParameters(), this.myConfiguration);
        MavenBuildEventProcessor eventProcessor = new MavenBuildEventProcessor(this.myConfiguration, (BuildProgressListener)viewManager, (BuildDescriptor)descriptor2, taskId, targetFileMapper, this.getStartBuildEventSupplier(runner, processHandler, startBuildEvent, withResumeAction));
        processHandler.addProcessListener((ProcessListener)new BuildToolConsoleProcessAdapter(eventProcessor));
        DefaultExecutionResult res = new DefaultExecutionResult((ExecutionConsole)consoleView, processHandler, new AnAction[]{new DefaultActionGroup()});
        res.setRestartActions(new AnAction[]{new JvmToggleAutoTestAction()});
        return res;
    }

    public ExecutionResult doRunExecute(@NotNull Executor executor, @NotNull ProgramRunner runner, ExternalSystemTaskId taskId, DefaultBuildDescriptor descriptor2, ProcessHandler processHandler, @NotNull Function<String, String> targetFileMapper) throws ExecutionException {
        BuildView buildView;
        if (executor == null) {
            MavenCommandLineState.$$$reportNull$$$0(11);
        }
        if (runner == null) {
            MavenCommandLineState.$$$reportNull$$$0(12);
        }
        if (targetFileMapper == null) {
            MavenCommandLineState.$$$reportNull$$$0(13);
        }
        if ((buildView = this.createBuildView(executor, (BuildDescriptor)descriptor2, processHandler)) == null) {
            MavenLog.LOG.warn("buildView is null for " + this.myConfiguration.getName());
        }
        MavenBuildEventProcessor eventProcessor = new MavenBuildEventProcessor(this.myConfiguration, (BuildProgressListener)buildView, (BuildDescriptor)descriptor2, taskId, targetFileMapper, ctx -> new StartBuildEventImpl((BuildDescriptor)descriptor2, ""));
        processHandler.addProcessListener((ProcessListener)new BuildToolConsoleProcessAdapter(eventProcessor));
        if (this.emulateTerminal()) {
            buildView.attachToProcess(processHandler);
        } else {
            buildView.attachToProcess((ProcessHandler)new MavenHandlerFilterSpyWrapper(processHandler));
        }
        AnAction[] actions = new AnAction[]{BuildTreeFilters.createFilteringActionsGroup((Filterable)buildView)};
        DefaultExecutionResult res = new DefaultExecutionResult((ExecutionConsole)buildView, processHandler, actions);
        ArrayList<Object> restartActions = new ArrayList<Object>();
        restartActions.add(new JvmToggleAutoTestAction());
        if (MavenResumeAction.isApplicable(this.getEnvironment().getProject(), this.getJavaParameters(), this.myConfiguration)) {
            MavenResumeAction resumeAction = new MavenResumeAction(res.getProcessHandler(), runner, this.getEnvironment(), eventProcessor.getParsingContext());
            restartActions.add((Object)resumeAction);
        }
        res.setRestartActions(restartActions.toArray(AnAction.EMPTY_ARRAY));
        return res;
    }

    @NotNull
    private Function<MavenParsingContext, StartBuildEvent> getStartBuildEventSupplier(@NotNull ProgramRunner runner, ProcessHandler processHandler, StartBuildEventImpl startBuildEvent, boolean withResumeAction) {
        if (runner == null) {
            MavenCommandLineState.$$$reportNull$$$0(14);
        }
        Function<MavenParsingContext, StartBuildEvent> function = ctx -> withResumeAction ? startBuildEvent.withRestartActions(new AnAction[]{new MavenRebuildAction(this.getEnvironment()), new MavenResumeAction(processHandler, runner, this.getEnvironment(), (MavenParsingContext)ctx)}) : startBuildEvent.withRestartActions(new AnAction[]{new MavenRebuildAction(this.getEnvironment())});
        if (function == null) {
            MavenCommandLineState.$$$reportNull$$$0(15);
        }
        return function;
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        TargetedCommandLineBuilder targetedCommandLineBuilder;
        String targetWorkingDirectory;
        if (executor == null) {
            MavenCommandLineState.$$$reportNull$$$0(16);
        }
        if (runner == null) {
            MavenCommandLineState.$$$reportNull$$$0(17);
        }
        this.checkMavenWrapperAndPatchJavaParams();
        OSProcessHandler processHandler = this.startProcess();
        ExecutionEnvironment environment = this.getEnvironment();
        TargetEnvironment targetEnvironment = environment.getPreparedTargetEnvironment((RunProfileState)this, TargetProgressIndicator.EMPTY);
        Function<String, String> targetFileMapper = path2 -> path2 != null && SystemInfo.isWindows && path2.charAt(0) == '/' ? path2.substring(1) : path2;
        if (!(targetEnvironment instanceof LocalTargetEnvironment)) {
            TargetEnvironmentRequest targetEnvironmentRequest = this.getTargetEnvironmentRequest();
            LanguageRuntimeType.VolumeType mavenProjectFolderVolumeType = MavenRuntimeTypeConstants.getPROJECT_FOLDER_VOLUME().getType();
            Set uploadVolumes = targetEnvironmentRequest.getUploadVolumes();
            for (TargetEnvironment.UploadRoot uploadVolume : uploadVolumes) {
                String localPath = uploadVolume.getLocalRootPath().toString();
                TargetEnvironment.TargetPath targetRootPath = uploadVolume.getTargetRootPath();
                if (!(targetRootPath instanceof TargetEnvironment.TargetPath.Temporary) || !mavenProjectFolderVolumeType.getId().equals(((TargetEnvironment.TargetPath.Temporary)targetRootPath).getHint())) continue;
                String targetPath = (String)TargetEnvironmentFunctions.getTargetUploadPath((TargetEnvironment.UploadRoot)uploadVolume).apply(targetEnvironment);
                targetFileMapper = MavenCommandLineState.createTargetFileMapper(targetEnvironment, localPath, targetPath);
                break;
            }
        }
        String workingDir = (targetWorkingDirectory = (targetedCommandLineBuilder = this.getTargetedCommandLine()).build().getWorkingDirectory()) != null ? targetFileMapper.apply(targetWorkingDirectory) : this.getEnvironment().getProject().getBasePath();
        ExternalSystemTaskId taskId = ExternalSystemTaskId.create((ProjectSystemId)MavenUtil.SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)this.myConfiguration.getProject());
        DefaultBuildDescriptor descriptor2 = new DefaultBuildDescriptor((Object)taskId, this.myConfiguration.getName(), workingDir, System.currentTimeMillis());
        if (MavenRunConfigurationType.isDelegate(this.getEnvironment())) {
            ExecutionResult executionResult = this.doDelegateBuildExecute(executor, runner, taskId, descriptor2, (ProcessHandler)processHandler, targetFileMapper);
            if (executionResult == null) {
                MavenCommandLineState.$$$reportNull$$$0(18);
            }
            return executionResult;
        }
        ExecutionResult executionResult = this.doRunExecute(executor, runner, taskId, descriptor2, (ProcessHandler)processHandler, targetFileMapper);
        if (executionResult == null) {
            MavenCommandLineState.$$$reportNull$$$0(19);
        }
        return executionResult;
    }

    @Nullable
    private BuildView createBuildView(@NotNull Executor executor, @NotNull BuildDescriptor descriptor2, @NotNull ProcessHandler processHandler) throws ExecutionException {
        ConsoleView console;
        if (executor == null) {
            MavenCommandLineState.$$$reportNull$$$0(20);
        }
        if (descriptor2 == null) {
            MavenCommandLineState.$$$reportNull$$$0(21);
        }
        if (processHandler == null) {
            MavenCommandLineState.$$$reportNull$$$0(22);
        }
        if ((console = this.createConsole(executor, processHandler, this.myConfiguration.getProject())) == null) {
            return null;
        }
        Project project = this.myConfiguration.getProject();
        final ExternalSystemRunConfigurationViewManager viewManager = (ExternalSystemRunConfigurationViewManager)project.getService(ExternalSystemRunConfigurationViewManager.class);
        return new BuildView(project, (ExecutionConsole)console, descriptor2, "build.toolwindow.run.selection.state", (ViewManager)viewManager){

            public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
                if (buildId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.onEvent(buildId, event);
                viewManager.onEvent(buildId, event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "buildId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/maven/execution/run/MavenCommandLineState$1";
                objectArray[2] = "onEvent";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void checkMavenWrapperAndPatchJavaParams() {
        String workingDirPath;
        if (this.myConfiguration.getGeneralSettings() == null || !MavenUtil.isWrapper(this.myConfiguration.getGeneralSettings())) {
            return;
        }
        MavenDistributionsCache instance = MavenDistributionsCache.getInstance(this.myConfiguration.getProject());
        MavenDistribution wrapper = instance.getWrapper(workingDirPath = this.myConfiguration.getRunnerParameters().getWorkingDirPath());
        if (wrapper == null) {
            MavenWrapperDownloader.checkOrInstall(this.myConfiguration.getProject(), workingDirPath);
        }
        if ((wrapper = instance.getWrapper(workingDirPath)) == null) {
            return;
        }
        try {
            JavaParameters javaParameters = this.getJavaParameters();
            if (javaParameters == null || !javaParameters.getVMParametersList().hasProperty("maven.home")) {
                return;
            }
            String mavenHomePath = wrapper.getMavenHome().toFile().getCanonicalPath();
            ParametersList vmParametersList = javaParameters.getVMParametersList();
            if (Objects.equals(vmParametersList.getPropertyValue("maven.home"), wrapper.getMavenHome().toString())) {
                return;
            }
            vmParametersList.addProperty("maven.home", mavenHomePath);
        }
        catch (ExecutionException | IOException e) {
            MavenLog.LOG.error(e);
        }
    }

    @NotNull
    protected TargetedCommandLineBuilder createTargetedCommandLine(@NotNull TargetEnvironmentRequest request) throws ExecutionException {
        if (request == null) {
            MavenCommandLineState.$$$reportNull$$$0(23);
        }
        if (request instanceof LocalTargetEnvironmentRequest) {
            TargetedCommandLineBuilder commandLineBuilder = super.createTargetedCommandLine(request);
            if (this.emulateTerminal()) {
                commandLineBuilder.setPtyOptions(MavenCommandLineState.getLocalTargetPtyOptions());
            }
            TargetedCommandLineBuilder targetedCommandLineBuilder = commandLineBuilder;
            if (targetedCommandLineBuilder == null) {
                MavenCommandLineState.$$$reportNull$$$0(24);
            }
            return targetedCommandLineBuilder;
        }
        if (request.getConfiguration() == null) {
            throw new CantRunException(RunnerBundle.message("cannot.find.target.environment.configuration", new Object[0]));
        }
        MavenRunConfiguration.MavenSettings settings = new MavenRunConfiguration.MavenSettings(this.myConfiguration.getProject());
        settings.setRunnerParameters(this.myConfiguration.getRunnerParameters());
        settings.setGeneralSettings(this.myConfiguration.getGeneralSettings());
        settings.setRunnerSettings(this.myConfiguration.getRunnerSettings());
        TargetedCommandLineBuilder targetedCommandLineBuilder = new MavenCommandLineSetup(this.myConfiguration.getProject(), this.myConfiguration.getName(), request).setupCommandLine(settings).getCommandLine();
        if (targetedCommandLineBuilder == null) {
            MavenCommandLineState.$$$reportNull$$$0(25);
        }
        return targetedCommandLineBuilder;
    }

    @NotNull
    private static PtyOptions getLocalTargetPtyOptions() {
        return new PtyOptions(){

            public int getInitialColumns() {
                return LocalPtyOptions.defaults().getInitialColumns();
            }

            public int getInitialRows() {
                return LocalPtyOptions.defaults().getInitialRows();
            }
        };
    }

    public void handleCreatedTargetEnvironment(@NotNull TargetEnvironment environment, @NotNull TargetProgressIndicator targetProgressIndicator) {
        if (environment == null) {
            MavenCommandLineState.$$$reportNull$$$0(26);
        }
        if (targetProgressIndicator == null) {
            MavenCommandLineState.$$$reportNull$$$0(27);
        }
        if (environment instanceof LocalTargetEnvironment) {
            super.handleCreatedTargetEnvironment(environment, targetProgressIndicator);
        } else {
            TargetedCommandLineBuilder targetedCommandLineBuilder = this.getTargetedCommandLine();
            Objects.requireNonNull((MavenCommandLineSetup)targetedCommandLineBuilder.getUserData(MavenCommandLineSetup.getSetupKey())).provideEnvironment(environment, targetProgressIndicator);
        }
    }

    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        ExecutionEnvironment environment = this.getEnvironment();
        TargetEnvironment remoteEnvironment = environment.getPreparedTargetEnvironment((RunProfileState)this, TargetProgressIndicator.EMPTY);
        TargetedCommandLineBuilder targetedCommandLineBuilder = this.getTargetedCommandLine();
        TargetedCommandLine targetedCommandLine = targetedCommandLineBuilder.build();
        Process process2 = remoteEnvironment.createProcess(targetedCommandLine, (ProgressIndicator)new EmptyProgressIndicator());
        OSProcessHandler handler2 = this.createProcessHandler(remoteEnvironment, targetedCommandLineBuilder, targetedCommandLine, process2);
        ProcessTerminatedListener.attach((ProcessHandler)handler2);
        JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.myConfiguration, (ProcessHandler)handler2, this.getRunnerSettings());
        OSProcessHandler oSProcessHandler = handler2;
        if (oSProcessHandler == null) {
            MavenCommandLineState.$$$reportNull$$$0(28);
        }
        return oSProcessHandler;
    }

    @NotNull
    protected OSProcessHandler createProcessHandler(TargetEnvironment remoteEnvironment, TargetedCommandLineBuilder targetedCommandLineBuilder, TargetedCommandLine targetedCommandLine, Process process2) throws ExecutionException {
        if (this.emulateTerminal()) {
            return new MavenKillableProcessHandler(process2, targetedCommandLine.getCommandPresentation(remoteEnvironment), targetedCommandLine.getCharset(), targetedCommandLineBuilder.getFilesToDeleteOnTermination());
        }
        return new KillableColoredProcessHandler.Silent(process2, targetedCommandLine.getCommandPresentation(remoteEnvironment), targetedCommandLine.getCharset(), targetedCommandLineBuilder.getFilesToDeleteOnTermination());
    }

    public RemoteConnectionCreator getRemoteConnectionCreator() {
        if (this.myRemoteConnectionCreator == null) {
            try {
                this.myRemoteConnectionCreator = this.myConfiguration.createRemoteConnectionCreator(this.getJavaParameters());
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Cannot create java parameters", e);
            }
        }
        return this.myRemoteConnectionCreator;
    }

    @Nullable
    public RemoteConnection createRemoteConnection(ExecutionEnvironment environment) {
        return this.getRemoteConnectionCreator().createRemoteConnection(environment);
    }

    public boolean isPollConnection() {
        return this.getRemoteConnectionCreator().isPollConnection();
    }

    @NotNull
    private static Function<String, String> createTargetFileMapper(@NotNull TargetEnvironment targetEnvironment, @NotNull String projectRootlocalPath, @NotNull String projectRootTargetPath) {
        if (targetEnvironment == null) {
            MavenCommandLineState.$$$reportNull$$$0(29);
        }
        if (projectRootlocalPath == null) {
            MavenCommandLineState.$$$reportNull$$$0(30);
        }
        if (projectRootTargetPath == null) {
            MavenCommandLineState.$$$reportNull$$$0(31);
        }
        Function<String, String> function = path2 -> {
            if (path2 == null) {
                return null;
            }
            boolean isWindows = targetEnvironment.getTargetPlatform().getPlatform() == Platform.WINDOWS;
            String string = path2 = isWindows && path2.charAt(0) == '/' ? path2.substring(1) : path2;
            if (path2.startsWith(projectRootTargetPath)) {
                return Paths.get(projectRootlocalPath, StringUtil.trimStart((String)path2, (String)projectRootTargetPath)).toString();
            }
            if (path2.startsWith("/private" + projectRootTargetPath)) {
                return Paths.get(projectRootlocalPath, StringUtil.trimStart((String)path2, (String)("/private" + projectRootTargetPath))).toString();
            }
            return path2;
        };
        if (function == null) {
            MavenCommandLineState.$$$reportNull$$$0(32);
        }
        return function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 18, 19, 24, 25, 28, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: 
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFileMapper";
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/run/MavenCommandLineState";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProgressIndicator";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironment";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootlocalPath";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootTargetPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/run/MavenCommandLineState";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartBuildEventSupplier";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetedCommandLine";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetFileMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleView";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doDelegateBuildExecute";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doRunExecute";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStartBuildEventSupplier";
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 28: 
            case 32: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createBuildView";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createTargetedCommandLine";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "handleCreatedTargetEnvironment";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createTargetFileMapper";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 18, 19, 24, 25, 28, 32 -> new IllegalStateException(string);
        };
    }
}

