/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.externalSystemIntegration.output.LogMessageType;

public interface MavenLogEntryReader {
    public void pushBack();

    @Nullable
    public MavenLogEntry readLine();

    default public List<MavenLogEntry> readWhile(Predicate<MavenLogEntry> logEntryPredicate) {
        MavenLogEntry next;
        SmartList result2 = new SmartList();
        while ((next = this.readLine()) != null) {
            if (logEntryPredicate.test(next)) {
                result2.add(next);
                continue;
            }
            this.pushBack();
            break;
        }
        return result2;
    }

    default public MavenLogEntry findFirst(Predicate<MavenLogEntry> logEntryPredicate) {
        MavenLogEntry result2;
        while ((result2 = this.readLine()) != null) {
            if (!logEntryPredicate.test(result2)) continue;
            return result2;
        }
        return null;
    }

    @ApiStatus.Internal
    public static final class MavenLogEntry {
        @Nullable
        public final LogMessageType myType;
        @NotNull
        public final String myLine;

        @TestOnly
        public MavenLogEntry(@NotNull String line, LogMessageType type) {
            if (line == null) {
                MavenLogEntry.$$$reportNull$$$0(0);
            }
            this.myLine = line;
            this.myType = type;
        }

        public MavenLogEntry(@NotNull String line) {
            if (line == null) {
                MavenLogEntry.$$$reportNull$$$0(1);
            }
            line = MavenLogEntry.clearProgressCarriageReturns(line);
            this.myType = LogMessageType.determine(line);
            this.myLine = MavenLogEntry.clearLine(this.myType, line);
        }

        @NotNull
        private static String clearProgressCarriageReturns(@NotNull String line) {
            int i2;
            if (line == null) {
                MavenLogEntry.$$$reportNull$$$0(2);
            }
            if ((i2 = line.lastIndexOf("\r")) == -1) {
                String string = line;
                if (string == null) {
                    MavenLogEntry.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = line.substring(i2 + 1);
            if (string == null) {
                MavenLogEntry.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        private static String clearLine(@Nullable LogMessageType type, @NotNull String line) {
            if (line == null) {
                MavenLogEntry.$$$reportNull$$$0(5);
            }
            String string = type == null ? line : type.clearLine(line);
            if (string == null) {
                MavenLogEntry.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Nullable
        public LogMessageType getType() {
            return this.myType;
        }

        @NotNull
        @NlsSafe
        public String getLine() {
            String string = this.myLine;
            if (string == null) {
                MavenLogEntry.$$$reportNull$$$0(7);
            }
            return string;
        }

        public String toString() {
            return this.myType == null ? this.myLine : "[" + this.myType + "] " + this.myLine;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MavenLogEntry entry = (MavenLogEntry)o;
            return this.myType == entry.myType && this.myLine.equals(entry.myLine);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.myType, this.myLine});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/externalSystemIntegration/output/MavenLogEntryReader$MavenLogEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/externalSystemIntegration/output/MavenLogEntryReader$MavenLogEntry";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clearProgressCarriageReturns";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clearLine";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "clearProgressCarriageReturns";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "clearLine";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

