/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.util.Consumer;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\u000b\u0010\u0006\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0007J0\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenAnnotationProcessorConfiguratorUtil;", "", "<init>", "()V", "getModuleProfileName", "", "moduleName", "Lcom/intellij/openapi/util/NlsSafe;", "getProcessorVersion", "groupId", "artifactId", "version", "project", "Lorg/jetbrains/idea/maven/project/MavenProject;", "getProcessorArtifactInfos", "", "Lorg/jetbrains/idea/maven/model/MavenArtifactInfo;", "config", "Lorg/jdom/Element;", "mavenProject", "intellij.maven"})
@ApiStatus.Internal
public final class MavenAnnotationProcessorConfiguratorUtil {
    @NotNull
    public static final MavenAnnotationProcessorConfiguratorUtil INSTANCE = new MavenAnnotationProcessorConfiguratorUtil();

    private MavenAnnotationProcessorConfiguratorUtil() {
    }

    @NotNull
    public final String getModuleProfileName(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return "Annotation profile for " + moduleName;
    }

    private final String getProcessorVersion(String groupId, String artifactId, String version, MavenProject project) {
        String string = version;
        if (string != null) {
            return string;
        }
        Object object = MavenProject.findPlugin$default(project, "org.apache.maven.plugins", "maven-compiler-plugin", false, 4, null);
        if (object == null || (object = object.getVersion()) == null) {
            return null;
        }
        Object pluginVersion = object;
        if (VersionComparatorUtil.compare((String)pluginVersion, (String)"3.12.0") >= 0 && groupId != null && artifactId != null) {
            MavenId mavenId = project.findManagedDependency(groupId, artifactId);
            return mavenId != null ? mavenId.getVersion() : null;
        }
        return null;
    }

    @NotNull
    public final List<MavenArtifactInfo> getProcessorArtifactInfos(@NotNull Element config, @NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        List artifacts = new ArrayList();
        Consumer addToArtifacts = arg_0 -> MavenAnnotationProcessorConfiguratorUtil.getProcessorArtifactInfos$lambda$0(mavenProject, artifacts, arg_0);
        for (Element path2 : config.getChildren("path")) {
            addToArtifacts.consume((Object)path2);
        }
        for (Element dependency : config.getChildren("dependency")) {
            addToArtifacts.consume((Object)dependency);
        }
        for (Element annotationProcessorPath : config.getChildren("annotationProcessorPath")) {
            addToArtifacts.consume((Object)annotationProcessorPath);
        }
        return artifacts;
    }

    private static final void getProcessorArtifactInfos$lambda$0(MavenProject $mavenProject, List $artifacts, Element path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String groupId = path2.getChildTextTrim("groupId");
        String artifactId = path2.getChildTextTrim("artifactId");
        String version = path2.getChildTextTrim("version");
        String resolvedVersion = INSTANCE.getProcessorVersion(groupId, artifactId, version, $mavenProject);
        String classifier = path2.getChildTextTrim("classifier");
        $artifacts.add(new MavenArtifactInfo(groupId, artifactId, resolvedVersion, "jar", classifier));
    }
}

