/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.MavenDisposable;
import org.jetbrains.idea.maven.importing.MavenApplicableConfigurator;
import org.jetbrains.idea.maven.importing.MavenCompilerConfigurationRawData;
import org.jetbrains.idea.maven.importing.MavenCompilerConfiguratorKt;
import org.jetbrains.idea.maven.importing.MavenCompilerExtension;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.importing.StandardMavenModuleType;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.jps.model.java.compiler.CompilerOptions;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001:B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\"\u0010\u0017\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0002J0\u0010\u001b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0002J*\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%H\u0002J4\u0010&\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\b\u0010'\u001a\u0004\u0018\u00010!2\u0006\u0010\u0018\u001a\u00020(2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0002J \u0010)\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020(H\u0002J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u000fH\u0002J\u0010\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020\u0016H\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020\u0016H\u0002J\u0014\u00102\u001a\u0004\u0018\u00010\u00162\b\u0010-\u001a\u0004\u0018\u00010\u0016H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u00162\u0006\u00103\u001a\u00020\u000fH\u0002J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u0016052\u0006\u00106\u001a\u00020#H\u0002J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u0016052\u0006\u00107\u001a\u00020\u000fH\u0002J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u0016052\u0006\u00107\u001a\u00020\u000fH\u0002J\u0010\u00109\u001a\u00020%2\u0006\u0010 \u001a\u00020!H\u0002\u00a8\u0006;"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenCompilerConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenApplicableConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;", "<init>", "()V", "beforeModelApplied", "", "context", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$MutableModelContext;", "afterModelApplied", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$AppliedModelContext;", "removeOutdatedCompilerConfigSettings", "project", "Lcom/intellij/openapi/project/Project;", "getCompilerConfigurationWhenApplicable", "Lorg/jdom/Element;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "selectDefaultCompilerExtension", "Lorg/jetbrains/idea/maven/importing/MavenCompilerExtension;", "allCompilers", "", "", "setDefaultProjectCompiler", "ideCompilerConfiguration", "Lcom/intellij/compiler/CompilerConfigurationImpl;", "defaultCompilerExtension", "configureModules", "mavenProjectWithModule", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/idea/maven/importing/MavenCompilerConfigurator$MavenProjectWithModulesData;", "applyCompilerExtensionConfiguration", "module", "Lcom/intellij/openapi/module/Module;", "collectRawMavenData", "Lorg/jetbrains/idea/maven/importing/MavenCompilerConfigurationRawData;", "forTests", "", "configureTargetLevel", "compoundModule", "Lcom/intellij/compiler/CompilerConfiguration;", "excludeArchetypeResources", "getCompilerId", "config", "hasUnresolvedProperty", "txt", "findClosingBraceOrNextUnresolvedProperty", "", "index", "s", "getResolvedText", "it", "collectCompilerArgs", "", "configData", "element", "collectTestCompilerArgs", "isTestModule", "MavenProjectWithModulesData", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenCompilerConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenCompilerConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenCompilerConfigurator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,375:1\n1148#2:376\n1317#2:377\n1318#2:380\n1149#2:381\n1317#2:382\n1318#2:387\n1#3:378\n1#3:379\n295#4,2:383\n1863#4,2:385\n1187#4,2:388\n1261#4,4:390\n1863#4,2:394\n1187#4,2:396\n1261#4,4:398\n1557#4:402\n1628#4,3:403\n*S KotlinDebug\n*F\n+ 1 MavenCompilerConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenCompilerConfigurator\n*L\n50#1:376\n50#1:377\n50#1:380\n50#1:381\n117#1:382\n117#1:387\n50#1:379\n118#1:383,2\n119#1:385,2\n291#1:388,2\n291#1:390,4\n309#1:394,2\n328#1:396,2\n328#1:398,4\n66#1:402\n66#1:403,3\n*E\n"})
public final class MavenCompilerConfigurator
extends MavenApplicableConfigurator
implements MavenWorkspaceConfigurator {
    public MavenCompilerConfigurator() {
        super("org.apache.maven.plugins", "maven-compiler-plugin");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void beforeModelApplied(@NotNull MavenWorkspaceConfigurator.MutableModelContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        MavenCompilerExtension defaultCompilerExtension = (MavenCompilerExtension)context2.getProject().getUserData(MavenCompilerConfiguratorKt.getDEFAULT_COMPILER_EXTENSION());
        context2.putUserData(MavenCompilerConfiguratorKt.getDEFAULT_COMPILER_EXTENSION(), null);
        if (defaultCompilerExtension == null) {
            void destination$iv;
            void $this$mapNotNullTo$iv;
            Sequence sequence = context2.getMavenProjectsWithModules();
            Collection collection = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                MavenWorkspaceConfigurator.MavenProjectWithModules it = (MavenWorkspaceConfigurator.MavenProjectWithModules)element$iv;
                boolean bl2 = false;
                if (this.getCompilerConfigurationWhenApplicable(context2.getProject(), it.getMavenProject()) != null) {
                    Element config;
                    boolean bl3 = false;
                    string = this.getCompilerId(config);
                } else {
                    string = null;
                }
                if (string == null) continue;
                String it$iv = string;
                boolean bl4 = false;
                destination$iv.add(it$iv);
            }
            Set allCompilers = (Set)destination$iv;
            defaultCompilerExtension = this.selectDefaultCompilerExtension(allCompilers);
        }
        context2.putUserData(MavenCompilerConfiguratorKt.getDEFAULT_COMPILER_EXTENSION(), defaultCompilerExtension);
    }

    @Override
    public void afterModelApplied(@NotNull MavenWorkspaceConfigurator.AppliedModelContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        MavenCompilerExtension defaultCompilerExtension = (MavenCompilerExtension)context2.getUserData(MavenCompilerConfiguratorKt.getDEFAULT_COMPILER_EXTENSION());
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)context2.getProject());
        Intrinsics.checkNotNull((Object)compilerConfiguration, (String)"null cannot be cast to non-null type com.intellij.compiler.CompilerConfigurationImpl");
        CompilerConfigurationImpl ideCompilerConfiguration = (CompilerConfigurationImpl)compilerConfiguration;
        this.setDefaultProjectCompiler(context2.getProject(), ideCompilerConfiguration, defaultCompilerExtension);
        Sequence data = SequencesKt.map(context2.getMavenProjectsWithModules(), MavenCompilerConfigurator::afterModelApplied$lambda$3);
        this.configureModules(context2.getProject(), (Sequence<MavenProjectWithModulesData>)data, ideCompilerConfiguration, defaultCompilerExtension);
        this.removeOutdatedCompilerConfigSettings(context2.getProject());
    }

    private final void removeOutdatedCompilerConfigSettings(Project project) {
        String options;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        JpsJavaCompilerOptions javacOptions = JavacConfiguration.getOptions((Project)project, JavacConfiguration.class);
        CharSequence charSequence = options = javacOptions.ADDITIONAL_OPTIONS_STRING;
        Intrinsics.checkNotNull((Object)charSequence);
        charSequence = charSequence;
        Regex regex = new Regex("(-target (\\S+))");
        String string = "";
        javacOptions.ADDITIONAL_OPTIONS_STRING = options = regex.replaceFirst(charSequence, string);
    }

    private final Element getCompilerConfigurationWhenApplicable(Project project, MavenProject mavenProject) {
        if (!Registry.Companion.is("maven.import.compiler.arguments", true) || !MavenProjectsManager.getInstance(project).getImportingSettings().isAutoDetectCompiler()) {
            return null;
        }
        if (!super.isApplicable(mavenProject)) {
            return null;
        }
        return this.getConfig(mavenProject);
    }

    private final MavenCompilerExtension selectDefaultCompilerExtension(Set<String> allCompilers) {
        Object object;
        block2: {
            String string = (String)CollectionsKt.singleOrNull((Iterable)allCompilers);
            if (string == null) {
                string = "javac";
            }
            String defaultCompilerId = string;
            for (Object object2 : MavenCompilerExtension.Companion.getEP_NAME().getExtensions()) {
                MavenCompilerExtension it = (MavenCompilerExtension)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)defaultCompilerId, (Object)it.getMavenCompilerId())) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        return (MavenCompilerExtension)object;
    }

    private final void setDefaultProjectCompiler(Project project, CompilerConfigurationImpl ideCompilerConfiguration, MavenCompilerExtension defaultCompilerExtension) {
        MavenCompilerExtension mavenCompilerExtension = defaultCompilerExtension;
        if (mavenCompilerExtension == null || (mavenCompilerExtension = mavenCompilerExtension.getCompiler(project)) == null) {
            return;
        }
        MavenCompilerExtension backendCompiler = mavenCompilerExtension;
        boolean autoDetectCompiler = MavenProjectsManager.getInstance(project).getImportingSettings().isAutoDetectCompiler();
        Object[] objectArray = new Object[]{autoDetectCompiler};
        MavenLog.LOG.debug("maven compiler autodetect = ", objectArray);
        if (!Intrinsics.areEqual((Object)ideCompilerConfiguration.getDefaultCompiler(), (Object)backendCompiler) && autoDetectCompiler) {
            if (ideCompilerConfiguration.getRegisteredJavaCompilers().contains(backendCompiler)) {
                ideCompilerConfiguration.setDefaultCompiler((BackendCompiler)backendCompiler);
            } else {
                MavenCompilerConfiguratorKt.access$getLOG$p().error((BackendCompiler)backendCompiler + " is not registered.");
            }
        }
    }

    private final void configureModules(Project project, Sequence<MavenProjectWithModulesData> mavenProjectWithModule, CompilerConfigurationImpl ideCompilerConfiguration, MavenCompilerExtension defaultCompilerExtension) {
        Sequence<MavenProjectWithModulesData> $this$forEach$iv = mavenProjectWithModule;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            List<Module> modules;
            MavenProject mavenProject;
            block3: {
                MavenProjectWithModulesData mavenProjectWithModulesData = (MavenProjectWithModulesData)element$iv;
                boolean bl = false;
                mavenProject = mavenProjectWithModulesData.component1();
                modules = mavenProjectWithModulesData.component2();
                Iterable $this$firstOrNull$iv = modules;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    Module it = (Module)element$iv2;
                    boolean bl2 = false;
                    if (!(MavenImportUtil.INSTANCE.getMavenModuleType$intellij_maven(it) == StandardMavenModuleType.COMPOUND_MODULE)) continue;
                    v0 = element$iv2;
                    break block3;
                }
                v0 = null;
            }
            Module compoundModule = v0;
            Iterable $this$forEach$iv2 = modules;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Module module = (Module)element$iv2;
                boolean bl = false;
                this.applyCompilerExtensionConfiguration(mavenProject, module, ideCompilerConfiguration, defaultCompilerExtension);
                this.configureTargetLevel(mavenProject, module, compoundModule, (CompilerConfiguration)ideCompilerConfiguration, defaultCompilerExtension);
            }
            this.excludeArchetypeResources(project, mavenProject, (CompilerConfiguration)ideCompilerConfiguration);
        }
    }

    private final void applyCompilerExtensionConfiguration(MavenProject mavenProject, Module module, CompilerConfigurationImpl ideCompilerConfiguration, MavenCompilerExtension defaultCompilerExtension) {
        String string;
        boolean isTestModule = this.isTestModule(module);
        MavenCompilerConfigurationRawData mavenConfiguration = this.collectRawMavenData(mavenProject, isTestModule);
        if (Intrinsics.areEqual((Object)mavenProject.getPackaging(), (Object)"pom")) {
            string = null;
        } else {
            Element element = mavenConfiguration.getEffectiveConfiguration();
            if (element != null) {
                Element it = element;
                boolean bl = false;
                string = this.getCompilerId(it);
            } else {
                string = null;
            }
        }
        String projectCompilerId = string;
        for (MavenCompilerExtension compilerExtension : (MavenCompilerExtension[])MavenCompilerExtension.Companion.getEP_NAME().getExtensions()) {
            JpsJavaCompilerOptions it;
            CompilerOptions compilerOptions;
            boolean applyThisExtension = Intrinsics.areEqual((Object)projectCompilerId, (Object)compilerExtension.getMavenCompilerId()) || projectCompilerId == null && Intrinsics.areEqual((Object)compilerExtension, (Object)defaultCompilerExtension);
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            BackendCompiler backendCompiler = compilerExtension.getCompiler(project);
            Object object = compilerOptions = backendCompiler != null ? backendCompiler.getOptions() : null;
            if (applyThisExtension && !mavenConfiguration.isEmpty()) {
                compilerExtension.configureOptions(compilerOptions, module, mavenProject, this.collectCompilerArgs(mavenConfiguration));
                continue;
            }
            if ((compilerOptions instanceof JpsJavaCompilerOptions ? (JpsJavaCompilerOptions)compilerOptions : null) == null) continue;
            it = it;
            boolean bl = false;
            ideCompilerConfiguration.setAdditionalOptions(it, module, CollectionsKt.emptyList());
        }
    }

    private final MavenCompilerConfigurationRawData collectRawMavenData(MavenProject mavenProject, boolean forTests) {
        List<Element> list;
        Element pluginConfig = this.getConfig(mavenProject);
        Object propertyConfig = mavenProject.getProperties().get("maven.compiler.parameters");
        if (forTests) {
            MavenPlugin mavenPlugin = MavenProject.findPlugin$default(mavenProject, "org.apache.maven.plugins", "maven-compiler-plugin", false, 4, null);
            list = mavenPlugin != null ? MavenImportUtil.INSTANCE.getTestCompileExecutionConfigurations$intellij_maven(mavenPlugin) : null;
        } else {
            MavenPlugin mavenPlugin = MavenProject.findPlugin$default(mavenProject, "org.apache.maven.plugins", "maven-compiler-plugin", false, 4, null);
            list = mavenPlugin != null ? MavenImportUtil.INSTANCE.getCompileExecutionConfigurations$intellij_maven(mavenPlugin) : null;
        }
        List<Element> list2 = list;
        Element executionConfig = list2 != null ? (Element)CollectionsKt.firstOrNull(list2) : null;
        Object object = propertyConfig;
        return new MavenCompilerConfigurationRawData(forTests, object != null ? object.toString() : null, pluginConfig, executionConfig);
    }

    private final void configureTargetLevel(MavenProject mavenProject, Module module, Module compoundModule, CompilerConfiguration ideCompilerConfiguration, MavenCompilerExtension defaultCompilerExtension) {
        MavenCompilerExtension mavenCompilerExtension = defaultCompilerExtension;
        String targetLevel = mavenCompilerExtension != null ? mavenCompilerExtension.getDefaultCompilerTargetLevel(mavenProject, module) : null;
        String string = module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String moduleName = string;
        MavenCompilerExtension mavenCompilerExtension2 = defaultCompilerExtension;
        MavenLog.LOG.debug("Bytecode target level " + targetLevel + " in module " + moduleName + ", compiler extension = " + (mavenCompilerExtension2 != null ? mavenCompilerExtension2.getMavenCompilerId() : null));
        if (targetLevel == null) {
            LanguageLevel level = null;
            StandardMavenModuleType type = MavenImportUtil.INSTANCE.getMavenModuleType$intellij_maven(module);
            if (type == StandardMavenModuleType.TEST_ONLY) {
                level = MavenImportUtil.INSTANCE.getTestTargetLanguageLevel$intellij_maven(mavenProject);
            } else if (type == StandardMavenModuleType.MAIN_ONLY_ADDITIONAL) {
                if (compoundModule != null) {
                    String string2 = moduleName.substring(compoundModule.getName().length() + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    String moduleSuffix = string2;
                    String executionId = MavenImportUtil.INSTANCE.unescapeCompileSourceRootModuleSuffix$intellij_maven(moduleSuffix);
                    level = MavenImportUtil.INSTANCE.getTargetLanguageLevel$intellij_maven(mavenProject, executionId);
                }
            } else {
                level = MavenImportUtil.INSTANCE.getTargetLanguageLevel$intellij_maven(mavenProject);
            }
            if (level == null) {
                level = MavenImportUtil.INSTANCE.getDefaultLevel$intellij_maven(mavenProject);
            }
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            level = MavenImportUtil.adjustLevelAndNotify(project, level);
            targetLevel = level.toJavaVersion().toString();
        }
        MavenLog.LOG.debug("Setting bytecode target level " + targetLevel + " in module " + moduleName);
        ideCompilerConfiguration.setBytecodeTargetLevel(module, targetLevel);
    }

    private final void excludeArchetypeResources(Project project, MavenProject mavenProject, CompilerConfiguration ideCompilerConfiguration) {
        Object object;
        Object object2 = this;
        try {
            MavenCompilerConfigurator $this$excludeArchetypeResources_u24lambda_u2410 = object2;
            boolean bl = false;
            String[] stringArray = new String[]{"src", "main", "resources", "archetype-resources"};
            object = Result.constructor-impl((Object)VfsUtil.findRelativeFile((VirtualFile)mavenProject.getDirectoryFile(), (String[])stringArray));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        VirtualFile dir = (VirtualFile)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (dir != null && !ideCompilerConfiguration.isExcludedFromCompilation(dir)) {
            ExcludesConfiguration cfg = ideCompilerConfiguration.getExcludedEntriesConfiguration();
            cfg.addExcludeEntryDescription(new ExcludeEntryDescription(dir, true, false, (Disposable)MavenDisposable.getInstance(project)));
        }
    }

    private final String getCompilerId(Element config) {
        String compilerId = config.getChildTextTrim("compilerId");
        CharSequence charSequence = compilerId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)"javac", (Object)compilerId) || this.hasUnresolvedProperty(compilerId)) {
            return "javac";
        }
        return compilerId;
    }

    private final boolean hasUnresolvedProperty(String txt) {
        int i2 = StringsKt.indexOf$default((CharSequence)txt, (String)"${", (int)0, (boolean)false, (int)6, null);
        return i2 >= 0 && this.findClosingBraceOrNextUnresolvedProperty(i2 + 1, txt) != -1;
    }

    private final int findClosingBraceOrNextUnresolvedProperty(int index, String s) {
        if (index == -1) {
            return -1;
        }
        Object[] objectArray = new String[]{"}", "${"};
        Pair pair = StringsKt.findAnyOf$default((CharSequence)s, (Collection)CollectionsKt.listOf((Object[])objectArray), (int)index, (boolean)false, (int)4, null);
        if (pair == null) {
            return -1;
        }
        Pair pair2 = pair;
        if (Intrinsics.areEqual((Object)pair2.getSecond(), (Object)"}")) {
            return ((Number)pair2.getFirst()).intValue();
        }
        int nextIndex = Intrinsics.areEqual((Object)pair2.getSecond(), (Object)"${") ? ((Number)pair2.getFirst()).intValue() + 2 : ((Number)pair2.getFirst()).intValue() + 1;
        return this.findClosingBraceOrNextUnresolvedProperty(nextIndex, s);
    }

    private final String getResolvedText(String txt) {
        String string = StringKt.nullize$default((String)txt, (boolean)false, (int)1, null);
        if (string == null) {
            return null;
        }
        String result2 = string;
        if (this.hasUnresolvedProperty(result2)) {
            return null;
        }
        return result2;
    }

    private final String getResolvedText(Element it) {
        return this.getResolvedText(it.getTextTrim());
    }

    private final List<String> collectCompilerArgs(MavenCompilerConfigurationRawData configData) {
        List result2;
        block4: {
            List<String> testData;
            String it;
            result2 = new ArrayList();
            String string = configData.getPropertyCompilerParameters();
            if (string != null) {
                it = string;
                boolean bl = false;
                if (Boolean.parseBoolean(it)) {
                    result2.add("-parameters");
                }
            }
            Element element = configData.getEffectiveConfiguration();
            if (element == null) break block4;
            it = element;
            boolean bl = false;
            Element element2 = it.getChild("parameters");
            if (element2 != null) {
                Element it2 = element2;
                boolean bl2 = false;
                boolean bl3 = Boolean.parseBoolean(it2.getTextTrim()) ? result2.add("-parameters") : result2.remove("-parameters");
            }
            if (configData.getForTests() && !((Collection)(testData = this.collectTestCompilerArgs((Element)it))).isEmpty()) {
                result2.addAll((Collection)testData);
                return CollectionsKt.toList((Iterable)result2);
            }
            result2.addAll((Collection)this.collectCompilerArgs((Element)it));
        }
        return CollectionsKt.toList((Iterable)result2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> collectCompilerArgs(Element element) {
        ArrayList<String> result2;
        block6: {
            result2 = new ArrayList<String>();
            Element element2 = element.getChild("compilerArguments");
            if (element2 != null) {
                void $this$associateTo$iv$iv;
                Element arguments = element2;
                boolean bl = false;
                Set unresolvedArgs = new LinkedHashSet();
                List list = arguments.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
                Iterable $this$associate$iv = list;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv;
                    Element it = (Element)element$iv$iv;
                    boolean bl2 = false;
                    String $this$collectCompilerArgs_u24lambda_u2419_u24lambda_u2415_u24lambda_u2414 = it.getName();
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)$this$collectCompilerArgs_u24lambda_u2419_u24lambda_u2415_u24lambda_u2414);
                    Object key = StringsKt.startsWith$default((String)$this$collectCompilerArgs_u24lambda_u2419_u24lambda_u2415_u24lambda_u2414, (String)"-", (boolean)false, (int)2, null) ? $this$collectCompilerArgs_u24lambda_u2419_u24lambda_u2415_u24lambda_u2414 : "-" + $this$collectCompilerArgs_u24lambda_u2419_u24lambda_u2415_u24lambda_u2414;
                    Intrinsics.checkNotNull((Object)it);
                    String value = this.getResolvedText(it);
                    if (value == null) {
                        String string = it.getTextTrim();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextTrim(...)");
                        if (this.hasUnresolvedProperty(string)) {
                            ((Collection)unresolvedArgs).add(key);
                        }
                    }
                    Pair pair = TuplesKt.to((Object)key, (Object)value);
                    map.put(pair.getFirst(), pair.getSecond());
                }
                Map effectiveArguments = destination$iv$iv;
                effectiveArguments.forEach((arg_0, arg_1) -> MavenCompilerConfigurator.collectCompilerArgs$lambda$19$lambda$18((arg_0, arg_1) -> MavenCompilerConfigurator.collectCompilerArgs$lambda$19$lambda$17(result2, unresolvedArgs, arg_0, arg_1), arg_0, arg_1));
            }
            Iterable $this$forEach$iv = MavenJDOMUtil.findChildrenValuesByPath(element, "compilerArgs", "arg");
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                String text = this.getResolvedText(it);
                if (text == null || this.hasUnresolvedProperty(text)) continue;
                result2.add(text);
            }
            Object object = element.getChild("compilerArgument");
            if (object == null || (object = object.getTextTrim()) == null) break block6;
            Object it = object;
            boolean bl = false;
            String text = this.getResolvedText((String)it);
            if (text != null && !this.hasUnresolvedProperty(text)) {
                result2.add(text);
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> collectTestCompilerArgs(Element element) {
        ArrayList<String> result2;
        block5: {
            Object object;
            result2 = new ArrayList<String>();
            Element element2 = element.getChild("testCompilerArguments");
            if (element2 != null) {
                void $this$associateTo$iv$iv;
                Element arguments = element2;
                boolean bl = false;
                Set unresolvedArgs = new LinkedHashSet();
                List list = arguments.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
                Iterable $this$associate$iv = list;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv;
                    Element it = (Element)element$iv$iv;
                    boolean bl2 = false;
                    String $this$collectTestCompilerArgs_u24lambda_u2427_u24lambda_u2423_u24lambda_u2422 = it.getName();
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)$this$collectTestCompilerArgs_u24lambda_u2427_u24lambda_u2423_u24lambda_u2422);
                    Object key = StringsKt.startsWith$default((String)$this$collectTestCompilerArgs_u24lambda_u2427_u24lambda_u2423_u24lambda_u2422, (String)"-", (boolean)false, (int)2, null) ? $this$collectTestCompilerArgs_u24lambda_u2427_u24lambda_u2423_u24lambda_u2422 : "-" + $this$collectTestCompilerArgs_u24lambda_u2427_u24lambda_u2423_u24lambda_u2422;
                    Intrinsics.checkNotNull((Object)it);
                    String value = this.getResolvedText(it);
                    if (value == null) {
                        String string = it.getTextTrim();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextTrim(...)");
                        if (this.hasUnresolvedProperty(string)) {
                            ((Collection)unresolvedArgs).add(key);
                        }
                    }
                    Pair pair = TuplesKt.to((Object)key, (Object)value);
                    map.put(pair.getFirst(), pair.getSecond());
                }
                Map effectiveArguments = destination$iv$iv;
                effectiveArguments.forEach((arg_0, arg_1) -> MavenCompilerConfigurator.collectTestCompilerArgs$lambda$27$lambda$26((arg_0, arg_1) -> MavenCompilerConfigurator.collectTestCompilerArgs$lambda$27$lambda$25(result2, unresolvedArgs, arg_0, arg_1), arg_0, arg_1));
            }
            if ((object = element.getChild("testCompilerArgument")) == null || (object = object.getTextTrim()) == null) break block5;
            Object it = object;
            boolean bl = false;
            String text = this.getResolvedText((String)it);
            if (text != null && !this.hasUnresolvedProperty(text)) {
                result2.add(text);
            }
        }
        return result2;
    }

    private final boolean isTestModule(Module module) {
        StandardMavenModuleType type = MavenImportUtil.INSTANCE.getMavenModuleType$intellij_maven(module);
        return type == StandardMavenModuleType.TEST_ONLY;
    }

    /*
     * WARNING - void declaration
     */
    private static final MavenProjectWithModulesData afterModelApplied$lambda$3(MavenWorkspaceConfigurator.MavenProjectWithModules it) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable iterable = it.getModules();
        MavenProject mavenProject = it.getMavenProject();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            MavenWorkspaceConfigurator.ModuleWithType moduleWithType = (MavenWorkspaceConfigurator.ModuleWithType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Module)it2.getModule());
        }
        List list = (List)destination$iv$iv;
        MavenProject mavenProject2 = mavenProject;
        return new MavenProjectWithModulesData(mavenProject2, list);
    }

    private static final Unit collectCompilerArgs$lambda$19$lambda$17(ArrayList $result, Set $unresolvedArgs, String key, String value) {
        block2: {
            block1: {
                Intrinsics.checkNotNull((Object)key);
                if (!StringsKt.startsWith$default((String)key, (String)"-A", (boolean)false, (int)2, null) || value == null) break block1;
                $result.add(key + "=" + value);
                break block2;
            }
            if ($unresolvedArgs.contains(key)) break block2;
            $result.add(key);
            String string = value;
            if (string != null) {
                String it = string;
                boolean bl = false;
                $result.add(it);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void collectCompilerArgs$lambda$19$lambda$18(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit collectTestCompilerArgs$lambda$27$lambda$25(ArrayList $result, Set $unresolvedArgs, String key, String value) {
        block2: {
            block1: {
                Intrinsics.checkNotNull((Object)key);
                if (!StringsKt.startsWith$default((String)key, (String)"-A", (boolean)false, (int)2, null) || value == null) break block1;
                $result.add(key + "=" + value);
                break block2;
            }
            if ($unresolvedArgs.contains(key)) break block2;
            $result.add(key);
            String string = value;
            if (string != null) {
                String it = string;
                boolean bl = false;
                $result.add(it);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void collectTestCompilerArgs$lambda$27$lambda$26(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenCompilerConfigurator$MavenProjectWithModulesData;", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "modules", "", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lorg/jetbrains/idea/maven/project/MavenProject;Ljava/util/List;)V", "getMavenProject", "()Lorg/jetbrains/idea/maven/project/MavenProject;", "getModules", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.maven"})
    private static final class MavenProjectWithModulesData {
        @NotNull
        private final MavenProject mavenProject;
        @NotNull
        private final List<Module> modules;

        public MavenProjectWithModulesData(@NotNull MavenProject mavenProject, @NotNull List<? extends Module> modules) {
            Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
            Intrinsics.checkNotNullParameter(modules, (String)"modules");
            this.mavenProject = mavenProject;
            this.modules = modules;
        }

        @NotNull
        public final MavenProject getMavenProject() {
            return this.mavenProject;
        }

        @NotNull
        public final List<Module> getModules() {
            return this.modules;
        }

        @NotNull
        public final MavenProject component1() {
            return this.mavenProject;
        }

        @NotNull
        public final List<Module> component2() {
            return this.modules;
        }

        @NotNull
        public final MavenProjectWithModulesData copy(@NotNull MavenProject mavenProject, @NotNull List<? extends Module> modules) {
            Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
            Intrinsics.checkNotNullParameter(modules, (String)"modules");
            return new MavenProjectWithModulesData(mavenProject, modules);
        }

        public static /* synthetic */ MavenProjectWithModulesData copy$default(MavenProjectWithModulesData mavenProjectWithModulesData, MavenProject mavenProject, List list, int n, Object object) {
            if ((n & 1) != 0) {
                mavenProject = mavenProjectWithModulesData.mavenProject;
            }
            if ((n & 2) != 0) {
                list = mavenProjectWithModulesData.modules;
            }
            return mavenProjectWithModulesData.copy(mavenProject, list);
        }

        @NotNull
        public String toString() {
            return "MavenProjectWithModulesData(mavenProject=" + this.mavenProject + ", modules=" + this.modules + ")";
        }

        public int hashCode() {
            int result2 = this.mavenProject.hashCode();
            result2 = result2 * 31 + ((Object)this.modules).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MavenProjectWithModulesData)) {
                return false;
            }
            MavenProjectWithModulesData mavenProjectWithModulesData = (MavenProjectWithModulesData)other;
            if (!Intrinsics.areEqual((Object)this.mavenProject, (Object)mavenProjectWithModulesData.mavenProject)) {
                return false;
            }
            return Intrinsics.areEqual(this.modules, mavenProjectWithModulesData.modules);
        }
    }
}

