/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.java.library.MavenCoordinates;
import com.intellij.java.library.MavenCoordinatesKt;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemCoordinateContributor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.Library;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.importing.MavenShadePluginConfiguratorKt;
import org.jetbrains.idea.maven.importing.StandardMavenModuleType;
import org.jetbrains.idea.maven.model.MavenCoordinate;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\f\u0010\n\u001a\u00020\u0005*\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\f\u0010\n\u001a\u00020\u0005*\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenCoordinateContributor;", "Lcom/intellij/openapi/externalSystem/service/project/ExternalSystemCoordinateContributor;", "<init>", "()V", "findModuleCoordinate", "Lcom/intellij/openapi/externalSystem/model/project/ProjectCoordinate;", "module", "Lcom/intellij/openapi/module/Module;", "findMavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "toProjectCoordinate", "Lorg/jetbrains/idea/maven/model/MavenCoordinate;", "findLibraryCoordinate", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "Lcom/intellij/java/library/MavenCoordinates;", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenCoordinateContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenCoordinateContributor.kt\norg/jetbrains/idea/maven/importing/MavenCoordinateContributor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class MavenCoordinateContributor
implements ExternalSystemCoordinateContributor {
    @Nullable
    public ProjectCoordinate findModuleCoordinate(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        MavenProject mavenProject = this.findMavenProject(module);
        if (mavenProject == null) {
            return null;
        }
        MavenProject mavenProject2 = mavenProject;
        ProjectCoordinate mavenProjectCoordinate = this.toProjectCoordinate((MavenCoordinate)mavenProject2.getMavenId());
        return switch (WhenMappings.$EnumSwitchMapping$0[MavenImportUtil.INSTANCE.getMavenModuleType$intellij_maven(module).ordinal()]) {
            case 1 -> mavenProjectCoordinate;
            case 2 -> mavenProjectCoordinate;
            default -> null;
        };
    }

    private final MavenProject findMavenProject(Module module) {
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project2);
        return mavenProjectsManager.findProject(module);
    }

    private final ProjectCoordinate toProjectCoordinate(MavenCoordinate $this$toProjectCoordinate) {
        return (ProjectCoordinate)new ProjectId($this$toProjectCoordinate.getGroupId(), $this$toProjectCoordinate.getArtifactId(), $this$toProjectCoordinate.getVersion());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public ProjectCoordinate findLibraryCoordinate(@NotNull Library library) {
        MavenCoordinates mavenCoordinates;
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        ProjectModelExternalSource projectModelExternalSource = library.getExternalSource();
        if (projectModelExternalSource == null) {
            return null;
        }
        ProjectModelExternalSource librarySource = projectModelExternalSource;
        if (!Intrinsics.areEqual((Object)librarySource.getId(), (Object)"Maven")) {
            return null;
        }
        String string = library.getName();
        if (string == null) {
            return null;
        }
        String libraryName = string;
        if (StringsKt.startsWith$default((String)libraryName, (String)MavenShadePluginConfiguratorKt.getSHADED_MAVEN_LIBRARY_NAME_PREFIX(), (boolean)false, (int)2, null)) {
            return null;
        }
        MavenCoordinates mavenCoordinates2 = MavenCoordinatesKt.getMavenCoordinates((Library)library);
        if (mavenCoordinates2 == null) return null;
        MavenCoordinates it = mavenCoordinates = mavenCoordinates2;
        boolean bl = false;
        if (it.getClassifier() != null) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        MavenCoordinates mavenCoordinates3 = mavenCoordinates;
        MavenCoordinates mavenCoordinates4 = mavenCoordinates3;
        if (mavenCoordinates4 == null) return null;
        ProjectCoordinate projectCoordinate = this.toProjectCoordinate(mavenCoordinates4);
        return projectCoordinate;
    }

    private final ProjectCoordinate toProjectCoordinate(MavenCoordinates $this$toProjectCoordinate) {
        return (ProjectCoordinate)new ProjectId($this$toProjectCoordinate.getGroupId(), $this$toProjectCoordinate.getArtifactId(), $this$toProjectCoordinate.getVersion());
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StandardMavenModuleType.values().length];
            try {
                nArray[StandardMavenModuleType.SINGLE_MODULE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardMavenModuleType.MAIN_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

