/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapterLegacyImpl;
import org.jetbrains.idea.maven.importing.StandardMavenModuleType;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.statistics.MavenImportCollector;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenProjectImporterUtil;", "", "<init>", "()V", "importLegacyExtensions", "", "project", "Lcom/intellij/openapi/project/Project;", "modifiableModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "extensionImporters", "", "Lorg/jetbrains/idea/maven/importing/MavenProjectImporterUtil$LegacyExtensionImporter;", "postTasks", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "activity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "selectScope", "Lcom/intellij/openapi/roots/DependencyScope;", "mavenScope", "", "LegacyExtensionImporter", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenProjectImporterUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenProjectImporterUtil.kt\norg/jetbrains/idea/maven/importing/MavenProjectImporterUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,205:1\n774#2:206\n865#2,2:207\n*S KotlinDebug\n*F\n+ 1 MavenProjectImporterUtil.kt\norg/jetbrains/idea/maven/importing/MavenProjectImporterUtil\n*L\n31#1:206\n31#1:207,2\n*E\n"})
public final class MavenProjectImporterUtil {
    @NotNull
    public static final MavenProjectImporterUtil INSTANCE = new MavenProjectImporterUtil();

    private MavenProjectImporterUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void importLegacyExtensions(@NotNull Project project, @NotNull IdeModifiableModelsProvider modifiableModelsProvider, @NotNull List<LegacyExtensionImporter> extensionImporters, @NotNull List<? extends MavenProjectsProcessorTask> postTasks, @NotNull StructuredIdeActivity activity) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
        Intrinsics.checkNotNullParameter(extensionImporters, (String)"extensionImporters");
        Intrinsics.checkNotNullParameter(postTasks, (String)"postTasks");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Iterable $this$filter$iv = extensionImporters;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LegacyExtensionImporter it = (LegacyExtensionImporter)element$iv$iv;
            boolean bl = false;
            if (!(!it.isModuleDisposed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List importers = (List)destination$iv$iv;
        if (importers.isEmpty()) {
            return;
        }
        long beforeBridgesCreation = System.nanoTime();
        IdeUIModifiableModelsProvider ideUIModifiableModelsProvider = modifiableModelsProvider instanceof IdeUIModifiableModelsProvider ? (IdeUIModifiableModelsProvider)modifiableModelsProvider : null;
        destination$iv$iv = ideUIModifiableModelsProvider != null ? (IdeModifiableModelsProvider)ideUIModifiableModelsProvider : ProjectDataManager.getInstance().createModifiableModelsProvider(project);
        Intrinsics.checkNotNull((Object)destination$iv$iv);
        Collection provider = destination$iv$iv;
        long bridgesCreationNano = System.nanoTime() - beforeBridgesCreation;
        try {
            long beforeInitInit = System.nanoTime();
            importers.forEach(arg_0 -> MavenProjectImporterUtil.importLegacyExtensions$lambda$1((IdeModifiableModelsProvider)provider, arg_0));
            bridgesCreationNano += System.nanoTime() - beforeInitInit;
            Map counters = new HashMap();
            importers.forEach(arg_0 -> MavenProjectImporterUtil.importLegacyExtensions$lambda$2(counters, arg_0));
            importers.forEach(arg_0 -> MavenProjectImporterUtil.importLegacyExtensions$lambda$3(postTasks, counters, arg_0));
            importers.forEach(arg_0 -> MavenProjectImporterUtil.importLegacyExtensions$lambda$4(counters, arg_0));
            for (Map.Entry eventPairArray2 : counters.entrySet()) {
                Class key = (Class)eventPairArray2.getKey();
                LegacyExtensionImporter.CountAndTime value = (LegacyExtensionImporter.CountAndTime)eventPairArray2.getValue();
                EventPair[] eventPairArray = new EventPair[]{MavenImportCollector.ACTIVITY_ID.with((Object)activity), MavenImportCollector.IMPORTER_CLASS.with((Object)key), MavenImportCollector.NUMBER_OF_MODULES.with((Object)value.getCount()), MavenImportCollector.TOTAL_DURATION_MS.with((Object)TimeUnit.NANOSECONDS.toMillis(value.getTimeNano()))};
                MavenImportCollector.IMPORTER_RUN.log(project, eventPairArray);
            }
        }
        catch (Throwable throwable) {
            long beforeCommit = System.nanoTime();
            MavenUtil.invokeAndWaitWriteAction(project, () -> MavenProjectImporterUtil.importLegacyExtensions$lambda$6(project, (IdeModifiableModelsProvider)provider));
            long afterCommit = System.nanoTime();
            EventPair[] eventPairArray = new EventPair[]{MavenImportCollector.ACTIVITY_ID.with((Object)activity), MavenImportCollector.DURATION_OF_LEGACY_BRIDGES_CREATION_MS.with((Object)TimeUnit.NANOSECONDS.toMillis(bridgesCreationNano)), MavenImportCollector.DURATION_OF_LEGACY_BRIDGES_COMMIT_MS.with((Object)TimeUnit.NANOSECONDS.toMillis(afterCommit - beforeCommit))};
            MavenImportCollector.LEGACY_IMPORTERS_STATS.log(project, eventPairArray);
            throw throwable;
        }
        long beforeCommit = System.nanoTime();
        MavenUtil.invokeAndWaitWriteAction(project, () -> MavenProjectImporterUtil.importLegacyExtensions$lambda$6(project, (IdeModifiableModelsProvider)provider));
        long afterCommit = System.nanoTime();
        EventPair[] eventPairArray = new EventPair[]{MavenImportCollector.ACTIVITY_ID.with((Object)activity), MavenImportCollector.DURATION_OF_LEGACY_BRIDGES_CREATION_MS.with((Object)TimeUnit.NANOSECONDS.toMillis(bridgesCreationNano)), MavenImportCollector.DURATION_OF_LEGACY_BRIDGES_COMMIT_MS.with((Object)TimeUnit.NANOSECONDS.toMillis(afterCommit - beforeCommit))};
        MavenImportCollector.LEGACY_IMPORTERS_STATS.log(project, eventPairArray);
    }

    @JvmStatic
    @NotNull
    public static final DependencyScope selectScope(@Nullable String mavenScope) {
        if (Intrinsics.areEqual((Object)"runtime", (Object)mavenScope)) {
            return DependencyScope.RUNTIME;
        }
        if (Intrinsics.areEqual((Object)"test", (Object)mavenScope)) {
            return DependencyScope.TEST;
        }
        return Intrinsics.areEqual((Object)"provided", (Object)mavenScope) ? DependencyScope.PROVIDED : DependencyScope.COMPILE;
    }

    private static final void importLegacyExtensions$lambda$1(IdeModifiableModelsProvider $provider, LegacyExtensionImporter importer) {
        Intrinsics.checkNotNullParameter((Object)importer, (String)"importer");
        importer.init($provider);
    }

    private static final void importLegacyExtensions$lambda$2(Map $counters, LegacyExtensionImporter it) {
        it.preConfig($counters);
    }

    private static final void importLegacyExtensions$lambda$3(List $postTasks, Map $counters, LegacyExtensionImporter it) {
        it.config($postTasks, $counters);
    }

    private static final void importLegacyExtensions$lambda$4(Map $counters, LegacyExtensionImporter it) {
        it.postConfig($counters);
    }

    private static final void importLegacyExtensions$lambda$6$lambda$5(IdeModifiableModelsProvider $provider) {
        $provider.commit();
    }

    private static final void importLegacyExtensions$lambda$6(Project $project, IdeModifiableModelsProvider $provider) {
        ProjectRootManagerEx.getInstanceEx((Project)$project).mergeRootsChangesDuring(() -> MavenProjectImporterUtil.importLegacyExtensions$lambda$6$lambda$5($provider));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 ,2\u00020\u0001:\u0002+,BK\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0015J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\"\u0010\u001f\u001a\u00020\u001a2\u001a\u0010 \u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\"\u0012\u0004\u0012\u00020#0!J$\u0010$\u001a\u00020\u001a2\u001a\u0010 \u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\"\u0012\u0004\u0012\u00020#0!H\u0002J0\u0010%\u001a\u00020\u001a2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\u001a\u0010 \u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\"\u0012\u0004\u0012\u00020#0!J2\u0010(\u001a\u00020\u001a2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\u001a\u0010 \u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\"\u0012\u0004\u0012\u00020#0!H\u0002J\"\u0010)\u001a\u00020\u001a2\u001a\u0010 \u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\"\u0012\u0004\u0012\u00020#0!J$\u0010*\u001a\u00020\u001a2\u001a\u0010 \u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\"\u0012\u0004\u0012\u00020#0!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018\u00a8\u0006-"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenProjectImporterUtil$LegacyExtensionImporter;", "", "myModule", "Lcom/intellij/openapi/module/Module;", "myMavenProjectsTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "myMavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "myMavenProjectChanges", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "myMavenProjectToModuleName", "", "", "myImporters", "", "Lorg/jetbrains/idea/maven/importing/MavenImporter;", "<init>", "(Lcom/intellij/openapi/module/Module;Lorg/jetbrains/idea/maven/project/MavenProjectsTree;Lorg/jetbrains/idea/maven/project/MavenProject;Lorg/jetbrains/idea/maven/project/MavenProjectChanges;Ljava/util/Map;Ljava/util/List;)V", "myRootModelAdapter", "Lorg/jetbrains/idea/maven/importing/MavenRootModelAdapter;", "myModifiableModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "isModuleDisposed", "", "()Z", "init", "", "ideModelsProvider", "doConfigurationStep", "step", "Ljava/lang/Runnable;", "preConfig", "counters", "", "Ljava/lang/Class;", "Lorg/jetbrains/idea/maven/importing/MavenProjectImporterUtil$LegacyExtensionImporter$CountAndTime;", "doPreConfig", "config", "postTasks", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "doConfig", "postConfig", "doPostConfig", "CountAndTime", "Companion", "intellij.maven"})
    public static final class LegacyExtensionImporter {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Module myModule;
        @NotNull
        private final MavenProjectsTree myMavenProjectsTree;
        @NotNull
        private final MavenProject myMavenProject;
        @NotNull
        private final MavenProjectChanges myMavenProjectChanges;
        @NotNull
        private final Map<MavenProject, String> myMavenProjectToModuleName;
        @NotNull
        private final List<MavenImporter> myImporters;
        @Nullable
        private MavenRootModelAdapter myRootModelAdapter;
        @Nullable
        private IdeModifiableModelsProvider myModifiableModelsProvider;

        private LegacyExtensionImporter(Module myModule, MavenProjectsTree myMavenProjectsTree, MavenProject myMavenProject, MavenProjectChanges myMavenProjectChanges, Map<MavenProject, String> myMavenProjectToModuleName, List<? extends MavenImporter> myImporters) {
            this.myModule = myModule;
            this.myMavenProjectsTree = myMavenProjectsTree;
            this.myMavenProject = myMavenProject;
            this.myMavenProjectChanges = myMavenProjectChanges;
            this.myMavenProjectToModuleName = myMavenProjectToModuleName;
            this.myImporters = myImporters;
        }

        public final boolean isModuleDisposed() {
            return this.myModule.isDisposed();
        }

        public final void init(@NotNull IdeModifiableModelsProvider ideModelsProvider) {
            Intrinsics.checkNotNullParameter((Object)ideModelsProvider, (String)"ideModelsProvider");
            this.myModifiableModelsProvider = ideModelsProvider;
            this.myRootModelAdapter = new MavenRootModelAdapter(new MavenRootModelAdapterLegacyImpl(this.myMavenProject, this.myModule, this.myModifiableModelsProvider));
        }

        private final void doConfigurationStep(Runnable step) {
            Project project = this.myModule.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            MavenUtil.invokeAndWaitWriteAction(project, step);
        }

        public final void preConfig(@NotNull Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            Intrinsics.checkNotNullParameter(counters, (String)"counters");
            this.doConfigurationStep(() -> LegacyExtensionImporter.preConfig$lambda$0(this, counters));
        }

        private final void doPreConfig(Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            Intrinsics.checkNotNullExpressionValue((Object)moduleType, (String)"get(...)");
            ModuleType moduleType2 = moduleType;
            for (MavenImporter importer : this.myImporters) {
                try {
                    if (importer.getModuleType() != moduleType2) continue;
                    LegacyExtensionImporter.Companion.measureImporterTime(importer, counters, true, () -> LegacyExtensionImporter.doPreConfig$lambda$1(importer, this));
                }
                catch (Exception e) {
                    MavenLog.LOG.error("Exception in MavenImporter.preConfig, skipping it.", (Throwable)e);
                }
            }
        }

        public final void config(@NotNull List<? extends MavenProjectsProcessorTask> postTasks, @NotNull Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            Intrinsics.checkNotNullParameter(postTasks, (String)"postTasks");
            Intrinsics.checkNotNullParameter(counters, (String)"counters");
            this.doConfigurationStep(() -> LegacyExtensionImporter.config$lambda$2(this, postTasks, counters));
        }

        private final void doConfig(List<? extends MavenProjectsProcessorTask> postTasks, Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            Intrinsics.checkNotNullExpressionValue((Object)moduleType, (String)"get(...)");
            ModuleType moduleType2 = moduleType;
            for (MavenImporter importer : this.myImporters) {
                if (importer.getModuleType() != moduleType2) continue;
                try {
                    LegacyExtensionImporter.Companion.measureImporterTime(importer, counters, false, () -> LegacyExtensionImporter.doConfig$lambda$3(importer, this, postTasks));
                }
                catch (Exception e) {
                    MavenLog.LOG.error("Exception in MavenImporter.config, skipping it.", (Throwable)e);
                }
            }
        }

        public final void postConfig(@NotNull Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            Intrinsics.checkNotNullParameter(counters, (String)"counters");
            this.doConfigurationStep(() -> LegacyExtensionImporter.postConfig$lambda$4(this, counters));
        }

        private final void doPostConfig(Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            Intrinsics.checkNotNullExpressionValue((Object)moduleType, (String)"get(...)");
            ModuleType moduleType2 = moduleType;
            for (MavenImporter importer : this.myImporters) {
                try {
                    if (!Intrinsics.areEqual(importer.getModuleType(), (Object)moduleType2)) continue;
                    LegacyExtensionImporter.Companion.measureImporterTime(importer, counters, false, () -> LegacyExtensionImporter.doPostConfig$lambda$5(importer, this));
                }
                catch (Exception e) {
                    MavenLog.LOG.error("Exception in MavenImporter.postConfig, skipping it.", (Throwable)e);
                }
            }
        }

        private static final void preConfig$lambda$0(LegacyExtensionImporter this$0, Map $counters) {
            this$0.doPreConfig($counters);
        }

        private static final void doPreConfig$lambda$1(MavenImporter $importer, LegacyExtensionImporter this$0) {
            $importer.preProcess(this$0.myModule, this$0.myMavenProject, this$0.myMavenProjectChanges, this$0.myModifiableModelsProvider);
        }

        private static final void config$lambda$2(LegacyExtensionImporter this$0, List $postTasks, Map $counters) {
            this$0.doConfig($postTasks, $counters);
        }

        private static final void doConfig$lambda$3(MavenImporter $importer, LegacyExtensionImporter this$0, List $postTasks) {
            IdeModifiableModelsProvider ideModifiableModelsProvider = this$0.myModifiableModelsProvider;
            Intrinsics.checkNotNull((Object)ideModifiableModelsProvider);
            Module module = this$0.myModule;
            MavenRootModelAdapter mavenRootModelAdapter = this$0.myRootModelAdapter;
            Intrinsics.checkNotNull((Object)mavenRootModelAdapter);
            $importer.process(ideModifiableModelsProvider, module, mavenRootModelAdapter, this$0.myMavenProjectsTree, this$0.myMavenProject, this$0.myMavenProjectChanges, this$0.myMavenProjectToModuleName, $postTasks);
        }

        private static final void postConfig$lambda$4(LegacyExtensionImporter this$0, Map $counters) {
            this$0.doPostConfig($counters);
        }

        private static final void doPostConfig$lambda$5(MavenImporter $importer, LegacyExtensionImporter this$0) {
            $importer.postProcess(this$0.myModule, this$0.myMavenProject, this$0.myMavenProjectChanges, this$0.myModifiableModelsProvider);
        }

        @JvmStatic
        @Nullable
        public static final LegacyExtensionImporter createIfApplicable(@NotNull MavenProject mavenProject, @NotNull Module module, @NotNull StandardMavenModuleType moduleType, @NotNull MavenProjectsTree mavenTree, boolean hasChanges, @NotNull Map<MavenProject, String> mavenProjectToModuleName, @NotNull List<? extends MavenImporter> mavenImporters) {
            return Companion.createIfApplicable(mavenProject, module, moduleType, mavenTree, hasChanges, mavenProjectToModuleName, mavenImporters);
        }

        public /* synthetic */ LegacyExtensionImporter(Module myModule, MavenProjectsTree myMavenProjectsTree, MavenProject myMavenProject, MavenProjectChanges myMavenProjectChanges, Map myMavenProjectToModuleName, List myImporters, DefaultConstructorMarker $constructor_marker) {
            this(myModule, myMavenProjectsTree, myMavenProject, myMavenProjectChanges, myMavenProjectToModuleName, myImporters);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JT\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007J<\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u001a\u0010\u0019\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/idea/maven/importing/MavenProjectImporterUtil$LegacyExtensionImporter$Companion;", "", "<init>", "()V", "createIfApplicable", "Lorg/jetbrains/idea/maven/importing/MavenProjectImporterUtil$LegacyExtensionImporter;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "module", "Lcom/intellij/openapi/module/Module;", "moduleType", "Lorg/jetbrains/idea/maven/importing/StandardMavenModuleType;", "mavenTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "hasChanges", "", "mavenProjectToModuleName", "", "", "mavenImporters", "", "Lorg/jetbrains/idea/maven/importing/MavenImporter;", "measureImporterTime", "", "importer", "counters", "", "Ljava/lang/Class;", "Lorg/jetbrains/idea/maven/importing/MavenProjectImporterUtil$LegacyExtensionImporter$CountAndTime;", "increaseModuleCounter", "r", "Ljava/lang/Runnable;", "intellij.maven"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @Nullable
            public final LegacyExtensionImporter createIfApplicable(@NotNull MavenProject mavenProject, @NotNull Module module, @NotNull StandardMavenModuleType moduleType, @NotNull MavenProjectsTree mavenTree, boolean hasChanges, @NotNull Map<MavenProject, String> mavenProjectToModuleName, @NotNull List<? extends MavenImporter> mavenImporters) {
                LegacyExtensionImporter legacyExtensionImporter;
                MavenProjectChanges changes;
                Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Intrinsics.checkNotNullParameter((Object)moduleType, (String)"moduleType");
                Intrinsics.checkNotNullParameter((Object)mavenTree, (String)"mavenTree");
                Intrinsics.checkNotNullParameter(mavenProjectToModuleName, (String)"mavenProjectToModuleName");
                Intrinsics.checkNotNullParameter(mavenImporters, (String)"mavenImporters");
                if (moduleType == StandardMavenModuleType.COMPOUND_MODULE) {
                    return null;
                }
                List<? extends MavenImporter> suitableImporters = mavenImporters;
                MavenProjectChanges mavenProjectChanges = changes = hasChanges ? MavenProjectChanges.ALL : MavenProjectChanges.NONE;
                if (suitableImporters.isEmpty()) {
                    legacyExtensionImporter = null;
                } else {
                    Intrinsics.checkNotNull((Object)changes);
                    legacyExtensionImporter = new LegacyExtensionImporter(module, mavenTree, mavenProject, changes, mavenProjectToModuleName, suitableImporters, null);
                }
                return legacyExtensionImporter;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void measureImporterTime(MavenImporter importer, Map<Class<? extends MavenImporter>, CountAndTime> counters, boolean increaseModuleCounter, Runnable r) {
                long before = System.nanoTime();
                try {
                    r.run();
                }
                finally {
                    CountAndTime countAndTime = counters.computeIfAbsent(importer.getClass(), arg_0 -> Companion.measureImporterTime$lambda$1(Companion::measureImporterTime$lambda$0, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)countAndTime, (String)"computeIfAbsent(...)");
                    CountAndTime countAndTime2 = countAndTime;
                    if (increaseModuleCounter) {
                        int n = countAndTime2.getCount();
                        countAndTime2.setCount(n + 1);
                    }
                    countAndTime2.setTimeNano(countAndTime2.getTimeNano() + (System.nanoTime() - before));
                }
            }

            private static final CountAndTime measureImporterTime$lambda$0(Class clazz) {
                return new CountAndTime();
            }

            private static final CountAndTime measureImporterTime$lambda$1(Function1 $tmp0, Object p0) {
                return (CountAndTime)$tmp0.invoke(p0);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenProjectImporterUtil$LegacyExtensionImporter$CountAndTime;", "", "<init>", "()V", "count", "", "getCount", "()I", "setCount", "(I)V", "timeNano", "", "getTimeNano", "()J", "setTimeNano", "(J)V", "intellij.maven"})
        public static final class CountAndTime {
            private int count;
            private long timeNano;

            public final int getCount() {
                return this.count;
            }

            public final void setCount(int n) {
                this.count = n;
            }

            public final long getTimeNano() {
                return this.timeNano;
            }

            public final void setTimeNano(long l) {
                this.timeNano = l;
            }
        }
    }
}

