/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.DependencyScope;
import com.intellij.platform.workspace.jps.entities.LibraryDependency;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.LibraryRootTypeId;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.entities.ModuleDependency;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntityAndExtensions;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.ide.legacyBridge.LegacyBridgeJpsEntitySourceFactory;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenProjectShadingData;
import org.jetbrains.idea.maven.importing.MavenShadePluginConfiguratorKt;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.importing.RelocationData;
import org.jetbrains.idea.maven.importing.workspaceModel.WorkspaceModuleImporter;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J@\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r0\u0013H\u0002J\u0018\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u000f*\u00020\rH\u0002J\u0012\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018*\u00020\rH\u0002J\u0012\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018*\u00020\rH\u0002J\f\u0010\u001a\u001a\u00020\u0016*\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\rH\u0002J0\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0016H\u0002J4\u0010&\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020(2\u0012\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\u00100*H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenShadePluginConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;", "<init>", "()V", "externalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "Lorg/jetbrains/annotations/NotNull;", "beforeModelApplied", "", "context", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$MutableModelContext;", "collectDependentMavenProjects", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "mavenProjectToModules", "", "", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "moduleIdToMavenProject", "Ljava/util/HashMap;", "Lcom/intellij/platform/workspace/jps/entities/ModuleId;", "getRelocationMap", "", "getIncludes", "", "getExcludes", "replaceDots", "getUberJarPath", "mavenProject", "addJarDependency", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "project", "Lcom/intellij/openapi/project/Project;", "module", "dependencyMavenId", "Lorg/jetbrains/idea/maven/model/MavenId;", "dependencyJarPath", "addLibraryEntity", "libraryId", "Lcom/intellij/platform/workspace/jps/entities/LibraryId;", "libraryRootsProvider", "Lkotlin/Function0;", "Lcom/intellij/platform/workspace/jps/entities/LibraryRoot;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenShadePluginConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenShadePluginConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenShadePluginConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,459:1\n774#2:460\n865#2,2:461\n808#2,11:463\n808#2,11:474\n1557#2:485\n1628#2,3:486\n*S KotlinDebug\n*F\n+ 1 MavenShadePluginConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenShadePluginConfigurator\n*L\n80#1:460\n80#1:461,2\n84#1:463,11\n117#1:474,11\n54#1:485\n54#1:486,3\n*E\n"})
public final class MavenShadePluginConfigurator
implements MavenWorkspaceConfigurator {
    @NotNull
    private final ProjectModelExternalSource externalSource;

    public MavenShadePluginConfigurator() {
        ProjectModelExternalSource projectModelExternalSource = ExternalProjectSystemRegistry.getInstance().getSourceById(WorkspaceModuleImporter.Companion.getEXTERNAL_SOURCE_ID());
        Intrinsics.checkNotNullExpressionValue((Object)projectModelExternalSource, (String)"getSourceById(...)");
        this.externalSource = projectModelExternalSource;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void beforeModelApplied(@NotNull MavenWorkspaceConfigurator.MutableModelContext context2) {
        void $this$filterTo$iv$iv;
        Object module2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!Registry.Companion.is("maven.shade.plugin.create.uber.jar.dependency")) {
            return;
        }
        Map mavenProjectToModules = MapsKt.toMap((Sequence)SequencesKt.map(context2.getMavenProjectsWithModules(), MavenShadePluginConfigurator::beforeModelApplied$lambda$1));
        Map shadedProjectsToRelocations = MapsKt.toMap((Sequence)SequencesKt.mapNotNull(context2.getMavenProjectsWithModules(), arg_0 -> MavenShadePluginConfigurator.beforeModelApplied$lambda$2(this, arg_0)));
        Set shadedProjects = shadedProjectsToRelocations.keySet();
        if (shadedProjects.isEmpty()) {
            return;
        }
        Map shadedMavenProjectsToBuildUberJar = new LinkedHashMap();
        HashMap<ModuleId, MavenProject> moduleIdToMavenProject = new HashMap<ModuleId, MavenProject>();
        for (MavenWorkspaceConfigurator.MavenProjectWithModules mavenProjectWithModules : context2.getMavenProjectsWithModules()) {
            for (Object module2 : mavenProjectWithModules.getModules()) {
                ((Map)moduleIdToMavenProject).put(((ModuleEntity)module2.getModule()).getSymbolicId(), mavenProjectWithModules.getMavenProject());
            }
        }
        Set set = moduleIdToMavenProject.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        module2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModuleId it = (ModuleId)element$iv$iv;
            boolean bl = false;
            if (!CollectionsKt.contains((Iterable)shadedProjects, moduleIdToMavenProject.get(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List shadedModuleIds = (List)destination$iv$iv;
        for (ModuleEntity module3 : ((MutableEntityStorage)context2.getStorage()).entities(ModuleEntity.class)) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = module3.getDependencies();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ModuleDependency)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            for (ModuleDependency dependency : (List)destination$iv$iv2) {
                ModuleId dependencyModuleId = dependency.getModule();
                if (!shadedModuleIds.contains(dependencyModuleId)) continue;
                Object v = moduleIdToMavenProject.get(dependencyModuleId);
                Intrinsics.checkNotNull(v);
                MavenProject mavenProject = (MavenProject)v;
                String uberJarPath = this.getUberJarPath(mavenProject);
                this.addJarDependency((MutableEntityStorage)context2.getStorage(), context2.getProject(), module3, mavenProject.getMavenId(), uberJarPath);
                if (shadedMavenProjectsToBuildUberJar.containsKey(mavenProject)) continue;
                Object v2 = shadedProjectsToRelocations.get(mavenProject);
                Intrinsics.checkNotNull(v2);
                RelocationData relocationData = (RelocationData)v2;
                Collection<MavenProject> dependentMavenProjects = this.collectDependentMavenProjects(mavenProject, mavenProjectToModules, moduleIdToMavenProject);
                shadedMavenProjectsToBuildUberJar.put(mavenProject, new MavenProjectShadingData(relocationData, uberJarPath, dependentMavenProjects));
            }
        }
        context2.putUserDataIfAbsent(MavenShadePluginConfiguratorKt.access$getSHADED_MAVEN_PROJECTS$p(), shadedMavenProjectsToBuildUberJar);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<MavenProject> collectDependentMavenProjects(MavenProject $this$collectDependentMavenProjects, Map<MavenProject, ? extends List<? extends ModuleEntity>> mavenProjectToModules, HashMap<ModuleId, MavenProject> moduleIdToMavenProject) {
        Set dependentMavenProjects = new LinkedHashSet();
        ArrayDeque<MavenProject> queue = new ArrayDeque<MavenProject>();
        queue.add($this$collectDependentMavenProjects);
        while (!((Collection)queue).isEmpty()) {
            List<? extends ModuleEntity> modules;
            MavenProject currentProject = (MavenProject)queue.removeFirst();
            if (mavenProjectToModules.get(currentProject) == null) continue;
            for (ModuleEntity moduleEntity : modules) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = moduleEntity.getDependencies();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ModuleDependency)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List moduleDependencies = (List)destination$iv$iv;
                for (ModuleDependency moduleDependency : moduleDependencies) {
                    MavenProject mavenProject;
                    if (moduleIdToMavenProject.get(moduleDependency.getModule()) == null || !dependentMavenProjects.add(mavenProject)) continue;
                    queue.add(mavenProject);
                }
            }
        }
        return dependentMavenProjects;
    }

    private final Map<String, String> getRelocationMap(MavenProject $this$getRelocationMap) {
        Map map;
        Sequence sequence;
        Sequence sequence2;
        Sequence sequence3;
        Sequence sequence4;
        List list;
        MavenPlugin mavenPlugin = MavenProject.findPlugin$default($this$getRelocationMap, "org.apache.maven.plugins", "maven-shade-plugin", false, 4, null);
        return mavenPlugin != null && (list = mavenPlugin.getExecutions()) != null && (sequence4 = CollectionsKt.asSequence((Iterable)list)) != null && (sequence3 = SequencesKt.mapNotNull((Sequence)sequence4, MavenShadePluginConfigurator::getRelocationMap$lambda$4)) != null && (sequence2 = SequencesKt.flatMap((Sequence)sequence3, MavenShadePluginConfigurator::getRelocationMap$lambda$5)) != null && (sequence = SequencesKt.mapNotNull((Sequence)sequence2, arg_0 -> MavenShadePluginConfigurator.getRelocationMap$lambda$6(this, arg_0))) != null && (map = MapsKt.toMap((Sequence)sequence)) != null ? map : MapsKt.emptyMap();
    }

    private final Set<String> getIncludes(MavenProject $this$getIncludes) {
        Set set;
        Sequence sequence;
        Sequence sequence2;
        Sequence sequence3;
        Sequence sequence4;
        List list;
        MavenPlugin mavenPlugin = MavenProject.findPlugin$default($this$getIncludes, "org.apache.maven.plugins", "maven-shade-plugin", false, 4, null);
        return mavenPlugin != null && (list = mavenPlugin.getExecutions()) != null && (sequence4 = CollectionsKt.asSequence((Iterable)list)) != null && (sequence3 = SequencesKt.mapNotNull((Sequence)sequence4, MavenShadePluginConfigurator::getIncludes$lambda$7)) != null && (sequence2 = SequencesKt.flatMap((Sequence)sequence3, MavenShadePluginConfigurator::getIncludes$lambda$8)) != null && (sequence = SequencesKt.mapNotNull((Sequence)sequence2, MavenShadePluginConfigurator::getIncludes$lambda$9)) != null && (set = SequencesKt.toSet((Sequence)sequence)) != null ? set : SetsKt.emptySet();
    }

    private final Set<String> getExcludes(MavenProject $this$getExcludes) {
        Set set;
        Sequence sequence;
        Sequence sequence2;
        Sequence sequence3;
        Sequence sequence4;
        List list;
        MavenPlugin mavenPlugin = MavenProject.findPlugin$default($this$getExcludes, "org.apache.maven.plugins", "maven-shade-plugin", false, 4, null);
        return mavenPlugin != null && (list = mavenPlugin.getExecutions()) != null && (sequence4 = CollectionsKt.asSequence((Iterable)list)) != null && (sequence3 = SequencesKt.mapNotNull((Sequence)sequence4, MavenShadePluginConfigurator::getExcludes$lambda$10)) != null && (sequence2 = SequencesKt.flatMap((Sequence)sequence3, MavenShadePluginConfigurator::getExcludes$lambda$11)) != null && (sequence = SequencesKt.mapNotNull((Sequence)sequence2, MavenShadePluginConfigurator::getExcludes$lambda$12)) != null && (set = SequencesKt.toSet((Sequence)sequence)) != null ? set : SetsKt.emptySet();
    }

    private final String replaceDots(String $this$replaceDots) {
        return StringsKt.replace$default((String)$this$replaceDots, (char)'.', (char)'/', (boolean)false, (int)4, null);
    }

    private final String getUberJarPath(MavenProject mavenProject) {
        MavenId mavenId = mavenProject.getMavenId();
        String fileName = mavenId.getArtifactId() + "-" + mavenId.getVersion() + ".jar";
        String[] stringArray = new String[]{fileName};
        Path path2 = Path.of(mavenProject.getBuildDirectory(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        return ((Object)path2).toString();
    }

    private final void addJarDependency(MutableEntityStorage builder2, Project project, ModuleEntity module, MavenId dependencyMavenId, String dependencyJarPath) {
        String libraryName = MavenShadePluginConfiguratorKt.getSHADED_MAVEN_LIBRARY_NAME_PREFIX() + dependencyMavenId.getDisplayString();
        LibraryId libraryId = new LibraryId(libraryName, (LibraryTableId)LibraryTableId.ProjectLibraryTableId.INSTANCE);
        VirtualFileUrl jarUrl = WorkspaceModel.Companion.getInstance(project).getVirtualFileUrlManager().getOrCreateFromUrl("jar://" + dependencyJarPath + "!/");
        this.addLibraryEntity(builder2, project, libraryId, (Function0<? extends List<LibraryRoot>>)((Function0)() -> MavenShadePluginConfigurator.addJarDependency$lambda$13(jarUrl)));
        DependencyScope scope = DependencyScope.COMPILE;
        LibraryDependency libraryDependency = new LibraryDependency(libraryId, false, scope);
        ModuleEntityAndExtensions.modifyModuleEntity((MutableEntityStorage)builder2, (ModuleEntity)module, arg_0 -> MavenShadePluginConfigurator.addJarDependency$lambda$14(libraryDependency, arg_0));
    }

    private final void addLibraryEntity(MutableEntityStorage builder2, Project project, LibraryId libraryId, Function0<? extends List<LibraryRoot>> libraryRootsProvider) {
        if (builder2.contains((SymbolicEntityId)libraryId)) {
            return;
        }
        EntitySource librarySource = LegacyBridgeJpsEntitySourceFactory.Companion.getInstance(project).createEntitySourceForProjectLibrary(this.externalSource);
        builder2.addEntity((WorkspaceEntity.Builder)LibraryEntity.Companion.create$default((LibraryEntity.Companion)LibraryEntity.Companion, (String)libraryId.getName(), (LibraryTableId)libraryId.getTableId(), (List)((List)libraryRootsProvider.invoke()), (EntitySource)librarySource, null, (int)16, null));
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair beforeModelApplied$lambda$1(MavenWorkspaceConfigurator.MavenProjectWithModules it) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable iterable = it.getModules();
        MavenProject mavenProject = it.getMavenProject();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void m;
            MavenWorkspaceConfigurator.ModuleWithType moduleWithType = (MavenWorkspaceConfigurator.ModuleWithType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((ModuleEntity)m.getModule());
        }
        return TuplesKt.to((Object)mavenProject, (Object)((List)destination$iv$iv));
    }

    private static final Pair beforeModelApplied$lambda$2(MavenShadePluginConfigurator this$0, MavenWorkspaceConfigurator.MavenProjectWithModules p) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        MavenProject mavenProject = p.getMavenProject();
        Map<String, String> relocationMap = this$0.getRelocationMap(mavenProject);
        if (relocationMap.isEmpty()) {
            pair = null;
        } else {
            Set<String> includes = this$0.getIncludes(mavenProject);
            Set<String> excludes = this$0.getExcludes(mavenProject);
            pair = TuplesKt.to((Object)mavenProject, (Object)new RelocationData(relocationMap, includes, excludes));
        }
        return pair;
    }

    private static final Element getRelocationMap$lambda$4(MavenPlugin.Execution it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Element element = it.getConfigurationElement();
        return element != null ? element.getChild("relocations") : null;
    }

    private static final Sequence getRelocationMap$lambda$5(Element it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List list = it.getChildren("relocation");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        return CollectionsKt.asSequence((Iterable)list);
    }

    private static final Pair getRelocationMap$lambda$6(MavenShadePluginConfigurator this$0, Element it) {
        String pattern = it.getChildText("pattern");
        String shadedPattern = it.getChildText("shadedPattern");
        return pattern != null && shadedPattern != null ? TuplesKt.to((Object)this$0.replaceDots(pattern), (Object)this$0.replaceDots(shadedPattern)) : null;
    }

    private static final Element getIncludes$lambda$7(MavenPlugin.Execution it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Element element = it.getConfigurationElement();
        return element != null && (element = element.getChild("artifactSet")) != null ? element.getChild("includes") : null;
    }

    private static final Sequence getIncludes$lambda$8(Element it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List list = it.getChildren("include");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        return CollectionsKt.asSequence((Iterable)list);
    }

    private static final String getIncludes$lambda$9(Element it) {
        return it.getText();
    }

    private static final Element getExcludes$lambda$10(MavenPlugin.Execution it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Element element = it.getConfigurationElement();
        return element != null && (element = element.getChild("artifactSet")) != null ? element.getChild("excludes") : null;
    }

    private static final Sequence getExcludes$lambda$11(Element it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List list = it.getChildren("exclude");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        return CollectionsKt.asSequence((Iterable)list);
    }

    private static final String getExcludes$lambda$12(Element it) {
        return it.getText();
    }

    private static final List addJarDependency$lambda$13(VirtualFileUrl $jarUrl) {
        return CollectionsKt.listOf((Object)new LibraryRoot($jarUrl, LibraryRootTypeId.Companion.getCOMPILED(), null, 4, null));
    }

    private static final Unit addJarDependency$lambda$14(LibraryDependency $libraryDependency, ModuleEntity.Builder $this$modifyModuleEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyModuleEntity, (String)"$this$modifyModuleEntity");
        $this$modifyModuleEntity.getDependencies().add($libraryDependency);
        return Unit.INSTANCE;
    }
}

