/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices.archetype;

import com.intellij.openapi.project.Project;
import com.intellij.platform.ide.progress.TasksKt;
import java.net.URL;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.config.MavenConfig;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenHomeKt;
import org.jetbrains.idea.maven.project.MavenHomeType;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.StaticResolvedMavenHomeType;
import org.jetbrains.idea.maven.utils.MavenEelUtil;
import org.jetbrains.idea.maven.wizards.MavenWizardBundle;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\t\n\u000bR\u0017\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u0082\u0001\u0003\f\r\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog;", "", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "()Ljava/lang/String;", "location", "getLocation", "System", "Local", "Remote", "Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog$Local;", "Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog$Remote;", "Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog$System;", "intellij.maven"})
public interface MavenCatalog {
    @NotNull
    public String getName();

    @NotNull
    public String getLocation();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog$Local;", "Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog;", "name", "", "path", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "getName", "()Ljava/lang/String;", "getPath", "()Ljava/nio/file/Path;", "location", "getLocation", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.maven"})
    public static final class Local
    implements MavenCatalog {
        @NotNull
        private final String name;
        @NotNull
        private final Path path;
        @NotNull
        private final String location;

        public Local(@NotNull String name, @NotNull Path path2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            this.name = name;
            this.path = path2;
            this.location = PathsKt.getInvariantSeparatorsPathString((Path)this.path);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        @Override
        @NotNull
        public String getLocation() {
            return this.location;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final Path component2() {
            return this.path;
        }

        @NotNull
        public final Local copy(@NotNull String name, @NotNull Path path2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return new Local(name, path2);
        }

        public static /* synthetic */ Local copy$default(Local local, String string, Path path2, int n, Object object) {
            if ((n & 1) != 0) {
                string = local.name;
            }
            if ((n & 2) != 0) {
                path2 = local.path;
            }
            return local.copy(string, path2);
        }

        @NotNull
        public String toString() {
            return "Local(name=" + this.name + ", path=" + this.path + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + ((Object)this.path).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Local)) {
                return false;
            }
            Local local = (Local)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)local.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.path, (Object)local.path);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog$Remote;", "Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog;", "name", "", "url", "Ljava/net/URL;", "<init>", "(Ljava/lang/String;Ljava/net/URL;)V", "getName", "()Ljava/lang/String;", "getUrl", "()Ljava/net/URL;", "location", "getLocation", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.maven"})
    public static final class Remote
    implements MavenCatalog {
        @NotNull
        private final String name;
        @NotNull
        private final URL url;
        @NotNull
        private final String location;

        public Remote(@NotNull String name, @NotNull URL url) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.name = name;
            this.url = url;
            String string = this.url.toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
            this.location = string;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public final URL getUrl() {
            return this.url;
        }

        @Override
        @NotNull
        public String getLocation() {
            return this.location;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final URL component2() {
            return this.url;
        }

        @NotNull
        public final Remote copy(@NotNull String name, @NotNull URL url) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new Remote(name, url);
        }

        public static /* synthetic */ Remote copy$default(Remote remote, String string, URL uRL, int n, Object object) {
            if ((n & 1) != 0) {
                string = remote.name;
            }
            if ((n & 2) != 0) {
                uRL = remote.url;
            }
            return remote.copy(string, uRL);
        }

        @NotNull
        public String toString() {
            return "Remote(name=" + this.name + ", url=" + this.url + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.url.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Remote)) {
                return false;
            }
            Remote remote = (Remote)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)remote.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.url, (Object)remote.url);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog$System;", "Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog;", "Internal", "DefaultLocal", "MavenCentral", "Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog$System$DefaultLocal;", "Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog$System$Internal;", "Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog$System$MavenCentral;", "intellij.maven"})
    public static interface System
    extends MavenCatalog {

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0010\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u000bH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog$System$DefaultLocal;", "Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog$System;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "file", "Ljava/nio/file/Path;", "getFile", "()Ljava/nio/file/Path;", "name", "", "getName", "()Ljava/lang/String;", "location", "getLocation", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.maven"})
        public static final class DefaultLocal
        implements System {
            @NotNull
            private final Project project;
            @NotNull
            private final String name;

            public DefaultLocal(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                this.project = project;
                String string = MavenWizardBundle.message("maven.new.project.wizard.archetype.catalog.default.local.name", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.name = string;
            }

            @NotNull
            public final Path getFile() {
                MavenGeneralSettings generalSettings = MavenProjectsManager.getInstance(this.project).getGeneralSettings();
                MavenConfig mavenConfig = generalSettings.getMavenConfig();
                MavenHomeType mavenHomeType = generalSettings.getMavenHomeType();
                Intrinsics.checkNotNullExpressionValue((Object)mavenHomeType, (String)"getMavenHomeType(...)");
                StaticResolvedMavenHomeType mavenHome = MavenHomeKt.staticOrBundled(mavenHomeType);
                String string = MavenConfigurableBundle.message("maven.progress.title.computing.repository.location", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return (Path)TasksKt.runWithModalProgressBlocking((Project)this.project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(this, mavenConfig, mavenHome, null){
                    int label;
                    final /* synthetic */ DefaultLocal this$0;
                    final /* synthetic */ MavenConfig $mavenConfig;
                    final /* synthetic */ StaticResolvedMavenHomeType $mavenHome;
                    {
                        this.this$0 = $receiver;
                        this.$mavenConfig = $mavenConfig;
                        this.$mavenHome = $mavenHome;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = MavenEelUtil.getUserSettingsAsync(DefaultLocal.access$getProject$p(this.this$0), "", this.$mavenConfig, (Continuation<? super Path>)((Continuation)this));
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                settings = v0.toString();
                                this.label = 2;
                                v1 = MavenEelUtil.getLocalRepoAsync(DefaultLocal.access$getProject$p(this.this$0), "", this.$mavenHome, settings, this.$mavenConfig, (Continuation<? super Path>)((Continuation)this));
                                if (v1 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl22
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl22:
                                // 2 sources

                                return v1;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }

            @Override
            @NotNull
            public String getName() {
                return this.name;
            }

            @Override
            @NotNull
            public String getLocation() {
                return PathsKt.getInvariantSeparatorsPathString((Path)this.getFile());
            }

            private final Project component1() {
                return this.project;
            }

            @NotNull
            public final DefaultLocal copy(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return new DefaultLocal(project);
            }

            public static /* synthetic */ DefaultLocal copy$default(DefaultLocal defaultLocal, Project project, int n, Object object) {
                if ((n & 1) != 0) {
                    project = defaultLocal.project;
                }
                return defaultLocal.copy(project);
            }

            @NotNull
            public String toString() {
                return "DefaultLocal(project=" + this.project + ")";
            }

            public int hashCode() {
                return this.project.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DefaultLocal)) {
                    return false;
                }
                DefaultLocal defaultLocal = (DefaultLocal)other;
                return Intrinsics.areEqual((Object)this.project, (Object)defaultLocal.project);
            }

            public static final /* synthetic */ Project access$getProject$p(DefaultLocal $this) {
                return $this.project;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog$System$Internal;", "Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog$System;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "location", "getLocation", "intellij.maven"})
        public static final class Internal
        implements System {
            @NotNull
            public static final Internal INSTANCE = new Internal();
            @NotNull
            private static final String name;
            @NotNull
            private static final String location;

            private Internal() {
            }

            @Override
            @NotNull
            public String getName() {
                return name;
            }

            @Override
            @NotNull
            public String getLocation() {
                return location;
            }

            static {
                String string = MavenWizardBundle.message("maven.new.project.wizard.archetype.catalog.internal.name", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                name = string;
                location = "";
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog$System$MavenCentral;", "Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog$System;", "<init>", "()V", "url", "Ljava/net/URL;", "getUrl", "()Ljava/net/URL;", "name", "", "getName", "()Ljava/lang/String;", "location", "getLocation", "intellij.maven"})
        public static final class MavenCentral
        implements System {
            @NotNull
            public static final MavenCentral INSTANCE = new MavenCentral();
            @NotNull
            private static final URL url = new URL("https://repo.maven.apache.org/maven2");
            @NotNull
            private static final String name;
            @NotNull
            private static final String location;

            private MavenCentral() {
            }

            @NotNull
            public final URL getUrl() {
                return url;
            }

            @Override
            @NotNull
            public String getName() {
                return name;
            }

            @Override
            @NotNull
            public String getLocation() {
                return location;
            }

            static {
                String string = MavenWizardBundle.message("maven.new.project.wizard.archetype.catalog.central.name", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                name = string;
                String string2 = url.toExternalForm();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toExternalForm(...)");
                location = string2;
            }
        }
    }
}

