/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.internal;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.internal.ReadStatisticsCollectorKt;
import org.jetbrains.idea.maven.server.DummyMavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerStatus;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000eJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0006\u0010\u0010\u001a\u00020\u000bJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0006\u0010\u0015\u001a\u00020\u000bR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/maven/internal/ReadStatisticsCollector;", "", "<init>", "()V", "shouldCollectMavenStatistics", "", "map", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/concurrent/atomic/AtomicInteger;", "fileRead", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/io/File;", "path", "print", "getDebugStatusFromMaven", "", "Lorg/jetbrains/idea/maven/server/MavenServerStatus;", "clean", "reset", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nReadStatisticsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadStatisticsCollector.kt\norg/jetbrains/idea/maven/internal/ReadStatisticsCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ReadStatisticsCollector.kt\norg/jetbrains/idea/maven/internal/ReadStatisticsCollectorKt\n*L\n1#1,123:1\n1#2:124\n462#3:125\n412#3:126\n1246#4,4:127\n1863#4,2:131\n115#5:133\n*S KotlinDebug\n*F\n+ 1 ReadStatisticsCollector.kt\norg/jetbrains/idea/maven/internal/ReadStatisticsCollector\n*L\n41#1:125\n41#1:126\n41#1:127,4\n54#1:131,2\n80#1:133\n*E\n"})
public final class ReadStatisticsCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, AtomicInteger> map = new ConcurrentHashMap();

    private final boolean shouldCollectMavenStatistics() {
        return Registry.Companion.is("maven.collect.local.stat");
    }

    public final void fileRead(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.shouldCollectMavenStatistics()) {
            return;
        }
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.fileRead(string);
    }

    public final void fileRead(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.shouldCollectMavenStatistics()) {
            return;
        }
        String string = file2.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        this.fileRead(string);
    }

    private final void fileRead(String path2) {
        block3: {
            AtomicInteger counter;
            AtomicInteger atomicInteger = this.map.get(path2);
            if (atomicInteger != null) {
                AtomicInteger atomicInteger2;
                AtomicInteger it = atomicInteger2 = atomicInteger;
                boolean bl = false;
                it.incrementAndGet();
                v1 = atomicInteger2;
            } else {
                v1 = counter = null;
            }
            if (counter != null) break block3;
            AtomicInteger atomicInteger3 = this.map.putIfAbsent(path2, new AtomicInteger(1));
            if (atomicInteger3 != null) {
                atomicInteger3.incrementAndGet();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void print() {
        void $this$forEach$iv;
        Iterable $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv = this.map;
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Integer n = ((AtomicInteger)it.getValue()).get();
            map3.put(k, n);
        }
        Map totalMap = MapsKt.toMutableMap((Map)destination$iv$iv);
        System.out.println((Object)"======================================================");
        System.out.println((Object)"Maven files read Statistics IDEA process: ");
        ReadStatisticsCollectorKt.access$printAsArray(totalMap);
        System.out.println((Object)"======================================================");
        System.out.println((Object)"getting info from maven server:");
        HashMap readMapFromMaven = new HashMap();
        HashMap resolvePluginsFromMaven = new HashMap();
        $this$mapValuesTo$iv$iv = this.getDebugStatusFromMaven(false);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MavenServerStatus it = (MavenServerStatus)element$iv;
            boolean bl = false;
            Map map4 = readMapFromMaven;
            HashMap hashMap = it.fileReadAccessCount;
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"fileReadAccessCount");
            ReadStatisticsCollectorKt.access$mergeWith(map4, hashMap);
            Map map5 = resolvePluginsFromMaven;
            HashMap hashMap2 = it.pluginResolveCount;
            Intrinsics.checkNotNullExpressionValue((Object)hashMap2, (String)"pluginResolveCount");
            ReadStatisticsCollectorKt.access$mergeWith(map5, hashMap2);
        }
        ReadStatisticsCollectorKt.access$printAsArray(readMapFromMaven);
        System.out.println((Object)"======================================================");
        System.out.println((Object)"total: ");
        ReadStatisticsCollectorKt.access$mergeWith(totalMap, readMapFromMaven);
        ReadStatisticsCollectorKt.access$printAsArray(totalMap);
        System.out.println((Object)"======================================================");
        System.out.println((Object)"plugins:");
        ReadStatisticsCollectorKt.access$printAsArray(resolvePluginsFromMaven);
        System.out.println((Object)"======================================================");
        this.map.clear();
    }

    private final List<MavenServerStatus> getDebugStatusFromMaven(boolean clean) {
        Sequence $this$mapSafe$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)MavenServerManager.Companion.getInstance().getAllConnectors()), ReadStatisticsCollector::getDebugStatusFromMaven$lambda$3);
        boolean $i$f$mapSafe = false;
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)$this$mapSafe$iv, (Function1)((Function1)new Function1<MavenServerConnector, MavenServerStatus>(clean){
            final /* synthetic */ boolean $clean$inlined;
            {
                this.$clean$inlined = bl;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object invoke(Object it) {
                try {
                    MavenServerConnector it2 = (MavenServerConnector)it;
                    boolean bl = false;
                    return it2.getDebugStatus(this.$clean$inlined);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        })), ReadStatisticsCollector::getDebugStatusFromMaven$lambda$5));
    }

    public final void reset() {
        this.map.clear();
        this.getDebugStatusFromMaven(true);
    }

    private static final boolean getDebugStatusFromMaven$lambda$3(MavenServerConnector it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !DummyMavenServerConnector.Companion.isDummy(it);
    }

    private static final boolean getDebugStatusFromMaven$lambda$5(MavenServerStatus it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.statusCollected;
    }

    @JvmStatic
    @NotNull
    public static final ReadStatisticsCollector getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/idea/maven/internal/ReadStatisticsCollector$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/idea/maven/internal/ReadStatisticsCollector;", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nReadStatisticsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadStatisticsCollector.kt\norg/jetbrains/idea/maven/internal/ReadStatisticsCollector$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,123:1\n31#2,2:124\n*S KotlinDebug\n*F\n+ 1 ReadStatisticsCollector.kt\norg/jetbrains/idea/maven/internal/ReadStatisticsCollector$Companion\n*L\n93#1:124,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ReadStatisticsCollector getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<ReadStatisticsCollector> serviceClass$iv = ReadStatisticsCollector.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ReadStatisticsCollector)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

