/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.maven4;

import com.intellij.maven.server.telemetry.MavenServerTelemetryClasspathUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.MavenVersionAwareSupportExtension;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.BundledMaven4;
import org.jetbrains.idea.maven.project.StaticResolvedMavenHomeType;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;
import org.jetbrains.intellij.build.impl.BundledMavenDownloader;

final class Maven4Support
implements MavenVersionAwareSupportExtension {
    @NonNls
    private static final String MAIN_CLASS40 = "com.intellij.maven.server.m40.RemoteMavenServer40";

    Maven4Support() {
    }

    @Override
    public boolean isSupportedByExtension(@Nullable File mavenHome) {
        String version = mavenHome == null ? null : MavenUtil.getMavenVersion(mavenHome.toPath());
        return StringUtil.compareVersionNumbers((String)version, (String)"4") >= 0;
    }

    @Override
    @Nullable
    public Path getMavenHomeFile(@Nullable StaticResolvedMavenHomeType mavenHomeType) {
        if (mavenHomeType == null) {
            return null;
        }
        if (mavenHomeType == BundledMaven4.INSTANCE) {
            return MavenDistributionsCache.resolveEmbeddedMavenHome().getMavenHome();
        }
        return null;
    }

    @Override
    @NotNull
    public List<Path> collectClassPathAndLibsFolder(@NotNull MavenDistribution distribution) {
        if (distribution == null) {
            Maven4Support.$$$reportNull$$$0(0);
        }
        Path pluginFileOrDir = Path.of(PathUtil.getJarPathForClass(MavenServerManager.class), new String[0]);
        ArrayList<Path> classpath = new ArrayList<Path>();
        String relevantJarsRoot = PathManager.getArchivedCompliedClassesLocation();
        if (Files.isDirectory(pluginFileOrDir, new LinkOption[0])) {
            MavenLog.LOG.debug("collecting classpath for local run");
            Maven4Support.prepareClassPathForLocalRunAndUnitTests(distribution.getVersion(), classpath, pluginFileOrDir.toFile().getParent());
        } else if (relevantJarsRoot != null && pluginFileOrDir.startsWith(relevantJarsRoot)) {
            MavenLog.LOG.debug("collecting classpath for local run on archived outputs");
            Maven4Support.prepareClassPathForLocalRunAndUnitTestsArchived(distribution.getVersion(), classpath);
        } else {
            MavenLog.LOG.debug("collecting classpath for production");
            Maven4Support.prepareClassPathForProduction(distribution.getVersion(), classpath, pluginFileOrDir.toFile().getParent());
        }
        Maven4Support.addMavenLibs(classpath, distribution.getMavenHome());
        MavenLog.LOG.debug("Collected classpath = ", new Object[]{classpath});
        ArrayList<Path> arrayList = classpath;
        if (arrayList == null) {
            Maven4Support.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static void prepareClassPathForProduction(@NotNull String mavenVersion, List<Path> classpath, String root) {
        if (mavenVersion == null) {
            Maven4Support.$$$reportNull$$$0(2);
        }
        classpath.add(Path.of(PathUtil.getJarPathForClass(MavenId.class), new String[0]));
        classpath.add(Path.of(PathUtil.getJarPathForClass(MavenServer.class), new String[0]));
        Path rootPath = Path.of(root, new String[0]);
        classpath.add(rootPath.resolve("maven-server-telemetry.jar"));
        try {
            classpath.add(Path.of(PathUtil.getJarPathForClass(Class.forName("io.opentelemetry.sdk.trace.export.SpanExporter")), new String[0]));
        }
        catch (ClassNotFoundException e) {
            MavenLog.LOG.error((Throwable)e);
        }
        Maven4Support.addDir(classpath, rootPath.resolve("maven-telemetry-lib"), f -> true);
        Maven4Support.addDir(classpath, rootPath.resolve("maven4-server-lib"), f -> true);
        classpath.add(rootPath.resolve("maven40-server.jar"));
    }

    private static void prepareClassPathForLocalRunAndUnitTests(@NotNull String mavenVersion, List<Path> classpath, String root) {
        if (mavenVersion == null) {
            Maven4Support.$$$reportNull$$$0(3);
        }
        BuildDependenciesCommunityRoot communityRoot = new BuildDependenciesCommunityRoot(Path.of(PathManager.getCommunityHomePath(), new String[0]));
        BundledMavenDownloader.INSTANCE.downloadMaven4LibsSync(communityRoot);
        Path rootPath = Path.of(root, new String[0]);
        classpath.add(Path.of(PathUtil.getJarPathForClass(MavenId.class), new String[0]));
        classpath.add(rootPath.resolve("intellij.maven.server"));
        classpath.add(rootPath.resolve("intellij.maven.server.telemetry"));
        classpath.addAll(MavenUtil.collectClasspath(MavenServerTelemetryClasspathUtil.TELEMETRY_CLASSES));
        Path parentPath = MavenUtil.getMavenPluginParentFile();
        Maven4Support.addDir(classpath, parentPath.resolve("maven40-server-impl/lib"), f -> true);
        classpath.add(rootPath.resolve("intellij.maven.server.m40"));
    }

    private static void prepareClassPathForLocalRunAndUnitTestsArchived(@NotNull String mavenVersion, List<Path> classpath) {
        if (mavenVersion == null) {
            Maven4Support.$$$reportNull$$$0(4);
        }
        BuildDependenciesCommunityRoot communityRoot = new BuildDependenciesCommunityRoot(Path.of(PathManager.getCommunityHomePath(), new String[0]));
        BundledMavenDownloader.INSTANCE.downloadMaven4LibsSync(communityRoot);
        Map mapping = PathManager.getArchivedCompiledClassesMapping();
        if (mapping == null) {
            throw new IllegalStateException("Mapping cannot be null at this point");
        }
        classpath.add(Path.of(PathUtil.getJarPathForClass(MavenId.class), new String[0]));
        classpath.add(Path.of((String)mapping.get("production/intellij.maven.server"), new String[0]));
        classpath.add(Path.of((String)mapping.get("production/intellij.maven.server.telemetry"), new String[0]));
        classpath.addAll(MavenUtil.collectClasspath(MavenServerTelemetryClasspathUtil.TELEMETRY_CLASSES));
        Path parentPath = MavenUtil.getMavenPluginParentFile();
        Maven4Support.addDir(classpath, parentPath.resolve("maven40-server-impl/lib"), f -> true);
        classpath.add(Path.of((String)mapping.get("production/intellij.maven.server.m40"), new String[0]));
    }

    private static void addMavenLibs(List<Path> classpath, Path mavenHome) {
        Maven4Support.addDir(classpath, mavenHome.resolve("lib"), f -> !f.getFileName().toString().contains("maven-slf4j-provider"));
        Path bootFolder = mavenHome.resolve("boot");
        List<Path> classworldsJars = NioFiles.list((Path)bootFolder).stream().filter(f -> StringUtil.contains((CharSequence)f.getFileName().toString(), (CharSequence)"classworlds")).toList();
        classpath.addAll(classworldsJars);
    }

    private static void addDir(List<Path> classpath, Path dir, Predicate<Path> filter) {
        List files2 = NioFiles.list((Path)dir);
        for (Path jar : files2) {
            if (!Files.isRegularFile(jar, new LinkOption[0]) || !jar.getFileName().toString().endsWith(".jar") || !filter.test(jar)) continue;
            classpath.add(jar);
        }
    }

    @Override
    public String getMainClass(MavenDistribution distribution) {
        return MAIN_CLASS40;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/maven4/Maven4Support";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/maven4/Maven4Support";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassPathAndLibsFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectClassPathAndLibsFolder";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForProduction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForLocalRunAndUnitTests";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForLocalRunAndUnitTestsArchived";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

