/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenImportEventProcessor;
import org.jetbrains.idea.maven.execution.MavenSpyEventsBuffer;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenRemoteProcessSupportFactory;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.ssl.SslDelegateHandlerConfirmingTrustManager;
import org.jetbrains.idea.maven.server.ssl.SslDelegateHandlerStateMachine;
import org.jetbrains.idea.maven.utils.MavenLog;

public abstract class AbstractMavenServerRemoteProcessSupport
extends MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport {
    protected final Sdk myJdk;
    protected final String myOptions;
    protected final MavenDistribution myDistribution;
    protected final Project myProject;
    protected final Integer myDebugPort;
    @Nullable
    protected Consumer<ProcessEvent> onTerminate;
    private final MavenImportEventProcessor myImportEventProcessor;
    private final MavenSpyEventsBuffer myMavenSpyEventsBuffer;
    private final SslDelegateHandlerStateMachine mySslDelegateHandlerStateMachine;

    public AbstractMavenServerRemoteProcessSupport(@NotNull Sdk jdk, @Nullable String vmOptions, @NotNull MavenDistribution mavenDistribution, @NotNull Project project, @Nullable Integer debugPort) {
        if (jdk == null) {
            AbstractMavenServerRemoteProcessSupport.$$$reportNull$$$0(0);
        }
        if (mavenDistribution == null) {
            AbstractMavenServerRemoteProcessSupport.$$$reportNull$$$0(1);
        }
        if (project == null) {
            AbstractMavenServerRemoteProcessSupport.$$$reportNull$$$0(2);
        }
        super(MavenServer.class);
        this.myJdk = jdk;
        this.myOptions = vmOptions;
        this.myDistribution = mavenDistribution;
        this.myProject = project;
        this.myDebugPort = debugPort;
        this.myImportEventProcessor = new MavenImportEventProcessor(project);
        AnsiEscapeDecoder myDecoder = new AnsiEscapeDecoder();
        this.mySslDelegateHandlerStateMachine = new SslDelegateHandlerConfirmingTrustManager();
        this.myMavenSpyEventsBuffer = new MavenSpyEventsBuffer((l, k) -> {
            this.mySslDelegateHandlerStateMachine.addLine((String)l);
            myDecoder.escapeText(l, k, (AnsiEscapeDecoder.ColoredTextAcceptor)this.myImportEventProcessor);
        });
    }

    protected void fireModificationCountChanged() {
    }

    protected String getName(@NotNull Object file2) {
        if (file2 == null) {
            AbstractMavenServerRemoteProcessSupport.$$$reportNull$$$0(3);
        }
        return MavenServerManager.class.getSimpleName();
    }

    protected void sendDataAfterStart(ProcessHandler handler2) {
        if (handler2.getProcessInput() == null) {
            return;
        }
        this.mySslDelegateHandlerStateMachine.setOutput(handler2.getProcessInput());
        OutputStreamWriter writer = new OutputStreamWriter(handler2.getProcessInput(), StandardCharsets.UTF_8);
        try {
            writer.write("token=" + MavenRemoteObjectWrapper.ourToken);
            writer.write(System.lineSeparator());
            writer.flush();
            MavenLog.LOG.info("Sent token to maven server");
        }
        catch (IOException e) {
            MavenLog.LOG.warn("Cannot send token to maven server", (Throwable)e);
        }
    }

    @Override
    public void onTerminate(Consumer<ProcessEvent> onTerminate) {
        this.onTerminate = onTerminate;
    }

    protected void onProcessTerminated(ProcessEvent event) {
        Project[] openProjects;
        Consumer<ProcessEvent> eventConsumer = this.onTerminate;
        if (eventConsumer != null) {
            eventConsumer.accept(event);
        }
        if (event.getExitCode() == 0) {
            return;
        }
        this.myImportEventProcessor.finish();
        for (Project p : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            ReadAction.run(() -> {
                if (p.isDisposed()) {
                    return;
                }
                MavenProjectsManager manager = MavenProjectsManager.getInstance(p);
                if (!manager.isMavenizedProject()) {
                    return;
                }
                manager.terminateImport(event.getExitCode());
            });
        }
    }

    protected void logText(@NotNull Object configuration, @NotNull ProcessEvent event, @NotNull Key outputType) {
        if (configuration == null) {
            AbstractMavenServerRemoteProcessSupport.$$$reportNull$$$0(4);
        }
        if (event == null) {
            AbstractMavenServerRemoteProcessSupport.$$$reportNull$$$0(5);
        }
        if (outputType == null) {
            AbstractMavenServerRemoteProcessSupport.$$$reportNull$$$0(6);
        }
        super.logText(configuration, event, outputType);
        this.myMavenSpyEventsBuffer.addText(event.getText(), outputType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenDistribution";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/server/AbstractMavenServerRemoteProcessSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "logText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

