/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.google.common.base.Charsets;
import com.intellij.diagnostic.PluginException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.PathUtil;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/maven/server/MavenIndexerCMDState;", "Lcom/intellij/execution/configurations/CommandLineState;", "myJdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "myOptions", "", "myDistribution", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "myDebugPort", "", "<init>", "(Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Lorg/jetbrains/idea/maven/server/MavenDistribution;Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "startProcess", "Lcom/intellij/execution/process/ProcessHandler;", "createJavaParameters", "Lcom/intellij/execution/configurations/SimpleJavaParameters;", "Companion", "intellij.maven"})
public final class MavenIndexerCMDState
extends CommandLineState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Sdk myJdk;
    @NotNull
    private final String myOptions;
    @NotNull
    private final MavenDistribution myDistribution;
    @Nullable
    private final Integer myDebugPort;

    public MavenIndexerCMDState(@NotNull Sdk myJdk, @NotNull String myOptions, @NotNull MavenDistribution myDistribution, @Nullable Integer myDebugPort) {
        Intrinsics.checkNotNullParameter((Object)myJdk, (String)"myJdk");
        Intrinsics.checkNotNullParameter((Object)myOptions, (String)"myOptions");
        Intrinsics.checkNotNullParameter((Object)myDistribution, (String)"myDistribution");
        super(null);
        this.myJdk = myJdk;
        this.myOptions = myOptions;
        this.myDistribution = myDistribution;
        this.myDebugPort = myDebugPort;
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        SimpleJavaParameters params = this.createJavaParameters();
        GeneralCommandLine generalCommandLine = params.toCommandLine();
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"toCommandLine(...)");
        GeneralCommandLine commandLine = generalCommandLine;
        OSProcessHandler processHandler = (OSProcessHandler)new OSProcessHandler.Silent(commandLine);
        processHandler.setShouldDestroyProcessRecursively(false);
        return (ProcessHandler)processHandler;
    }

    @NotNull
    protected final SimpleJavaParameters createJavaParameters() {
        SimpleJavaParameters params = new SimpleJavaParameters();
        params.setJdk(this.myJdk);
        params.setWorkingDirectory(PathManager.getBinPath());
        params.getVMParametersList().add(Registry.Companion.stringValue("maven.dedicated.indexer.vmargs"));
        if (this.myDebugPort != null) {
            params.getVMParametersList().addParametersString("-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=*:" + this.myDebugPort);
        }
        params.getVMParametersList().add("-Didea.version=" + MavenUtil.getIdeaVersionToPassToMavenProcess());
        params.setMainClass("org.jetbrains.idea.maven.server.indexer.MavenServerIndexerMain");
        params.getClassPath().add(PathUtil.getJarPathForClass(StringUtilRt.class));
        params.getClassPath().add(PathUtil.getJarPathForClass(NotNull.class));
        params.getClassPath().addAllFiles(MavenIndexerCMDState.Companion.collectClassPathAndLibsFolder(this.myDistribution));
        params.getClassPath().add(PathUtil.getJarPathForClass(Element.class));
        return params;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0018\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J&\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J&\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u001e\u0010\u001a\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u001e\u0010\u001c\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001d\u001a\u00020\bH\u0002R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/idea/maven/server/MavenIndexerCMDState$Companion;", "", "<init>", "()V", "addDependenciesFromMavenRepo", "", "classPath", "", "Ljava/io/File;", "parseDependenciesUrls", "", "", "pathToIml", "Ljava/nio/file/Path;", "collectClassPathAndLibsFolder", "distribution", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "addIndexerRTLibs", "classpath", "indexerRTList", "getIndexerRTList", "()Ljava/util/List;", "prepareClassPathForProduction", "mavenVersion", "root", "prepareClassPathForLocalRunAndUnitTests", "addMavenLibs", "mavenHome", "addDir", "dir", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nMavenIndexerCMDState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenIndexerCMDState.kt\norg/jetbrains/idea/maven/server/MavenIndexerCMDState$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,212:1\n1#2:213\n1#2:227\n1#2:246\n774#3:214\n865#3,2:215\n1611#3,9:217\n1863#3:226\n1864#3:228\n1620#3:229\n1368#3:230\n1454#3,5:231\n1611#3,9:236\n1863#3:245\n1864#3:247\n1620#3:248\n739#3,9:249\n37#4:258\n36#4,3:259\n*S KotlinDebug\n*F\n+ 1 MavenIndexerCMDState.kt\norg/jetbrains/idea/maven/server/MavenIndexerCMDState$Companion\n*L\n93#1:227\n95#1:246\n92#1:214\n92#1:215,2\n93#1:217,9\n93#1:226\n93#1:228\n93#1:229\n94#1:230\n94#1:231,5\n95#1:236,9\n95#1:245\n95#1:247\n95#1:248\n162#1:249,9\n162#1:258\n162#1:259,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void addDependenciesFromMavenRepo(List<File> classPath) {
            String string = PathManager.getCommunityHomePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommunityHomePath(...)");
            String communityHomePath = string;
            Path mavenIndexerIml = Paths.get(communityHomePath, new String[0]).resolve("plugins/maven/maven-server-indexer/intellij.maven.server.indexer.iml");
            Intrinsics.checkNotNull((Object)mavenIndexerIml);
            List<String> list = this.parseDependenciesUrls(mavenIndexerIml);
            if (list == null) {
                throw new RuntimeException("Cannot parse maven.server.indexer.iml");
            }
            List<String> dependenciesUrls = list;
            PathMacros pathMacros = PathMacros.getInstance();
            String string2 = pathMacros.getValue("MAVEN_REPOSITORY");
            if (string2 == null) {
                throw new RuntimeException("Cannot find maven repo");
            }
            String pathToRepo = string2;
            for (String depTemplate : dependenciesUrls) {
                char c = '$';
                String string3 = "MAVEN_REPOSITORY";
                String url = StringsKt.replace$default((String)depTemplate, (String)(c + string3 + "$"), (String)pathToRepo, (boolean)false, (int)4, null);
                Path path2 = Paths.get(new URI(url));
                File jar = path2.toFile();
                if (!jar.isFile()) {
                    boolean bl = false;
                    String string4 = "File " + jar.getPath() + " not found";
                    throw new IllegalStateException(string4.toString());
                }
                Intrinsics.checkNotNull((Object)jar);
                classPath.add(jar);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> parseDependenciesUrls(Path pathToIml) {
            Collection destination$iv$iv;
            List list;
            Element element = JDOMUtil.load((Path)pathToIml);
            if (element == null) {
                return null;
            }
            Element root = element;
            Element element2 = root.getChild("component");
            if (element2 != null && (list = element2.getChildren()) != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                void $this$mapNotNullTo$iv$iv2;
                void $this$mapNotNull$iv2;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable iterable = list;
                boolean $i$f$filter22 = false;
                void var7_8 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Element it = (Element)element$iv$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"orderEntry") && Intrinsics.areEqual((Object)it.getAttributeValue("type"), (Object)"module-library"))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                Iterable $i$f$filter22 = (List)destination$iv$iv2;
                boolean $i$f$mapNotNull22 = false;
                destination$iv$iv2 = $this$mapNotNull$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach = false;
                Iterator bl = $this$forEach$iv$iv$iv.iterator();
                while (bl.hasNext()) {
                    Element it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = bl.next();
                    boolean bl2 = false;
                    Element it = (Element)element$iv$iv;
                    boolean bl3 = false;
                    Element element3 = it.getChild("library");
                    if ((element3 != null && (element3 = element3.getChild("properties")) != null ? element3.getChild("verification") : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl4 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                Iterable $i$f$mapNotNull22 = (List)destination$iv$iv3;
                boolean $i$f$flatMap22 = false;
                destination$iv$iv3 = $this$flatMap$iv;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    Element it = (Element)element$iv$iv;
                    boolean bl5 = false;
                    List list2 = it.getChildren("artifact");
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildren(...)");
                    Iterable list$iv$iv = list2;
                    CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
                }
                Iterable $i$f$flatMap22 = (List)destination$iv$iv4;
                boolean $i$f$mapNotNull = false;
                destination$iv$iv4 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl6 = false;
                    Element it = (Element)element$iv$iv;
                    boolean bl7 = false;
                    if (it.getAttributeValue("url") == null) continue;
                    boolean bl8 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
            } else {
                return null;
            }
            return (List)destination$iv$iv;
        }

        private final List<File> collectClassPathAndLibsFolder(MavenDistribution distribution) {
            File pluginFileOrDir = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
            String root = pluginFileOrDir.getParent();
            List classpath = new ArrayList();
            File file2 = distribution.getMavenHome().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            this.addMavenLibs(classpath, file2);
            this.addIndexerRTLibs(classpath);
            if (pluginFileOrDir.isDirectory()) {
                MavenLog.LOG.debug("collecting classpath for local run");
                String string = distribution.getVersion();
                Intrinsics.checkNotNull((Object)string);
                Intrinsics.checkNotNull((Object)root);
                this.prepareClassPathForLocalRunAndUnitTests(string, classpath, root);
                this.addDependenciesFromMavenRepo(classpath);
            } else {
                MavenLog.LOG.debug("collecting classpath for production");
                String string = distribution.getVersion();
                Intrinsics.checkNotNull((Object)string);
                Intrinsics.checkNotNull((Object)root);
                this.prepareClassPathForProduction(string, classpath, root);
            }
            Object[] objectArray = new Object[]{classpath};
            MavenLog.LOG.debug("Collected classpath = ", objectArray);
            return classpath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void addIndexerRTLibs(List<File> classpath) {
            List<String> resources = this.getIndexerRTList();
            File libDir = MavenUtil.getPluginSystemDir("rt-maven-indexer-lib").toFile();
            if (!libDir.isDirectory() && !libDir.mkdirs()) {
                throw new PluginException("Cannot create cache directory for maven", PluginId.getId((String)"org.jetbrains.idea.maven"));
            }
            for (String jarName : resources) {
                File file2 = new File(libDir, jarName);
                if (!file2.isFile()) {
                    try {
                        Closeable closeable = MavenIndexerCMDState.class.getClassLoader().getResourceAsStream(jarName);
                        Throwable throwable = null;
                        try {
                            int n;
                            InputStream is = (InputStream)closeable;
                            boolean bl = false;
                            Closeable closeable2 = new BufferedOutputStream(new FileOutputStream(file2));
                            Throwable throwable2 = null;
                            try {
                                BufferedOutputStream bos = (BufferedOutputStream)closeable2;
                                boolean bl2 = false;
                                if (is == null) {
                                    throw new PluginException("Cannot find runtime library " + jarName + " in resources", PluginId.getId((String)"org.jetbrains.idea.maven"));
                                }
                                n = StreamUtil.copy((InputStream)is, (OutputStream)bos);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                            }
                            int n2 = n;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    catch (IOException e) {
                        throw new PluginException("Cannot copy runtime library " + jarName + " into " + file2, (Throwable)e, PluginId.getId((String)"org.jetbrains.idea.maven"));
                    }
                }
                classpath.add(file2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final List<String> getIndexerRTList() {
            try {
                Closeable closeable = MavenIndexerCMDState.class.getClassLoader().getResourceAsStream("META-INF/org.jetbrains.idea.maven.maven-indexer-api-rt");
                Throwable throwable = null;
                try {
                    void $this$toTypedArray$iv;
                    List list;
                    Collection $this$dropLastWhile$iv;
                    InputStream is = (InputStream)closeable;
                    boolean bl = false;
                    if (is == null) {
                        throw new PluginException("Cannot find indexer rt libs", PluginId.findId((String)"org.jetbrains.idea.maven"));
                    }
                    String string = StreamUtil.readText((Reader)new InputStreamReader(is, Charsets.UTF_8));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readText(...)");
                    Object object = string;
                    Regex regex = new Regex("\n");
                    int n = 0;
                    object = regex.split((CharSequence)object, n);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            boolean bl2 = false;
                            if (((CharSequence)it).length() == 0) continue;
                            list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    $this$dropLastWhile$iv = list;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    List<String> list2 = Arrays.asList(Arrays.copyOf(stringArray, stringArray.length));
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"asList(...)");
                    List<String> list3 = list2;
                    return list3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                throw new PluginException((Throwable)e, PluginId.getId((String)"org.jetbrains.idea.maven"));
            }
        }

        private final void prepareClassPathForProduction(String mavenVersion, List<File> classpath, String root) {
            classpath.add(new File(PathUtil.getJarPathForClass(MavenId.class)));
            classpath.add(new File(PathUtil.getJarPathForClass(MavenServer.class)));
            classpath.add(new File(root, "maven-server-indexer.jar"));
            this.addDir(classpath, new File(root, "maven-server-indexer"));
            this.addDir(classpath, new File(new File(root, "intellij.maven.server.indexer"), "lib"));
        }

        private final void prepareClassPathForLocalRunAndUnitTests(String mavenVersion, List<File> classpath, String root) {
            classpath.add(new File(PathUtil.getJarPathForClass(MavenId.class)));
            classpath.add(new File(root, "intellij.maven.server"));
            classpath.add(new File(root, "intellij.maven.server.indexer"));
        }

        private final void addMavenLibs(List<File> classpath, File mavenHome) {
            this.addDir(classpath, new File(mavenHome, "lib"));
            File bootFolder = new File(mavenHome, "boot");
            File[] classworldsJars = bootFolder.listFiles(Companion::addMavenLibs$lambda$9);
            if (classworldsJars != null) {
                Collections.addAll((Collection)classpath, Arrays.copyOf(classworldsJars, classworldsJars.length));
            }
        }

        private final void addDir(List<File> classpath, File dir) {
            Object[] files2 = dir.listFiles();
            if (files2 == null) {
                return;
            }
            Iterator iterator = ArrayIteratorKt.iterator((Object[])files2);
            while (iterator.hasNext()) {
                File jar = (File)iterator.next();
                if (!jar.isFile()) continue;
                String string = jar.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNull((Object)jar);
                classpath.add(jar);
            }
        }

        private static final boolean addMavenLibs$lambda$9(File dir, String name) {
            String string = name;
            Intrinsics.checkNotNull((Object)string);
            return StringUtil.contains((CharSequence)string, (CharSequence)"classworlds");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

