/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.project.Project;
import java.io.File;
import java.nio.file.Path;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenIndices;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenIndexId;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.server.AddArtifactResponse;
import org.jetbrains.idea.maven.server.AsyncMavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenIndexUpdateState;
import org.jetbrains.idea.maven.server.MavenIndicesProcessor;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerIndexerException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0002H%J\b\u0010\u0006\u001a\u00020\u0002H\u0015J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u001e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0015J \u0010 \u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001eJ\"\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00170'J(\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\u0019J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0007J\u0010\u00102\u001a\u00020/2\u0006\u00100\u001a\u000201H$R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00063"}, d2={"Lorg/jetbrains/idea/maven/server/MavenIndexerWrapper;", "Lorg/jetbrains/idea/maven/server/MavenRemoteObjectWrapper;", "Lorg/jetbrains/idea/maven/server/MavenServerIndexer;", "<init>", "()V", "createBlocking", "getOrCreateWrappeeBlocking", "startIndexing", "Lorg/jetbrains/idea/maven/server/MavenIndexUpdateState;", "info", "Lorg/jetbrains/idea/maven/model/MavenRepositoryInfo;", "indexDir", "Ljava/io/File;", "stopIndexing", "", "status", "", "releaseIndex", "mavenIndexId", "Lorg/jetbrains/idea/maven/model/MavenIndexId;", "indexExists", "", "dir", "Ljava/nio/file/Path;", "indexCount", "", "getIndexCount", "()I", "updateIndex", "indicator", "Lorg/jetbrains/idea/maven/utils/MavenProgressIndicator;", "multithreaded", "processArtifacts", "processor", "Lorg/jetbrains/idea/maven/server/MavenIndicesProcessor;", "progress", "addArtifacts", "Lorg/jetbrains/idea/maven/server/AddArtifactResponse;", "artifactFiles", "", "search", "", "Lorg/jetbrains/idea/maven/model/MavenArtifactInfo;", "pattern", "", "maxResult", "getOrCreateIndices", "Lorg/jetbrains/idea/maven/indices/MavenIndices;", "project", "Lcom/intellij/openapi/project/Project;", "createMavenIndices", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenIndexerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenIndexerWrapper.kt\norg/jetbrains/idea/maven/server/MavenIndexerWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1557#2:173\n1628#2,3:174\n*S KotlinDebug\n*F\n+ 1 MavenIndexerWrapper.kt\norg/jetbrains/idea/maven/server/MavenIndexerWrapper\n*L\n154#1:173\n154#1:174,3\n*E\n"})
public abstract class MavenIndexerWrapper
extends MavenRemoteObjectWrapper<MavenServerIndexer> {
    @Deprecated(message="use suspend", replaceWith=@ReplaceWith(expression="create", imports={}))
    @ApiStatus.Internal
    @NotNull
    protected abstract MavenServerIndexer createBlocking() throws RemoteException;

    @Deprecated(message="use suspend", replaceWith=@ReplaceWith(expression="create", imports={}))
    @ApiStatus.Internal
    @NotNull
    protected synchronized MavenServerIndexer getOrCreateWrappeeBlocking() throws RemoteException {
        if (this.getMyWrappee() == null) {
            this.setMyWrappee(this.createBlocking());
        }
        Object t = this.getMyWrappee();
        Intrinsics.checkNotNull(t);
        return (MavenServerIndexer)t;
    }

    @Nullable
    public final MavenIndexUpdateState startIndexing(@Nullable MavenRepositoryInfo info, @Nullable File indexDir) {
        try {
            MavenServerIndexer w = this.getOrCreateWrappeeBlocking();
            if (!(w instanceof AsyncMavenServerIndexer)) {
                MavenLog.LOG.warn("wrappee not an instance of AsyncMavenServerIndexer, is dedicated indexer enabled?");
                return null;
            }
            return ((AsyncMavenServerIndexer)w).startIndexing(info, indexDir, MavenRemoteObjectWrapper.ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
            return null;
        }
    }

    public final void stopIndexing(@Nullable MavenRepositoryInfo info) {
        try {
            MavenServerIndexer w = this.getOrCreateWrappeeBlocking();
            if (!(w instanceof AsyncMavenServerIndexer)) {
                MavenLog.LOG.warn("wrappee not an instance of AsyncMavenServerIndexer, is dedicated indexer enabled?");
                return;
            }
            ((AsyncMavenServerIndexer)w).stopIndexing(info, MavenRemoteObjectWrapper.ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    @NotNull
    public final List<MavenIndexUpdateState> status() {
        try {
            MavenServerIndexer w = this.getOrCreateWrappeeBlocking();
            if (!(w instanceof AsyncMavenServerIndexer)) {
                MavenLog.LOG.warn("wrappee not an instance of AsyncMavenServerIndexer, is dedicated indexer enabled?");
                return CollectionsKt.emptyList();
            }
            ArrayList arrayList = ((AsyncMavenServerIndexer)w).status(MavenRemoteObjectWrapper.ourToken);
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"status(...)");
            return arrayList;
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
            return CollectionsKt.emptyList();
        }
    }

    public final void releaseIndex(@NotNull MavenIndexId mavenIndexId) throws MavenServerIndexerException {
        Intrinsics.checkNotNullParameter((Object)mavenIndexId, (String)"mavenIndexId");
        MavenLog.LOG.debug("releaseIndex " + mavenIndexId.indexId);
        MavenServerIndexer w = (MavenServerIndexer)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.releaseIndex(mavenIndexId, MavenRemoteObjectWrapper.ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    public final boolean indexExists(@Nullable Path dir) {
        try {
            return this.getOrCreateWrappeeBlocking().indexExists(dir, MavenRemoteObjectWrapper.ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
            return false;
        }
    }

    public final int getIndexCount() {
        return ((Number)this.perform(() -> MavenIndexerWrapper._get_indexCount_$lambda$0(this))).intValue();
    }

    public final void updateIndex(@NotNull MavenIndexId mavenIndexId, @NotNull MavenProgressIndicator indicator, boolean multithreaded) throws MavenProcessCanceledException, MavenServerIndexerException {
        Intrinsics.checkNotNullParameter((Object)mavenIndexId, (String)"mavenIndexId");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.performCancelable(indicator, () -> MavenIndexerWrapper.updateIndex$lambda$1(indicator, this, mavenIndexId, multithreaded));
    }

    public final void processArtifacts(@Nullable MavenIndexId mavenIndexId, @NotNull MavenIndicesProcessor processor, @NotNull MavenProgressIndicator progress) throws MavenServerIndexerException {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        this.perform(() -> MavenIndexerWrapper.processArtifacts$lambda$2(progress, this, mavenIndexId, processor));
    }

    @NotNull
    public final List<AddArtifactResponse> addArtifacts(@NotNull MavenIndexId mavenIndexId, @NotNull Collection<? extends Path> artifactFiles) {
        Intrinsics.checkNotNullParameter((Object)mavenIndexId, (String)"mavenIndexId");
        Intrinsics.checkNotNullParameter(artifactFiles, (String)"artifactFiles");
        return this.perform(() -> MavenIndexerWrapper.addArtifacts$lambda$4(this, mavenIndexId, artifactFiles));
    }

    @NotNull
    public final Set<MavenArtifactInfo> search(@Nullable MavenIndexId mavenIndexId, @Nullable String pattern, int maxResult) throws MavenServerIndexerException {
        return this.perform(() -> MavenIndexerWrapper.search$lambda$5(this, mavenIndexId, pattern, maxResult));
    }

    @ApiStatus.Internal
    @NotNull
    public final MavenIndices getOrCreateIndices(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.createMavenIndices(project);
    }

    @NotNull
    protected abstract MavenIndices createMavenIndices(@NotNull Project var1);

    private static final int _get_indexCount_$lambda$0(MavenIndexerWrapper this$0) {
        return this$0.getOrCreateWrappeeBlocking().getIndexCount(MavenRemoteObjectWrapper.ourToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit updateIndex$lambda$1(MavenProgressIndicator $indicator, MavenIndexerWrapper this$0, MavenIndexId $mavenIndexId, boolean $multithreaded) {
        MavenServerProgressIndicator indicatorWrapper = MavenRemoteObjectWrapper.Companion.wrapAndExport($indicator);
        try {
            this$0.getOrCreateWrappeeBlocking().updateIndex($mavenIndexId, indicatorWrapper, $multithreaded, MavenRemoteObjectWrapper.ourToken);
        }
        finally {
            UnicastRemoteObject.unexportObject((Remote)indicatorWrapper, true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit processArtifacts$lambda$2(MavenProgressIndicator $progress, MavenIndexerWrapper this$0, MavenIndexId $mavenIndexId, MavenIndicesProcessor $processor) {
        try {
            int start = 0;
            List list = null;
            do {
                if ($progress.isCanceled()) {
                    return Unit.INSTANCE;
                }
                MavenLog.LOG.debug("process artifacts: " + start);
                list = this$0.getOrCreateWrappeeBlocking().processArtifacts($mavenIndexId, start, MavenRemoteObjectWrapper.ourToken);
                if (list == null) continue;
                $processor.processArtifacts(list);
                start += ((ArrayList)list).size();
            } while (list != null);
            return Unit.INSTANCE;
        }
        catch (Exception e) {
            return Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List addArtifacts$lambda$4(MavenIndexerWrapper this$0, MavenIndexId $mavenIndexId, Collection $artifactFiles) {
        try {
            ArrayList arrayList = this$0.getOrCreateWrappeeBlocking().addArtifacts($mavenIndexId, new ArrayList($artifactFiles), MavenRemoteObjectWrapper.ourToken);
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"addArtifacts(...)");
            return arrayList;
        }
        catch (Throwable ignore) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $artifactFiles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file2;
                Path path2 = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = file2;
                collection.add(new AddArtifactResponse(v1 != null ? v1.toFile() : null, null));
            }
            return (List)destination$iv$iv;
        }
    }

    private static final HashSet search$lambda$5(MavenIndexerWrapper this$0, MavenIndexId $mavenIndexId, String $pattern, int $maxResult) {
        HashSet hashSet = this$0.getOrCreateWrappeeBlocking().search($mavenIndexId, $pattern, $maxResult, MavenRemoteObjectWrapper.ourToken);
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"search(...)");
        return hashSet;
    }
}

