/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.eel;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.LocalEelApi;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelFileSystemApiKt;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.server.RemotePathTransformerFactory;
import org.jetbrains.idea.maven.server.eel.EelRemotePathTransformFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/maven/server/eel/EelRemotePathTransformFactory;", "Lorg/jetbrains/idea/maven/server/RemotePathTransformerFactory;", "<init>", "()V", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "createTransformer", "Lorg/jetbrains/idea/maven/server/RemotePathTransformerFactory$Transformer;", "intellij.maven"})
public final class EelRemotePathTransformFactory
implements RemotePathTransformerFactory {
    @Override
    public boolean isApplicable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return !project.isDefault() && !Intrinsics.areEqual((Object)EelProviderUtil.getEelDescriptor((Project)project), (Object)LocalEelDescriptor.INSTANCE);
    }

    @Override
    @NotNull
    public RemotePathTransformerFactory.Transformer createTransformer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        EelApi eel = EelProviderUtil.upgradeBlocking((EelDescriptor)EelProviderUtil.getEelDescriptor((Project)project));
        return new RemotePathTransformerFactory.Transformer(eel, project){
            final /* synthetic */ EelApi $eel;
            final /* synthetic */ Project $project;
            {
                this.$eel = $eel;
                this.$project = $project;
            }

            public String toRemotePath(String localPath) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
                if (((CharSequence)localPath).length() == 0) {
                    return localPath;
                }
                Object object2 = this;
                try {
                    createTransformer.1 $this$toRemotePath_u24lambda_u240 = object2;
                    boolean bl = false;
                    Path path2 = Paths.get(localPath, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                    object = Result.constructor-impl((Object)EelNioBridgeServiceKt.asEelPath((Path)path2).toString());
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                String string = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
                if (string == null) {
                    string = localPath;
                }
                return string;
            }

            public String toIdePath(String remotePath) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
                if (((CharSequence)remotePath).length() == 0) {
                    return remotePath;
                }
                Path path2 = Paths.get(remotePath, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                String canonicalPath = NioPathUtil.toCanonicalPath((Path)path2);
                Object object2 = this;
                EelApi eelApi = this.$eel;
                Project project = this.$project;
                try {
                    createTransformer.1 $this$toIdePath_u24lambda_u241 = object2;
                    boolean bl = false;
                    EelPath eelPath = EelFileSystemApiKt.getPath((EelFileSystemApi)eelApi.getFs(), (String)canonicalPath);
                    Path fullyQualifiedPath = EelNioBridgeServiceKt.asNioPath((EelPath)eelPath, (Project)project);
                    object = Result.constructor-impl((Object)((Object)fullyQualifiedPath).toString());
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                String string = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
                if (string == null) {
                    string = remotePath;
                }
                return string;
            }

            public boolean canBeRemotePath(String s) {
                return !(this.$eel instanceof LocalEelApi);
            }
        };
    }
}

