/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.ssl;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.server.ssl.ReadForCertificates;
import org.jetbrains.idea.maven.server.ssl.SslDelegateHandlerStateMachine;
import org.jetbrains.idea.maven.server.ssl.State;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/maven/server/ssl/WaitForAuthType;", "Lorg/jetbrains/idea/maven/server/ssl/State;", "machine", "Lorg/jetbrains/idea/maven/server/ssl/SslDelegateHandlerStateMachine;", "key", "", "len", "<init>", "(Lorg/jetbrains/idea/maven/server/ssl/SslDelegateHandlerStateMachine;II)V", "getMachine", "()Lorg/jetbrains/idea/maven/server/ssl/SslDelegateHandlerStateMachine;", "getKey", "()I", "getLen", "addLine", "text", "", "intellij.maven"})
public final class WaitForAuthType
extends State {
    @NotNull
    private final SslDelegateHandlerStateMachine machine;
    private final int key;
    private final int len;

    public WaitForAuthType(@NotNull SslDelegateHandlerStateMachine machine, int key, int len) {
        Intrinsics.checkNotNullParameter((Object)machine, (String)"machine");
        super(null);
        this.machine = machine;
        this.key = key;
        this.len = len;
    }

    @NotNull
    public final SslDelegateHandlerStateMachine getMachine() {
        return this.machine;
    }

    public final int getKey() {
        return this.key;
    }

    public final int getLen() {
        return this.len;
    }

    @Override
    @NotNull
    public State addLine(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new ReadForCertificates(this.machine, this.key, this.len, this.len, text, new ArrayList<X509Certificate>());
    }
}

