/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.IndicesBundle;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenPluginInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0014\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001a\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0014\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u000bH\u0007J'\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\u0019J \u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0006H\u0007J \u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0006H\u0007J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0011H\u0007J0\u0010\u001b\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0007J6\u0010 \u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\u00062\b\u0010\"\u001a\u0004\u0018\u00010\u00062\b\u0010#\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0007J\u0012\u0010$\u001a\u00020\u00062\b\u0010%\u001a\u0004\u0018\u00010\u0006H\u0002J \u0010&\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0006H\u0002J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u000bH\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/idea/maven/utils/MavenArtifactUtil;", "", "<init>", "()V", "DEFAULT_GROUPS", "", "", "[Ljava/lang/String;", "MAVEN_PLUGIN_DESCRIPTOR", "ourPluginInfoCache", "", "Ljava/nio/file/Path;", "Lorg/jetbrains/idea/maven/utils/MavenPluginInfo;", "readPluginInfo", "localRepository", "Ljava/io/File;", "mavenId", "Lorg/jetbrains/idea/maven/model/MavenId;", "mavenArtifact", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "file", "hasArtifactFile", "", "id", "type", "hasArtifactFile$intellij_maven", "getArtifactFile", "isPluginIdEquals", "groupId1", "artifactId1", "groupId2", "artifactId2", "getArtifactNioPath", "groupId", "artifactId", "version", "sanitizeMavenIdentifier", "groupOrArtifactId", "getArtifactDirectory", "resolveVersion", "pluginDir", "createPluginDocument", "intellij.maven"})
public final class MavenArtifactUtil {
    @NotNull
    public static final MavenArtifactUtil INSTANCE = new MavenArtifactUtil();
    @JvmField
    @NotNull
    public static final String[] DEFAULT_GROUPS;
    @NotNull
    public static final String MAVEN_PLUGIN_DESCRIPTOR = "META-INF/maven/plugin.xml";
    @NotNull
    private static final Map<Path, MavenPluginInfo> ourPluginInfoCache;

    private MavenArtifactUtil() {
    }

    @JvmStatic
    @Deprecated(message="this method does not support split repositories")
    @Nullable
    public static final MavenPluginInfo readPluginInfo(@NotNull File localRepository, @NotNull MavenId mavenId) {
        Intrinsics.checkNotNullParameter((Object)localRepository, (String)"localRepository");
        Intrinsics.checkNotNullParameter((Object)mavenId, (String)"mavenId");
        Path path2 = localRepository.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
        return MavenArtifactUtil.readPluginInfo(path2, mavenId);
    }

    @JvmStatic
    @Deprecated(message="this method does not support split repositories")
    @Nullable
    public static final MavenPluginInfo readPluginInfo(@NotNull Path localRepository, @NotNull MavenId mavenId) {
        Intrinsics.checkNotNullParameter((Object)localRepository, (String)"localRepository");
        Intrinsics.checkNotNullParameter((Object)mavenId, (String)"mavenId");
        Path file2 = MavenArtifactUtil.getArtifactNioPath(localRepository, mavenId.getGroupId(), mavenId.getArtifactId(), mavenId.getVersion(), "jar");
        return MavenArtifactUtil.readPluginInfo(file2);
    }

    @JvmStatic
    @Nullable
    public static final MavenPluginInfo readPluginInfo(@Nullable MavenArtifact mavenArtifact) {
        Object object = mavenArtifact;
        if (object == null || (object = object.getFile()) == null || (object = ((File)object).toPath()) == null) {
            return null;
        }
        Object file2 = object;
        return MavenArtifactUtil.readPluginInfo((Path)file2);
    }

    @JvmStatic
    @Nullable
    public static final MavenPluginInfo readPluginInfo(@NotNull Path file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        MavenPluginInfo result2 = ourPluginInfoCache.get(file2);
        if (result2 == null) {
            result2 = INSTANCE.createPluginDocument(file2);
            ourPluginInfoCache.put(file2, result2);
        }
        return result2;
    }

    @JvmStatic
    @Deprecated(message="this method does not support split repositories")
    @JvmOverloads
    public static final boolean hasArtifactFile$intellij_maven(@NotNull Path localRepository, @NotNull MavenId id, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)localRepository, (String)"localRepository");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Files.exists(MavenArtifactUtil.getArtifactFile(localRepository, id, type), new LinkOption[0]);
    }

    public static /* synthetic */ boolean hasArtifactFile$intellij_maven$default(Path path2, MavenId mavenId, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "jar";
        }
        return MavenArtifactUtil.hasArtifactFile$intellij_maven(path2, mavenId, string);
    }

    @JvmStatic
    @Deprecated(message="this method does not support split repositories")
    @NotNull
    public static final Path getArtifactFile(@NotNull File localRepository, @NotNull MavenId id, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)localRepository, (String)"localRepository");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Path path2 = localRepository.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
        return MavenArtifactUtil.getArtifactNioPath(path2, id.getGroupId(), id.getArtifactId(), id.getVersion(), type);
    }

    @JvmStatic
    @Deprecated(message="this method does not support split repositories")
    @NotNull
    public static final Path getArtifactFile(@NotNull Path localRepository, @NotNull MavenId id, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)localRepository, (String)"localRepository");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return MavenArtifactUtil.getArtifactNioPath(localRepository, id.getGroupId(), id.getArtifactId(), id.getVersion(), type);
    }

    @JvmStatic
    @Deprecated(message="this method does not support split repositories")
    @NotNull
    public static final Path getArtifactFile(@NotNull Path localRepository, @NotNull MavenId id) {
        Intrinsics.checkNotNullParameter((Object)localRepository, (String)"localRepository");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return MavenArtifactUtil.getArtifactNioPath(localRepository, id.getGroupId(), id.getArtifactId(), id.getVersion(), "pom");
    }

    @JvmStatic
    public static final boolean isPluginIdEquals(@Nullable String groupId1, @Nullable String artifactId1, @Nullable String groupId2, @Nullable String artifactId2) {
        String groupId12 = groupId1;
        String groupId22 = groupId2;
        if (artifactId1 == null) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)artifactId1, (Object)artifactId2)) {
            return false;
        }
        if (groupId12 != null) {
            for (String group : DEFAULT_GROUPS) {
                if (!Intrinsics.areEqual((Object)groupId12, (Object)group)) continue;
                groupId12 = null;
                break;
            }
        }
        if (groupId22 != null) {
            for (String group : DEFAULT_GROUPS) {
                if (!Intrinsics.areEqual((Object)groupId22, (Object)group)) continue;
                groupId22 = null;
                break;
            }
        }
        return Intrinsics.areEqual((Object)groupId12, (Object)groupId22);
    }

    @JvmStatic
    @Deprecated(message="this method does not support split repositories")
    @NotNull
    public static final Path getArtifactNioPath(@NotNull Path localRepository, @Nullable String groupId, @Nullable String artifactId, @Nullable String version, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)localRepository, (String)"localRepository");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String groupId2 = groupId;
        String artifactId2 = artifactId;
        String version2 = version;
        groupId2 = INSTANCE.sanitizeMavenIdentifier(groupId2);
        artifactId2 = INSTANCE.sanitizeMavenIdentifier(artifactId2);
        version2 = INSTANCE.sanitizeMavenIdentifier(version2);
        Path dir = null;
        if (StringUtil.isEmpty((String)groupId2)) {
            String each;
            String[] stringArray = DEFAULT_GROUPS;
            int n = stringArray.length;
            for (int j = 0; j < n && !Files.exists(dir = INSTANCE.getArtifactDirectory(localRepository, each = stringArray[j], artifactId2), new LinkOption[0]); ++j) {
            }
        } else {
            dir = INSTANCE.getArtifactDirectory(localRepository, groupId2, artifactId2);
        }
        if (StringUtil.isEmpty((String)version2)) {
            Path path2 = dir;
            Intrinsics.checkNotNull((Object)path2);
            version2 = INSTANCE.resolveVersion(path2);
        }
        Path path3 = dir;
        Intrinsics.checkNotNull((Object)path3);
        Path path4 = path3.resolve(version2).resolve(artifactId2 + "-" + version2 + "." + type);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        return path4;
    }

    private final String sanitizeMavenIdentifier(String groupOrArtifactId) {
        if (groupOrArtifactId == null) {
            return "";
        }
        StringBuilder result2 = new StringBuilder(groupOrArtifactId.length());
        for (int j = 0; j < ((CharSequence)groupOrArtifactId).length(); ++j) {
            char c = ((CharSequence)groupOrArtifactId).charAt(j);
            if (!Character.isLetterOrDigit(c) && c != '-' && c != '.' && c != '_') continue;
            result2.append(c);
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final Path getArtifactDirectory(Path localRepository, String groupId, String artifactId) {
        String groupId2 = groupId;
        String artifactId2 = artifactId;
        groupId2 = this.sanitizeMavenIdentifier(groupId2);
        artifactId2 = this.sanitizeMavenIdentifier(artifactId2);
        Path path2 = localRepository.resolve(StringUtil.replace((String)groupId2, (String)".", (String)File.separator)).resolve(artifactId2);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String resolveVersion(Path pluginDir) {
        List versions = new ArrayList();
        try {
            AutoCloseable autoCloseable = Files.list(pluginDir);
            Throwable throwable = null;
            try {
                Stream children = (Stream)autoCloseable;
                boolean bl = false;
                children.forEach(arg_0 -> MavenArtifactUtil.resolveVersion$lambda$2$lambda$1(arg_0 -> MavenArtifactUtil.resolveVersion$lambda$2$lambda$0(versions, arg_0), arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException e) {
            return "";
        }
        catch (Exception e) {
            MavenLog.LOG.warn(e.getMessage());
            return "";
        }
        if (versions.isEmpty()) {
            return "";
        }
        CollectionsKt.sort((List)versions);
        return (String)versions.get(versions.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MavenPluginInfo createPluginDocument(Path file2) {
        try {
            if (!Files.exists(file2, new LinkOption[0])) {
                return null;
            }
            Closeable closeable = (Closeable)new JBZipFile(file2.toFile());
            Throwable throwable = null;
            try {
                MavenPluginInfo mavenPluginInfo;
                JBZipFile jar = (JBZipFile)closeable;
                boolean bl = false;
                JBZipEntry entry = jar.getEntry(MAVEN_PLUGIN_DESCRIPTOR);
                if (entry == null) {
                    Object[] objectArray = new Object[]{file2};
                    MavenLog.LOG.info(IndicesBundle.message("repository.plugin.corrupt", objectArray));
                    MavenPluginInfo mavenPluginInfo2 = null;
                    return mavenPluginInfo2;
                }
                Closeable closeable2 = entry.getInputStream();
                Throwable throwable2 = null;
                try {
                    InputStream is = (InputStream)closeable2;
                    boolean bl2 = false;
                    byte[] byArray = FileUtil.loadBytes((InputStream)is);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"loadBytes(...)");
                    byte[] bytes = byArray;
                    mavenPluginInfo = new MavenPluginInfo(bytes);
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            CloseableKt.closeFinally((Closeable)closeable2, throwable2);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                MavenPluginInfo mavenPluginInfo3 = mavenPluginInfo;
                return mavenPluginInfo3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            MavenLog.LOG.info((Throwable)e);
            return null;
        }
    }

    @JvmStatic
    @Deprecated(message="this method does not support split repositories")
    @JvmOverloads
    public static final boolean hasArtifactFile$intellij_maven(@NotNull Path localRepository, @NotNull MavenId id) {
        Intrinsics.checkNotNullParameter((Object)localRepository, (String)"localRepository");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return MavenArtifactUtil.hasArtifactFile$intellij_maven$default(localRepository, id, null, 4, null);
    }

    private static final Unit resolveVersion$lambda$2$lambda$0(List $versions, Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        if (Files.isDirectory(path2, new LinkOption[0])) {
            $versions.add(((Object)path2.getFileName()).toString());
        }
        return Unit.INSTANCE;
    }

    private static final void resolveVersion$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        String[] stringArray = new String[]{"org.apache.maven.plugins", "org.codehaus.mojo"};
        DEFAULT_GROUPS = stringArray;
        Map map = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        ourPluginInfoCache = map;
    }
}

