/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;

public class MavenPluginInfo {
    private final String myGroupId;
    private final String myArtifactId;
    private final String myVersion;
    private final String myGoalPrefix;
    private final Map<String, Mojo> myMojos;

    public MavenPluginInfo(byte[] text) {
        Element plugin = MavenJDOMUtil.read(text, null);
        this.myGroupId = MavenJDOMUtil.findChildValueByPath(plugin, "groupId", "Unknown");
        this.myArtifactId = MavenJDOMUtil.findChildValueByPath(plugin, "artifactId", "Unknown");
        this.myVersion = MavenJDOMUtil.findChildValueByPath(plugin, "version", "Unknown");
        this.myGoalPrefix = MavenJDOMUtil.findChildValueByPath(plugin, "goalPrefix", "unknown");
        this.myMojos = this.readMojos(plugin);
    }

    private Map<String, Mojo> readMojos(Element plugin) {
        LinkedHashMap<String, Mojo> result2 = new LinkedHashMap<String, Mojo>();
        for (Element each : MavenJDOMUtil.findChildrenByPath(plugin, "mojos", "mojo")) {
            String goal = MavenJDOMUtil.findChildValueByPath(each, "goal", "unknown");
            result2.put(goal, new Mojo(goal));
        }
        return result2;
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    public String getArtifactId() {
        return this.myArtifactId;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public String getGoalPrefix() {
        return this.myGoalPrefix;
    }

    public Collection<Mojo> getMojos() {
        return this.myMojos.values();
    }

    public Mojo findMojo(String name) {
        return this.myMojos.get(name);
    }

    public final class Mojo {
        private final String myGoal;

        private Mojo(String goal) {
            this.myGoal = goal;
        }

        public String getGoal() {
            return this.myGoal;
        }

        public String getDisplayName() {
            return MavenPluginInfo.this.myGoalPrefix + ":" + this.myGoal;
        }

        public String getQualifiedGoal() {
            StringBuilder builder2 = new StringBuilder();
            MavenId.append((StringBuilder)builder2, (String)MavenPluginInfo.this.myGroupId);
            MavenId.append((StringBuilder)builder2, (String)MavenPluginInfo.this.myArtifactId);
            MavenId.append((StringBuilder)builder2, (String)MavenPluginInfo.this.myVersion);
            MavenId.append((StringBuilder)builder2, (String)this.myGoal);
            return builder2.toString();
        }
    }
}

