/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.util.SystemInfoRt;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;

public final class NioFiles {
    public static void rename(@NotNull Path source, @NotNull Path target) throws IOException {
        if (source == null) {
            NioFiles.$$$reportNull$$$0(0);
        }
        if (target == null) {
            NioFiles.$$$reportNull$$$0(1);
        }
        try {
            Files.move(source, target, new CopyOption[0]);
            return;
        }
        catch (IOException iOException) {
            if (!Files.exists(source, new LinkOption[0])) {
                return;
            }
            NioFiles.copyRecursively(source, target);
            NioFiles.delete(source);
            return;
        }
    }

    public static void copyRecursively(final @NotNull Path from, final @NotNull Path to) throws IOException {
        if (from == null) {
            NioFiles.$$$reportNull$$$0(2);
        }
        if (to == null) {
            NioFiles.$$$reportNull$$$0(3);
        }
        Files.walkFileTree(from, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path copy = dir == from ? to : to.resolve(from.relativize(dir));
                com.intellij.openapi.util.io.NioFiles.createDirectories((Path)copy);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
                Path copy = file2 == from ? to : to.resolve(from.relativize(file2));
                Files.copy(file2, copy, LinkOption.NOFOLLOW_LINKS, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void delete(@NotNull Path path2) throws IOException {
        if (path2 == null) {
            NioFiles.$$$reportNull$$$0(4);
        }
        if (Files.isDirectory(path2, new LinkOption[0])) {
            try (DirectoryStream<Path> entries = Files.newDirectoryStream(path2);){
                for (Path entry : entries) {
                    NioFiles.delete(entry);
                }
            }
            Files.delete(path2);
        } else {
            Files.delete(path2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rename(@NotNull Path source, @NotNull String newName) throws IOException {
        if (source == null) {
            NioFiles.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            NioFiles.$$$reportNull$$$0(6);
        }
        Path target = source.resolveSibling(newName);
        String sourceName = source.getFileName().toString();
        if (!SystemInfoRt.isFileSystemCaseSensitive && newName.equalsIgnoreCase(sourceName)) {
            Path intermediate = Files.createTempFile(source.getParent(), sourceName, ".tmp", new FileAttribute[0]);
            try {
                Files.deleteIfExists(intermediate);
                Files.move(source, intermediate, StandardCopyOption.REPLACE_EXISTING);
                Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                Files.deleteIfExists(intermediate);
            }
        } else {
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/utils/NioFiles";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "rename";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "copyRecursively";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "delete";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

