/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppConsoleFontOptions;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.colors.impl.AppFontOptions;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.util.Disposer;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.PersistentTerminalFontPreferences;
import org.jetbrains.plugins.terminal.TerminalFontOptionsKt;
import org.jetbrains.plugins.terminal.TerminalFontOptionsListener;
import org.jetbrains.plugins.terminal.TerminalFontSettings;

@State(name="TerminalFontOptions", storages={@Storage(value="terminal-font.xml")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0010J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\b\u0010\u0018\u001a\u00020\u000bH\u0016J\b\u0010\u0019\u001a\u00020\u000bH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalFontOptions;", "Lcom/intellij/openapi/editor/colors/impl/AppFontOptions;", "Lorg/jetbrains/plugins/terminal/PersistentTerminalFontPreferences;", "<init>", "()V", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lorg/jetbrains/plugins/terminal/TerminalFontOptionsListener;", "columnSpacing", "", "addListener", "", "listener", "disposable", "Lcom/intellij/openapi/Disposable;", "getSettings", "Lorg/jetbrains/plugins/terminal/TerminalFontSettings;", "setSettings", "settings", "createFontState", "fontPreferences", "Lcom/intellij/openapi/editor/colors/FontPreferences;", "loadState", "state", "noStateLoaded", "fireListeners", "Companion", "intellij.terminal"})
@ApiStatus.Internal
public final class TerminalFontOptions
extends AppFontOptions<PersistentTerminalFontPreferences> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CopyOnWriteArrayList<TerminalFontOptionsListener> listeners = new CopyOnWriteArrayList();
    private float columnSpacing = 1.0f;
    @NotNull
    public static final String COMPONENT_NAME = "TerminalFontOptions";

    public final void addListener(@NotNull TerminalFontOptionsListener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.listeners.add(listener2);
        Disposer.register((Disposable)disposable, () -> TerminalFontOptions.addListener$lambda$0(this, listener2));
    }

    @NotNull
    public final TerminalFontSettings getSettings() {
        FontPreferences fontPreferences = this.getFontPreferences();
        Intrinsics.checkNotNullExpressionValue((Object)fontPreferences, (String)"getFontPreferences(...)");
        FontPreferences preferences = fontPreferences;
        String string = preferences.getFontFamily();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFontFamily(...)");
        return new TerminalFontSettings(string, preferences.getSize2D(preferences.getFontFamily()), preferences.getLineSpacing(), this.columnSpacing);
    }

    public final void setSettings(@NotNull TerminalFontSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        TerminalFontSettings oldSettings = this.getSettings();
        FontPreferencesImpl newPreferences = new FontPreferencesImpl();
        AppConsoleFontOptions.getInstance().getFontPreferences().copyTo((FontPreferences)newPreferences);
        newPreferences.clearFonts();
        newPreferences.addFontFamily(settings.getFontFamily());
        newPreferences.setFontSize(settings.getFontFamily(), settings.getFontSize());
        newPreferences.setLineSpacing(settings.getLineSpacing());
        this.columnSpacing = settings.getColumnSpacing();
        this.update((FontPreferences)newPreferences);
        if (!Intrinsics.areEqual((Object)settings, (Object)oldSettings)) {
            this.fireListeners();
        }
    }

    @NotNull
    protected PersistentTerminalFontPreferences createFontState(@NotNull FontPreferences fontPreferences) {
        PersistentTerminalFontPreferences persistentTerminalFontPreferences;
        Intrinsics.checkNotNullParameter((Object)fontPreferences, (String)"fontPreferences");
        PersistentTerminalFontPreferences it = persistentTerminalFontPreferences = new PersistentTerminalFontPreferences(fontPreferences);
        boolean bl = false;
        it.setCOLUMN_SPACING(this.columnSpacing);
        return persistentTerminalFontPreferences;
    }

    public void loadState(@NotNull PersistentTerminalFontPreferences state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.columnSpacing = state.getCOLUMN_SPACING();
        super.loadState((AppEditorFontOptions.PersistentFontPreferences)state);
        this.fireListeners();
    }

    public void noStateLoaded() {
        FontPreferences fontPreferences = AppConsoleFontOptions.getInstance().getFontPreferences();
        Intrinsics.checkNotNullExpressionValue((Object)fontPreferences, (String)"getFontPreferences(...)");
        PersistentTerminalFontPreferences defaultState = new PersistentTerminalFontPreferences(fontPreferences);
        float userSetConsoleLineSpacing = defaultState.LINE_SPACING;
        float defaultConsoleLineSpacing = 1.2f;
        if (TerminalFontOptionsKt.sameLineSpacings(userSetConsoleLineSpacing, defaultConsoleLineSpacing)) {
            defaultState.LINE_SPACING = 1.0f;
        }
        this.loadState(defaultState);
    }

    private final void fireListeners() {
        Iterator<TerminalFontOptionsListener> iterator = this.listeners.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<TerminalFontOptionsListener> iterator2 = iterator;
        while (iterator2.hasNext()) {
            TerminalFontOptionsListener listener2 = iterator2.next();
            listener2.fontOptionsChanged();
        }
    }

    private static final void addListener$lambda$0(TerminalFontOptions this$0, TerminalFontOptionsListener $listener) {
        this$0.listeners.remove($listener);
    }

    @JvmStatic
    @NotNull
    public static final TerminalFontOptions getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalFontOptions$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/plugins/terminal/TerminalFontOptions;", "COMPONENT_NAME", "", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalFontOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalFontOptions.kt\norg/jetbrains/plugins/terminal/TerminalFontOptions$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,178:1\n40#2,3:179\n*S KotlinDebug\n*F\n+ 1 TerminalFontOptions.kt\norg/jetbrains/plugins/terminal/TerminalFontOptions$Companion\n*L\n25#1:179,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TerminalFontOptions getInstance() {
            boolean $i$f$service = false;
            Class<TerminalFontOptions> serviceClass$iv = TerminalFontOptions.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (TerminalFontOptions)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

