/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.terminal.TerminalFontSizeProvider;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalFontOptions;
import org.jetbrains.plugins.terminal.TerminalFontOptionsKt;
import org.jetbrains.plugins.terminal.TerminalFontOptionsListener;
import org.jetbrains.plugins.terminal.TerminalUtil;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0001\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\tH\u0002J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalFontSizeProviderImpl;", "Lcom/intellij/terminal/TerminalFontSizeProvider;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/intellij/terminal/TerminalFontSizeProvider$Listener;", "fontSize", "", "Ljava/lang/Float;", "getFontSize", "", "getFontSize2D", "setFontSize", "", "newSize", "resetFontSize", "getDefaultScaledFontSize", "addListener", "parentDisposable", "listener", "dispose", "Companion", "intellij.terminal"})
public final class TerminalFontSizeProviderImpl
implements TerminalFontSizeProvider,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CopyOnWriteArrayList<TerminalFontSizeProvider.Listener> listeners = new CopyOnWriteArrayList();
    @Nullable
    private Float fontSize;

    public TerminalFontSizeProviderImpl() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = UISettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> TerminalFontSizeProviderImpl._init_$lambda$0(this, arg_0));
        TerminalFontOptions.Companion.getInstance().addListener(new TerminalFontOptionsListener(){

            @Override
            public void fontOptionsChanged() {
                this.resetFontSize();
            }
        }, this);
    }

    public int getFontSize() {
        return MathKt.roundToInt((float)this.getFontSize2D());
    }

    public float getFontSize2D() {
        Float size = this.fontSize;
        if (size == null) {
            this.fontSize = size = Float.valueOf(this.getDefaultScaledFontSize());
        }
        return size.floatValue();
    }

    public void setFontSize(float newSize) {
        Float oldSize = this.fontSize;
        if (oldSize == null || !TerminalFontOptionsKt.sameFontSizes(oldSize.floatValue(), newSize)) {
            this.fontSize = Float.valueOf(newSize);
            Iterator<TerminalFontSizeProvider.Listener> iterator = this.listeners.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<TerminalFontSizeProvider.Listener> iterator2 = iterator;
            while (iterator2.hasNext()) {
                TerminalFontSizeProvider.Listener listener2 = iterator2.next();
                listener2.fontChanged();
            }
        }
    }

    public void resetFontSize() {
        this.setFontSize(this.getDefaultScaledFontSize());
    }

    private final float getDefaultScaledFontSize() {
        return UISettingsUtils.Companion.getInstance().scaleFontSize(TerminalFontOptions.Companion.getInstance().getSettings().getFontSize());
    }

    public void addListener(@NotNull Disposable parentDisposable, @NotNull TerminalFontSizeProvider.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        TerminalUtil.addItem((List)this.listeners, listener2, parentDisposable);
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(TerminalFontSizeProviderImpl this$0, UISettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.resetFontSize();
    }

    @JvmStatic
    @NotNull
    public static final TerminalFontSizeProviderImpl getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalFontSizeProviderImpl$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/plugins/terminal/TerminalFontSizeProviderImpl;", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalFontSizeProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalFontSizeProviderImpl.kt\norg/jetbrains/plugins/terminal/TerminalFontSizeProviderImpl$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,74:1\n40#2,3:75\n*S KotlinDebug\n*F\n+ 1 TerminalFontSizeProviderImpl.kt\norg/jetbrains/plugins/terminal/TerminalFontSizeProviderImpl$Companion\n*L\n72#1:75,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TerminalFontSizeProviderImpl getInstance() {
            boolean $i$f$service = false;
            Class<TerminalFontSizeProviderImpl> serviceClass$iv = TerminalFontSizeProviderImpl.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (TerminalFontSizeProviderImpl)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

