/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.FontComboBox;
import com.intellij.ui.FontInfoRenderer;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicate;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalOptionsConfigurable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001aE\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\b\b\u0000\u0010\t*\u00020\n*\b\u0012\u0004\u0012\u0002H\t0\b2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\b\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\b\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\b\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\b\u0010\u0014\u001a\u00020\u0013H\u0002\u001a!\u0010\u0015\u001a\u00020\u00132\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0018\u001a\b\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\f\u0010\u001b\u001a\u00020\u0001*\u00020\u001cH\u0002\u001a\f\u0010\u001d\u001a\u00020\u001c*\u00020\u0001H\u0002\u001a\f\u0010\u001e\u001a\u00020\u0001*\u00020\u001cH\u0002\u001a\f\u0010\u001f\u001a\u00020\u0001*\u00020\u001cH\u0002\u001a\f\u0010 \u001a\u00020\u001c*\u00020\u0001H\u0002\u001a\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002\u001a\u0010\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002\u001a\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010#\u001a\u00020$H\u0002\"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"TERMINAL_CONFIGURABLE_ID", "", "configurables", "", "Lcom/intellij/ui/dsl/builder/Panel;", "", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "setupDefaultValue", "Lcom/intellij/ui/dsl/builder/Cell;", "T", "Ljavax/swing/JComponent;", "textComponent", "Lkotlin/Function1;", "Ljavax/swing/JTextField;", "Lkotlin/ExtensionFunctionType;", "defaultValue", "newUiPredicate", "Lcom/intellij/ui/layout/ComponentPredicate;", "getDefaultValueColor", "Ljava/awt/Color;", "getChangedValueColor", "findColorByKey", "colorKeys", "", "([Ljava/lang/String;)Ljava/awt/Color;", "fontComboBox", "Lcom/intellij/ui/FontComboBox;", "fontSizeToString", "", "parseFontSize", "spacingToString", "formatWithOneDecimalDigit", "parseSpacing", "isMac", "", "project", "Lcom/intellij/openapi/project/Project;", "isWindows", "getClientSystemInfo", "Lcom/intellij/openapi/client/ClientSystemInfo;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalOptionsConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOptionsConfigurable.kt\norg/jetbrains/plugins/terminal/TerminalOptionsConfigurableKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,390:1\n1#2:391\n15#3:392\n*S KotlinDebug\n*F\n+ 1 TerminalOptionsConfigurable.kt\norg/jetbrains/plugins/terminal/TerminalOptionsConfigurableKt\n*L\n389#1:392\n*E\n"})
public final class TerminalOptionsConfigurableKt {
    @ApiStatus.Internal
    @NotNull
    public static final String TERMINAL_CONFIGURABLE_ID = "terminal";
    @NotNull
    private static final Logger LOG;

    private static final void configurables(Panel $this$configurables, List<? extends UnnamedConfigurable> configurables) {
        for (UnnamedConfigurable unnamedConfigurable : configurables) {
            JComponent component2;
            if (unnamedConfigurable.createComponent() == null) continue;
            Panel.row$default((Panel)$this$configurables, null, arg_0 -> TerminalOptionsConfigurableKt.configurables$lambda$3(component2, unnamedConfigurable, arg_0), (int)1, null);
        }
    }

    private static final <T extends JComponent> Cell<T> setupDefaultValue(Cell<? extends T> $this$setupDefaultValue, Function1<? super T, ? extends JTextField> textComponent, String defaultValue) {
        Cell<? extends T> cell;
        Cell<? extends T> $this$setupDefaultValue_u24lambda_u244 = cell = $this$setupDefaultValue;
        boolean bl = false;
        CharSequence charSequence = defaultValue;
        if (!(charSequence == null || charSequence.length() == 0)) {
            JTextField component2 = (JTextField)textComponent.invoke((Object)$this$setupDefaultValue_u24lambda_u244.getComponent());
            component2.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(component2, defaultValue){
                final /* synthetic */ JTextField $component;
                final /* synthetic */ String $defaultValue;
                {
                    this.$component = $component;
                    this.$defaultValue = $defaultValue;
                }

                protected void textChanged(DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$component.setForeground(Intrinsics.areEqual((Object)this.$component.getText(), (Object)this.$defaultValue) ? TerminalOptionsConfigurableKt.access$getDefaultValueColor() : TerminalOptionsConfigurableKt.access$getChangedValueColor());
                }
            });
            if (component2 instanceof JBTextField) {
                ((JBTextField)component2).getEmptyText().setText(defaultValue);
            }
        }
        return cell;
    }

    private static final ComponentPredicate newUiPredicate() {
        return ExperimentalUI.Companion.isNewUI() ? ComponentPredicate.Companion.getTRUE() : ComponentPredicate.Companion.getFALSE();
    }

    private static final Color getDefaultValueColor() {
        String[] stringArray = new String[]{"TextField.inactiveForeground", "nimbusDisabledText"};
        return TerminalOptionsConfigurableKt.findColorByKey(stringArray);
    }

    private static final Color getChangedValueColor() {
        String[] stringArray = new String[]{"TextField.foreground"};
        return TerminalOptionsConfigurableKt.findColorByKey(stringArray);
    }

    private static final Color findColorByKey(String ... colorKeys) {
        Color color;
        block3: {
            for (String it : colorKeys) {
                boolean bl = false;
                color = UIManager.getColor(it);
                if (color == null) {
                    continue;
                }
                break block3;
            }
            color = null;
        }
        if (color == null) {
            String string = Arrays.toString(colorKeys);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            throw new IllegalStateException("Can't find color for keys " + string);
        }
        return color;
    }

    private static final FontComboBox fontComboBox() {
        FontComboBox fontComboBox2;
        FontComboBox $this$fontComboBox_u24lambda_u246 = fontComboBox2 = new FontComboBox();
        boolean bl = false;
        $this$fontComboBox_u24lambda_u246.setRenderer((ListCellRenderer)new FontInfoRenderer(){

            protected boolean isEditorFont() {
                return true;
            }
        });
        $this$fontComboBox_u24lambda_u246.setMonospacedOnly(true);
        return fontComboBox2;
    }

    private static final String fontSizeToString(float $this$fontSizeToString) {
        return TerminalOptionsConfigurableKt.formatWithOneDecimalDigit($this$fontSizeToString);
    }

    private static final float parseFontSize(String $this$parseFontSize) {
        float f;
        try {
            f = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(Float.parseFloat($this$parseFontSize)), (ClosedFloatingPointRange)RangesKt.rangeTo((float)EditorFontsConstants.getMinEditorFontSize(), (float)EditorFontsConstants.getMaxEditorFontSize())))).floatValue();
        }
        catch (Exception exception) {
            f = EditorFontsConstants.getDefaultEditorFontSize();
        }
        return f;
    }

    private static final String spacingToString(float $this$spacingToString) {
        return TerminalOptionsConfigurableKt.formatWithOneDecimalDigit($this$spacingToString);
    }

    private static final String formatWithOneDecimalDigit(float $this$formatWithOneDecimalDigit) {
        Locale locale = Locale.ROOT;
        String string = "%.1f";
        Object[] objectArray = new Object[]{Float.valueOf($this$formatWithOneDecimalDigit)};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final float parseSpacing(String $this$parseSpacing) {
        float f;
        try {
            f = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(Float.parseFloat($this$parseSpacing)), (ClosedFloatingPointRange)RangesKt.rangeTo((float)EditorFontsConstants.getMinEditorLineSpacing(), (float)EditorFontsConstants.getMaxEditorLineSpacing())))).floatValue();
        }
        catch (Exception exception) {
            f = 1.0f;
        }
        return f;
    }

    private static final boolean isMac(Project project) {
        Object object = TerminalOptionsConfigurableKt.getClientSystemInfo(project);
        return object != null && (object = object.getMacClient()) != null ? (Boolean)object : SystemInfo.isMac;
    }

    private static final boolean isWindows(Project project) {
        Object object = TerminalOptionsConfigurableKt.getClientSystemInfo(project);
        return object != null && (object = object.getWindowsClient()) != null ? (Boolean)object : SystemInfo.isWindows;
    }

    private static final ClientSystemInfo getClientSystemInfo(Project project) {
        ClientProjectSession clientProjectSession = (ClientProjectSession)CollectionsKt.singleOrNull((List)ClientSessionsUtil.sessions((Project)project, (ClientKind)ClientKind.CONTROLLER));
        if (clientProjectSession == null || (clientProjectSession = clientProjectSession.getClientId()) == null) {
            return null;
        }
        ClientProjectSession clientId = clientProjectSession;
        return (ClientSystemInfo)ClientId.Companion.withExplicitClientId((ClientId)clientId, TerminalOptionsConfigurableKt::getClientSystemInfo$lambda$7);
    }

    private static final Unit configurables$lambda$3$lambda$0(UnnamedConfigurable $configurable) {
        try {
            $configurable.apply();
        }
        catch (Exception e) {
            LOG.warn("Terminal configurable " + $configurable + " threw an exception on apply", (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    private static final Unit configurables$lambda$3$lambda$1(UnnamedConfigurable $configurable) {
        try {
            $configurable.reset();
        }
        catch (Exception e) {
            LOG.warn("Terminal configurable " + $configurable + " threw an exception on reset", (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    private static final boolean configurables$lambda$3$lambda$2(UnnamedConfigurable $configurable) {
        return $configurable.isModified();
    }

    private static final Unit configurables$lambda$3(JComponent $component, UnnamedConfigurable $configurable, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell($component).onApply(() -> TerminalOptionsConfigurableKt.configurables$lambda$3$lambda$0($configurable)).onReset(() -> TerminalOptionsConfigurableKt.configurables$lambda$3$lambda$1($configurable)).onIsModified(() -> TerminalOptionsConfigurableKt.configurables$lambda$3$lambda$2($configurable));
        return Unit.INSTANCE;
    }

    private static final ClientSystemInfo getClientSystemInfo$lambda$7() {
        return ClientSystemInfo.Companion.getInstance();
    }

    public static final /* synthetic */ void access$configurables(Panel $receiver, List configurables) {
        TerminalOptionsConfigurableKt.configurables($receiver, configurables);
    }

    public static final /* synthetic */ Cell access$setupDefaultValue(Cell $receiver, Function1 textComponent, String defaultValue) {
        return TerminalOptionsConfigurableKt.setupDefaultValue($receiver, textComponent, defaultValue);
    }

    public static final /* synthetic */ FontComboBox access$fontComboBox() {
        return TerminalOptionsConfigurableKt.fontComboBox();
    }

    public static final /* synthetic */ String access$fontSizeToString(float $receiver) {
        return TerminalOptionsConfigurableKt.fontSizeToString($receiver);
    }

    public static final /* synthetic */ float access$parseFontSize(String $receiver) {
        return TerminalOptionsConfigurableKt.parseFontSize($receiver);
    }

    public static final /* synthetic */ String access$spacingToString(float $receiver) {
        return TerminalOptionsConfigurableKt.spacingToString($receiver);
    }

    public static final /* synthetic */ float access$parseSpacing(String $receiver) {
        return TerminalOptionsConfigurableKt.parseSpacing($receiver);
    }

    public static final /* synthetic */ boolean access$isMac(Project project) {
        return TerminalOptionsConfigurableKt.isMac(project);
    }

    public static final /* synthetic */ boolean access$isWindows(Project project) {
        return TerminalOptionsConfigurableKt.isWindows(project);
    }

    public static final /* synthetic */ ComponentPredicate access$newUiPredicate() {
        return TerminalOptionsConfigurableKt.newUiPredicate();
    }

    public static final /* synthetic */ Color access$getDefaultValueColor() {
        return TerminalOptionsConfigurableKt.getDefaultValueColor();
    }

    public static final /* synthetic */ Color access$getChangedValueColor() {
        return TerminalOptionsConfigurableKt.getChangedValueColor();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalOptionsConfigurable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

