/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.KeyCollectionForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentStringEnumerator;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.NameEnumerator;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;

public class CompilerReferenceIndex<Input> {
    private static final Logger LOG = Logger.getInstance(CompilerReferenceIndex.class);
    private static final String FILE_ENUM_TAB = "file.path.enum.tab";
    private static final String NAME_ENUM_TAB = "name.tab";
    private static final String VERSION_FILE = "version";
    private final ConcurrentMap<IndexId<?, ?>, InvertedIndex<?, ?, Input>> myIndices;
    private final NameEnumerator myNameEnumerator;
    private final PersistentStringEnumerator myFilePathEnumerator;
    private final Path myBuildDir;
    private final Path indexDir;
    private final LowMemoryWatcher myLowMemoryWatcher = LowMemoryWatcher.register(() -> this.force());
    private volatile Throwable myRebuildRequestCause;

    public CompilerReferenceIndex(Collection<? extends IndexExtension<?, ?, ? super Input>> indices, Path buildDir, boolean readOnly, int version) {
        this(indices, buildDir, null, readOnly, version);
    }

    @Deprecated
    public CompilerReferenceIndex(Collection<? extends IndexExtension<?, ?, ? super Input>> indices, File buildDir, boolean readOnly, int version) {
        this(indices, buildDir.toPath(), null, readOnly, version);
    }

    public CompilerReferenceIndex(Collection<? extends IndexExtension<?, ?, ? super Input>> indices, Path buildDir, @Nullable PathRelativizerService relativizer, boolean readOnly, int version) {
        this(indices, buildDir, relativizer, readOnly, version, SystemInfo.isFileSystemCaseSensitive);
    }

    public CompilerReferenceIndex(Collection<? extends IndexExtension<?, ?, ? super Input>> indices, Path buildDir, final @Nullable PathRelativizerService relativizer, boolean readOnly, int version, final boolean isCaseSensitive) {
        this.myBuildDir = buildDir;
        this.indexDir = CompilerReferenceIndex.getIndexDir(buildDir);
        try {
            Files.createDirectories(this.indexDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            if (CompilerReferenceIndex.versionDiffers(buildDir, version)) {
                this.saveVersion(buildDir, version);
            }
            this.myFilePathEnumerator = new PersistentStringEnumerator(this.indexDir.resolve(FILE_ENUM_TAB)){

                public int enumerate(String path) throws IOException {
                    String caseAwarePath = this.convertToCaseAwarePath(path, isCaseSensitive);
                    if (relativizer != null) {
                        return super.enumerate(relativizer.toRelative(caseAwarePath));
                    }
                    return super.enumerate(caseAwarePath);
                }

                @Nullable
                public String valueOf(int idx) throws IOException {
                    String path = super.valueOf(idx);
                    if (relativizer != null && path != null) {
                        return this.convertToCaseAwarePath(relativizer.toFull(path), isCaseSensitive);
                    }
                    return path;
                }

                @NotNull
                private String convertToCaseAwarePath(@NotNull String path, boolean isCaseSensitive2) {
                    if (path == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String string = isCaseSensitive2 ? path : StringUtil.toLowerCase((String)path);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "path";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/jps/backwardRefs/index/CompilerReferenceIndex$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/jps/backwardRefs/index/CompilerReferenceIndex$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "convertToCaseAwarePath";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "convertToCaseAwarePath";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            this.myIndices = new ConcurrentHashMap();
            for (IndexExtension<?, ?, Input> indexExtension : indices) {
                this.myIndices.put((IndexId<?, ?>)indexExtension.getName(), (InvertedIndex<?, ?, Input>)this.createCompilerIndex(indexExtension, readOnly));
            }
            this.myNameEnumerator = new NameEnumerator(this.indexDir.resolve(NAME_ENUM_TAB).toFile());
        }
        catch (IOException e) {
            Exception exception = ExceptionUtil.runAndCatch(this::close);
            if (exception != null) {
                e.addSuppressed(exception);
            }
            CompilerReferenceIndex.removeIndexFiles(this.myBuildDir, e);
            throw new BuildDataCorruptedException(e);
        }
        catch (Throwable t) {
            Exception exception = ExceptionUtil.runAndCatch(this::close);
            if (exception != null) {
                t.addSuppressed(exception);
            }
            CompilerReferenceIndex.removeIndexFiles(this.myBuildDir, t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void force() {
        Object object = this.myNameEnumerator;
        synchronized (object) {
            if (!this.myNameEnumerator.isClosed()) {
                this.myNameEnumerator.force();
            }
        }
        object = this.myFilePathEnumerator;
        synchronized (object) {
            if (!this.myFilePathEnumerator.isClosed()) {
                this.myFilePathEnumerator.force();
            }
        }
        for (InvertedIndex index : this.myIndices.values()) {
            try {
                index.flush();
            }
            catch (StorageException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public Collection<InvertedIndex<?, ?, Input>> getIndices() {
        return this.myIndices.values();
    }

    public <K, V> InvertedIndex<K, V, Input> get(IndexId<K, V> key) {
        return (InvertedIndex)this.myIndices.get(key);
    }

    @NotNull
    public NameEnumerator getByteSeqEum() {
        NameEnumerator nameEnumerator = this.myNameEnumerator;
        if (nameEnumerator == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(0);
        }
        return nameEnumerator;
    }

    @NotNull
    public PersistentStringEnumerator getFilePathEnumerator() {
        PersistentStringEnumerator persistentStringEnumerator = this.myFilePathEnumerator;
        if (persistentStringEnumerator == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(1);
        }
        return persistentStringEnumerator;
    }

    public void close() {
        this.myLowMemoryWatcher.stop();
        CommonProcessors.FindFirstProcessor<Exception> exceptionProc = new CommonProcessors.FindFirstProcessor<Exception>(){

            public boolean process(Exception e) {
                LOG.error((Throwable)e);
                return super.process((Object)e);
            }
        };
        CompilerReferenceIndex.close((Closeable)this.myFilePathEnumerator, (Processor<? super Exception>)exceptionProc);
        CompilerReferenceIndex.close((Closeable)((Object)this.myNameEnumerator), (Processor<? super Exception>)exceptionProc);
        Iterator iterator = this.myIndices.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry index = iterator.next();
            CompilerReferenceIndex.close((InvertedIndex)index.getValue(), (CommonProcessors.FindFirstProcessor<? super Exception>)exceptionProc);
            iterator.remove();
        }
        Exception exception = (Exception)exceptionProc.getFoundValue();
        if (exception != null) {
            CompilerReferenceIndex.removeIndexFiles(this.myBuildDir, exception);
            if (this.myRebuildRequestCause == null) {
                throw new RuntimeException(exception);
            }
            return;
        }
        if (this.myRebuildRequestCause != null) {
            CompilerReferenceIndex.removeIndexFiles(this.myBuildDir, this.myRebuildRequestCause);
        }
    }

    public static void removeIndexFiles(@NotNull Path buildDir) {
        if (buildDir == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(2);
        }
        CompilerReferenceIndex.removeIndexFiles(buildDir, null);
    }

    @Deprecated
    public static void removeIndexFiles(@NotNull File buildDir) {
        if (buildDir == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(3);
        }
        CompilerReferenceIndex.removeIndexFiles(buildDir.toPath(), null);
    }

    public void saveVersion(@NotNull Path buildDir, int version) {
        if (buildDir == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(4);
        }
        Path versionFile = CompilerReferenceIndex.getIndexDir(buildDir).resolve(VERSION_FILE);
        try {
            NioFiles.createParentDirectories((Path)versionFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try (DataOutputStream os = new DataOutputStream(Files.newOutputStream(versionFile, new OpenOption[0]));){
            os.writeInt(version);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex);
            throw new BuildDataCorruptedException(ex);
        }
    }

    @Deprecated
    @NotNull
    public File getIndicesDir() {
        File file = this.indexDir.toFile();
        if (file == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(5);
        }
        return file;
    }

    @NotNull
    public Path getIndexDir() {
        Path path = this.indexDir;
        if (path == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(6);
        }
        return path;
    }

    @NotNull
    private <Key, Value> CompilerMapReduceIndex<Key, Value> createCompilerIndex(@NotNull IndexExtension<Key, Value, ? super Input> indexExtension, boolean readOnly) throws IOException {
        if (indexExtension == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(7);
        }
        IndexStorage<Key, Value> indexStorage = CompilerReferenceIndex.createIndexStorage(indexExtension.getKeyDescriptor(), indexExtension.getValueExternalizer(), indexExtension.getName(), this.indexDir, readOnly);
        try {
            if (readOnly) {
                return new CompilerMapReduceIndex<Key, Value>(indexExtension, indexStorage, null, null);
            }
            Path storagePath = this.indexDir.resolve(indexExtension.getName().getName() + ".inputs");
            PersistentMapBasedForwardIndex forwardIndex = new PersistentMapBasedForwardIndex(storagePath, false);
            try {
                KeyCollectionForwardIndexAccessor forwardIndexAccessor = new KeyCollectionForwardIndexAccessor(indexExtension);
                return new CompilerMapReduceIndex<Key, Value>(indexExtension, indexStorage, (ForwardIndex)forwardIndex, forwardIndexAccessor);
            }
            catch (Throwable t) {
                forwardIndex.close();
                throw t;
            }
        }
        catch (Throwable t) {
            indexStorage.close();
            throw t;
        }
    }

    public static void removeIndexFiles(Path buildDir, Throwable cause) {
        Path indexDir = CompilerReferenceIndex.getIndexDir(buildDir);
        if (Files.exists(indexDir, new LinkOption[0])) {
            try {
                FileUtilRt.deleteRecursively((Path)indexDir);
                LOG.info("backward reference index deleted", cause != null ? cause : new Exception());
            }
            catch (Throwable e) {
                LOG.info("failed to delete backward reference index", e);
            }
        }
    }

    @NotNull
    private static Path getIndexDir(@NotNull Path buildDir) {
        if (buildDir == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(8);
        }
        Path path = buildDir.resolve("backward-refs");
        if (path == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(9);
        }
        return path;
    }

    public Throwable getRebuildRequestCause() {
        return this.myRebuildRequestCause;
    }

    public static boolean exists(@NotNull Path buildDir) {
        if (buildDir == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(10);
        }
        return Files.exists(CompilerReferenceIndex.getIndexDir(buildDir), new LinkOption[0]);
    }

    @Deprecated
    public static boolean exists(@NotNull File buildDir) {
        if (buildDir == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(11);
        }
        return CompilerReferenceIndex.exists(buildDir.toPath());
    }

    public void setRebuildRequestCause(Throwable e) {
        this.myRebuildRequestCause = e;
        LOG.error(e);
    }

    private static void close(@NotNull InvertedIndex<?, ?, ?> index, @NotNull CommonProcessors.FindFirstProcessor<? super Exception> exceptionProcessor) {
        if (index == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(12);
        }
        if (exceptionProcessor == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(13);
        }
        try {
            index.dispose();
        }
        catch (Exception e) {
            exceptionProcessor.process((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(@Nullable Closeable closeable, @NotNull Processor<? super Exception> exceptionProcessor) {
        if (exceptionProcessor == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(14);
        }
        if (closeable == null) {
            return;
        }
        Closeable closeable2 = closeable;
        synchronized (closeable2) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                exceptionProcessor.process((Object)new BuildDataCorruptedException(e));
            }
            catch (Exception e) {
                exceptionProcessor.process((Object)e);
            }
        }
    }

    @Deprecated
    public static boolean versionDiffers(@NotNull File buildDir, int expectedVersion) {
        if (buildDir == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(15);
        }
        return CompilerReferenceIndex.versionDiffers(buildDir.toPath(), expectedVersion);
    }

    public static boolean versionDiffers(@NotNull Path buildDir, int expectedVersion) {
        block10: {
            boolean bl;
            if (buildDir == null) {
                CompilerReferenceIndex.$$$reportNull$$$0(16);
            }
            Path versionFile = CompilerReferenceIndex.getIndexDir(buildDir).resolve(VERSION_FILE);
            DataInputStream is = new DataInputStream(Files.newInputStream(versionFile, new OpenOption[0]));
            try {
                boolean isDiffer;
                int currentIndexVersion = is.readInt();
                boolean bl2 = isDiffer = currentIndexVersion != expectedVersion;
                if (isDiffer) {
                    LOG.info("backward reference index version differ, expected = " + expectedVersion + ", current = " + currentIndexVersion);
                }
                bl = isDiffer;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (NoSuchFileException ignore) {
                    LOG.info("backward reference index version doesn't exist");
                    break block10;
                }
                catch (IOException e) {
                    LOG.info("backward reference index version differ due to: " + e.getClass());
                }
            }
            is.close();
            return bl;
        }
        return true;
    }

    private static <Key, Value> IndexStorage<Key, Value> createIndexStorage(@NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, @NotNull IndexId<Key, Value> indexId, @NotNull Path indexDir, boolean readOnly) throws IOException {
        if (keyDescriptor == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(17);
        }
        if (valueExternalizer == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(18);
        }
        if (indexId == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(19);
        }
        if (indexDir == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(20);
        }
        return new MapIndexStorage(indexDir.resolve(indexId.getName()), keyDescriptor, valueExternalizer, 16384, false, true, false, readOnly, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/backwardRefs/index/CompilerReferenceIndex";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexExtension";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionProcessor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getByteSeqEum";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathEnumerator";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/backwardRefs/index/CompilerReferenceIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicesDir";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeIndexFiles";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveVersion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCompilerIndex";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIndexDir";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "close";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "versionDiffers";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createIndexStorage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    final class CompilerMapReduceIndex<Key, Value>
    extends MapReduceIndex<Key, Value, Input> {
        CompilerMapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @Nullable IndexStorage<Key, Value> storage, @Nullable ForwardIndex index, ForwardIndexAccessor<Key, Value> accessor) throws IOException {
            if (extension == null) {
                CompilerMapReduceIndex.$$$reportNull$$$0(0);
            }
            if (storage == null) {
                CompilerMapReduceIndex.$$$reportNull$$$0(1);
            }
            super(extension, storage, index, accessor);
        }

        public void checkCanceled() {
        }

        protected void requestRebuild(@NotNull Throwable e) {
            if (e == null) {
                CompilerMapReduceIndex.$$$reportNull$$$0(2);
            }
            CompilerReferenceIndex.this.setRebuildRequestCause(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/backwardRefs/index/CompilerReferenceIndex$CompilerMapReduceIndex";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestRebuild";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

